'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

exports.defaultValue = defaultValue;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _graphql = require('graphql');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

// TODO: 1. Add default fields recursively
// TODO: 2. Add default fields for all selections (not just fragments)
// TODO: 3. Add stylesheet and remove inline styles
// TODO: 4. Indication of when query in explorer diverges from query in editor pane
// TODO: 5. Separate section for deprecated args, with support for 'beta' fields
// TODO: 6. Custom default arg fields

// Note: Attempted 1. and 2., but they were more annoying than helpful

function capitalize(string) {
  return string.charAt(0).toUpperCase() + string.slice(1);
}

var graphiqlArrowOpen = _react2.default.createElement(
  'svg',
  { width: '12', height: '9' },
  _react2.default.createElement('path', { fill: '#666', d: 'M 0 2 L 9 2 L 4.5 7.5 z' })
);

var graphiqlArrowClosed = _react2.default.createElement(
  'svg',
  { width: '12', height: '9' },
  _react2.default.createElement('path', { fill: '#666', d: 'M 0 0 L 0 9 L 5.5 4.5 z' })
);

var checkboxChecked = _react2.default.createElement(
  'svg',
  {
    style: { marginRight: '3px', marginLeft: '-3px' },
    width: '12',
    height: '12',
    viewBox: '0 0 18 18',
    fill: 'none',
    xmlns: 'http://www.w3.org/2000/svg' },
  _react2.default.createElement('path', {
    d: 'M16 0H2C0.9 0 0 0.9 0 2V16C0 17.1 0.9 18 2 18H16C17.1 18 18 17.1 18 16V2C18 0.9 17.1 0 16 0ZM16 16H2V2H16V16ZM14.99 6L13.58 4.58L6.99 11.17L4.41 8.6L2.99 10.01L6.99 14L14.99 6Z',
    fill: '#666'
  })
);

var checkboxEmpty = _react2.default.createElement(
  'svg',
  {
    style: { marginRight: '3px', marginLeft: '-3px' },
    width: '12',
    height: '12',
    viewBox: '0 0 18 18',
    fill: 'none',
    xmlns: 'http://www.w3.org/2000/svg' },
  _react2.default.createElement('path', {
    d: 'M16 2V16H2V2H16ZM16 0H2C0.9 0 0 0.9 0 2V16C0 17.1 0.9 18 2 18H16C17.1 18 18 17.1 18 16V2C18 0.9 17.1 0 16 0Z',
    fill: '#CCC'
  })
);

function Checkbox(props) {
  return props.checked ? checkboxChecked : checkboxEmpty;
}

function defaultGetDefaultFieldNames(type) {
  var fields = type.getFields();

  // Is there an `id` field?
  if (fields['id']) {
    var res = ['id'];
    if (fields['email']) {
      res.push('email');
    } else if (fields['name']) {
      res.push('name');
    }
    return res;
  }

  // Is there an `edges` field?
  if (fields['edges']) {
    return ['edges'];
  }

  // Is there an `node` field?
  if (fields['node']) {
    return ['node'];
  }

  if (fields['nodes']) {
    return ['nodes'];
  }

  // Include all leaf-type fields.
  var leafFieldNames = [];
  Object.keys(fields).forEach(function (fieldName) {
    if ((0, _graphql.isLeafType)(fields[fieldName].type)) {
      leafFieldNames.push(fieldName);
    }
  });
  return leafFieldNames.slice(0, 2); // Prevent too many fields from being added
}

function isRequiredArgument(arg) {
  return (0, _graphql.isNonNullType)(arg.type) && arg.defaultValue === undefined;
}

function unwrapOutputType(outputType) {
  var unwrappedType = outputType;
  while ((0, _graphql.isWrappingType)(unwrappedType)) {
    unwrappedType = unwrappedType.ofType;
  }
  return unwrappedType;
}

function unwrapInputType(inputType) {
  var unwrappedType = inputType;
  while ((0, _graphql.isWrappingType)(unwrappedType)) {
    unwrappedType = unwrappedType.ofType;
  }
  return unwrappedType;
}

function coerceArgValue(argType, value) {
  if ((0, _graphql.isScalarType)(argType)) {
    try {
      switch (argType.name) {
        case 'String':
          return {
            kind: 'StringValue',
            value: String(argType.parseValue(value))
          };
        case 'Float':
          return {
            kind: 'FloatValue',
            value: String(argType.parseValue(parseFloat(value)))
          };
        case 'Int':
          return {
            kind: 'IntValue',
            value: String(argType.parseValue(parseInt(value, 10)))
          };
        case 'Boolean':
          try {
            var parsed = JSON.parse(value);
            if (typeof parsed === 'boolean') {
              return { kind: 'BooleanValue', value: parsed };
            } else {
              return { kind: 'BooleanValue', value: false };
            }
          } catch (e) {
            return {
              kind: 'BooleanValue',
              value: false
            };
          }
        default:
          return {
            kind: 'StringValue',
            value: String(argType.parseValue(value))
          };
      }
    } catch (e) {
      console.error('error coercing arg value', e, value);
      return { kind: 'StringValue', value: value };
    }
  } else {
    try {
      var parsedValue = argType.parseValue(value);
      if (parsedValue) {
        return { kind: 'EnumValue', value: String(parsedValue) };
      } else {
        return { kind: 'EnumValue', value: argType.getValues()[0].name };
      }
    } catch (e) {
      return { kind: 'EnumValue', value: argType.getValues()[0].name };
    }
  }
}

var InputArgView = function (_React$PureComponent) {
  _inherits(InputArgView, _React$PureComponent);

  function InputArgView() {
    var _ref;

    var _temp, _this, _ret;

    _classCallCheck(this, InputArgView);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = InputArgView.__proto__ || Object.getPrototypeOf(InputArgView)).call.apply(_ref, [this].concat(args))), _this), _this._getArgSelection = function () {
      return _this.props.selection.fields.find(function (field) {
        return field.name.value === _this.props.arg.name;
      });
    }, _this._removeArg = function () {
      var selection = _this.props.selection;

      var argSelection = _this._getArgSelection();
      _this._previousArgSelection = argSelection;
      _this.props.modifyFields(selection.fields.filter(function (field) {
        return field !== argSelection;
      }));
    }, _this._addArg = function () {
      var _this$props = _this.props,
          selection = _this$props.selection,
          arg = _this$props.arg,
          getDefaultScalarArgValue = _this$props.getDefaultScalarArgValue,
          parentField = _this$props.parentField,
          makeDefaultArg = _this$props.makeDefaultArg;

      var argType = unwrapInputType(arg.type);

      var argSelection = null;
      if (_this._previousArgSelection) {
        argSelection = _this._previousArgSelection;
      } else if ((0, _graphql.isInputObjectType)(argType)) {
        var _fields = argType.getFields();
        argSelection = {
          kind: 'ObjectField',
          name: { kind: 'Name', value: arg.name },
          value: {
            kind: 'ObjectValue',
            fields: defaultInputObjectFields(getDefaultScalarArgValue, makeDefaultArg, parentField, Object.keys(_fields).map(function (k) {
              return _fields[k];
            }))
          }
        };
      } else if ((0, _graphql.isLeafType)(argType)) {
        argSelection = {
          kind: 'ObjectField',
          name: { kind: 'Name', value: arg.name },
          value: getDefaultScalarArgValue(parentField, arg, argType)
        };
      }

      if (!argSelection) {
        console.error('Unable to add arg for argType', argType);
      } else {
        _this.props.modifyFields([].concat(_toConsumableArray(selection.fields || []), [argSelection]));
      }
    }, _this._setArgValue = function (event) {
      var selection = _this.props.selection;

      var argSelection = _this._getArgSelection();
      if (!argSelection) {
        console.error('missing arg selection when setting arg value');
        return;
      }
      var argType = unwrapInputType(_this.props.arg.type);
      if (!(0, _graphql.isLeafType)(argType)) {
        console.warn('Unable to handle non leaf types in setArgValue');
        return;
      }
      var targetValue = event.target.value;

      _this.props.modifyFields((selection.fields || []).map(function (field) {
        return field === argSelection ? _extends({}, field, {
          value: coerceArgValue(argType, targetValue)
        }) : field;
      }));
    }, _this._modifyChildFields = function (fields) {
      _this.props.modifyFields(_this.props.selection.fields.map(function (field) {
        return field.name.value === _this.props.arg.name ? _extends({}, field, {
          value: {
            kind: 'ObjectValue',
            fields: fields
          }
        }) : field;
      }));
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  _createClass(InputArgView, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          arg = _props.arg,
          parentField = _props.parentField;

      var argSelection = this._getArgSelection();

      return _react2.default.createElement(AbstractArgView, {
        argValue: argSelection ? argSelection.value : null,
        arg: arg,
        parentField: parentField,
        addArg: this._addArg,
        removeArg: this._removeArg,
        setArgFields: this._modifyChildFields,
        setArgValue: this._setArgValue,
        getDefaultScalarArgValue: this.props.getDefaultScalarArgValue,
        makeDefaultArg: this.props.makeDefaultArg,
        onRunOperation: this.props.onRunOperation
      });
    }
  }]);

  return InputArgView;
}(_react2.default.PureComponent);

function defaultValue(argType) {
  if ((0, _graphql.isEnumType)(argType)) {
    return { kind: 'EnumValue', value: argType.getValues()[0].name };
  } else {
    switch (argType.name) {
      case 'String':
        return { kind: 'StringValue', value: '' };
      case 'Float':
        return { kind: 'FloatValue', value: '1.5' };
      case 'Int':
        return { kind: 'IntValue', value: '10' };
      case 'Boolean':
        return { kind: 'BooleanValue', value: false };
      default:
        return { kind: 'StringValue', value: '' };
    }
  }
}

function defaultGetDefaultScalarArgValue(parentField, arg, argType) {
  return defaultValue(argType);
}

var ArgView = function (_React$PureComponent2) {
  _inherits(ArgView, _React$PureComponent2);

  function ArgView() {
    var _ref2;

    var _temp2, _this2, _ret2;

    _classCallCheck(this, ArgView);

    for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      args[_key2] = arguments[_key2];
    }

    return _ret2 = (_temp2 = (_this2 = _possibleConstructorReturn(this, (_ref2 = ArgView.__proto__ || Object.getPrototypeOf(ArgView)).call.apply(_ref2, [this].concat(args))), _this2), _this2._getArgSelection = function () {
      var selection = _this2.props.selection;


      return (selection.arguments || []).find(function (arg) {
        return arg.name.value === _this2.props.arg.name;
      });
    }, _this2._removeArg = function () {
      var selection = _this2.props.selection;

      var argSelection = _this2._getArgSelection();
      _this2._previousArgSelection = argSelection;
      _this2.props.modifyArguments((selection.arguments || []).filter(function (arg) {
        return arg !== argSelection;
      }));
    }, _this2._addArg = function () {
      var _this2$props = _this2.props,
          selection = _this2$props.selection,
          getDefaultScalarArgValue = _this2$props.getDefaultScalarArgValue,
          makeDefaultArg = _this2$props.makeDefaultArg,
          parentField = _this2$props.parentField,
          arg = _this2$props.arg;

      var argType = unwrapInputType(arg.type);

      var argSelection = null;
      if (_this2._previousArgSelection) {
        argSelection = _this2._previousArgSelection;
      } else if ((0, _graphql.isInputObjectType)(argType)) {
        var _fields2 = argType.getFields();
        argSelection = {
          kind: 'Argument',
          name: { kind: 'Name', value: arg.name },
          value: {
            kind: 'ObjectValue',
            fields: defaultInputObjectFields(getDefaultScalarArgValue, makeDefaultArg, parentField, Object.keys(_fields2).map(function (k) {
              return _fields2[k];
            }))
          }
        };
      } else if ((0, _graphql.isLeafType)(argType)) {
        argSelection = {
          kind: 'Argument',
          name: { kind: 'Name', value: arg.name },
          value: getDefaultScalarArgValue(parentField, arg, argType)
        };
      }

      if (!argSelection) {
        console.error('Unable to add arg for argType', argType);
      } else {
        _this2.props.modifyArguments([].concat(_toConsumableArray(selection.arguments || []), [argSelection]));
      }
    }, _this2._setArgValue = function (event) {
      var selection = _this2.props.selection;

      var argSelection = _this2._getArgSelection();
      if (!argSelection) {
        console.error('missing arg selection when setting arg value');
        return;
      }
      var argType = unwrapInputType(_this2.props.arg.type);
      if (!(0, _graphql.isLeafType)(argType)) {
        console.warn('Unable to handle non leaf types in setArgValue');
        return;
      }

      var targetValue = event.target.value;

      _this2.props.modifyArguments((selection.arguments || []).map(function (a) {
        return a === argSelection ? _extends({}, a, {
          value: coerceArgValue(argType, targetValue)
        }) : a;
      }));
    }, _this2._setArgFields = function (fields) {
      var selection = _this2.props.selection;

      var argSelection = _this2._getArgSelection();
      if (!argSelection) {
        console.error('missing arg selection when setting arg value');
        return;
      }

      _this2.props.modifyArguments((selection.arguments || []).map(function (a) {
        return a === argSelection ? _extends({}, a, {
          value: {
            kind: 'ObjectValue',
            fields: fields
          }
        }) : a;
      }));
    }, _temp2), _possibleConstructorReturn(_this2, _ret2);
  }

  _createClass(ArgView, [{
    key: 'render',
    value: function render() {
      var _props2 = this.props,
          arg = _props2.arg,
          parentField = _props2.parentField;

      var argSelection = this._getArgSelection();

      return _react2.default.createElement(AbstractArgView, {
        argValue: argSelection ? argSelection.value : null,
        arg: arg,
        parentField: parentField,
        addArg: this._addArg,
        removeArg: this._removeArg,
        setArgFields: this._setArgFields,
        setArgValue: this._setArgValue,
        getDefaultScalarArgValue: this.props.getDefaultScalarArgValue,
        makeDefaultArg: this.props.makeDefaultArg,
        onRunOperation: this.props.onRunOperation
      });
    }
  }]);

  return ArgView;
}(_react2.default.PureComponent);

function isRunShortcut(event) {
  return event.metaKey && event.key === 'Enter';
}

var ScalarInput = function (_React$PureComponent3) {
  _inherits(ScalarInput, _React$PureComponent3);

  function ScalarInput() {
    var _ref3;

    var _temp3, _this3, _ret3;

    _classCallCheck(this, ScalarInput);

    for (var _len3 = arguments.length, args = Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
      args[_key3] = arguments[_key3];
    }

    return _ret3 = (_temp3 = (_this3 = _possibleConstructorReturn(this, (_ref3 = ScalarInput.__proto__ || Object.getPrototypeOf(ScalarInput)).call.apply(_ref3, [this].concat(args))), _this3), _this3._handleChange = function (event) {
      _this3.props.setArgValue(event);
    }, _temp3), _possibleConstructorReturn(_this3, _ret3);
  }

  _createClass(ScalarInput, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      var input = this._ref;
      var activeElement = document.activeElement;
      if (input && activeElement && !(activeElement instanceof HTMLTextAreaElement)) {
        input.focus();
        input.setSelectionRange(0, input.value.length);
      }
    }
  }, {
    key: 'render',
    value: function render() {
      var _this4 = this;

      var _props3 = this.props,
          arg = _props3.arg,
          argValue = _props3.argValue;

      var argType = unwrapInputType(arg.type);
      var color = this.props.argValue.kind === 'StringValue' ? '#D64292' : '#2882F9';
      var value = typeof argValue.value === 'string' ? argValue.value : '';
      return _react2.default.createElement(
        'span',
        { style: { color: color } },
        argType.name === 'String' ? '"' : '',
        _react2.default.createElement('input', {
          style: {
            border: 'none',
            borderBottom: '1px solid #888',
            outline: 'none',
            color: color,
            width: Math.max(1, value.length) + 'ch'
          },
          ref: function ref(_ref4) {
            _this4._ref = _ref4;
          },
          type: 'text',
          onKeyDown: function onKeyDown(event) {
            if (isRunShortcut(event)) {
              _this4.props.onRunOperation(event);
            }
          },
          onChange: this._handleChange,
          value: value
        }),
        argType.name === 'String' ? '"' : ''
      );
    }
  }]);

  return ScalarInput;
}(_react2.default.PureComponent);

var AbstractArgView = function (_React$PureComponent4) {
  _inherits(AbstractArgView, _React$PureComponent4);

  function AbstractArgView() {
    _classCallCheck(this, AbstractArgView);

    return _possibleConstructorReturn(this, (AbstractArgView.__proto__ || Object.getPrototypeOf(AbstractArgView)).apply(this, arguments));
  }

  _createClass(AbstractArgView, [{
    key: 'render',
    value: function render() {
      var _this6 = this;

      var _props4 = this.props,
          argValue = _props4.argValue,
          arg = _props4.arg;
      /* TODO: handle List types*/

      var argType = unwrapInputType(arg.type);

      var input = null;
      if (argValue) {
        if (argValue.kind === 'Variable') {
          input = _react2.default.createElement(
            'span',
            { style: { color: '#397D13' } },
            '$',
            argValue.name.value
          );
        } else if ((0, _graphql.isScalarType)(argType)) {
          if (argType.name === 'Boolean') {
            input = _react2.default.createElement(
              'select',
              {
                style: { backgroundColor: 'white', color: '#D47509' },
                onChange: this.props.setArgValue,
                value: argValue.kind === 'BooleanValue' ? argValue.value : undefined },
              _react2.default.createElement(
                'option',
                { key: 'true', value: 'true' },
                'true'
              ),
              _react2.default.createElement(
                'option',
                { key: 'false', value: 'false' },
                'false'
              )
            );
          } else {
            input = _react2.default.createElement(ScalarInput, {
              setArgValue: this.props.setArgValue,
              arg: arg,
              argValue: argValue,
              onRunOperation: this.props.onRunOperation
            });
          }
        } else if ((0, _graphql.isEnumType)(argType)) {
          if (argValue.kind === 'EnumValue') {
            input = _react2.default.createElement(
              'select',
              {
                style: { backgroundColor: 'white', color: '#0B7FC7' },
                onChange: this.props.setArgValue,
                value: argValue.value },
              argType.getValues().map(function (value) {
                return _react2.default.createElement(
                  'option',
                  { key: value.name, value: value.name },
                  value.name
                );
              })
            );
          } else {
            console.error('arg mismatch between arg and selection', argType, argValue);
          }
        } else if ((0, _graphql.isInputObjectType)(argType)) {
          if (argValue.kind === 'ObjectValue') {
            var _fields3 = argType.getFields();
            input = _react2.default.createElement(
              'div',
              { style: { marginLeft: 16 } },
              Object.keys(_fields3).sort().map(function (fieldName) {
                return _react2.default.createElement(InputArgView, {
                  key: fieldName,
                  arg: _fields3[fieldName],
                  parentField: _this6.props.parentField,
                  selection: argValue,
                  modifyFields: _this6.props.setArgFields,
                  getDefaultScalarArgValue: _this6.props.getDefaultScalarArgValue,
                  makeDefaultArg: _this6.props.makeDefaultArg,
                  onRunOperation: _this6.props.onRunOperation
                });
              })
            );
          } else {
            console.error('arg mismatch between arg and selection', argType, argValue);
          }
        }
      }

      return _react2.default.createElement(
        'div',
        {
          style: {
            cursor: 'pointer',
            minHeight: '16px',
            WebkitUserSelect: 'none',
            userSelect: 'none'
          },
          'data-arg-name': arg.name,
          'data-arg-type': argType.name },
        _react2.default.createElement(
          'span',
          {
            style: { cursor: 'pointer' },
            onClick: argValue ? this.props.removeArg : this.props.addArg },
          _react2.default.createElement(Checkbox, { checked: !!argValue }),
          _react2.default.createElement(
            'span',
            { title: arg.description, style: { color: '#8B2BB9' } },
            arg.name,
            isRequiredArgument(arg) ? '*' : '',
            ':'
          )
        ),
        ' ',
        input || _react2.default.createElement('span', null)
      );
    }
  }]);

  return AbstractArgView;
}(_react2.default.PureComponent);

var AbstractView = function (_React$PureComponent5) {
  _inherits(AbstractView, _React$PureComponent5);

  function AbstractView() {
    var _ref5;

    var _temp4, _this7, _ret4;

    _classCallCheck(this, AbstractView);

    for (var _len4 = arguments.length, args = Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
      args[_key4] = arguments[_key4];
    }

    return _ret4 = (_temp4 = (_this7 = _possibleConstructorReturn(this, (_ref5 = AbstractView.__proto__ || Object.getPrototypeOf(AbstractView)).call.apply(_ref5, [this].concat(args))), _this7), _this7._addFragment = function () {
      _this7.props.modifySelections([].concat(_toConsumableArray(_this7.props.selections), [_this7._previousSelection || {
        kind: 'InlineFragment',
        typeCondition: {
          kind: 'NamedType',
          name: { kind: 'Name', value: _this7.props.implementingType.name }
        },
        selectionSet: {
          kind: 'SelectionSet',
          selections: _this7.props.getDefaultFieldNames(_this7.props.implementingType).map(function (fieldName) {
            return {
              kind: 'Field',
              name: { kind: 'Name', value: fieldName }
            };
          })
        }
      }]));
    }, _this7._removeFragment = function () {
      var thisSelection = _this7._getSelection();
      _this7._previousSelection = thisSelection;
      _this7.props.modifySelections(_this7.props.selections.filter(function (s) {
        return s !== thisSelection;
      }));
    }, _this7._getSelection = function () {
      var selection = _this7.props.selections.find(function (selection) {
        return selection.kind === 'InlineFragment' && selection.typeCondition && _this7.props.implementingType.name === selection.typeCondition.name.value;
      });
      if (!selection) {
        return null;
      }
      if (selection.kind === 'InlineFragment') {
        return selection;
      }
    }, _this7._modifyChildSelections = function (selections) {
      var thisSelection = _this7._getSelection();
      _this7.props.modifySelections(_this7.props.selections.map(function (selection) {
        if (selection === thisSelection) {
          return {
            directives: selection.directives,
            kind: 'InlineFragment',
            typeCondition: {
              kind: 'NamedType',
              name: { kind: 'Name', value: _this7.props.implementingType.name }
            },
            selectionSet: {
              kind: 'SelectionSet',
              selections: selections
            }
          };
        }
        return selection;
      }));
    }, _temp4), _possibleConstructorReturn(_this7, _ret4);
  }

  _createClass(AbstractView, [{
    key: 'render',
    value: function render() {
      var _this8 = this;

      var _props5 = this.props,
          implementingType = _props5.implementingType,
          schema = _props5.schema,
          getDefaultFieldNames = _props5.getDefaultFieldNames;

      var selection = this._getSelection();
      var fields = implementingType.getFields();
      var childSelections = selection ? selection.selectionSet ? selection.selectionSet.selections : [] : [];
      return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
          'span',
          {
            style: { cursor: 'pointer' },
            onClick: selection ? this._removeFragment : this._addFragment },
          _react2.default.createElement(Checkbox, { checked: !!selection }),
          _react2.default.createElement(
            'span',
            { style: { color: '#CA9800' } },
            this.props.implementingType.name
          )
        ),
        selection ? _react2.default.createElement(
          'div',
          { style: { marginLeft: 16 } },
          Object.keys(fields).sort().map(function (fieldName) {
            return _react2.default.createElement(FieldView, {
              key: fieldName,
              field: fields[fieldName],
              selections: childSelections,
              modifySelections: _this8._modifyChildSelections,
              schema: schema,
              getDefaultFieldNames: getDefaultFieldNames,
              getDefaultScalarArgValue: _this8.props.getDefaultScalarArgValue,
              makeDefaultArg: _this8.props.makeDefaultArg,
              onRunOperation: _this8.props.onRunOperation
            });
          })
        ) : null
      );
    }
  }]);

  return AbstractView;
}(_react2.default.PureComponent);

function defaultInputObjectFields(getDefaultScalarArgValue, makeDefaultArg, parentField, fields) {
  var nodes = [];
  var _iteratorNormalCompletion = true;
  var _didIteratorError = false;
  var _iteratorError = undefined;

  try {
    for (var _iterator = fields[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
      var _field = _step.value;

      if ((0, _graphql.isRequiredInputField)(_field) || makeDefaultArg && makeDefaultArg(parentField, _field)) {
        var fieldType = unwrapInputType(_field.type);
        if ((0, _graphql.isInputObjectType)(fieldType)) {
          (function () {
            var fields = fieldType.getFields();
            nodes.push({
              kind: 'ObjectField',
              name: { kind: 'Name', value: _field.name },
              value: {
                kind: 'ObjectValue',
                fields: defaultInputObjectFields(getDefaultScalarArgValue, makeDefaultArg, parentField, Object.keys(fields).map(function (k) {
                  return fields[k];
                }))
              }
            });
          })();
        } else if ((0, _graphql.isLeafType)(fieldType)) {
          nodes.push({
            kind: 'ObjectField',
            name: { kind: 'Name', value: _field.name },
            value: getDefaultScalarArgValue(parentField, _field, fieldType)
          });
        }
      }
    }
  } catch (err) {
    _didIteratorError = true;
    _iteratorError = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion && _iterator.return) {
        _iterator.return();
      }
    } finally {
      if (_didIteratorError) {
        throw _iteratorError;
      }
    }
  }

  return nodes;
}

function defaultArgs(getDefaultScalarArgValue, makeDefaultArg, field) {
  var args = [];
  var _iteratorNormalCompletion2 = true;
  var _didIteratorError2 = false;
  var _iteratorError2 = undefined;

  try {
    for (var _iterator2 = field.args[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
      var _arg = _step2.value;

      if (isRequiredArgument(_arg) || makeDefaultArg && makeDefaultArg(field, _arg)) {
        var argType = unwrapInputType(_arg.type);
        if ((0, _graphql.isInputObjectType)(argType)) {
          (function () {
            var fields = argType.getFields();
            args.push({
              kind: 'Argument',
              name: { kind: 'Name', value: _arg.name },
              value: {
                kind: 'ObjectValue',
                fields: defaultInputObjectFields(getDefaultScalarArgValue, makeDefaultArg, field, Object.keys(fields).map(function (k) {
                  return fields[k];
                }))
              }
            });
          })();
        } else if ((0, _graphql.isLeafType)(argType)) {
          args.push({
            kind: 'Argument',
            name: { kind: 'Name', value: _arg.name },
            value: getDefaultScalarArgValue(field, _arg, argType)
          });
        }
      }
    }
  } catch (err) {
    _didIteratorError2 = true;
    _iteratorError2 = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion2 && _iterator2.return) {
        _iterator2.return();
      }
    } finally {
      if (_didIteratorError2) {
        throw _iteratorError2;
      }
    }
  }

  return args;
}

var FieldView = function (_React$PureComponent6) {
  _inherits(FieldView, _React$PureComponent6);

  function FieldView() {
    var _ref6;

    var _temp5, _this9, _ret7;

    _classCallCheck(this, FieldView);

    for (var _len5 = arguments.length, args = Array(_len5), _key5 = 0; _key5 < _len5; _key5++) {
      args[_key5] = arguments[_key5];
    }

    return _ret7 = (_temp5 = (_this9 = _possibleConstructorReturn(this, (_ref6 = FieldView.__proto__ || Object.getPrototypeOf(FieldView)).call.apply(_ref6, [this].concat(args))), _this9), _this9._addAllFieldsToSelections = function (rawSubfields) {
      var subFields = !!rawSubfields ? Object.keys(rawSubfields).map(function (fieldName) {
        return {
          kind: 'Field',
          name: { kind: 'Name', value: fieldName },
          arguments: []
        };
      }) : [];

      var subSelectionSet = {
        kind: 'SelectionSet',
        selections: subFields
      };

      var nextSelections = [].concat(_toConsumableArray(_this9.props.selections.filter(function (selection) {
        if (selection.kind === 'InlineFragment') {
          return true;
        } else {
          // Remove the current selection set for the target field
          return selection.name.value !== _this9.props.field.name;
        }
      })), [{
        kind: 'Field',
        name: { kind: 'Name', value: _this9.props.field.name },
        arguments: defaultArgs(_this9.props.getDefaultScalarArgValue, _this9.props.makeDefaultArg, _this9.props.field),
        selectionSet: subSelectionSet
      }]);

      _this9.props.modifySelections(nextSelections);
    }, _this9._addFieldToSelections = function (rawSubfields) {
      var nextSelections = [].concat(_toConsumableArray(_this9.props.selections), [_this9._previousSelection || {
        kind: 'Field',
        name: { kind: 'Name', value: _this9.props.field.name },
        arguments: defaultArgs(_this9.props.getDefaultScalarArgValue, _this9.props.makeDefaultArg, _this9.props.field)
      }]);

      _this9.props.modifySelections(nextSelections);
    }, _this9._handleUpdateSelections = function (event) {
      var selection = _this9._getSelection();
      if (selection && !event.altKey) {
        _this9._removeFieldFromSelections();
      } else {
        var fieldType = (0, _graphql.getNamedType)(_this9.props.field.type);
        var rawSubfields = (0, _graphql.isObjectType)(fieldType) && fieldType.getFields();

        var shouldSelectAllSubfields = !!rawSubfields && event.altKey;

        shouldSelectAllSubfields ? _this9._addAllFieldsToSelections(rawSubfields) : _this9._addFieldToSelections(rawSubfields);
      }
    }, _this9._removeFieldFromSelections = function () {
      var previousSelection = _this9._getSelection();
      _this9._previousSelection = previousSelection;
      _this9.props.modifySelections(_this9.props.selections.filter(function (selection) {
        return selection !== previousSelection;
      }));
    }, _this9._getSelection = function () {
      var selection = _this9.props.selections.find(function (selection) {
        return selection.kind === 'Field' && _this9.props.field.name === selection.name.value;
      });
      if (!selection) {
        return null;
      }
      if (selection.kind === 'Field') {
        return selection;
      }
    }, _this9._setArguments = function (argumentNodes) {
      var selection = _this9._getSelection();
      if (!selection) {
        console.error('Missing selection when setting arguments', argumentNodes);
        return;
      }
      _this9.props.modifySelections(_this9.props.selections.map(function (s) {
        return s === selection ? {
          alias: selection.alias,
          arguments: argumentNodes,
          directives: selection.directives,
          kind: 'Field',
          name: selection.name,
          selectionSet: selection.selectionSet
        } : s;
      }));
    }, _this9._modifyChildSelections = function (selections) {
      _this9.props.modifySelections(_this9.props.selections.map(function (selection) {
        if (selection.kind === 'Field' && _this9.props.field.name === selection.name.value) {
          if (selection.kind !== 'Field') {
            throw new Error('invalid selection');
          }
          return {
            alias: selection.alias,
            arguments: selection.arguments,
            directives: selection.directives,
            kind: 'Field',
            name: selection.name,
            selectionSet: {
              kind: 'SelectionSet',
              selections: selections
            }
          };
        }
        return selection;
      }));
    }, _temp5), _possibleConstructorReturn(_this9, _ret7);
  }

  _createClass(FieldView, [{
    key: 'render',
    value: function render() {
      var _this10 = this;

      var _props6 = this.props,
          field = _props6.field,
          schema = _props6.schema,
          getDefaultFieldNames = _props6.getDefaultFieldNames;

      var selection = this._getSelection();
      var type = unwrapOutputType(field.type);
      var args = field.args.sort(function (a, b) {
        return a.name.localeCompare(b.name);
      });
      var node = _react2.default.createElement(
        'div',
        { className: 'graphiql-explorer-node' },
        _react2.default.createElement(
          'span',
          {
            title: field.description,
            style: {
              cursor: 'pointer',
              display: 'inline-flex',
              alignItems: 'center',
              minHeight: '16px',
              WebkitUserSelect: 'none',
              userSelect: 'none'
            },
            'data-field-name': field.name,
            'data-field-type': type.name,
            onClick: this._handleUpdateSelections },
          (0, _graphql.isObjectType)(type) ? _react2.default.createElement(
            'span',
            null,
            !!selection ? graphiqlArrowOpen : graphiqlArrowClosed
          ) : null,
          (0, _graphql.isObjectType)(type) ? null : _react2.default.createElement(Checkbox, { checked: !!selection }),
          _react2.default.createElement(
            'span',
            { style: { color: 'rgb(31, 97, 160)' } },
            field.name
          )
        ),
        selection && args.length ? _react2.default.createElement(
          'div',
          { style: { marginLeft: 16 } },
          args.map(function (arg) {
            return _react2.default.createElement(ArgView, {
              key: arg.name,
              parentField: field,
              arg: arg,
              selection: selection,
              modifyArguments: _this10._setArguments,
              getDefaultScalarArgValue: _this10.props.getDefaultScalarArgValue,
              makeDefaultArg: _this10.props.makeDefaultArg,
              onRunOperation: _this10.props.onRunOperation
            });
          })
        ) : null
      );

      if (selection && ((0, _graphql.isObjectType)(type) || (0, _graphql.isInterfaceType)(type) || (0, _graphql.isUnionType)(type))) {
        var _fields4 = (0, _graphql.isUnionType)(type) ? {} : type.getFields();
        var childSelections = selection ? selection.selectionSet ? selection.selectionSet.selections : [] : [];
        return _react2.default.createElement(
          'div',
          null,
          node,
          _react2.default.createElement(
            'div',
            { style: { marginLeft: 16 } },
            Object.keys(_fields4).sort().map(function (fieldName) {
              return _react2.default.createElement(FieldView, {
                key: fieldName,
                field: _fields4[fieldName],
                selections: childSelections,
                modifySelections: _this10._modifyChildSelections,
                schema: schema,
                getDefaultFieldNames: getDefaultFieldNames,
                getDefaultScalarArgValue: _this10.props.getDefaultScalarArgValue,
                makeDefaultArg: _this10.props.makeDefaultArg,
                onRunOperation: _this10.props.onRunOperation
              });
            }),
            (0, _graphql.isInterfaceType)(type) || (0, _graphql.isUnionType)(type) ? schema.getPossibleTypes(type).map(function (type) {
              return _react2.default.createElement(AbstractView, {
                key: type.name,
                implementingType: type,
                selections: childSelections,
                modifySelections: _this10._modifyChildSelections,
                schema: schema,
                getDefaultFieldNames: getDefaultFieldNames,
                getDefaultScalarArgValue: _this10.props.getDefaultScalarArgValue,
                makeDefaultArg: _this10.props.makeDefaultArg,
                onRunOperation: _this10.props.onRunOperation
              });
            }) : null
          )
        );
      }
      return node;
    }
  }]);

  return FieldView;
}(_react2.default.PureComponent);

function parseQuery(text) {
  try {
    if (!text.trim()) {
      return null;
    }
    return (0, _graphql.parse)(text,
    // Tell graphql to not bother track locations when parsing, we don't need
    // it and it's a tiny bit more expensive.
    { noLocation: true });
  } catch (e) {
    return new Error(e);
  }
}

var DEFAULT_OPERATION = {
  kind: 'OperationDefinition',
  operation: 'query',
  variableDefinitions: [],
  name: { kind: 'Name', value: 'MyQuery' },
  directives: [],
  selectionSet: {
    kind: 'SelectionSet',
    selections: []
  }
};
var DEFAULT_DOCUMENT = {
  kind: 'Document',
  definitions: [DEFAULT_OPERATION]
};
var parseQueryMemoize = null;
function memoizeParseQuery(query) {
  if (parseQueryMemoize && parseQueryMemoize[0] === query) {
    return parseQueryMemoize[1];
  } else {
    var result = parseQuery(query);
    if (!result) {
      return DEFAULT_DOCUMENT;
    } else if (result instanceof Error) {
      if (parseQueryMemoize) {
        // Most likely a temporarily invalid query while they type
        return parseQueryMemoize[1];
      } else {
        return DEFAULT_DOCUMENT;
      }
    } else {
      parseQueryMemoize = [query, result];
      return result;
    }
  }
}

var buttonStyle = {
  fontSize: '1.2em',
  padding: '0px',
  backgroundColor: 'white',
  border: 'none',
  margin: '5px 0px',
  height: '40px',
  width: '100%',
  display: 'block',
  maxWidth: 'none'
};

var explorerActionsStyle = {
  margin: '4px -8px -8px',
  paddingLeft: '8px',
  bottom: '0px',
  width: '100%',
  textAlign: 'center',
  background: 'none',
  borderTop: 'none',
  borderBottom: 'none'
};

var RootView = function (_React$PureComponent7) {
  _inherits(RootView, _React$PureComponent7);

  function RootView() {
    var _ref7;

    var _temp6, _this11, _ret8;

    _classCallCheck(this, RootView);

    for (var _len6 = arguments.length, args = Array(_len6), _key6 = 0; _key6 < _len6; _key6++) {
      args[_key6] = arguments[_key6];
    }

    return _ret8 = (_temp6 = (_this11 = _possibleConstructorReturn(this, (_ref7 = RootView.__proto__ || Object.getPrototypeOf(RootView)).call.apply(_ref7, [this].concat(args))), _this11), _this11._modifySelections = function (selections) {
      var operationDef = _this11.props.definition;

      if (operationDef.selectionSet.selections.length === 0 && _this11._previousOperationDef) {
        operationDef = _this11._previousOperationDef;
      }

      var newOperationDef = void 0;

      if (selections.length === 0) {
        _this11._previousOperationDef = operationDef;
        newOperationDef = null;
      } else if (operationDef.kind === 'FragmentDefinition') {
        newOperationDef = _extends({}, operationDef, {
          selectionSet: _extends({}, operationDef.selectionSet, {
            selections: selections
          })
        });
      } else if (operationDef.kind === 'OperationDefinition') {
        newOperationDef = _extends({}, operationDef, {
          selectionSet: _extends({}, operationDef.selectionSet, {
            selections: selections
          })
        });
      }

      _this11.props.onEdit(newOperationDef);
    }, _this11._onOperationRename = function (event) {
      return _this11.props.onOperationRename(event.target.value);
    }, _this11._handlePotentialRun = function (event) {
      if (isRunShortcut(event)) {
        _this11.props.onRunOperation(_this11.props.name);
      }
    }, _temp6), _possibleConstructorReturn(_this11, _ret8);
  }

  _createClass(RootView, [{
    key: 'render',
    value: function render() {
      var _this12 = this;

      var _props7 = this.props,
          fields = _props7.fields,
          operation = _props7.operation,
          name = _props7.name,
          definition = _props7.definition,
          schema = _props7.schema,
          getDefaultFieldNames = _props7.getDefaultFieldNames;

      var operationDef = definition;
      var selections = operationDef.selectionSet.selections;

      var operationDisplayName = this.props.name || capitalize(operation) + ' Name';

      return _react2.default.createElement(
        'div',
        {
          id: operation + '-' + (name || 'unknown'),
          style: {
            borderBottom: '1px solid #d6d6d6',
            marginBottom: '0em',
            paddingBottom: '1em'
          } },
        _react2.default.createElement(
          'div',
          { style: { color: '#B11A04', paddingBottom: 4 } },
          operation,
          ' ',
          _react2.default.createElement(
            'span',
            { style: { color: 'rgb(193, 42,80)' } },
            _react2.default.createElement('input', {
              style: {
                border: 'none',
                borderBottom: '1px solid #888',
                outline: 'none',
                color: 'rgb(193, 42,80)',
                width: Math.max(4, operationDisplayName.length) + 'ch'
              },
              autoComplete: 'false',
              placeholder: capitalize(operation) + ' Name',
              value: this.props.name,
              onKeyDown: this._handlePotentialRun,
              onChange: this._onOperationRename
            })
          ),
          !!this.props.onTypeName ? _react2.default.createElement(
            'span',
            null,
            _react2.default.createElement('br', null),
            'on ' + this.props.onTypeName
          ) : ''
        ),
        Object.keys(fields || {}).sort().map(function (fieldName) {
          return _react2.default.createElement(FieldView, {
            key: fieldName,
            field: fields[fieldName],
            selections: selections,
            modifySelections: _this12._modifySelections,
            schema: schema,
            getDefaultFieldNames: getDefaultFieldNames,
            getDefaultScalarArgValue: _this12.props.getDefaultScalarArgValue,
            makeDefaultArg: _this12.props.makeDefaultArg,
            onRunOperation: _this12.props.onRunOperation
          });
        })
      );
    }
  }]);

  return RootView;
}(_react2.default.PureComponent);

var Explorer = function (_React$PureComponent8) {
  _inherits(Explorer, _React$PureComponent8);

  function Explorer() {
    var _ref8;

    var _temp7, _this13, _ret9;

    _classCallCheck(this, Explorer);

    for (var _len7 = arguments.length, args = Array(_len7), _key7 = 0; _key7 < _len7; _key7++) {
      args[_key7] = arguments[_key7];
    }

    return _ret9 = (_temp7 = (_this13 = _possibleConstructorReturn(this, (_ref8 = Explorer.__proto__ || Object.getPrototypeOf(Explorer)).call.apply(_ref8, [this].concat(args))), _this13), _this13._resetScroll = function () {
      var container = _this13._ref;
      if (container) {
        container.scrollLeft = 0;
      }
    }, _this13._onEdit = function (query) {
      return _this13.props.onEdit(query);
    }, _temp7), _possibleConstructorReturn(_this13, _ret9);
  }

  _createClass(Explorer, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      this._resetScroll();
    }
  }, {
    key: 'render',
    value: function render() {
      var _this14 = this;

      var _props8 = this.props,
          schema = _props8.schema,
          query = _props8.query,
          makeDefaultArg = _props8.makeDefaultArg;


      if (!schema) {
        return _react2.default.createElement(
          'div',
          { style: { fontFamily: 'sans-serif' }, className: 'error-container' },
          'No Schema Available'
        );
      }
      var queryType = schema.getQueryType();
      var mutationType = schema.getMutationType();
      var subscriptionType = schema.getSubscriptionType();
      if (!queryType && !mutationType && !subscriptionType) {
        return _react2.default.createElement(
          'div',
          null,
          'Missing query type'
        );
      }
      var queryFields = queryType && queryType.getFields();
      var mutationFields = mutationType && mutationType.getFields();
      var subscriptionFields = subscriptionType && subscriptionType.getFields();

      var parsedQuery = memoizeParseQuery(query);
      var getDefaultFieldNames = this.props.getDefaultFieldNames || defaultGetDefaultFieldNames;
      var getDefaultScalarArgValue = this.props.getDefaultScalarArgValue || defaultGetDefaultScalarArgValue;

      var definitions = parsedQuery.definitions;

      var _relevantOperations = definitions.map(function (definition) {
        if (definition.kind === 'FragmentDefinition') {
          return definition;
        } else if (definition.kind === 'OperationDefinition') {
          return definition;
        } else {
          return null;
        }
      }).filter(Boolean);

      var relevantOperations =
      // If we don't have any relevant definitions from the parsed document,
      // then at least show an expanded Query selection
      _relevantOperations.length === 0 ? DEFAULT_DOCUMENT.definitions : _relevantOperations;

      var renameOperation = function renameOperation(targetOperation, name) {
        var newName = name == null || name === '' ? null : { kind: 'Name', value: name, loc: undefined };
        var newOperation = _extends({}, targetOperation, { name: newName });

        var existingDefs = parsedQuery.definitions;

        var newDefinitions = existingDefs.map(function (existingOperation) {
          if (targetOperation === existingOperation) {
            return newOperation;
          } else {
            return existingOperation;
          }
        });

        return _extends({}, parsedQuery, {
          definitions: newDefinitions
        });
      };

      var addOperation = function addOperation(kind) {
        var existingDefs = parsedQuery.definitions;

        var viewingDefaultOperation = parsedQuery.definitions.length === 1 && parsedQuery.definitions[0] === DEFAULT_DOCUMENT.definitions[0];

        var MySiblingDefs = viewingDefaultOperation ? [] : existingDefs.filter(function (def) {
          if (def.kind === 'OperationDefinition') {
            return def.operation === kind;
          } else {
            // Don't support adding fragments from explorer
            return false;
          }
        });

        var newOperationName = 'My' + capitalize(kind) + (MySiblingDefs.length === 0 ? '' : MySiblingDefs.length + 1);

        // Add this as the default field as it guarantees a valid selectionSet
        var firstFieldName = '__typename # Placeholder value';

        var selectionSet = {
          kind: 'SelectionSet',
          selections: [{
            kind: 'Field',
            name: {
              kind: 'Name',
              value: firstFieldName,
              loc: null
            },
            arguments: [],
            directives: [],
            selectionSet: null,
            loc: null
          }],
          loc: null
        };

        var newDefinition = {
          kind: 'OperationDefinition',
          operation: kind,
          name: { kind: 'Name', value: newOperationName },
          variableDefinitions: [],
          directives: [],
          selectionSet: selectionSet,
          loc: null
        };

        var newDefinitions =
        // If we only have our default operation in the document right now, then
        // just replace it with our new definition
        viewingDefaultOperation ? [newDefinition] : [].concat(_toConsumableArray(parsedQuery.definitions), [newDefinition]);

        var newOperationDef = _extends({}, parsedQuery, {
          definitions: newDefinitions
        });

        _this14.props.onEdit((0, _graphql.print)(newOperationDef));
      };

      return _react2.default.createElement(
        'div',
        {
          ref: function ref(_ref9) {
            _this14._ref = _ref9;
          },
          style: {
            fontSize: 12,
            overflow: 'scroll',
            textOverflow: 'ellipsis',
            whiteSpace: 'nowrap',
            margin: 0,
            padding: 8,
            fontFamily: 'Consolas, Inconsolata, "Droid Sans Mono", Monaco, monospace'
          },
          className: 'graphiql-explorer-root' },
        relevantOperations.map(function (operation, index) {
          var operationName = operation && operation.name && operation.name.value;

          var operationKind = operation.kind === 'FragmentDefinition' ? 'fragment' : operation && operation.operation || 'query';

          var onOperationRename = function onOperationRename(newName) {
            var newOperationDef = renameOperation(operation, newName);
            _this14.props.onEdit((0, _graphql.print)(newOperationDef));
          };

          var fragmentType = operation.kind === 'FragmentDefinition' && operation.typeCondition.kind === 'NamedType' && schema.getType(operation.typeCondition.name.value);

          var fragmentFields = fragmentType instanceof _graphql.GraphQLObjectType ? fragmentType.getFields() : null;

          var fields = operationKind === 'query' ? queryFields : operationKind === 'mutation' ? mutationFields : operationKind === 'subscription' ? subscriptionFields : operation.kind === 'FragmentDefinition' ? fragmentFields : null;

          var fragmentTypeName = operation.kind === 'FragmentDefinition' ? operation.typeCondition.name.value : null;

          return _react2.default.createElement(RootView, {
            key: index,
            fields: fields,
            operation: operationKind,
            name: operationName,
            definition: operation,
            onOperationRename: onOperationRename,
            onTypeName: fragmentTypeName,
            onEdit: function onEdit(newDefinition) {
              var newQuery = _extends({}, parsedQuery, {
                definitions: parsedQuery.definitions.map(function (existingDefinition) {
                  return existingDefinition === operation ? newDefinition : existingDefinition;
                })
              });

              var textualNewQuery = (0, _graphql.print)(newQuery);

              _this14.props.onEdit(textualNewQuery);
            },
            schema: schema,
            getDefaultFieldNames: getDefaultFieldNames,
            getDefaultScalarArgValue: getDefaultScalarArgValue,
            makeDefaultArg: makeDefaultArg,
            onRunOperation: function onRunOperation() {
              if (!!_this14.props.onRunOperation) {
                _this14.props.onRunOperation(operationName);
              }
            }
          });
        }),
        _react2.default.createElement(
          'div',
          { className: 'variable-editor-title', style: explorerActionsStyle },
          !!queryFields ? _react2.default.createElement(
            'button',
            {
              className: 'toolbar-button',
              style: buttonStyle,
              type: 'link',
              onClick: function onClick() {
                return addOperation('query');
              } },
            '+ ADD NEW QUERY'
          ) : null,
          !!mutationFields ? _react2.default.createElement(
            'button',
            {
              className: 'toolbar-button',
              style: buttonStyle,
              type: 'link',
              onClick: function onClick() {
                return addOperation('mutation');
              } },
            '+ ADD NEW MUTATION'
          ) : null,
          !!subscriptionFields ? _react2.default.createElement(
            'button',
            {
              className: 'toolbar-button',
              style: buttonStyle,
              type: 'link',
              onClick: function onClick() {
                return addOperation('subscription');
              } },
            '+ ADD NEW SUBSCRIPTION'
          ) : null
        )
      );
    }
  }]);

  return Explorer;
}(_react2.default.PureComponent);

Explorer.defaultProps = {
  getDefaultFieldNames: defaultGetDefaultFieldNames,
  getDefaultScalarArgValue: defaultGetDefaultScalarArgValue
};

var ErrorBoundary = function (_React$Component) {
  _inherits(ErrorBoundary, _React$Component);

  function ErrorBoundary() {
    var _ref10;

    var _temp8, _this15, _ret10;

    _classCallCheck(this, ErrorBoundary);

    for (var _len8 = arguments.length, args = Array(_len8), _key8 = 0; _key8 < _len8; _key8++) {
      args[_key8] = arguments[_key8];
    }

    return _ret10 = (_temp8 = (_this15 = _possibleConstructorReturn(this, (_ref10 = ErrorBoundary.__proto__ || Object.getPrototypeOf(ErrorBoundary)).call.apply(_ref10, [this].concat(args))), _this15), _this15.state = { hasError: false, error: null, errorInfo: null }, _temp8), _possibleConstructorReturn(_this15, _ret10);
  }

  _createClass(ErrorBoundary, [{
    key: 'componentDidCatch',
    value: function componentDidCatch(error, errorInfo) {
      this.setState({ hasError: true, error: error, errorInfo: errorInfo });
      console.error('Error in component', error, errorInfo);
    }
  }, {
    key: 'render',
    value: function render() {
      if (this.state.hasError) {
        return _react2.default.createElement(
          'div',
          { style: { padding: 18, fontFamily: 'sans-serif' } },
          _react2.default.createElement(
            'div',
            null,
            'Something went wrong'
          ),
          _react2.default.createElement(
            'details',
            { style: { whiteSpace: 'pre-wrap' } },
            this.state.error ? this.state.error.toString() : null,
            _react2.default.createElement('br', null),
            this.state.errorInfo ? this.state.errorInfo.componentStack : null
          )
        );
      }
      return this.props.children;
    }
  }]);

  return ErrorBoundary;
}(_react2.default.Component);

var ExplorerWrapper = function (_React$PureComponent9) {
  _inherits(ExplorerWrapper, _React$PureComponent9);

  function ExplorerWrapper() {
    _classCallCheck(this, ExplorerWrapper);

    return _possibleConstructorReturn(this, (ExplorerWrapper.__proto__ || Object.getPrototypeOf(ExplorerWrapper)).apply(this, arguments));
  }

  _createClass(ExplorerWrapper, [{
    key: 'render',
    value: function render() {
      return _react2.default.createElement(
        'div',
        {
          className: 'historyPaneWrap',
          style: {
            height: '100%',
            width: this.props.width,
            zIndex: 7,
            display: this.props.explorerIsOpen ? 'block' : 'none'
          } },
        _react2.default.createElement(
          'div',
          { className: 'history-title-bar' },
          _react2.default.createElement(
            'div',
            { className: 'history-title' },
            'Explorer'
          ),
          _react2.default.createElement(
            'div',
            { className: 'doc-explorer-rhs' },
            _react2.default.createElement(
              'div',
              {
                className: 'docExplorerHide',
                onClick: this.props.onToggleExplorer },
              '\u2715'
            )
          )
        ),
        _react2.default.createElement(
          'div',
          { className: 'history-contents' },
          _react2.default.createElement(
            ErrorBoundary,
            null,
            _react2.default.createElement(Explorer, this.props)
          )
        )
      );
    }
  }]);

  return ExplorerWrapper;
}(_react2.default.PureComponent);

ExplorerWrapper.defaultValue = defaultValue;
ExplorerWrapper.defaultProps = {
  width: 380
};
exports.default = ExplorerWrapper;