/*
 * Decompiled with CFR 0.152.
 */
package esmska.transfer;

import esmska.data.Queue;
import esmska.data.SMS;
import esmska.data.Tuple;
import esmska.data.event.ValuedEvent;
import esmska.data.event.ValuedListener;
import esmska.transfer.GatewayExecutor;
import esmska.transfer.GatewayInterpreter;
import esmska.utils.L10N;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingWorker;

public class SMSSender {
    private static final Logger logger = Logger.getLogger(SMSSender.class.getName());
    private static final ResourceBundle l10n = L10N.l10nBundle;
    private static final Queue queue = Queue.getInstance();
    private static final String SENDING_CRASHED_ERROR = MessageFormat.format(l10n.getString("SMSSender.SENDING_CRASHED_ERROR"), "http://code.google.com/p/esmska/wiki/Issues");
    private HashMap<String, SMSWorker> workers = new HashMap();
    private static final ExecutorService executor = Executors.newCachedThreadPool();

    public SMSSender() {
        queue.addValuedListener(new QueueListener());
    }

    public boolean isRunning() {
        return !this.workers.isEmpty();
    }

    private void sendNew(String gatewayName) {
        if (queue.isPaused()) {
            return;
        }
        List<SMS> readySMS = queue.getAllWithStatus(SMS.Status.READY, gatewayName);
        for (SMS sms : readySMS) {
            String gateway = sms.getGateway();
            if (this.workers.containsKey(gateway)) continue;
            logger.log(Level.FINE, "Sending new SMS: {0}", sms.toDebugString());
            queue.setSMSSending(sms);
            SMSWorker worker = new SMSWorker(sms);
            this.workers.put(gateway, worker);
            executor.execute(worker);
        }
    }

    private void finishedSending(SMS sms, boolean success) {
        logger.log(Level.FINE, "Finished sending SMS: {0}", sms.toDebugString());
        this.workers.remove(sms.getGateway());
        if (success) {
            queue.setSMSSent(sms);
        } else {
            if (sms.getProblem() == null) {
                logger.log(Level.SEVERE, "SMS sending failed, but no problem is set: {0}", sms);
                sms.setProblem(new Tuple<GatewayExecutor.Problem, Object>(GatewayExecutor.Problem.UNKNOWN, null));
            }
            queue.setSMSFailed(sms);
        }
        this.sendNew(sms.getGateway());
    }

    private class QueueListener
    implements ValuedListener<Queue.Events, SMS> {
        private QueueListener() {
        }

        @Override
        public void eventOccured(ValuedEvent<Queue.Events, SMS> e) {
            switch (e.getEvent()) {
                case NEW_SMS_READY: 
                case QUEUE_RESUMED: {
                    SMSSender.this.sendNew(null);
                }
            }
        }
    }

    private class SMSWorker
    extends SwingWorker<Boolean, Void> {
        private SMS sms;

        public SMSWorker(SMS sms) {
            this.sms = sms;
        }

        @Override
        protected void done() {
            boolean success = false;
            try {
                success = (Boolean)this.get();
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "Sending of SMS crashed", t);
                this.sms.setProblem(new Tuple<GatewayExecutor.Problem, String>(GatewayExecutor.Problem.INTERNAL_MESSAGE, SENDING_CRASHED_ERROR));
            }
            SMSSender.this.finishedSending(this.sms, success);
        }

        @Override
        protected Boolean doInBackground() {
            boolean success;
            block2: {
                success = false;
                try {
                    GatewayInterpreter interpreter = new GatewayInterpreter();
                    this.sms.setProblem(null);
                    this.sms.setSupplMsg(null);
                    success = interpreter.sendMessage(this.sms);
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, "Error while sending sms", ex);
                    success = false;
                    if (this.sms.getProblem() != null) break block2;
                    this.sms.setProblem(new Tuple<GatewayExecutor.Problem, Object>(GatewayExecutor.Problem.UNKNOWN, null));
                }
            }
            return success;
        }
    }
}

