# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.image_reader2 import ImageReader2


class GDALRasterReader(ImageReader2):
    """
    GDALRasterReader - Read raster file formats using GDAL.
    
    Superclass: ImageReader2
    
    GDALRasterReader is a source object that reads raster files and
    uses GDAL as the underlying library for the task. GDAL is required
    for this reader. The output of the reader is a UniformGrid
    (vtk_image_data with blanking) with cell data.
    
    @sa
    UniformGrid, ImageData
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkGDALRasterReader, obj, update, **traits)
    
    target_dimensions = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="int", value=(-1, -1), cols=2, desc=\
        """
        
        """
    )

    def _target_dimensions_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTargetDimensions,
                        self.target_dimensions)

    def get_domain_meta_data(self, *args):
        """
        V.get_domain_meta_data(string) -> Stvector_ISt6stringE
        C++: std::vector<std::string> GetDomainMetaData(
            const std::string &domain)
        Return domain metadata
        """
        ret = self._wrap_call(self._vtk_obj.GetDomainMetaData, *args)
        return ret

    def _get_driver_long_name(self):
        return self._vtk_obj.GetDriverLongName()
    driver_long_name = traits.Property(_get_driver_long_name, desc=\
        """
        Return driver name which was used to read the current data
        """
    )

    def _get_driver_short_name(self):
        return self._vtk_obj.GetDriverShortName()
    driver_short_name = traits.Property(_get_driver_short_name, desc=\
        """
        Return driver name which was used to read the current data
        """
    )

    def _get_geo_corner_points(self):
        return self._vtk_obj.GetGeoCornerPoints()
    geo_corner_points = traits.Property(_get_geo_corner_points, desc=\
        """
        Return geo-referenced corner points (Upper left, lower left,
        lower right, upper right)
        """
    )

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        V.get_input(int) -> DataObject
        C++: DataObject *GetInput(int port)
        V.get_input() -> DataObject
        C++: DataObject *GetInput()
        Get a data object for one of the input port connections.  The use
        of this method is strongly discouraged, but some filters that
        were written a long time ago still use this method.
        """
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_invalid_value(self):
        return self._vtk_obj.GetInvalidValue()
    invalid_value = traits.Property(_get_invalid_value, desc=\
        """
        Return the invalid value for a pixel (for blanking purposes)
        """
    )

    def _get_meta_data(self):
        return self._vtk_obj.GetMetaData()
    meta_data = traits.Property(_get_meta_data, desc=\
        """
        Return metadata as reported by GDAL
        """
    )

    def _get_number_of_cells(self):
        return self._vtk_obj.GetNumberOfCells()
    number_of_cells = traits.Property(_get_number_of_cells, desc=\
        """
        Return the number of cells that are not set to GDAL NODATA
        """
    )

    def _get_projection_string(self):
        return self._vtk_obj.GetProjectionString()
    projection_string = traits.Property(_get_projection_string, desc=\
        """
        Return proj4 spatial reference
        """
    )

    def _get_raster_dimensions(self):
        return self._vtk_obj.GetRasterDimensions()
    raster_dimensions = traits.Property(_get_raster_dimensions, desc=\
        """
        
        """
    )

    _updateable_traits_ = \
    (('file_lower_left', 'GetFileLowerLeft'), ('swap_bytes',
    'GetSwapBytes'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('data_byte_order', 'GetDataByteOrder'), ('target_dimensions',
    'GetTargetDimensions'), ('data_extent', 'GetDataExtent'),
    ('data_origin', 'GetDataOrigin'), ('data_spacing', 'GetDataSpacing'),
    ('file_dimensionality', 'GetFileDimensionality'), ('file_name',
    'GetFileName'), ('file_name_slice_offset', 'GetFileNameSliceOffset'),
    ('file_name_slice_spacing', 'GetFileNameSliceSpacing'),
    ('file_pattern', 'GetFilePattern'), ('file_prefix', 'GetFilePrefix'),
    ('header_size', 'GetHeaderSize'), ('memory_buffer_length',
    'GetMemoryBufferLength'), ('number_of_scalar_components',
    'GetNumberOfScalarComponents'), ('progress', 'GetProgress'),
    ('progress_text', 'GetProgressText'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'file_lower_left',
    'global_warning_display', 'release_data_flag', 'swap_bytes',
    'data_byte_order', 'data_extent', 'data_origin', 'data_spacing',
    'file_dimensionality', 'file_name', 'file_name_slice_offset',
    'file_name_slice_spacing', 'file_pattern', 'file_prefix',
    'header_size', 'memory_buffer_length', 'number_of_scalar_components',
    'progress_text', 'target_dimensions'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(GDALRasterReader, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit GDALRasterReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['file_lower_left', 'swap_bytes'], ['data_byte_order'],
            ['data_extent', 'data_origin', 'data_spacing', 'file_dimensionality',
            'file_name', 'file_name_slice_offset', 'file_name_slice_spacing',
            'file_pattern', 'file_prefix', 'header_size', 'memory_buffer_length',
            'number_of_scalar_components', 'target_dimensions']),
            title='Edit GDALRasterReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit GDALRasterReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

