# _StringSeq
<span class="source-link">[[Source]](src/cli/command_spec.md#L484)</span>

_StringSeq is a wrapper / helper class for working with String sequence
values while parsing. It assists in collecting the strings as they are
parsed, and producing a ReadSeq[String] as a result.


```pony
class ref _StringSeq is
  ReadSeq[String val] box
```

#### Implements

* [ReadSeq](builtin-ReadSeq.md)\[[String](builtin-String.md) val\] box

---

## Constructors

### empty
<span class="source-link">[[Source]](src/cli/command_spec.md#L492)</span>


```pony
new val empty()
: _StringSeq val^
```

#### Returns

* [_StringSeq](cli-_StringSeq.md) val^

---

### from_string
<span class="source-link">[[Source]](src/cli/command_spec.md#L495)</span>


```pony
new val from_string(
  s: String val)
: _StringSeq val^
```
#### Parameters

*   s: [String](builtin-String.md) val

#### Returns

* [_StringSeq](cli-_StringSeq.md) val^

---

### from_concat
<span class="source-link">[[Source]](src/cli/command_spec.md#L498)</span>


```pony
new val from_concat(
  ss0: _StringSeq val,
  ss1: _StringSeq val)
: _StringSeq val^
```
#### Parameters

*   ss0: [_StringSeq](cli-_StringSeq.md) val
*   ss1: [_StringSeq](cli-_StringSeq.md) val

#### Returns

* [_StringSeq](cli-_StringSeq.md) val^

---

## Public fields

### let strings: [Vec](collections-persistent-Vec.md)\[[String](builtin-String.md) val\] val
<span class="source-link">[[Source]](src/cli/command_spec.md#L490)</span>



---

## Public Functions

### string
<span class="source-link">[[Source]](src/cli/command_spec.md#L501)</span>


```pony
fun box string()
: String iso^
```

#### Returns

* [String](builtin-String.md) iso^

---

### size
<span class="source-link">[[Source]](src/cli/command_spec.md#L511)</span>


```pony
fun box size()
: USize val
```

#### Returns

* [USize](builtin-USize.md) val

---

### apply
<span class="source-link">[[Source]](src/cli/command_spec.md#L512)</span>


```pony
fun box apply(
  i: USize val)
: String val ?
```
#### Parameters

*   i: [USize](builtin-USize.md) val

#### Returns

* [String](builtin-String.md) val ?

---

### values
<span class="source-link">[[Source]](src/cli/command_spec.md#L513)</span>


```pony
fun box values()
: Iterator[String val] ref^
```

#### Returns

* [Iterator](builtin-Iterator.md)\[[String](builtin-String.md) val\] ref^

---

