# _WaitPidStatus
<span class="source-link">[[Source]](src/process/_process.md#L300)</span>

Pure Pony implementaton of C macros for investigating
the status returned by `waitpid()`.


```pony
primitive val _WaitPidStatus
```

## Constructors

### create
<span class="source-link">[[Source]](src/process/_process.md#L300)</span>


```pony
new val create()
: _WaitPidStatus val^
```

#### Returns

* [_WaitPidStatus](process-_WaitPidStatus.md) val^

---

## Public Functions

### exited
<span class="source-link">[[Source]](src/process/_process.md#L306)</span>


```pony
fun box exited(
  wstatus: I32 val)
: Bool val
```
#### Parameters

*   wstatus: [I32](builtin-I32.md) val

#### Returns

* [Bool](builtin-Bool.md) val

---

### exit_code
<span class="source-link">[[Source]](src/process/_process.md#L309)</span>


```pony
fun box exit_code(
  wstatus: I32 val)
: I32 val
```
#### Parameters

*   wstatus: [I32](builtin-I32.md) val

#### Returns

* [I32](builtin-I32.md) val

---

### signaled
<span class="source-link">[[Source]](src/process/_process.md#L312)</span>


```pony
fun box signaled(
  wstatus: I32 val)
: Bool val
```
#### Parameters

*   wstatus: [I32](builtin-I32.md) val

#### Returns

* [Bool](builtin-Bool.md) val

---

### termsig
<span class="source-link">[[Source]](src/process/_process.md#L315)</span>


```pony
fun box termsig(
  wstatus: I32 val)
: I32 val
```
#### Parameters

*   wstatus: [I32](builtin-I32.md) val

#### Returns

* [I32](builtin-I32.md) val

---

### stopped
<span class="source-link">[[Source]](src/process/_process.md#L318)</span>


```pony
fun box stopped(
  wstatus: I32 val)
: Bool val
```
#### Parameters

*   wstatus: [I32](builtin-I32.md) val

#### Returns

* [Bool](builtin-Bool.md) val

---

### stopsig
<span class="source-link">[[Source]](src/process/_process.md#L321)</span>


```pony
fun box stopsig(
  wstatus: I32 val)
: I32 val
```
#### Parameters

*   wstatus: [I32](builtin-I32.md) val

#### Returns

* [I32](builtin-I32.md) val

---

### coredumped
<span class="source-link">[[Source]](src/process/_process.md#L324)</span>


```pony
fun box coredumped(
  wstatus: I32 val)
: Bool val
```
#### Parameters

*   wstatus: [I32](builtin-I32.md) val

#### Returns

* [Bool](builtin-Bool.md) val

---

### continued
<span class="source-link">[[Source]](src/process/_process.md#L327)</span>


```pony
fun box continued(
  wstatus: I32 val)
: Bool val
```
#### Parameters

*   wstatus: [I32](builtin-I32.md) val

#### Returns

* [Bool](builtin-Bool.md) val

---

### eq
<span class="source-link">[[Source]](src/process/_process.md#L306)</span>


```pony
fun box eq(
  that: _WaitPidStatus val)
: Bool val
```
#### Parameters

*   that: [_WaitPidStatus](process-_WaitPidStatus.md) val

#### Returns

* [Bool](builtin-Bool.md) val

---

### ne
<span class="source-link">[[Source]](src/process/_process.md#L306)</span>


```pony
fun box ne(
  that: _WaitPidStatus val)
: Bool val
```
#### Parameters

*   that: [_WaitPidStatus](process-_WaitPidStatus.md) val

#### Returns

* [Bool](builtin-Bool.md) val

---

