'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LANGUAGE = undefined;
exports.getDefinitionQueryResultForNamedType = getDefinitionQueryResultForNamedType;
exports.getDefinitionQueryResultForFragmentSpread = getDefinitionQueryResultForFragmentSpread;
exports.getDefinitionQueryResultForDefinitionNode = getDefinitionQueryResultForDefinitionNode;

var _graphqlLanguageServiceUtils = require('graphql-language-service-utils');

var _assert = require('assert');

var _assert2 = _interopRequireDefault(_assert);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 *  Copyright (c) Facebook, Inc.
 *  All rights reserved.
 *
 *  This source code is licensed under the license found in the
 *  LICENSE file in the root directory of this source tree.
 *
 *  
 */

var LANGUAGE = exports.LANGUAGE = 'GraphQL';

function getRange(text, node) {
  var location = node.loc;
  (0, _assert2.default)(location, 'Expected ASTNode to have a location.');
  return (0, _graphqlLanguageServiceUtils.locToRange)(text, location);
}

function getPosition(text, node) {
  var location = node.loc;
  (0, _assert2.default)(location, 'Expected ASTNode to have a location.');
  return (0, _graphqlLanguageServiceUtils.offsetToPosition)(text, location.start);
}

function getDefinitionQueryResultForNamedType(text, node, dependencies) {
  var name, defNodes, definitions;
  return regeneratorRuntime.async(function getDefinitionQueryResultForNamedType$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          name = node.name.value;
          defNodes = dependencies.filter(function (_ref) {
            var definition = _ref.definition;
            return definition.name && definition.name.value === name;
          });

          if (!(defNodes.length === 0)) {
            _context.next = 5;
            break;
          }

          process.stderr.write('Definition not found for GraphQL type ' + name);
          return _context.abrupt('return', { queryRange: [], definitions: [] });

        case 5:
          definitions = defNodes.map(function (_ref2) {
            var filePath = _ref2.filePath,
                content = _ref2.content,
                definition = _ref2.definition;
            return getDefinitionForNodeDefinition(filePath || '', content, definition);
          });
          return _context.abrupt('return', {
            definitions: definitions,
            queryRange: definitions.map(function (_) {
              return getRange(text, node);
            })
          });

        case 7:
        case 'end':
          return _context.stop();
      }
    }
  }, null, this);
}

function getDefinitionQueryResultForFragmentSpread(text, fragment, dependencies) {
  var name, defNodes, definitions;
  return regeneratorRuntime.async(function getDefinitionQueryResultForFragmentSpread$(_context2) {
    while (1) {
      switch (_context2.prev = _context2.next) {
        case 0:
          name = fragment.name.value;
          defNodes = dependencies.filter(function (_ref3) {
            var definition = _ref3.definition;
            return definition.name.value === name;
          });

          if (!(defNodes.length === 0)) {
            _context2.next = 5;
            break;
          }

          process.stderr.write('Definition not found for GraphQL fragment ' + name);
          return _context2.abrupt('return', { queryRange: [], definitions: [] });

        case 5:
          definitions = defNodes.map(function (_ref4) {
            var filePath = _ref4.filePath,
                content = _ref4.content,
                definition = _ref4.definition;
            return getDefinitionForFragmentDefinition(filePath || '', content, definition);
          });
          return _context2.abrupt('return', {
            definitions: definitions,
            queryRange: definitions.map(function (_) {
              return getRange(text, fragment);
            })
          });

        case 7:
        case 'end':
          return _context2.stop();
      }
    }
  }, null, this);
}

function getDefinitionQueryResultForDefinitionNode(path, text, definition) {
  return {
    definitions: [getDefinitionForFragmentDefinition(path, text, definition)],
    queryRange: definition.name ? [getRange(text, definition.name)] : []
  };
}

function getDefinitionForFragmentDefinition(path, text, definition) {
  var name = definition.name;
  (0, _assert2.default)(name, 'Expected ASTNode to have a Name.');
  return {
    path: path,
    position: getPosition(text, definition),
    range: getRange(text, definition),
    name: name.value || '',
    language: LANGUAGE,
    // This is a file inside the project root, good enough for now
    projectRoot: path
  };
}

function getDefinitionForNodeDefinition(path, text, definition) {
  var name = definition.name;
  (0, _assert2.default)(name, 'Expected ASTNode to have a Name.');
  return {
    path: path,
    position: getPosition(text, definition),
    range: getRange(text, definition),
    name: name.value || '',
    language: LANGUAGE,
    // This is a file inside the project root, good enough for now
    projectRoot: path
  };
}