/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractAction;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import net.sf.sdedit.util.PopupActions;

public class TextArea
extends JTextPane
implements UndoableEditListener,
Highlighter.HighlightPainter,
PopupActions.Provider {
    private static final long serialVersionUID = -1422640864L;
    private Highlighter highlighter;
    private UndoManager undoManager = new UndoManager();
    private Object highlight;
    private static final Color ERROR_COLOR = Color.RED;
    private String EOL;
    private PopupActions popupActions;

    @Override
    public void undoableEditHappened(UndoableEditEvent evt) {
        this.undoManager.addEdit(evt.getEdit());
    }

    public TextArea() {
        this.highlighter = new DefaultHighlighter();
        this.setHighlighter(this.highlighter);
        this.getActionMap().put("Undo", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextArea.this.undo();
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke("control Z"), "Undo");
        this.getActionMap().put("Redo", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextArea.this.redo();
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke("control Y"), "Redo");
        this.EOL = (String)this.getDocument().getProperty("__EndOfLine__");
        this.getDocument().putProperty("__EndOfLine__", "\n");
        this.getDocument().addUndoableEditListener(this);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        super.paintComponent(g);
    }

    public void undo() {
        try {
            if (this.undoManager.canUndo()) {
                this.undoManager.undo();
                for (KeyListener kl : this.getKeyListeners()) {
                    kl.keyTyped(null);
                    kl.keyReleased(null);
                }
            }
        }
        catch (CannotUndoException cannotUndoException) {
            // empty catch block
        }
    }

    public void redo() {
        try {
            if (this.undoManager.canRedo()) {
                this.undoManager.redo();
                for (KeyListener kl : this.getKeyListeners()) {
                    kl.keyTyped(null);
                    kl.keyReleased(null);
                }
            }
        }
        catch (CannotRedoException cannotRedoException) {
            // empty catch block
        }
    }

    public void markError(int from, int to) {
        if (this.highlight != null) {
            this.highlighter.removeHighlight(this.highlight);
        }
        if (from >= 0) {
            try {
                this.highlight = this.highlighter.addHighlight(from, to, this);
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
        }
    }

    public int getCaretLine() {
        int caret = this.getCaretPosition();
        String text = this.getText();
        int line = 0;
        for (int i = 0; i < caret; ++i) {
            char c = text.charAt(i);
            if (c != '\n') continue;
            ++line;
        }
        return line;
    }

    private String getText(boolean format) {
        String text;
        if (format) {
            this.getDocument().putProperty("__EndOfLine__", this.EOL);
            text = super.getText();
            this.getDocument().putProperty("__EndOfLine__", "\n");
        } else {
            text = super.getText();
        }
        return text;
    }

    @Override
    public String getText() {
        return this.getText(false);
    }

    public int getCurrentLineBegin() {
        char c;
        int i;
        int caret = this.getCaretPosition();
        String text = this.getText();
        for (i = Math.min(text.length() - 1, caret); i >= 0 && ((c = text.charAt(i)) == '\n' || c == '\r'); --i) {
        }
        while (i >= 0) {
            c = text.charAt(i);
            if (c == '\n' || c == '\r') {
                return i + 1;
            }
            --i;
        }
        return 0;
    }

    private void paintLine(Graphics g, Rectangle r, int x2) {
        int ytop = r.y + r.height - 3;
        for (int x = r.x; x < x2 - r.x; x += 2) {
            g.drawLine(x, ytop, x + 1, ytop + 1);
            g.drawLine(x + 1, ytop + 1, x + 2, ytop);
        }
    }

    @Override
    public void paint(Graphics g, int p0, int p1, Shape bounds, JTextComponent c) {
        Rectangle r0 = null;
        Rectangle r1 = null;
        Rectangle rbounds = bounds.getBounds();
        int xmax = rbounds.x + rbounds.width;
        try {
            r0 = c.modelToView(p0);
            r1 = c.modelToView(p1);
        }
        catch (BadLocationException ex) {
            return;
        }
        if (r0 == null || r1 == null) {
            return;
        }
        g.setColor(ERROR_COLOR);
        if (r0.y == r1.y) {
            this.paintLine(g, r0, r1.x);
            return;
        }
        this.paintLine(g, r0, xmax);
        r0.y += r0.height;
        r0.x = rbounds.x;
        while (r0.y < r1.y) {
            this.paintLine(g, r0, xmax);
            r0.y += r0.height;
        }
        this.paintLine(g, r0, r1.x);
    }

    @Override
    public PopupActions getPopupActions(PopupActions.ContextHandler contextHandler) {
        if (this.popupActions == null) {
            this.popupActions = new PopupActions(this, contextHandler);
        }
        return this.popupActions;
    }
}

