/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.plugins.wifi101;

import cc.arduino.packages.BoardPort;
import cc.arduino.plugins.wifi101.CertificateListModel;
import cc.arduino.plugins.wifi101.SerialPortListModel;
import cc.arduino.plugins.wifi101.UpdaterJFrame;
import cc.arduino.plugins.wifi101.flashers.Flasher;
import cc.arduino.plugins.wifi101.flashers.java.NinaFlasher;
import cc.arduino.plugins.wifi101.flashers.java.WINCFlasher;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import processing.app.Base;

public class UpdaterImpl
extends UpdaterJFrame {
    private SerialPortListModel listModel;
    private List<String> websites = new ArrayList<String>();
    public ArrayList<String> compatibleBoard;
    public static ArrayList<Flasher> fwAvailable = new ArrayList();

    public UpdaterImpl() throws Exception {
        Base.registerWindowCloseKeys((JRootPane)this.getRootPane(), actionEvent -> this.setVisible(false));
        Base.setIcon((Frame)this);
        fwAvailable.add(new WINCFlasher("WINC1501 Model B", "19.6.1", "firmwares/WINC1500/19.6.1/m2m_aio_3a0.bin", true, 1000000, new ArrayList<String>(Arrays.asList("Arduino/Genuino MKR1000"))));
        fwAvailable.add(new WINCFlasher("WINC1501 Model B", "19.5.4", "firmwares/WINC1500/19.5.4/m2m_aio_3a0.bin", true, 1000000, new ArrayList<String>(Arrays.asList("Arduino/Genuino MKR1000"))));
        fwAvailable.add(new WINCFlasher("WINC1501 Model B", "19.5.2", "firmwares/WINC1500/19.5.2/m2m_aio_3a0.bin", true, 1000000, new ArrayList<String>(Arrays.asList("Arduino/Genuino MKR1000"))));
        fwAvailable.add(new WINCFlasher("WINC1501 Model B", "19.4.4", "firmwares/WINC1500/19.4.4/m2m_aio_3a0.bin", true, 1000000, new ArrayList<String>(Arrays.asList("Arduino/Genuino MKR1000"))));
        fwAvailable.add(new WINCFlasher("WINC1501 Model A", "19.4.4", "firmwares/WINC1500/19.4.4/m2m_aio_2b0.bin", true, 115200, new ArrayList<String>(Arrays.asList("Arduino WiFi 101 Shield"))));
        fwAvailable.add(new NinaFlasher("NINA firmware", "1.3.0", "firmwares/NINA/1.3.0/NINA_W102.bin", true, 1000000, new ArrayList<String>(Arrays.asList("Arduino MKR WiFi 1010", "Arduino NANO 33 IoT"))));
        fwAvailable.add(new NinaFlasher("NINA firmware", "1.3.0", "firmwares/NINA/1.3.0/NINA_W102-Uno_WiFi_Rev2.bin", true, 1000000, new ArrayList<String>(Arrays.asList("Arduino Uno WiFi Rev2"))));
        fwAvailable.add(new NinaFlasher("NINA firmware", "1.2.4", "firmwares/NINA/1.2.4/NINA_W102.bin", true, 1000000, new ArrayList<String>(Arrays.asList("Arduino MKR WiFi 1010", "Arduino NANO 33 IoT"))));
        fwAvailable.add(new NinaFlasher("NINA firmware", "1.2.4", "firmwares/NINA/1.2.4/NINA_W102-Uno_WiFi_Rev2.bin", true, 1000000, new ArrayList<String>(Arrays.asList("Arduino Uno WiFi Rev2"))));
        fwAvailable.add(new NinaFlasher("NINA firmware", "1.2.3", "firmwares/NINA/1.2.3/NINA_W102.bin", true, 1000000, new ArrayList<String>(Arrays.asList("Arduino MKR WiFi 1010"))));
        fwAvailable.add(new NinaFlasher("NINA firmware", "1.2.3", "firmwares/NINA/1.2.3/NINA_W102-Uno_WiFi_Rev2.bin", true, 1000000, new ArrayList<String>(Arrays.asList("Arduino Uno WiFi Rev2"))));
        fwAvailable.add(new NinaFlasher("NINA firmware", "1.2.2", "firmwares/NINA/1.2.2/NINA_W102.bin", true, 1000000, new ArrayList<String>(Arrays.asList("Arduino MKR WiFi 1010"))));
        fwAvailable.add(new NinaFlasher("NINA firmware", "1.2.2", "firmwares/NINA/1.2.2/NINA_W102-Uno_WiFi_Rev2.bin", true, 1000000, new ArrayList<String>(Arrays.asList("Arduino Uno WiFi Rev2"))));
        fwAvailable.add(new NinaFlasher("NINA firmware", "1.2.1", "firmwares/NINA/1.2.1/NINA_W102.bin", true, 1000000, new ArrayList<String>(Arrays.asList("Arduino MKR WiFi 1010"))));
        fwAvailable.add(new NinaFlasher("NINA firmware", "1.2.1", "firmwares/NINA/1.2.1/NINA_W102-Uno_WiFi_Rev2.bin", true, 1000000, new ArrayList<String>(Arrays.asList("Arduino Uno WiFi Rev2"))));
        fwAvailable.add(new NinaFlasher("NINA firmware", "1.1.0", "firmwares/NINA/1.1.0/NINA_W102.bin", true, 1000000, new ArrayList<String>(Arrays.asList("Arduino MKR WiFi 1010", "Arduino MKR Vidor 4000", "Arduino Uno WiFi Rev2"))));
        fwAvailable.add(new NinaFlasher("NINA firmware", "1.0.0", "firmwares/NINA/1.0.0/NINA_W102.bin", false, 1000000, new ArrayList<String>(Arrays.asList("Arduino MKR WiFi 1010", "Arduino MKR Vidor 4000", "Arduino Uno WiFi Rev2"))));
        for (Flasher flasher : fwAvailable) {
            this.getFirmwareSelector().addItem(flasher);
        }
        if (this.getSerialPortList().getModel().getSize() == 0) {
            this.setEnabledCommand(false);
        }
        this.refreshSerialPortList();
        this.websites.add("arduino.cc:443");
        this.refreshCertList();
    }

    private void refreshCertList() {
        CertificateListModel certificateListModel = new CertificateListModel(this.websites);
        this.getCertSelector().setModel(certificateListModel);
    }

    @Override
    protected void refreshSerialPortList() {
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        this.listModel = new SerialPortListModel();
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            BoardPort boardPort = this.listModel.getPort(i);
            if (boardPort.getBoardName() != null) {
                defaultListModel.addElement(boardPort.getBoardName().concat(" (").concat(boardPort.getAddress()).concat(")"));
                continue;
            }
            defaultListModel.addElement(boardPort.getAddress());
        }
        this.getSerialPortList().removeAll();
        this.getSerialPortList().setModel(defaultListModel);
    }

    @Override
    protected void updateCertSection() {
        Flasher flasher = (Flasher)this.getFirmwareSelector().getSelectedItem();
        if (flasher != null) {
            this.hideCertificatePanel(flasher.certificatesAvailable());
        }
    }

    @Override
    protected void SelectBoardModule() {
        int n = 0;
        this.setEnabledCommand(true);
        this.hideCertificatePanel(true);
        this.getFirmwareSelector().removeAllItems();
        if (this.getSelectedPort() != null) {
            for (Flasher flasher : fwAvailable) {
                if (!flasher.isCompatible(this.getSelectedPort().getBoardName())) continue;
                this.getFirmwareSelector().addItem(flasher);
                ++n;
            }
            if (n == 0) {
                for (Flasher flasher : fwAvailable) {
                    this.getFirmwareSelector().addItem(flasher);
                }
            }
            Flasher flasher = (Flasher)this.getFirmwareSelector().getSelectedItem();
            this.hideCertificatePanel(flasher.certificatesAvailable());
        } else {
            this.setEnabledCommand(false);
            this.hideCertificatePanel(false);
        }
    }

    private BoardPort getSelectedPort() {
        int n = this.getSerialPortList().getSelectedIndex();
        if (n == -1) {
            return null;
        }
        return this.listModel.getPort(n);
    }

    @Override
    protected void testConnection() {
        final Flasher flasher = (Flasher)this.getFirmwareSelector().getSelectedItem();
        flasher.setProgressBar(this.getUpdateProgressBar());
        final BoardPort boardPort = this.getSelectedPort();
        if (boardPort == null) {
            JOptionPane.showMessageDialog(this, "Please select a port to run the test!");
            return;
        }
        this.setEnabled(false);
        new Thread(){

            @Override
            public void run() {
                try {
                    flasher.testConnection(boardPort.getAddress(), flasher.getBaudrate());
                    JOptionPane.showMessageDialog(UpdaterImpl.this, "The programmer is working!", "Test successful", 1);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(UpdaterImpl.this, exception.getMessage(), "Connection error.", 0);
                }
                UpdaterImpl.this.setEnabled(true);
                UpdaterImpl.this.resetProgress();
            }
        }.start();
    }

    @Override
    protected void openFirmwareUpdaterSketch() {
        Flasher flasher = (Flasher)this.getFirmwareSelector().getSelectedItem();
        try {
            flasher.openFirmwareUpdaterSketch(this.getSelectedPort());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    protected void updateFirmware() {
        final BoardPort boardPort = this.getSelectedPort();
        if (boardPort == null) {
            JOptionPane.showMessageDialog(this, "Please select a port to update firmware!");
            return;
        }
        final Flasher flasher = (Flasher)this.getFirmwareSelector().getSelectedItem();
        flasher.setProgressBar(this.getUpdateProgressBar());
        this.setEnabled(false);
        new Thread(){

            @Override
            public void run() {
                try {
                    flasher.updateFirmware(boardPort.getAddress());
                    JOptionPane.showMessageDialog(UpdaterImpl.this, "The firmware has been updated!", "Success", 1);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(UpdaterImpl.this, exception.getMessage(), "Upload error.", 0);
                }
                UpdaterImpl.this.setEnabled(true);
                UpdaterImpl.this.resetProgress();
            }
        }.start();
    }

    @Override
    protected void addCertificate() {
        String string = JOptionPane.showInputDialog(this, "Enter the website to fetch SSL certificate:", "Add SSL certificate from website", 3);
        if (string.startsWith("http://")) {
            JOptionPane.showMessageDialog(this, "Sorry \"http://\" protocol doesn't support SSL", "Invalid URL error.", 0);
            return;
        }
        if (string.startsWith("https://")) {
            string = string.substring(8);
        }
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        if (!string.contains(":")) {
            string = string + ":443";
        }
        if (string.contains("/")) {
            JOptionPane.showMessageDialog(this, "Error: please use enter the addres using the format:\nwww.example.com:443", "Invalid URL error.", 0);
            return;
        }
        if (!this.websites.contains(string)) {
            this.websites.add(string);
        }
        this.refreshCertList();
    }

    @Override
    protected void removeCertificate() {
        int n = this.getCertSelector().getSelectedIndex();
        if (n == -1) {
            return;
        }
        this.websites.remove(n);
        this.refreshCertList();
    }

    @Override
    protected void uploadCertificates() {
        final Flasher flasher = (Flasher)this.getFirmwareSelector().getSelectedItem();
        flasher.setProgressBar(this.getUpdateProgressBar());
        final BoardPort boardPort = this.getSelectedPort();
        if (boardPort == null) {
            JOptionPane.showMessageDialog(this, "Please select a port to upload SSL certificates!");
            return;
        }
        this.setEnabled(false);
        new Thread(){

            @Override
            public void run() {
                try {
                    flasher.uploadCertificates(boardPort.getAddress(), UpdaterImpl.this.websites);
                    JOptionPane.showMessageDialog(UpdaterImpl.this, "The certificates have been uploaded!", "Success", 1);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(UpdaterImpl.this, exception.getMessage(), "Upload error.", 0);
                }
                UpdaterImpl.this.setEnabled(true);
                UpdaterImpl.this.resetProgress();
            }
        }.start();
    }

    public void resetProgress() {
        this.getUpdateProgressBar().setValue(0);
        this.getUpdateProgressBar().setStringPainted(false);
    }
}

