/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.common.plugins;

import freemind.extensions.PermanentNodeHook;
import freemind.extensions.PermanentNodeHookAdapter;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.main.XMLElement;
import freemind.modes.MindMapNode;
import java.io.File;
import java.util.HashMap;
import javax.swing.ImageIcon;

public class MapNodePositionHolderBase
extends PermanentNodeHookAdapter {
    public static final String NODE_MAP_HOOK_NAME = "plugins/map/MapNodePositionHolder.properties";
    public static final String NODE_MAP_LOCATION_ICON = "node_map_location_icon";
    protected static final String XML_STORAGE_POS_LON = "XML_STORAGE_POS_LON";
    protected static final String XML_STORAGE_POS_LAT = "XML_STORAGE_POS_LAT";
    protected static final String XML_STORAGE_MAP_LON = "XML_STORAGE_MAP_LON";
    protected static final String XML_STORAGE_MAP_LAT = "XML_STORAGE_MAP_LAT";
    protected static final String XML_STORAGE_ZOOM = "XML_STORAGE_ZOOM";
    protected static final String XML_STORAGE_TILE_SOURCE = "XML_STORAGE_TILE_SOURCE";
    protected static final String XML_STORAGE_MAP_TOOLTIP_LOCATION = "XML_STORAGE_MAP_TOOLTIP_LOCATION";
    protected static final String NODE_MAP_STORE_TOOLTIP = "node_map_store_tooltip";
    protected static final String NODE_MAP_SHOW_TOOLTIP = "node_map_show_tooltip";
    public static final String TILE_SOURCE_MAP_QUEST_OPEN_MAP = "plugins.map.FreeMindMapController.MapQuestOpenMap";
    public static final String TILE_SOURCE_TRANSPORT_MAP = "plugins.map.FreeMindMapController.TransportMap";
    public static final String TILE_SOURCE_CYCLE_MAP = "org.openstreetmap.gui.jmapviewer.tilesources.OsmTileSource$CycleMap";
    public static final String TILE_SOURCE_MAPNIK = "org.openstreetmap.gui.jmapviewer.tilesources.OsmTileSource$Mapnik";
    public static final String SHORT_MAP_QUEST_OPEN_MAP = "Q";
    public static final String SHORT_TRANSPORT_MAP = "T";
    public static final String SHORT_CYCLE_MAP = "C";
    public static final String SHORT_MAPNIK = "M";
    public static ImageIcon sMapLocationIcon;
    protected String mTooltipLocation = null;
    protected File mTooltipFile = null;
    private HashMap mValues;

    public static ImageIcon getMapLocationIcon() {
        if (sMapLocationIcon == null) {
            sMapLocationIcon = new ImageIcon(Resources.getInstance().getResource("images/map_location.png"));
        }
        return sMapLocationIcon;
    }

    protected void setStateIcon(MindMapNode node, boolean enabled) {
        node.setStateIcon(NODE_MAP_LOCATION_ICON, enabled ? MapNodePositionHolderBase.getMapLocationIcon() : null);
    }

    @Override
    public void shutdownMapHook() {
        this.setStateIcon(this.getNode(), false);
        this.hideTooltip();
        super.shutdownMapHook();
    }

    @Override
    public void invoke(MindMapNode pNode) {
        super.invoke(pNode);
        this.setStateIcon(pNode, true);
        this.showTooltip();
    }

    public void showTooltip() {
        if (this.isTooltipDesired() && this.mTooltipLocation != null) {
            this.addTooltip();
        }
    }

    protected boolean isTooltipDesired() {
        return Resources.getInstance().getBoolProperty(NODE_MAP_SHOW_TOOLTIP) && !Tools.safeEquals(this.mTooltipLocation, "false");
    }

    @Override
    public void loadFrom(XMLElement pChild) {
        super.loadFrom(pChild);
        this.mValues = this.loadNameValuePairs(pChild);
        this.mTooltipLocation = (String)this.mValues.get(XML_STORAGE_MAP_TOOLTIP_LOCATION);
    }

    public void addTooltip() {
        String imageHtml = this.getImageHtml();
        this.setToolTip(NODE_MAP_HOOK_NAME, imageHtml);
    }

    public String getImageHtml() {
        String imageTag = "<img src=\"file:./" + this.mTooltipLocation + "\"/>";
        String imageHtml = "<html><body>" + imageTag + "</body></html>";
        this.logger.fine("Tooltip at " + imageTag);
        return imageHtml;
    }

    protected void hideTooltip() {
        this.setToolTip(NODE_MAP_HOOK_NAME, null);
    }

    public static MapNodePositionHolderBase getBaseHook(MindMapNode node) {
        for (PermanentNodeHook element : node.getActivatedHooks()) {
            if (!(element instanceof MapNodePositionHolderBase)) continue;
            return (MapNodePositionHolderBase)element;
        }
        return null;
    }

    public String[] getBarePosition() {
        return new String[]{(String)this.mValues.get(XML_STORAGE_POS_LAT), (String)this.mValues.get(XML_STORAGE_POS_LON), (String)this.mValues.get(XML_STORAGE_MAP_LAT), (String)this.mValues.get(XML_STORAGE_MAP_LON), (String)this.mValues.get(XML_STORAGE_ZOOM), (String)this.mValues.get(XML_STORAGE_TILE_SOURCE)};
    }
}

