/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils.search;

import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import jadx.api.JavaClass;
import jadx.gui.treemodel.CodeNode;
import jadx.gui.utils.UiUtils;
import jadx.gui.utils.search.StringRef;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeIndex {
    private static final Logger LOG = LoggerFactory.getLogger(CodeIndex.class);
    private final List<CodeNode> values = new ArrayList<CodeNode>();

    public synchronized void put(CodeNode value) {
        this.values.add(value);
    }

    public void removeForCls(JavaClass cls) {
        this.values.removeIf(v -> v.getJavaNode().getTopParentClass().equals(cls));
    }

    private boolean isMatched(StringRef key, String str, boolean caseInsensitive) {
        return key.indexOf(str, caseInsensitive) != -1;
    }

    public Flowable<CodeNode> search(String searchStr, boolean caseInsensitive) {
        return Flowable.create(emitter -> {
            LOG.debug("Code search started: {} ...", (Object)searchStr);
            for (CodeNode node : this.values) {
                if (this.isMatched(node.getLineStr(), searchStr, caseInsensitive)) {
                    emitter.onNext((Object)node);
                }
                if (!emitter.isCancelled()) continue;
                LOG.debug("Code search canceled: {}", (Object)searchStr);
                return;
            }
            LOG.debug("Code search complete: {}, memory usage: {}", (Object)searchStr, (Object)UiUtils.memoryInfo());
            emitter.onComplete();
        }, (BackpressureStrategy)BackpressureStrategy.LATEST);
    }

    public int size() {
        return this.values.size();
    }
}

