/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.codegen;

import jadx.api.CodePosition;
import jadx.api.ICodeInfo;
import jadx.api.impl.SimpleCodeInfo;
import jadx.core.dex.attributes.nodes.LineAttrNode;
import jadx.core.utils.StringUtils;
import jadx.core.utils.Utils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeWriter {
    private static final Logger LOG = LoggerFactory.getLogger(CodeWriter.class);
    public static final String NL = System.getProperty("line.separator");
    public static final String INDENT_STR = "    ";
    private static final boolean ADD_LINE_NUMBERS = false;
    private static final String[] INDENT_CACHE = new String[]{"", "    ", "        ", "            ", "                ", "                    "};
    private StringBuilder buf;
    @Nullable
    private String code;
    private String indentStr = "";
    private int indent = 0;
    private int line = 1;
    private int offset = 0;
    private Map<CodePosition, Object> annotations = Collections.emptyMap();
    private Map<Integer, Integer> lineMap = Collections.emptyMap();

    public CodeWriter() {
        this.buf = new StringBuilder();
    }

    public CodeWriter startLine() {
        this.addLine();
        this.addLineIndent();
        return this;
    }

    public CodeWriter startLine(char c) {
        this.addLine();
        this.addLineIndent();
        this.add(c);
        return this;
    }

    public CodeWriter startLine(String str) {
        this.addLine();
        this.addLineIndent();
        this.add(str);
        return this;
    }

    public CodeWriter startLineWithNum(int sourceLine) {
        if (sourceLine == 0) {
            this.startLine();
            return this;
        }
        this.startLine();
        this.attachSourceLine(sourceLine);
        return this;
    }

    public CodeWriter addMultiLine(String str) {
        if (str.contains(NL)) {
            this.buf.append(str.replace(NL, NL + this.indentStr));
            this.line += StringUtils.countMatches(str, NL);
            this.offset = 0;
        } else {
            this.buf.append(str);
        }
        return this;
    }

    public CodeWriter add(String str) {
        this.buf.append(str);
        this.offset += str.length();
        return this;
    }

    public CodeWriter add(char c) {
        this.buf.append(c);
        ++this.offset;
        return this;
    }

    CodeWriter add(CodeWriter code) {
        --this.line;
        for (Map.Entry<CodePosition, Object> entry : code.annotations.entrySet()) {
            CodePosition pos = entry.getKey();
            this.attachAnnotation(entry.getValue(), new CodePosition(this.line + pos.getLine(), pos.getOffset()));
        }
        for (Map.Entry<Object, Object> entry : code.lineMap.entrySet()) {
            this.attachSourceLine(this.line + (Integer)entry.getKey(), (Integer)entry.getValue());
        }
        this.line += code.line;
        this.offset = code.offset;
        this.buf.append((CharSequence)code.buf);
        return this;
    }

    public CodeWriter newLine() {
        this.addLine();
        return this;
    }

    public CodeWriter addIndent() {
        this.add(INDENT_STR);
        return this;
    }

    private void addLine() {
        this.buf.append(NL);
        ++this.line;
        this.offset = 0;
    }

    private CodeWriter addLineIndent() {
        this.buf.append(this.indentStr);
        this.offset += this.indentStr.length();
        return this;
    }

    private void updateIndent() {
        int curIndent = this.indent;
        this.indentStr = curIndent < INDENT_CACHE.length ? INDENT_CACHE[curIndent] : Utils.strRepeat(INDENT_STR, curIndent);
    }

    public void incIndent() {
        this.incIndent(1);
    }

    public void decIndent() {
        this.decIndent(1);
    }

    public void incIndent(int c) {
        this.indent += c;
        this.updateIndent();
    }

    public void decIndent(int c) {
        this.indent -= c;
        if (this.indent < 0) {
            LOG.warn("Indent < 0");
            this.indent = 0;
        }
        this.updateIndent();
    }

    public int getIndent() {
        return this.indent;
    }

    public void setIndent(int indent) {
        this.indent = indent;
        this.updateIndent();
    }

    public int getLine() {
        return this.line;
    }

    public void attachDefinition(LineAttrNode obj) {
        this.attachAnnotation(obj);
        this.attachAnnotation(new DefinitionWrapper(obj), new CodePosition(this.line, this.offset));
    }

    public void attachAnnotation(Object obj) {
        this.attachAnnotation(obj, new CodePosition(this.line, this.offset + 1));
    }

    public void attachLineAnnotation(Object obj) {
        this.attachAnnotation(obj, new CodePosition(this.line, 0));
    }

    private Object attachAnnotation(Object obj, CodePosition pos) {
        if (this.annotations.isEmpty()) {
            this.annotations = new HashMap<CodePosition, Object>();
        }
        return this.annotations.put(pos, obj);
    }

    public void attachSourceLine(int sourceLine) {
        if (sourceLine == 0) {
            return;
        }
        this.attachSourceLine(this.line, sourceLine);
    }

    private void attachSourceLine(int decompiledLine, int sourceLine) {
        if (this.lineMap.isEmpty()) {
            this.lineMap = new TreeMap<Integer, Integer>();
        }
        this.lineMap.put(decompiledLine, sourceLine);
    }

    public ICodeInfo finish() {
        this.removeFirstEmptyLine();
        this.processDefinitionAnnotations();
        this.code = this.buf.toString();
        this.buf = null;
        return new SimpleCodeInfo(this.code, this.lineMap, this.annotations);
    }

    private void removeFirstEmptyLine() {
        int len = NL.length();
        if (this.buf.length() > len && this.buf.substring(0, len).equals(NL)) {
            this.buf.delete(0, len);
        }
    }

    private void processDefinitionAnnotations() {
        if (!this.annotations.isEmpty()) {
            this.annotations.entrySet().removeIf(entry -> {
                Object v = entry.getValue();
                if (v instanceof DefinitionWrapper) {
                    LineAttrNode l = ((DefinitionWrapper)v).getNode();
                    l.setDecompiledLine(((CodePosition)entry.getKey()).getLine());
                    return true;
                }
                return false;
            });
        }
    }

    public int bufLength() {
        return this.buf.length();
    }

    public String getCodeStr() {
        if (this.code == null) {
            this.finish();
        }
        return this.code;
    }

    public String toString() {
        return this.code != null ? this.code : this.buf.toString();
    }

    private static class DefinitionWrapper {
        private final LineAttrNode node;

        private DefinitionWrapper(LineAttrNode node) {
            this.node = node;
        }

        public LineAttrNode getNode() {
            return this.node;
        }
    }
}

