/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.attributes;

import jadx.api.plugins.input.data.annotations.EncodedValue;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.IAttribute;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;

public class FieldInitAttr
implements IAttribute {
    public static final FieldInitAttr NULL_VALUE = FieldInitAttr.constValue(EncodedValue.NULL);
    private final Object value;
    private final InitType valueType;
    private final MethodNode insnMth;

    private FieldInitAttr(InitType valueType, Object value, MethodNode insnMth) {
        this.value = value;
        this.valueType = valueType;
        this.insnMth = insnMth;
    }

    public static FieldInitAttr constValue(EncodedValue value) {
        return new FieldInitAttr(InitType.CONST, value, null);
    }

    public static FieldInitAttr insnValue(MethodNode mth, InsnNode insn) {
        return new FieldInitAttr(InitType.INSN, insn, mth);
    }

    public EncodedValue getEncodedValue() {
        return (EncodedValue)this.value;
    }

    public InsnNode getInsn() {
        return (InsnNode)this.value;
    }

    public InitType getValueType() {
        return this.valueType;
    }

    public MethodNode getInsnMth() {
        return this.insnMth;
    }

    public AType<FieldInitAttr> getType() {
        return AType.FIELD_INIT;
    }

    public String toString() {
        return "V=" + this.value;
    }

    public static enum InitType {
        CONST,
        INSN;

    }
}

