/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.nodes.utils;

import jadx.core.clsp.ClspClass;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.MethodTypeVarsAttr;
import jadx.core.dex.attributes.nodes.NotificationAttrNode;
import jadx.core.dex.instructions.BaseInvokeNode;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.IMethodDetails;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.Utils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class TypeUtils {
    private final RootNode root;

    public TypeUtils(RootNode rootNode) {
        this.root = rootNode;
    }

    public List<ArgType> getClassGenerics(ArgType type) {
        ClassNode classNode = this.root.resolveClass(type);
        if (classNode != null) {
            return classNode.getGenericTypeParameters();
        }
        ClspClass clsDetails = this.root.getClsp().getClsDetails(type);
        if (clsDetails == null || clsDetails.getTypeParameters().isEmpty()) {
            return Collections.emptyList();
        }
        List<ArgType> generics = clsDetails.getTypeParameters();
        return generics == null ? Collections.emptyList() : generics;
    }

    public ArgType expandTypeVariables(ClassNode cls, ArgType type) {
        if (type.containsTypeVariable()) {
            this.expandTypeVar(cls, type, cls.getGenericTypeParameters());
        }
        return type;
    }

    public ArgType expandTypeVariables(MethodNode mth, ArgType type) {
        if (type.containsTypeVariable()) {
            this.expandTypeVar(mth, type, this.getKnownTypeVarsAtMethod(mth));
        }
        return type;
    }

    private void expandTypeVar(NotificationAttrNode node, ArgType type, Collection<ArgType> typeVars) {
        boolean allExtendsEmpty = true;
        for (ArgType argType : typeVars) {
            if (!Utils.notEmpty(argType.getExtendTypes())) continue;
            allExtendsEmpty = false;
            break;
        }
        if (allExtendsEmpty) {
            return;
        }
        type.visitTypes(t -> {
            if (t.isGenericType()) {
                String typeVarName = t.getObject();
                for (ArgType typeVar : typeVars) {
                    if (!typeVar.getObject().equals(typeVarName)) continue;
                    t.setExtendTypes(typeVar.getExtendTypes());
                    return null;
                }
                node.addWarnComment("Unknown type variable: " + typeVarName + " in type: " + type);
            }
            return null;
        });
    }

    public Set<ArgType> getKnownTypeVarsAtMethod(MethodNode mth) {
        MethodTypeVarsAttr typeVarsAttr = mth.get(AType.METHOD_TYPE_VARS);
        if (typeVarsAttr != null) {
            return typeVarsAttr.getTypeVars();
        }
        Set<ArgType> typeVars = TypeUtils.collectKnownTypeVarsAtMethod(mth);
        MethodTypeVarsAttr varsAttr = MethodTypeVarsAttr.build(typeVars);
        mth.addAttr(varsAttr);
        return varsAttr.getTypeVars();
    }

    private static Set<ArgType> collectKnownTypeVarsAtMethod(MethodNode mth) {
        ClassNode declCls = mth.getParentClass();
        HashSet<ArgType> typeVars = new HashSet<ArgType>(declCls.getGenericTypeParameters());
        declCls.visitParentClasses(parent -> typeVars.addAll(parent.getGenericTypeParameters()));
        typeVars.addAll(mth.getTypeParameters());
        return typeVars.isEmpty() ? Collections.emptySet() : typeVars;
    }

    @Nullable
    public ArgType replaceClassGenerics(ArgType instanceType, ArgType typeWithGeneric) {
        if (typeWithGeneric == null) {
            return null;
        }
        Map<ArgType, ArgType> replaceMap = this.getTypeVariablesMapping(instanceType);
        if (replaceMap.isEmpty()) {
            return null;
        }
        return this.replaceTypeVariablesUsingMap(typeWithGeneric, replaceMap);
    }

    public Map<ArgType, ArgType> getTypeVariablesMapping(ArgType clsType) {
        if (!clsType.isGeneric()) {
            return Collections.emptyMap();
        }
        List<ArgType> typeParameters = this.root.getTypeUtils().getClassGenerics(clsType);
        if (typeParameters.isEmpty()) {
            return Collections.emptyMap();
        }
        List<ArgType> actualTypes = clsType.getGenericTypes();
        if (Utils.isEmpty(actualTypes)) {
            return Collections.emptyMap();
        }
        int genericParamsCount = actualTypes.size();
        if (genericParamsCount != typeParameters.size()) {
            return Collections.emptyMap();
        }
        HashMap<ArgType, ArgType> replaceMap = new HashMap<ArgType, ArgType>(genericParamsCount);
        for (int i = 0; i < genericParamsCount; ++i) {
            ArgType actualType = actualTypes.get(i);
            ArgType typeVar = typeParameters.get(i);
            replaceMap.put(typeVar, actualType);
        }
        return replaceMap;
    }

    @Nullable
    public ArgType replaceMethodGenerics(BaseInvokeNode invokeInsn, IMethodDetails details, ArgType typeWithGeneric) {
        if (typeWithGeneric == null) {
            return null;
        }
        List<ArgType> methodArgTypes = details.getArgTypes();
        if (methodArgTypes.isEmpty()) {
            return null;
        }
        int firstArgOffset = invokeInsn.getFirstArgOffset();
        int argsCount = methodArgTypes.size();
        for (int i = 0; i < argsCount; ++i) {
            ArgType methodArgType = methodArgTypes.get(i);
            InsnArg insnArg = invokeInsn.getArg(i + firstArgOffset);
            ArgType insnType = insnArg.getType();
            if (!methodArgType.equals(typeWithGeneric)) continue;
            return insnType;
        }
        return null;
    }

    @Nullable
    public ArgType replaceTypeVariablesUsingMap(ArgType replaceType, Map<ArgType, ArgType> replaceMap) {
        if (replaceMap.isEmpty()) {
            return null;
        }
        if (replaceType.isGenericType()) {
            return replaceMap.get(replaceType);
        }
        if (replaceType.isArray()) {
            ArgType replaced = this.replaceTypeVariablesUsingMap(replaceType.getArrayElement(), replaceMap);
            if (replaced == null) {
                return null;
            }
            return ArgType.array(replaced);
        }
        ArgType wildcardType = replaceType.getWildcardType();
        if (wildcardType != null && wildcardType.containsTypeVariable()) {
            ArgType newWildcardType = this.replaceTypeVariablesUsingMap(wildcardType, replaceMap);
            if (newWildcardType == null) {
                return null;
            }
            return ArgType.wildcard(newWildcardType, replaceType.getWildcardBound());
        }
        List<ArgType> genericTypes = replaceType.getGenericTypes();
        if (replaceType.isGeneric() && Utils.notEmpty(genericTypes)) {
            List<ArgType> newTypes = Utils.collectionMap(genericTypes, t -> {
                ArgType type = this.replaceTypeVariablesUsingMap((ArgType)t, replaceMap);
                return type == null ? t : type;
            });
            return ArgType.generic(replaceType, newTypes);
        }
        return null;
    }
}

