/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils;

import jadx.core.codegen.CodeWriter;
import jadx.core.codegen.InsnGen;
import jadx.core.codegen.MethodGen;
import jadx.core.dex.attributes.IAttributeNode;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.IBlock;
import jadx.core.dex.nodes.IContainer;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.DotGraphVisitor;
import jadx.core.dex.visitors.IDexTreeVisitor;
import jadx.core.dex.visitors.regions.DepthRegionTraversal;
import jadx.core.dex.visitors.regions.TracedRegionVisitor;
import jadx.core.utils.StringUtils;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.CodegenException;
import jadx.core.utils.exceptions.JadxException;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.TestOnly;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@TestOnly
public class DebugUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DebugUtils.class);

    private DebugUtils() {
    }

    public static void dump(MethodNode mth) {
        DebugUtils.dump(mth, "dump");
    }

    public static void dumpRaw(MethodNode mth, String desc) {
        File out = new File("test-graph-" + desc + "-tmp");
        DotGraphVisitor.dumpRaw().save(out, mth);
    }

    public static IDexTreeVisitor dumpRawVisitor(final String desc) {
        return new AbstractVisitor(){

            @Override
            public void visit(MethodNode mth) throws JadxException {
                DebugUtils.dumpRaw(mth, desc);
            }
        };
    }

    public static void dump(MethodNode mth, String desc) {
        File out = new File("test-graph-" + desc + "-tmp");
        DotGraphVisitor.dump().save(out, mth);
        DotGraphVisitor.dumpRaw().save(out, mth);
        DotGraphVisitor.dumpRegions().save(out, mth);
    }

    public static void printRegionsWithBlock(MethodNode mth, final BlockNode block) {
        final LinkedHashSet regions = new LinkedHashSet();
        DepthRegionTraversal.traverse(mth, new TracedRegionVisitor(){

            @Override
            public void processBlockTraced(MethodNode mth, IBlock container, IRegion currentRegion) {
                if (block.equals(container)) {
                    regions.add(currentRegion);
                }
            }
        });
        LOG.debug(" Found block: {} in regions: {}", (Object)block, regions);
    }

    public static IDexTreeVisitor printRegionsVisitor() {
        return new AbstractVisitor(){

            @Override
            public void visit(MethodNode mth) throws JadxException {
                DebugUtils.printRegions(mth, true);
            }
        };
    }

    public static void printRegions(MethodNode mth) {
        DebugUtils.printRegions(mth, false);
    }

    public static void printRegions(MethodNode mth, boolean printInsns) {
        DebugUtils.printRegion(mth, mth.getRegion(), printInsns);
    }

    public static void printRegion(MethodNode mth, IRegion region, boolean printInsns) {
        CodeWriter cw = new CodeWriter();
        cw.startLine('|').add(mth.toString());
        DebugUtils.printRegion(mth, region, cw, "|  ", printInsns);
        LOG.debug("{}{}", (Object)CodeWriter.NL, (Object)cw.finish().getCodeStr());
    }

    private static void printRegion(MethodNode mth, IRegion region, CodeWriter cw, String indent, boolean printInsns) {
        DebugUtils.printWithAttributes(cw, indent, region.toString(), region);
        indent = indent + "|  ";
        for (IContainer container : region.getSubBlocks()) {
            if (container instanceof IRegion) {
                DebugUtils.printRegion(mth, (IRegion)container, cw, indent, printInsns);
                continue;
            }
            DebugUtils.printWithAttributes(cw, indent, container.toString(), container);
            if (!printInsns || !(container instanceof IBlock)) continue;
            IBlock block = (IBlock)container;
            DebugUtils.printInsns(mth, cw, indent, block);
        }
    }

    private static void printInsns(MethodNode mth, CodeWriter cw, String indent, IBlock block) {
        for (InsnNode insn : block.getInstructions()) {
            try {
                String insnStr;
                MethodGen mg = MethodGen.getFallbackMethodGen(mth);
                InsnGen ig = new InsnGen(mg, true);
                CodeWriter code = new CodeWriter();
                ig.makeInsn(insn, code);
                String codeStr = code.finish().getCodeStr();
                List insnStrings = Stream.of(codeStr.split(CodeWriter.NL)).filter(StringUtils::notBlank).map(s -> "|> " + s).collect(Collectors.toList());
                Iterator it = insnStrings.iterator();
                while (true) {
                    insnStr = (String)it.next();
                    if (!it.hasNext()) break;
                    cw.startLine(indent).add(insnStr);
                }
                DebugUtils.printWithAttributes(cw, indent, insnStr, insn);
            }
            catch (CodegenException e) {
                cw.startLine(indent).add(">!! ").add(insn.toString());
            }
        }
    }

    private static void printWithAttributes(CodeWriter cw, String indent, String codeStr, IAttributeNode attrNode) {
        String str = attrNode.isAttrStorageEmpty() ? codeStr : codeStr + ' ' + attrNode.getAttributesString();
        List attrStrings = Stream.of(str.split(CodeWriter.NL)).filter(StringUtils::notBlank).collect(Collectors.toList());
        Iterator it = attrStrings.iterator();
        if (!it.hasNext()) {
            return;
        }
        cw.startLine(indent).add((String)it.next());
        while (it.hasNext()) {
            cw.startLine(indent).add("|+  ").add((String)it.next());
        }
    }

    public static void printMap(Map<?, ?> map, String desc) {
        LOG.debug("Map {} (size = {}):", (Object)desc, (Object)map.size());
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            LOG.debug("  {}: {}", entry.getKey(), entry.getValue());
        }
    }

    public static void printStackTrace(String label) {
        LOG.debug("StackTrace: {}\n{}", (Object)label, (Object)Utils.getStackTrace(new Exception()));
    }
}

