/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.annotation.Nonnull;
import javax.swing.JOptionPane;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.bufferio.IoTask;
import org.gjt.sp.jedit.gui.ErrorListDialog;
import org.gjt.sp.jedit.io.FileVFS;
import org.gjt.sp.jedit.io.UrlVFS;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.VFSUpdate;
import org.gjt.sp.util.AwtRunnableQueue;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.Task;
import org.gjt.sp.util.TaskManager;
import org.gjt.sp.util.ThreadUtilities;

public class VFSManager {
    public static final String SERVICE = "org.gjt.sp.jedit.io.VFS";
    private static final VFS fileVFS;
    private static final VFS urlVFS;
    private static boolean error;
    private static final Object errorLock;
    private static final Vector<ErrorListDialog.ErrorEntry> errors;
    private static final Object vfsUpdateLock;
    private static final List<VFSUpdate> vfsUpdates;
    private static boolean errorDisplayerActive;

    public static void init() {
    }

    public static void start() {
        AwtRunnableQueue.INSTANCE.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canReadFile(String string) {
        VFS vFS = VFSManager.getVFSForPath(string);
        Object object = vFS.createVFSSession(string, jEdit.getActiveView());
        if (object == null) {
            return false;
        }
        try {
            VFSFile vFSFile = vFS._getFile(object, string, jEdit.getActiveView());
            boolean bl = vFSFile != null && vFSFile.isReadable() && vFSFile.getType() == 1;
            return bl;
        }
        catch (IOException iOException) {
            Log.log(9, VFSManager.class, iOException, iOException);
        }
        finally {
            try {
                vFS._endVFSSession(object, jEdit.getActiveView());
            }
            catch (IOException iOException) {
                Log.log(9, VFSManager.class, iOException, iOException);
            }
        }
        return false;
    }

    public static VFS getFileVFS() {
        return fileVFS;
    }

    public static VFS getUrlVFS() {
        return urlVFS;
    }

    @Nonnull
    public static VFS getVFSForProtocol(String string) {
        if (string.equals("file")) {
            return fileVFS;
        }
        VFS vFS = (VFS)ServiceManager.getService(SERVICE, string);
        if (vFS != null) {
            return vFS;
        }
        return urlVFS;
    }

    @Nonnull
    public static VFS getVFSForPath(String string) {
        if (MiscUtilities.isURL(string)) {
            return VFSManager.getVFSForProtocol(MiscUtilities.getProtocolOfURL(string));
        }
        return fileVFS;
    }

    public static String[] getVFSs() {
        String[] stringArray = ServiceManager.getServiceNames(SERVICE);
        return stringArray;
    }

    public static void waitForRequests() {
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalStateException();
        }
        TaskManager.instance.waitForIoTasks();
    }

    public static boolean errorOccurred() {
        return error;
    }

    public static int getRequestCount() {
        return TaskManager.instance.countIoTasks();
    }

    @Deprecated
    public static void runInAWTThread(Runnable runnable) {
        AwtRunnableQueue.INSTANCE.runAfterIoTasks(runnable);
    }

    @Deprecated
    public static void runInWorkThread(Task task) {
        if (!(task instanceof IoTask)) {
            throw new IllegalArgumentException();
        }
        ThreadUtilities.runInBackground(task);
    }

    public static void error(IOException iOException, String string, Component component) {
        Log.log(9, VFSManager.class, iOException);
        VFSManager.error(component, string, "ioerror", new String[]{iOException.toString()});
    }

    public static void error(Component component, String string, String string2, Object[] objectArray) {
        VFSManager.error(component, string, string2, objectArray, 9);
    }

    public static void error(final Component component, final String string, final String string2, final Object[] objectArray, final int n) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Frame frame = JOptionPane.getFrameForComponent(component);
                Object object = errorLock;
                synchronized (object) {
                    error = true;
                    errors.add(new ErrorListDialog.ErrorEntry(string, string2, objectArray, n));
                    if (errors.size() == 1 && !errorDisplayerActive) {
                        ThreadUtilities.runInBackground(new ErrorDisplayer(frame));
                    }
                }
            }
        };
        ThreadUtilities.runInDispatchThreadAndWait(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendVFSUpdate(VFS vFS, String string, boolean bl) {
        if (bl) {
            VFSManager.sendVFSUpdate(vFS, vFS.getParentOfPath(string), false);
            VFSManager.sendVFSUpdate(vFS, string, false);
        } else {
            if (string.length() != 1 && (string.endsWith("/") || string.endsWith(File.separator))) {
                string = string.substring(0, string.length() - 1);
            }
            Object object = vfsUpdateLock;
            synchronized (object) {
                for (VFSUpdate vFSUpdate : vfsUpdates) {
                    if (!vFSUpdate.getPath().equals(string)) continue;
                    return;
                }
                vfsUpdates.add(new VFSUpdate(string));
                if (vfsUpdates.size() == 1) {
                    AwtRunnableQueue.INSTANCE.runAfterIoTasks(new SendVFSUpdatesSafely());
                }
            }
        }
    }

    private VFSManager() {
    }

    static {
        errorLock = new Object();
        vfsUpdateLock = new Object();
        errors = new Vector();
        fileVFS = new FileVFS();
        urlVFS = new UrlVFS();
        vfsUpdates = new ArrayList<VFSUpdate>(10);
    }

    private static class ErrorDisplayer
    implements Runnable {
        private final Frame frame;

        ErrorDisplayer(Frame frame) {
            this.frame = frame;
        }

        private static void showDialog(Frame frame, Vector<ErrorListDialog.ErrorEntry> vector) {
            try {
                EventQueue.invokeAndWait(() -> {
                    String string = jEdit.getProperty("ioerror.caption" + (vector.size() == 1 ? "-1" : ""), new Integer[]{vector.size()});
                    new ErrorListDialog(frame.isShowing() ? frame : jEdit.getFirstView(), jEdit.getProperty("ioerror.title"), string, vector, false);
                });
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            catch (InvocationTargetException invocationTargetException) {
                Log.log(9, ErrorDisplayer.class, invocationTargetException);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = errorLock;
            synchronized (object) {
                if (errorDisplayerActive) {
                    return;
                }
                errorDisplayerActive = true;
            }
            while (true) {
                Vector<ErrorListDialog.ErrorEntry> vector;
                object = errorLock;
                synchronized (object) {
                    if (errors.isEmpty()) {
                        errorDisplayerActive = false;
                        break;
                    }
                }
                int n = -1;
                int n2 = 0;
                while (n != n2) {
                    n = errors.size();
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                    n2 = errors.size();
                }
                Object object2 = errorLock;
                synchronized (object2) {
                    vector = new Vector<ErrorListDialog.ErrorEntry>(errors);
                    errors.clear();
                    error = false;
                }
                ErrorDisplayer.showDialog(this.frame, vector);
            }
        }
    }

    private static class SendVFSUpdatesSafely
    implements Runnable {
        private SendVFSUpdatesSafely() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = vfsUpdateLock;
            synchronized (object) {
                vfsUpdates.sort(new StandardUtilities.StringCompare());
                vfsUpdates.forEach(EditBus::send);
                vfsUpdates.clear();
            }
        }
    }
}

