/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.lexer;

import com.intellij.lexer.LexerBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.tree.IElementType;
import java.util.LinkedList;
import java.util.Queue;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.language.TextMateLanguageDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateElementType;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateLexer;

public class TextMateHighlightingLexer
extends LexerBase {
    private final TextMateLexer myLexer;
    private final Queue<TextMateLexer.Token> currentLineTokens;
    private CharSequence myBuffer;
    private int myEndOffset;
    private int myCurrentOffset;
    private IElementType myTokenType;
    private int myTokenStart;
    private int myTokenEnd;
    private boolean myRestartable;

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public TextMateHighlightingLexer(CharSequence scopeName, SyntaxNodeDescriptor languageRootSyntaxNode) {
        this.currentLineTokens = new LinkedList<TextMateLexer.Token>();
        this.myLexer = new TextMateLexer(new TextMateLanguageDescriptor(scopeName, languageRootSyntaxNode), Registry.get((String)"textmate.line.highlighting.limit").asInteger());
    }

    public TextMateHighlightingLexer(@NotNull TextMateLanguageDescriptor languageDescriptor, int lineLimit) {
        if (languageDescriptor == null) {
            TextMateHighlightingLexer.$$$reportNull$$$0(0);
        }
        this.currentLineTokens = new LinkedList<TextMateLexer.Token>();
        this.myLexer = new TextMateLexer(languageDescriptor, lineLimit);
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            TextMateHighlightingLexer.$$$reportNull$$$0(1);
        }
        this.myBuffer = buffer;
        this.myCurrentOffset = startOffset;
        this.myTokenStart = startOffset;
        this.myEndOffset = endOffset;
        this.currentLineTokens.clear();
        this.myLexer.init(this.myBuffer, startOffset);
        this.advance();
    }

    public int getState() {
        return this.myRestartable ? 0 : 1;
    }

    @Nullable
    public IElementType getTokenType() {
        return this.myTokenType;
    }

    public int getTokenStart() {
        return this.myTokenStart;
    }

    public int getTokenEnd() {
        return this.myTokenEnd;
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myBuffer;
        if (charSequence == null) {
            TextMateHighlightingLexer.$$$reportNull$$$0(2);
        }
        return charSequence;
    }

    public int getBufferEnd() {
        return this.myEndOffset;
    }

    public void advance() {
        if (this.myCurrentOffset >= this.myEndOffset) {
            this.updateState(null, this.myEndOffset);
            return;
        }
        if (this.currentLineTokens.isEmpty()) {
            this.myLexer.advanceLine(this.currentLineTokens);
        }
        this.updateState(this.currentLineTokens.poll(), this.myLexer.getCurrentOffset());
    }

    protected void updateState(@Nullable TextMateLexer.Token token, int fallbackOffset) {
        if (token != null) {
            this.myTokenType = new TextMateElementType(token.selector);
            this.myTokenStart = token.startOffset;
            this.myTokenEnd = Math.min(token.endOffset, this.myEndOffset);
            this.myCurrentOffset = token.endOffset;
            this.myRestartable = token.restartable;
        } else {
            this.myTokenType = null;
            this.myTokenStart = fallbackOffset;
            this.myTokenEnd = fallbackOffset;
            this.myCurrentOffset = fallbackOffset;
            this.myRestartable = true;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageDescriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/language/syntax/lexer/TextMateHighlightingLexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/language/syntax/lexer/TextMateHighlightingLexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBufferSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

