/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.timeline;

import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.plugins.newui.HorizontalLayout;
import com.intellij.ide.plugins.newui.VerticalLayout;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.components.panels.HorizontalBox;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.UIUtil;
import icons.GithubIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GHActor;
import org.jetbrains.plugins.github.api.data.GHCommitShort;
import org.jetbrains.plugins.github.api.data.GHGitActor;
import org.jetbrains.plugins.github.api.data.GHIssueComment;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequest;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestCommitShort;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestReview;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestShort;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineItem;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.avatars.GHAvatarIconsProvider;
import org.jetbrains.plugins.github.pullrequest.comment.ui.GHPRReviewThreadComponent;
import org.jetbrains.plugins.github.pullrequest.comment.ui.GHPRReviewThreadModel;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRCommentsDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDetailsDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRReviewDataProvider;
import org.jetbrains.plugins.github.pullrequest.ui.GHEditableHtmlPaneHandle;
import org.jetbrains.plugins.github.pullrequest.ui.GHTextActions;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRReviewThreadDiffComponentFactory;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRReviewThreadsModel;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRReviewThreadsPanel;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRReviewsThreadsModelsProvider;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRSelectInToolWindowHelper;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineEventComponentFactory;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineItemComponentFactory;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineItemComponentFactory$WhenMappings;
import org.jetbrains.plugins.github.ui.util.HtmlEditorPane;
import org.jetbrains.plugins.github.util.GithubAsyncUtilKt;
import org.jetbrains.plugins.github.util.GithubUIUtil;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 '2\u00020\u0001:\u0002'(BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!J\u0012\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0002J\u0012\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010&H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory;", "", "detailsDataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDetailsDataProvider;", "commentsDataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRCommentsDataProvider;", "reviewDataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRReviewDataProvider;", "avatarIconsProvider", "Lorg/jetbrains/plugins/github/pullrequest/avatars/GHAvatarIconsProvider;", "reviewsThreadsModelsProvider", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRReviewsThreadsModelsProvider;", "reviewDiffComponentFactory", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRReviewThreadDiffComponentFactory;", "eventComponentFactory", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactory;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRTimelineEvent;", "selectInToolWindowHelper", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRSelectInToolWindowHelper;", "currentUser", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "(Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDetailsDataProvider;Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRCommentsDataProvider;Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRReviewDataProvider;Lorg/jetbrains/plugins/github/pullrequest/avatars/GHAvatarIconsProvider;Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRReviewsThreadsModelsProvider;Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRReviewThreadDiffComponentFactory;Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactory;Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRSelectInToolWindowHelper;Lorg/jetbrains/plugins/github/api/data/GHUser;)V", "createComponent", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory$Item;", "comment", "Lorg/jetbrains/plugins/github/api/data/GHIssueComment;", "commit", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestCommitShort;", "review", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestReview;", "details", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestShort;", "item", "Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRTimelineItem;", "userAvatar", "Ljavax/swing/JLabel;", "user", "Lorg/jetbrains/plugins/github/api/data/GHActor;", "Lorg/jetbrains/plugins/github/api/data/GHGitActor;", "Companion", "Item", "intellij.vcs.github"})
public final class GHPRTimelineItemComponentFactory {
    private final GHPRDetailsDataProvider detailsDataProvider;
    private final GHPRCommentsDataProvider commentsDataProvider;
    private final GHPRReviewDataProvider reviewDataProvider;
    private final GHAvatarIconsProvider avatarIconsProvider;
    private final GHPRReviewsThreadsModelsProvider reviewsThreadsModelsProvider;
    private final GHPRReviewThreadDiffComponentFactory reviewDiffComponentFactory;
    private final GHPRTimelineEventComponentFactory<GHPRTimelineEvent> eventComponentFactory;
    private final GHPRSelectInToolWindowHelper selectInToolWindowHelper;
    private final GHUser currentUser;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Item createComponent(@NotNull GHPRTimelineItem item) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        try {
            Item item2;
            GHPRTimelineItem gHPRTimelineItem = item;
            if (gHPRTimelineItem instanceof GHPullRequestCommitShort) {
                item2 = this.createComponent((GHPullRequestCommitShort)item);
            } else if (gHPRTimelineItem instanceof GHIssueComment) {
                item2 = this.createComponent((GHIssueComment)item);
            } else if (gHPRTimelineItem instanceof GHPullRequestReview) {
                item2 = this.createComponent((GHPullRequestReview)item);
            } else if (gHPRTimelineItem instanceof GHPRTimelineEvent) {
                item2 = this.eventComponentFactory.createComponent((GHPRTimelineEvent)item);
            } else {
                if (gHPRTimelineItem instanceof GHPRTimelineItem.Unknown) {
                    throw (Throwable)new IllegalStateException("Unknown item type: " + ((GHPRTimelineItem.Unknown)item).get__typename());
                }
                String string = "Undefined item type";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return item2;
        }
        catch (Exception e) {
            Icon icon = AllIcons.General.Warning;
            Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"AllIcons.General.Warning");
            Object[] objectArray = new Object[1];
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            objectArray[0] = string;
            String string2 = GithubBundle.message("cannot.display.item", objectArray);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"GithubBundle.message(\"ca\u2026y.item\", e.message ?: \"\")");
            return new Item(icon, (JComponent)new HtmlEditorPane(string2), null, 4, null);
        }
    }

    private final Item createComponent(GHPullRequestCommitShort commit) {
        GHCommitShort gitCommit = commit.getCommit();
        NonOpaquePanel nonOpaquePanel = new NonOpaquePanel((LayoutManager)new HorizontalLayout(UI.scale((int)8)));
        boolean bl = false;
        boolean bl2 = false;
        NonOpaquePanel $this$apply = nonOpaquePanel;
        boolean bl3 = false;
        $this$apply.add((Component)this.userAvatar(gitCommit.getAuthor()));
        $this$apply.add((Component)new HtmlEditorPane(gitCommit.getMessageHeadlineHTML()));
        $this$apply.add((Component)new LinkLabel(gitCommit.getAbbreviatedOid(), null, new LinkListener<T>(this, gitCommit){
            final /* synthetic */ GHPRTimelineItemComponentFactory this$0;
            final /* synthetic */ GHCommitShort $gitCommit$inlined;
            {
                this.this$0 = gHPRTimelineItemComponentFactory;
                this.$gitCommit$inlined = gHCommitShort;
            }

            public final void linkSelected(LinkLabel<Object> $noName_0, @Nullable Object $noName_1) {
                GHPRTimelineItemComponentFactory.access$getSelectInToolWindowHelper$p(this.this$0).selectCommit(this.$gitCommit$inlined.getAbbreviatedOid());
            }
        }));
        NonOpaquePanel titlePanel = nonOpaquePanel;
        Icon icon = AllIcons.Vcs.CommitNode;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"AllIcons.Vcs.CommitNode");
        return new Item(icon, (JComponent)titlePanel, null, 4, null);
    }

    @NotNull
    public final Item createComponent(@NotNull GHPullRequestShort details2) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)details2, (String)"details");
        JPanel contentPanel = null;
        JPanel actionsPanel = null;
        if (details2 instanceof GHPullRequest) {
            JPanel jPanel;
            HtmlEditorPane textPane = new HtmlEditorPane(((GHPullRequest)details2).getBodyHTML());
            GHEditableHtmlPaneHandle panelHandle2 = new GHEditableHtmlPaneHandle(textPane, (Function0<? extends CompletableFuture<String>>)((Function0)new Function0<CompletableFuture<String>>(this){
                final /* synthetic */ GHPRTimelineItemComponentFactory this$0;

                @NotNull
                public final CompletableFuture<String> invoke() {
                    return GHPRTimelineItemComponentFactory.access$getDetailsDataProvider$p(this.this$0).getDescriptionMarkdownBody((ProgressIndicator)new EmptyProgressIndicator());
                }
                {
                    this.this$0 = gHPRTimelineItemComponentFactory;
                    super(0);
                }
            }), (Function1<? super String, ? extends CompletableFuture<? extends Object>>)((Function1)new Function1<String, CompletableFuture<Unit>>(this, textPane){
                final /* synthetic */ GHPRTimelineItemComponentFactory this$0;
                final /* synthetic */ HtmlEditorPane $textPane;

                @NotNull
                public final CompletableFuture<Unit> invoke(@NotNull String newText) {
                    Intrinsics.checkParameterIsNotNull((Object)newText, (String)"newText");
                    return GithubAsyncUtilKt.successOnEdt$default(GHPRDetailsDataProvider.DefaultImpls.updateDetails$default(GHPRTimelineItemComponentFactory.access$getDetailsDataProvider$p(this.this$0), (ProgressIndicator)new EmptyProgressIndicator(), null, newText, 2, null), null, (Function1)new Function1<GHPullRequest, Unit>(this){
                        final /* synthetic */ createComponent.panelHandle.2 this$0;

                        public final void invoke(@NotNull GHPullRequest it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            this.this$0.$textPane.setBody(it.getBodyHTML());
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    }, 1, null);
                }
                {
                    this.this$0 = gHPRTimelineItemComponentFactory;
                    this.$textPane = htmlEditorPane;
                    super(1);
                }
            }));
            contentPanel = (JPanel)panelHandle2.getPanel();
            if (details2.getViewerCanUpdate()) {
                NonOpaquePanel nonOpaquePanel = new NonOpaquePanel((LayoutManager)new HorizontalLayout(UI.scale((int)8)));
                bl = false;
                boolean bl2 = false;
                NonOpaquePanel $this$apply = nonOpaquePanel;
                boolean bl3 = false;
                $this$apply.add((Component)GHTextActions.INSTANCE.createEditButton(panelHandle2));
                jPanel = (JPanel)nonOpaquePanel;
            } else {
                jPanel = null;
            }
            actionsPanel = jPanel;
        } else {
            contentPanel = null;
            actionsPanel = null;
        }
        NonOpaquePanel nonOpaquePanel = new NonOpaquePanel((LayoutManager)new HorizontalLayout(UI.scale((int)12)));
        boolean bl4 = false;
        bl = false;
        NonOpaquePanel $this$apply = nonOpaquePanel;
        boolean bl5 = false;
        GHActor gHActor = details2.getAuthor();
        String string = GithubBundle.message("pull.request.timeline.created", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"GithubBundle.message(\"pu\u2026equest.timeline.created\")");
        $this$apply.add((Component)Companion.actionTitle(gHActor, string, details2.getCreatedAt()));
        if (actionsPanel != null && actionsPanel.getComponentCount() > 0) {
            $this$apply.add((Component)actionsPanel);
        }
        NonOpaquePanel titlePanel = nonOpaquePanel;
        return new Item(this.userAvatar(details2.getAuthor()), (JComponent)titlePanel, (JComponent)contentPanel);
    }

    private final Item createComponent(GHIssueComment comment) {
        HtmlEditorPane textPane = new HtmlEditorPane(comment.getBodyHTML());
        GHEditableHtmlPaneHandle panelHandle2 = new GHEditableHtmlPaneHandle(textPane, (Function0<? extends CompletableFuture<String>>)((Function0)new Function0<CompletableFuture<String>>(this, comment){
            final /* synthetic */ GHPRTimelineItemComponentFactory this$0;
            final /* synthetic */ GHIssueComment $comment;

            @NotNull
            public final CompletableFuture<String> invoke() {
                return GHPRTimelineItemComponentFactory.access$getCommentsDataProvider$p(this.this$0).getCommentMarkdownBody((ProgressIndicator)new EmptyProgressIndicator(), this.$comment.getId());
            }
            {
                this.this$0 = gHPRTimelineItemComponentFactory;
                this.$comment = gHIssueComment;
                super(0);
            }
        }), (Function1<? super String, ? extends CompletableFuture<? extends Object>>)((Function1)new Function1<String, CompletableFuture<Unit>>(this, comment, textPane){
            final /* synthetic */ GHPRTimelineItemComponentFactory this$0;
            final /* synthetic */ GHIssueComment $comment;
            final /* synthetic */ HtmlEditorPane $textPane;

            @NotNull
            public final CompletableFuture<Unit> invoke(@NotNull String newText) {
                Intrinsics.checkParameterIsNotNull((Object)newText, (String)"newText");
                return GithubAsyncUtilKt.successOnEdt$default(GHPRTimelineItemComponentFactory.access$getCommentsDataProvider$p(this.this$0).updateComment((ProgressIndicator)new EmptyProgressIndicator(), this.$comment.getId(), newText), null, (Function1)new Function1<String, Unit>(this){
                    final /* synthetic */ createComponent.panelHandle.4 this$0;

                    public final void invoke(@NotNull String it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        this.this$0.$textPane.setBody(it);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }, 1, null);
            }
            {
                this.this$0 = gHPRTimelineItemComponentFactory;
                this.$comment = gHIssueComment;
                this.$textPane = htmlEditorPane;
                super(1);
            }
        }));
        NonOpaquePanel nonOpaquePanel = new NonOpaquePanel((LayoutManager)new HorizontalLayout(UI.scale((int)8)));
        boolean bl = false;
        boolean bl2 = false;
        NonOpaquePanel $this$apply = nonOpaquePanel;
        boolean bl3 = false;
        if (comment.getViewerCanUpdate()) {
            $this$apply.add((Component)GHTextActions.INSTANCE.createEditButton(panelHandle2));
        }
        if (comment.getViewerCanDelete()) {
            $this$apply.add((Component)GHTextActions.INSTANCE.createDeleteButton((Function0<? extends CompletableFuture<? extends Object>>)((Function0)new Function0<CompletableFuture<? extends Object>>(this, comment, panelHandle2){
                final /* synthetic */ GHPRTimelineItemComponentFactory this$0;
                final /* synthetic */ GHIssueComment $comment$inlined;
                final /* synthetic */ GHEditableHtmlPaneHandle $panelHandle$inlined;
                {
                    this.this$0 = gHPRTimelineItemComponentFactory;
                    this.$comment$inlined = gHIssueComment;
                    this.$panelHandle$inlined = gHEditableHtmlPaneHandle;
                    super(0);
                }

                @NotNull
                public final CompletableFuture<? extends Object> invoke() {
                    return GHPRTimelineItemComponentFactory.access$getCommentsDataProvider$p(this.this$0).deleteComment((ProgressIndicator)new EmptyProgressIndicator(), this.$comment$inlined.getId());
                }
            })));
        }
        NonOpaquePanel actionsPanel = nonOpaquePanel;
        NonOpaquePanel nonOpaquePanel2 = new NonOpaquePanel((LayoutManager)new HorizontalLayout(UI.scale((int)12)));
        bl2 = false;
        boolean bl4 = false;
        NonOpaquePanel $this$apply2 = nonOpaquePanel2;
        boolean bl5 = false;
        GHActor gHActor = comment.getAuthor();
        String string = GithubBundle.message("pull.request.timeline.commented", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"GithubBundle.message(\"pu\u2026uest.timeline.commented\")");
        $this$apply2.add((Component)Companion.actionTitle(gHActor, string, comment.getCreatedAt()));
        if (actionsPanel.getComponentCount() > 0) {
            $this$apply2.add((Component)actionsPanel);
        }
        NonOpaquePanel titlePanel = nonOpaquePanel2;
        return new Item(this.userAvatar(comment.getAuthor()), (JComponent)titlePanel, (JComponent)panelHandle2.getPanel());
    }

    private final Item createComponent(GHPullRequestReview review) {
        Icon icon;
        String string;
        GHPRReviewThreadsModel reviewThreadsModel = this.reviewsThreadsModelsProvider.getReviewThreadsModel(review.getId());
        GHEditableHtmlPaneHandle panelHandle2 = null;
        CharSequence charSequence = review.getBodyHTML();
        boolean bl = false;
        if (charSequence.length() > 0) {
            HtmlEditorPane editorPane = new HtmlEditorPane(review.getBodyHTML());
            panelHandle2 = new GHEditableHtmlPaneHandle(editorPane, (Function0<? extends CompletableFuture<String>>)((Function0)new Function0<CompletableFuture<String>>(this, review){
                final /* synthetic */ GHPRTimelineItemComponentFactory this$0;
                final /* synthetic */ GHPullRequestReview $review;

                @NotNull
                public final CompletableFuture<String> invoke() {
                    return GHPRTimelineItemComponentFactory.access$getReviewDataProvider$p(this.this$0).getReviewMarkdownBody((ProgressIndicator)new EmptyProgressIndicator(), this.$review.getId());
                }
                {
                    this.this$0 = gHPRTimelineItemComponentFactory;
                    this.$review = gHPullRequestReview;
                    super(0);
                }
            }), (Function1<? super String, ? extends CompletableFuture<? extends Object>>)((Function1)new Function1<String, CompletableFuture<Unit>>(this, review, editorPane){
                final /* synthetic */ GHPRTimelineItemComponentFactory this$0;
                final /* synthetic */ GHPullRequestReview $review;
                final /* synthetic */ HtmlEditorPane $editorPane;

                @NotNull
                public final CompletableFuture<Unit> invoke(@NotNull String newText) {
                    Intrinsics.checkParameterIsNotNull((Object)newText, (String)"newText");
                    return GithubAsyncUtilKt.successOnEdt$default(GHPRTimelineItemComponentFactory.access$getReviewDataProvider$p(this.this$0).updateReviewBody((ProgressIndicator)new EmptyProgressIndicator(), this.$review.getId(), newText), null, (Function1)new Function1<String, Unit>(this){
                        final /* synthetic */ createComponent.3 this$0;

                        public final void invoke(@NotNull String it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            this.this$0.$editorPane.setBody(it);
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    }, 1, null);
                }
                {
                    this.this$0 = gHPRTimelineItemComponentFactory;
                    this.$review = gHPullRequestReview;
                    this.$editorPane = htmlEditorPane;
                    super(1);
                }
            }));
        } else {
            panelHandle2 = null;
        }
        NonOpaquePanel nonOpaquePanel = new NonOpaquePanel((LayoutManager)new HorizontalLayout(UI.scale((int)8)));
        boolean bl2 = false;
        boolean bl3 = false;
        NonOpaquePanel $this$apply322 = nonOpaquePanel;
        boolean bl4 = false;
        if (panelHandle2 != null && review.getViewerCanUpdate()) {
            $this$apply322.add((Component)GHTextActions.INSTANCE.createEditButton(panelHandle2));
        }
        NonOpaquePanel actionsPanel = nonOpaquePanel;
        NonOpaquePanel nonOpaquePanel2 = new NonOpaquePanel((LayoutManager)new VerticalLayout(UI.scale((int)12)));
        bl3 = false;
        boolean $this$apply322 = false;
        NonOpaquePanel $this$apply = nonOpaquePanel2;
        boolean bl5 = false;
        $this$apply.setBorder((Border)JBUI.Borders.emptyTop((int)4));
        if (panelHandle2 != null) {
            $this$apply.add((Component)panelHandle2.getPanel(), (Object)"fill_h");
        }
        $this$apply.add((Component)GHPRReviewThreadsPanel.INSTANCE.create(reviewThreadsModel, (Function1<? super GHPRReviewThreadModel, ? extends JComponent>)((Function1)new Function1<GHPRReviewThreadModel, JComponent>(this, panelHandle2, reviewThreadsModel){
            final /* synthetic */ GHPRTimelineItemComponentFactory this$0;
            final /* synthetic */ GHEditableHtmlPaneHandle $panelHandle$inlined;
            final /* synthetic */ GHPRReviewThreadsModel $reviewThreadsModel$inlined;
            {
                this.this$0 = gHPRTimelineItemComponentFactory;
                this.$panelHandle$inlined = gHEditableHtmlPaneHandle;
                this.$reviewThreadsModel$inlined = gHPRReviewThreadsModel;
                super(1);
            }

            @NotNull
            public final JComponent invoke(@NotNull GHPRReviewThreadModel it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return GHPRReviewThreadComponent.INSTANCE.createWithDiff(it, GHPRTimelineItemComponentFactory.access$getReviewDataProvider$p(this.this$0), GHPRTimelineItemComponentFactory.access$getSelectInToolWindowHelper$p(this.this$0), GHPRTimelineItemComponentFactory.access$getReviewDiffComponentFactory$p(this.this$0), GHPRTimelineItemComponentFactory.access$getAvatarIconsProvider$p(this.this$0), GHPRTimelineItemComponentFactory.access$getCurrentUser$p(this.this$0));
            }
        })), (Object)"fill_h");
        NonOpaquePanel contentPanel = nonOpaquePanel2;
        switch (GHPRTimelineItemComponentFactory$WhenMappings.$EnumSwitchMapping$0[review.getState().ordinal()]) {
            case 1: {
                string = GithubBundle.message("pull.request.timeline.approved.changes", new Object[0]);
                break;
            }
            case 2: {
                string = GithubBundle.message("pull.request.timeline.requested.changes", new Object[0]);
                break;
            }
            case 3: {
                string = GithubBundle.message("pull.request.timeline.started.review", new Object[0]);
                break;
            }
            case 4: 
            case 5: {
                string = GithubBundle.message("pull.request.timeline.reviewed", new Object[0]);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"when (review.state) {\n  \u2026timeline.reviewed\")\n    }");
        String actionText = string;
        NonOpaquePanel $this$apply322 = new NonOpaquePanel((LayoutManager)new HorizontalLayout(UI.scale((int)12)));
        boolean bl6 = false;
        boolean bl7 = false;
        NonOpaquePanel $this$apply2 = $this$apply322;
        boolean bl8 = false;
        $this$apply2.add((Component)Companion.actionTitle(this.avatarIconsProvider, review.getAuthor(), actionText, review.getCreatedAt()));
        if (actionsPanel.getComponentCount() > 0) {
            $this$apply2.add((Component)actionsPanel);
        }
        NonOpaquePanel titlePanel = $this$apply322;
        switch (GHPRTimelineItemComponentFactory$WhenMappings.$EnumSwitchMapping$1[review.getState().ordinal()]) {
            case 1: {
                icon = GithubIcons.ReviewAccepted;
                break;
            }
            case 2: {
                icon = GithubIcons.ReviewRejected;
                break;
            }
            case 3: {
                icon = GithubIcons.Review;
                break;
            }
            case 4: {
                icon = GithubIcons.Review;
                break;
            }
            case 5: {
                icon = GithubIcons.Review;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"when (review.state) {\n  \u2026 GithubIcons.Review\n    }");
        Icon icon2 = icon;
        return new Item(icon2, (JComponent)titlePanel, (JComponent)contentPanel);
    }

    private final JLabel userAvatar(GHActor user) {
        return Companion.userAvatar(this.avatarIconsProvider, user);
    }

    private final JLabel userAvatar(GHGitActor user) {
        GHGitActor gHGitActor = user;
        return (JLabel)new LinkLabel("", this.avatarIconsProvider.getIcon(gHGitActor != null ? gHGitActor.getAvatarUrl() : null), (LinkListener)new LinkListener<Object>(user){
            final /* synthetic */ GHGitActor $user;

            public final void linkSelected(LinkLabel<Object> $noName_0, Object $noName_1) {
                block0: {
                    Object object = this.$user;
                    if (object == null || (object = ((GHGitActor)object).getUrl()) == null) break block0;
                    Object object2 = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object it = object2;
                    boolean bl3 = false;
                    BrowserUtil.browse((String)it);
                }
            }
            {
                this.$user = gHGitActor;
            }
        });
    }

    public GHPRTimelineItemComponentFactory(@NotNull GHPRDetailsDataProvider detailsDataProvider, @NotNull GHPRCommentsDataProvider commentsDataProvider, @NotNull GHPRReviewDataProvider reviewDataProvider, @NotNull GHAvatarIconsProvider avatarIconsProvider, @NotNull GHPRReviewsThreadsModelsProvider reviewsThreadsModelsProvider, @NotNull GHPRReviewThreadDiffComponentFactory reviewDiffComponentFactory, @NotNull GHPRTimelineEventComponentFactory<GHPRTimelineEvent> eventComponentFactory, @NotNull GHPRSelectInToolWindowHelper selectInToolWindowHelper, @NotNull GHUser currentUser) {
        Intrinsics.checkParameterIsNotNull((Object)detailsDataProvider, (String)"detailsDataProvider");
        Intrinsics.checkParameterIsNotNull((Object)commentsDataProvider, (String)"commentsDataProvider");
        Intrinsics.checkParameterIsNotNull((Object)reviewDataProvider, (String)"reviewDataProvider");
        Intrinsics.checkParameterIsNotNull((Object)avatarIconsProvider, (String)"avatarIconsProvider");
        Intrinsics.checkParameterIsNotNull((Object)reviewsThreadsModelsProvider, (String)"reviewsThreadsModelsProvider");
        Intrinsics.checkParameterIsNotNull((Object)reviewDiffComponentFactory, (String)"reviewDiffComponentFactory");
        Intrinsics.checkParameterIsNotNull(eventComponentFactory, (String)"eventComponentFactory");
        Intrinsics.checkParameterIsNotNull((Object)selectInToolWindowHelper, (String)"selectInToolWindowHelper");
        Intrinsics.checkParameterIsNotNull((Object)currentUser, (String)"currentUser");
        this.detailsDataProvider = detailsDataProvider;
        this.commentsDataProvider = commentsDataProvider;
        this.reviewDataProvider = reviewDataProvider;
        this.avatarIconsProvider = avatarIconsProvider;
        this.reviewsThreadsModelsProvider = reviewsThreadsModelsProvider;
        this.reviewDiffComponentFactory = reviewDiffComponentFactory;
        this.eventComponentFactory = eventComponentFactory;
        this.selectInToolWindowHelper = selectInToolWindowHelper;
        this.currentUser = currentUser;
    }

    public static final /* synthetic */ GHPRSelectInToolWindowHelper access$getSelectInToolWindowHelper$p(GHPRTimelineItemComponentFactory $this) {
        return $this.selectInToolWindowHelper;
    }

    public static final /* synthetic */ GHPRDetailsDataProvider access$getDetailsDataProvider$p(GHPRTimelineItemComponentFactory $this) {
        return $this.detailsDataProvider;
    }

    public static final /* synthetic */ GHPRCommentsDataProvider access$getCommentsDataProvider$p(GHPRTimelineItemComponentFactory $this) {
        return $this.commentsDataProvider;
    }

    public static final /* synthetic */ GHPRReviewDataProvider access$getReviewDataProvider$p(GHPRTimelineItemComponentFactory $this) {
        return $this.reviewDataProvider;
    }

    public static final /* synthetic */ GHPRReviewThreadDiffComponentFactory access$getReviewDiffComponentFactory$p(GHPRTimelineItemComponentFactory $this) {
        return $this.reviewDiffComponentFactory;
    }

    public static final /* synthetic */ GHAvatarIconsProvider access$getAvatarIconsProvider$p(GHPRTimelineItemComponentFactory $this) {
        return $this.avatarIconsProvider;
    }

    public static final /* synthetic */ GHUser access$getCurrentUser$p(GHPRTimelineItemComponentFactory $this) {
        return $this.currentUser;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \r2\u00020\u0001:\u0001\rB#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007B!\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\nR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory$Item;", "Ljavax/swing/JPanel;", "markerIcon", "Ljavax/swing/Icon;", "title", "Ljavax/swing/JComponent;", "content", "(Ljavax/swing/Icon;Ljavax/swing/JComponent;Ljavax/swing/JComponent;)V", "marker", "Ljavax/swing/JLabel;", "(Ljavax/swing/JLabel;Ljavax/swing/JComponent;Ljavax/swing/JComponent;)V", "getMarker", "()Ljavax/swing/JLabel;", "Companion", "intellij.vcs.github"})
    public static final class Item
    extends JPanel {
        @NotNull
        private final JLabel marker;
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final JLabel getMarker() {
            return this.marker;
        }

        public Item(@NotNull JLabel marker, @NotNull JComponent title, @Nullable JComponent content2) {
            Intrinsics.checkParameterIsNotNull((Object)marker, (String)"marker");
            Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
            this.marker = marker;
            this.setOpaque(false);
            MigLayout migLayout = new MigLayout(new LC().gridGap("0", "0").insets("0", "0", "0", "0").fill());
            Item item = this;
            boolean bl = false;
            boolean bl2 = false;
            MigLayout $this$apply = migLayout;
            boolean bl3 = false;
            $this$apply.setColumnConstraints((Object)("[]" + UI.scale((int)8) + "[]"));
            MigLayout migLayout2 = migLayout;
            item.setLayout((LayoutManager)migLayout2);
            this.add((Component)this.marker, new CC().pushY());
            this.add((Component)title, new CC().pushX());
            if (content2 != null) {
                this.add((Component)content2, new CC().newline().skip().grow().push());
            }
        }

        public /* synthetic */ Item(JLabel jLabel, JComponent jComponent, JComponent jComponent2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                jComponent2 = null;
            }
            this(jLabel, jComponent, jComponent2);
        }

        public Item(@NotNull Icon markerIcon, @NotNull JComponent title, @Nullable JComponent content2) {
            Intrinsics.checkParameterIsNotNull((Object)markerIcon, (String)"markerIcon");
            Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
            this(Item.Companion.createMarkerLabel(markerIcon), title, content2);
        }

        public /* synthetic */ Item(Icon icon, JComponent jComponent, JComponent jComponent2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                jComponent2 = null;
            }
            this(icon, jComponent, jComponent2);
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory$Item$Companion;", "", "()V", "createMarkerLabel", "Ljavax/swing/JLabel;", "markerIcon", "Ljavax/swing/Icon;", "intellij.vcs.github"})
        public static final class Companion {
            private final JLabel createMarkerLabel(Icon markerIcon) {
                JLabel jLabel = new JLabel(markerIcon);
                boolean bl = false;
                boolean bl2 = false;
                JLabel $this$apply = jLabel;
                boolean bl3 = false;
                float verticalGap = markerIcon.getIconHeight() < 20 ? (20.0f - (float)markerIcon.getIconHeight()) / (float)2 : 0.0f;
                float horizontalGap = markerIcon.getIconWidth() < 20 ? (20.0f - (float)markerIcon.getIconWidth()) / (float)2 : 0.0f;
                JLabel jLabel2 = $this$apply;
                boolean bl4 = false;
                float f = (float)Math.floor(verticalGap);
                int n = (int)f;
                bl4 = false;
                float f2 = (float)Math.floor(horizontalGap);
                int n2 = (int)f2;
                bl4 = false;
                float f3 = (float)Math.ceil(verticalGap);
                int n3 = (int)f3;
                bl4 = false;
                float f4 = (float)Math.ceil(horizontalGap);
                jLabel2.setBorder((Border)JBUI.Borders.empty((int)n, (int)n2, (int)n3, (int)((int)f4)));
                return jLabel;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ*\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0001\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory$Companion;", "", "()V", "actionTitle", "Ljavax/swing/JComponent;", "actor", "Lorg/jetbrains/plugins/github/api/data/GHActor;", "actionHTML", "", "date", "Ljava/util/Date;", "avatarIconsProvider", "Lorg/jetbrains/plugins/github/pullrequest/avatars/GHAvatarIconsProvider;", "userAvatar", "Ljavax/swing/JLabel;", "user", "intellij.vcs.github"})
    public static final class Companion {
        @NotNull
        public final JLabel userAvatar(@NotNull GHAvatarIconsProvider avatarIconsProvider, @Nullable GHActor user) {
            Intrinsics.checkParameterIsNotNull((Object)avatarIconsProvider, (String)"avatarIconsProvider");
            GHActor gHActor = user;
            return (JLabel)new LinkLabel("", avatarIconsProvider.getIcon(gHActor != null ? gHActor.getAvatarUrl() : null), (LinkListener)new LinkListener<Object>(user){
                final /* synthetic */ GHActor $user;

                public final void linkSelected(LinkLabel<Object> $noName_0, Object $noName_1) {
                    block0: {
                        Object object = this.$user;
                        if (object == null || (object = object.getUrl()) == null) break block0;
                        Object object2 = object;
                        boolean bl = false;
                        boolean bl2 = false;
                        Object it = object2;
                        boolean bl3 = false;
                        BrowserUtil.browse((String)it);
                    }
                }
                {
                    this.$user = gHActor;
                }
            });
        }

        @NotNull
        public final JComponent actionTitle(@NotNull GHAvatarIconsProvider avatarIconsProvider, @Nullable GHActor actor, @Language(value="HTML") @NotNull String actionHTML, @NotNull Date date) {
            Intrinsics.checkParameterIsNotNull((Object)avatarIconsProvider, (String)"avatarIconsProvider");
            Intrinsics.checkParameterIsNotNull((Object)actionHTML, (String)"actionHTML");
            Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
            HorizontalBox horizontalBox = new HorizontalBox();
            boolean bl = false;
            boolean bl2 = false;
            HorizontalBox $this$apply = horizontalBox;
            boolean bl3 = false;
            $this$apply.add((Component)Companion.userAvatar(avatarIconsProvider, actor));
            $this$apply.add(Box.createRigidArea((Dimension)new JBDimension(8, 0)));
            $this$apply.add((Component)Companion.actionTitle(actor, actionHTML, date));
            return (JComponent)horizontalBox;
        }

        @NotNull
        public final JComponent actionTitle(@Nullable GHActor actor, @NotNull String actionHTML, @NotNull Date date) {
            Intrinsics.checkParameterIsNotNull((Object)actionHTML, (String)"actionHTML");
            Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
            GHActor gHActor = actor;
            StringBuilder stringBuilder = new StringBuilder().append("<a href='").append(gHActor != null ? gHActor.getUrl() : null).append("'>");
            Object object = actor;
            if (object == null || (object = object.getLogin()) == null) {
                object = "unknown";
            }
            String text = stringBuilder.append((String)object).append("</a> ").append(actionHTML).append(' ').append(GithubUIUtil.INSTANCE.formatActionDate(date)).toString();
            HtmlEditorPane htmlEditorPane = new HtmlEditorPane(text);
            boolean bl = false;
            boolean bl2 = false;
            HtmlEditorPane $this$apply = htmlEditorPane;
            boolean bl3 = false;
            $this$apply.setForeground(UIUtil.getContextHelpForeground());
            return htmlEditorPane;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

