/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.visible.filters;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogBranchFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class VcsLogBranchFilterImpl
implements VcsLogBranchFilter {
    @NotNull
    private final List<String> myBranches;
    @NotNull
    private final List<Pattern> myPatterns;
    @NotNull
    private final List<String> myExcludedBranches;
    @NotNull
    private final List<Pattern> myExcludedPatterns;

    VcsLogBranchFilterImpl(@NotNull List<String> branches, @NotNull List<Pattern> patterns, @NotNull List<String> excludedBranches, @NotNull List<Pattern> excludedPatterns) {
        if (branches == null) {
            VcsLogBranchFilterImpl.$$$reportNull$$$0(0);
        }
        if (patterns == null) {
            VcsLogBranchFilterImpl.$$$reportNull$$$0(1);
        }
        if (excludedBranches == null) {
            VcsLogBranchFilterImpl.$$$reportNull$$$0(2);
        }
        if (excludedPatterns == null) {
            VcsLogBranchFilterImpl.$$$reportNull$$$0(3);
        }
        this.myBranches = branches;
        this.myPatterns = patterns;
        this.myExcludedBranches = excludedBranches;
        this.myExcludedPatterns = excludedPatterns;
    }

    @NotNull
    public Collection<String> getTextPresentation() {
        ArrayList<String> result2 = new ArrayList<String>();
        result2.addAll(this.myBranches);
        result2.addAll(ContainerUtil.map(this.myPatterns, pattern -> pattern.pattern()));
        result2.addAll(ContainerUtil.map(this.myExcludedBranches, branchName -> "-" + branchName));
        result2.addAll(ContainerUtil.map(this.myExcludedPatterns, pattern -> "-" + pattern.pattern()));
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            VcsLogBranchFilterImpl.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    public boolean isEmpty() {
        return this.myBranches.isEmpty() && this.myPatterns.isEmpty() && this.myExcludedBranches.isEmpty() && this.myExcludedPatterns.isEmpty();
    }

    @NonNls
    public String toString() {
        String result2 = "";
        if (!this.myPatterns.isEmpty()) {
            result2 = result2 + "on patterns: " + StringUtil.join(this.myPatterns, (String)", ");
        }
        if (!this.myBranches.isEmpty()) {
            if (!result2.isEmpty()) {
                result2 = result2 + "; ";
            }
            result2 = result2 + "on branches: " + StringUtil.join(this.myBranches, (String)", ");
        }
        if (!this.myExcludedPatterns.isEmpty()) {
            if (result2.isEmpty()) {
                result2 = result2 + "; ";
            }
            result2 = result2 + "not on patterns: " + StringUtil.join(this.myExcludedPatterns, (String)", ");
        }
        if (!this.myExcludedBranches.isEmpty()) {
            if (result2.isEmpty()) {
                result2 = result2 + "; ";
            }
            result2 = result2 + "not on branches: " + StringUtil.join(this.myExcludedBranches, (String)", ");
        }
        return result2;
    }

    public boolean matches(@NotNull String name) {
        if (name == null) {
            VcsLogBranchFilterImpl.$$$reportNull$$$0(5);
        }
        return this.isIncluded(name) && !this.isExcluded(name);
    }

    private boolean isIncluded(@NotNull String name) {
        if (name == null) {
            VcsLogBranchFilterImpl.$$$reportNull$$$0(6);
        }
        if (this.myPatterns.isEmpty() && this.myBranches.isEmpty()) {
            return true;
        }
        return VcsLogBranchFilterImpl.isMatched(name, this.myBranches, this.myPatterns);
    }

    private boolean isExcluded(@NotNull String name) {
        if (name == null) {
            VcsLogBranchFilterImpl.$$$reportNull$$$0(7);
        }
        return VcsLogBranchFilterImpl.isMatched(name, this.myExcludedBranches, this.myExcludedPatterns);
    }

    private static boolean isMatched(@NotNull String name, @NotNull List<String> branches, @NotNull List<Pattern> patterns) {
        if (name == null) {
            VcsLogBranchFilterImpl.$$$reportNull$$$0(8);
        }
        if (branches == null) {
            VcsLogBranchFilterImpl.$$$reportNull$$$0(9);
        }
        if (patterns == null) {
            VcsLogBranchFilterImpl.$$$reportNull$$$0(10);
        }
        if (branches.contains(name)) {
            return true;
        }
        for (Pattern regexp : patterns) {
            if (!regexp.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcsLogBranchFilterImpl filter = (VcsLogBranchFilterImpl)o;
        return Comparing.haveEqualElements(this.myBranches, filter.myBranches) && Comparing.haveEqualElements(this.myPatterns, filter.myPatterns) && Comparing.haveEqualElements(this.myExcludedBranches, filter.myExcludedBranches) && Comparing.haveEqualElements(this.myExcludedPatterns, filter.myExcludedPatterns);
    }

    public int hashCode() {
        return Objects.hash(Comparing.unorderedHashcode(this.myBranches), Comparing.unorderedHashcode(this.myPatterns), Comparing.unorderedHashcode(this.myExcludedBranches), Comparing.unorderedHashcode(this.myExcludedPatterns));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branches";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedBranches";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedPatterns";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/visible/filters/VcsLogBranchFilterImpl";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/visible/filters/VcsLogBranchFilterImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isIncluded";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isExcluded";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isMatched";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

