/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.find.FindBundle;
import com.intellij.find.FindInProjectSettings;
import com.intellij.find.editorHeaderActions.Utils;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.IdeaActionButtonLook;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextArea;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.popup.util.PopupState;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.PlainDocument;
import org.jetbrains.annotations.NotNull;

public class SearchTextArea
extends JPanel
implements PropertyChangeListener {
    public static final String JUST_CLEARED_KEY = "JUST_CLEARED";
    public static final KeyStroke NEW_LINE_KEYSTROKE = KeyStroke.getKeyStroke(10, (SystemInfo.isMac ? 256 : 128) | 0x40);
    private static final ActionButtonLook FIELD_INPLACE_LOOK = new IdeaActionButtonLook(){

        @Override
        public void paintBorder(Graphics g, JComponent component2, @ActionButtonComponent.ButtonState int state) {
            if (component2.isFocusOwner() && component2.isEnabled()) {
                Rectangle rect = new Rectangle(component2.getSize());
                JBInsets.removeFrom((Rectangle)rect, (Insets)component2.getInsets());
                SYSTEM_LOOK.paintLookBorder(g, rect, JBUI.CurrentTheme.ActionButton.focusedBorder());
            } else {
                super.paintBorder(g, component2, 0);
            }
        }

        @Override
        public void paintBackground(Graphics g, JComponent component2, int state) {
            if (((MyActionButton)component2).isRolloverState()) {
                super.paintBackground(g, component2, state);
            }
        }
    };
    private final JTextArea myTextArea;
    private final boolean mySearchMode;
    private final JPanel myIconsPanel;
    private final ActionButton myNewLineButton;
    private final ActionButton myClearButton;
    private final NonOpaquePanel myExtraActionsPanel;
    private final JBScrollPane myScrollPane;
    private final ActionButton myHistoryPopupButton;
    private boolean myMultilineEnabled;
    private final KeyAdapter myEnterRedispatcher;

    @Deprecated
    public SearchTextArea(boolean searchMode) {
        this((JTextArea)new JBTextArea(), searchMode);
    }

    @Deprecated
    public SearchTextArea(@NotNull JTextArea textArea, boolean searchMode, boolean infoMode) {
        if (textArea == null) {
            SearchTextArea.$$$reportNull$$$0(0);
        }
        this(textArea, searchMode);
    }

    @Deprecated
    public SearchTextArea(@NotNull JTextArea textArea, boolean searchMode, boolean infoMode, boolean allowInsertTabInMultiline) {
        if (textArea == null) {
            SearchTextArea.$$$reportNull$$$0(1);
        }
        this(textArea, searchMode);
    }

    public SearchTextArea(@NotNull JTextArea textArea, boolean searchMode) {
        if (textArea == null) {
            SearchTextArea.$$$reportNull$$$0(2);
        }
        this.myIconsPanel = new NonOpaquePanel();
        this.myExtraActionsPanel = new NonOpaquePanel();
        this.myMultilineEnabled = true;
        this.myEnterRedispatcher = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && SearchTextArea.this.getParent() != null) {
                    SearchTextArea.this.getParent().dispatchEvent(e);
                }
            }
        };
        this.myTextArea = textArea;
        this.mySearchMode = searchMode;
        this.updateFont();
        this.myTextArea.addPropertyChangeListener("background", this);
        this.myTextArea.addPropertyChangeListener("font", this);
        DumbAwareAction.create(event -> this.myTextArea.transferFocus()).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(9, 0)), (JComponent)this.myTextArea);
        DumbAwareAction.create(event -> this.myTextArea.transferFocusBackward()).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(9, 64)), (JComponent)this.myTextArea);
        KeymapUtil.reassignAction((JComponent)this.myTextArea, (KeyStroke)KeyStroke.getKeyStroke(10, 0), (KeyStroke)NEW_LINE_KEYSTROKE, (int)0);
        this.myTextArea.setDocument(new PlainDocument(){

            @Override
            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                if (this.getProperty("filterNewlines") == Boolean.TRUE && str.indexOf(10) >= 0) {
                    str = StringUtil.replace((String)str, (String)"\n", (String)" ");
                }
                if (!StringUtil.isEmpty((String)str)) {
                    super.insertString(offs, str, a);
                }
            }
        });
        if (Registry.is((String)"ide.find.field.trims.pasted.text", (boolean)false)) {
            this.myTextArea.getDocument().putProperty("trimTextOnPaste", Boolean.TRUE);
        }
        this.myTextArea.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (e.getType() == DocumentEvent.EventType.INSERT) {
                    SearchTextArea.this.myTextArea.putClientProperty(SearchTextArea.JUST_CLEARED_KEY, null);
                }
                int rows = Math.min(Registry.get((String)"ide.find.max.rows").asInteger(), SearchTextArea.this.myTextArea.getLineCount());
                SearchTextArea.this.myTextArea.setRows(Math.max(1, Math.min(25, rows)));
                SearchTextArea.this.updateIconsLayout();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/SearchTextArea$3", "textChanged"));
            }
        });
        this.myTextArea.setOpaque(false);
        this.myScrollPane = new JBScrollPane(this.myTextArea, 20, 30){

            protected void setupCorners() {
                super.setupCorners();
                this.setBorder((Border)JBUI.Borders.empty((int)2, (int)0, (int)2, (int)2));
            }

            public void updateUI() {
                super.updateUI();
                this.setBorder((Border)JBUI.Borders.empty((int)2, (int)0, (int)2, (int)2));
            }
        };
        this.myTextArea.setBorder(new Border(){

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            }

            @Override
            public Insets getBorderInsets(Component c) {
                int top;
                if (SystemInfo.isMac) {
                    return new JBInsets(3, 0, 2, 0);
                }
                int bottom = StringUtil.getLineBreakCount((CharSequence)SearchTextArea.this.myTextArea.getText()) > 0 ? 2 : (StartupUiUtil.isUnderDarcula() ? 1 : 0);
                int n = top = SearchTextArea.this.myTextArea.getFontMetrics(SearchTextArea.this.myTextArea.getFont()).getHeight() <= 16 ? 2 : 1;
                if (JBUIScale.isUsrHiDPI()) {
                    bottom = 0;
                    top = 2;
                }
                return new JBInsets(top, 0, bottom, 0);
            }

            @Override
            public boolean isBorderOpaque() {
                return false;
            }
        });
        this.myScrollPane.getViewport().setBorder(null);
        this.myScrollPane.getViewport().setOpaque(false);
        this.myScrollPane.setOpaque(false);
        this.myHistoryPopupButton = new MyActionButton((AnAction)new ShowHistoryAction(), false);
        this.myClearButton = new MyActionButton((AnAction)new ClearAction(), false);
        this.myNewLineButton = new MyActionButton((AnAction)new NewLineAction(), false);
        this.updateLayout();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.updateFont();
        this.setBackground(UIUtil.getTextFieldBackground());
    }

    private void updateFont() {
        if (this.myTextArea != null) {
            if (Registry.is((String)"ide.find.use.editor.font", (boolean)false)) {
                this.myTextArea.setFont(EditorUtil.getEditorFont());
            } else {
                this.myTextArea.setFont(UIManager.getFont("TextField.font"));
            }
        }
    }

    protected void updateLayout() {
        NonOpaquePanel historyButtonWrapper = new NonOpaquePanel((LayoutManager)new BorderLayout());
        historyButtonWrapper.setBorder((Border)JBUI.Borders.emptyTop((int)1));
        historyButtonWrapper.add((Component)this.myHistoryPopupButton, "North");
        NonOpaquePanel iconsPanelWrapper = new NonOpaquePanel((LayoutManager)new BorderLayout());
        iconsPanelWrapper.setBorder((Border)JBUI.Borders.emptyTop((int)1));
        NonOpaquePanel p = new NonOpaquePanel((LayoutManager)new BorderLayout());
        p.add((Component)this.myIconsPanel, "North");
        iconsPanelWrapper.add((Component)p, "West");
        iconsPanelWrapper.add((Component)this.myExtraActionsPanel, "Center");
        this.removeAll();
        this.setLayout(new BorderLayout(JBUIScale.scale((int)3), 0));
        this.setBorder(JBUI.Borders.empty((int)(SystemInfo.isLinux ? JBUI.scale((int)2) : JBUI.scale((int)1))));
        this.add((Component)historyButtonWrapper, "West");
        this.add((Component)this.myScrollPane, "Center");
        this.add((Component)iconsPanelWrapper, "East");
        this.updateIconsLayout();
    }

    private void updateIconsLayout() {
        boolean multiline;
        if (this.myIconsPanel.getParent() == null) {
            return;
        }
        boolean showClearIcon = !StringUtil.isEmpty((String)this.myTextArea.getText());
        boolean showNewLine = this.myMultilineEnabled;
        boolean wrongVisibility = this.myClearButton.getParent() == null == showClearIcon || this.myNewLineButton.getParent() == null == showNewLine;
        boolean bl = multiline = StringUtil.getLineBreakCount((CharSequence)this.myTextArea.getText()) > 0;
        if (wrongVisibility) {
            this.myIconsPanel.removeAll();
            this.myIconsPanel.setLayout(new BorderLayout());
            this.myIconsPanel.add((Component)this.myClearButton, "Center");
            this.myIconsPanel.add((Component)this.myNewLineButton, "East");
            this.myIconsPanel.setPreferredSize(this.myIconsPanel.getPreferredSize());
            if (!showClearIcon) {
                this.myIconsPanel.remove(this.myClearButton);
            }
            if (!showNewLine) {
                this.myIconsPanel.remove(this.myNewLineButton);
            }
            this.myIconsPanel.revalidate();
            this.myIconsPanel.repaint();
        }
        this.myScrollPane.setHorizontalScrollBarPolicy(30);
        this.myScrollPane.setVerticalScrollBarPolicy(multiline ? 20 : 21);
        this.myScrollPane.getHorizontalScrollBar().setVisible(multiline);
        this.myScrollPane.revalidate();
        this.doLayout();
    }

    public List<Component> setExtraActions(AnAction ... actions) {
        this.myExtraActionsPanel.removeAll();
        this.myExtraActionsPanel.setBorder((Border)JBUI.Borders.empty());
        ArrayList<Component> addedButtons = new ArrayList<Component>();
        if (actions != null && actions.length > 0) {
            NonOpaquePanel buttonsGrid = new NonOpaquePanel((LayoutManager)new GridLayout(1, actions.length, 0, 0));
            for (AnAction action2 : actions) {
                MyActionButton button2 = new MyActionButton(action2, true);
                addedButtons.add(button2);
                buttonsGrid.add(button2);
            }
            this.myExtraActionsPanel.setLayout((LayoutManager)new BorderLayout());
            this.myExtraActionsPanel.add((Component)buttonsGrid, (Object)"North");
            this.myExtraActionsPanel.setBorder((Border)new CompoundBorder(JBUI.Borders.customLine((Color)JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground(), (int)0, (int)1, (int)0, (int)0), (Border)JBUI.Borders.emptyLeft((int)4)));
        }
        return addedButtons;
    }

    public void updateExtraActions() {
        for (ActionButton button2 : UIUtil.findComponentsOfType((JComponent)this.myExtraActionsPanel, ActionButton.class)) {
            button2.update();
        }
    }

    public void setMultilineEnabled(boolean enabled) {
        if (this.myMultilineEnabled == enabled) {
            return;
        }
        this.myMultilineEnabled = enabled;
        this.myTextArea.getDocument().putProperty("filterNewlines", this.myMultilineEnabled ? null : Boolean.TRUE);
        if (!this.myMultilineEnabled) {
            this.myTextArea.getInputMap().put(KeyStroke.getKeyStroke("shift UP"), "selection-begin-line");
            this.myTextArea.getInputMap().put(KeyStroke.getKeyStroke("shift DOWN"), "selection-end-line");
            this.myTextArea.addKeyListener(this.myEnterRedispatcher);
        } else {
            this.myTextArea.getInputMap().put(KeyStroke.getKeyStroke("shift UP"), "selection-up");
            this.myTextArea.getInputMap().put(KeyStroke.getKeyStroke("shift DOWN"), "selection-down");
            this.myTextArea.removeKeyListener(this.myEnterRedispatcher);
        }
        this.updateIconsLayout();
    }

    @NotNull
    public JTextArea getTextArea() {
        JTextArea jTextArea = this.myTextArea;
        if (jTextArea == null) {
            SearchTextArea.$$$reportNull$$$0(3);
        }
        return jTextArea;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("background".equals(evt.getPropertyName())) {
            this.repaint();
        }
        if ("font".equals(evt.getPropertyName())) {
            this.updateLayout();
        }
    }

    @Deprecated
    public void setInfoText(String info) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textArea";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/SearchTextArea";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/SearchTextArea";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextArea";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyActionButton
    extends ActionButton {
        private MyActionButton(@NotNull AnAction action2, boolean focusable) {
            if (action2 == null) {
                MyActionButton.$$$reportNull$$$0(0);
            }
            super(action2, action2.getTemplatePresentation().clone(), "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
            this.setLook(focusable ? FIELD_INPLACE_LOOK : ActionButtonLook.INPLACE_LOOK);
            this.setFocusable(focusable);
            this.updateIcon();
        }

        @Override
        protected DataContext getDataContext() {
            return DataManager.getInstance().getDataContext((Component)this);
        }

        @Override
        public int getPopState() {
            return this.isSelected() ? 2 : super.getPopState();
        }

        boolean isRolloverState() {
            return super.isRollover();
        }

        @Override
        public Icon getIcon() {
            Icon selectedIcon;
            if (this.isEnabled() && this.isSelected() && (selectedIcon = this.myPresentation.getSelectedIcon()) != null) {
                return selectedIcon;
            }
            return super.getIcon();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/find/SearchTextArea$MyActionButton", "<init>"));
        }
    }

    private class NewLineAction
    extends DumbAwareAction {
        NewLineAction() {
            super(FindBundle.message("find.new.line", new Object[0]), null, AllIcons.Actions.SearchNewLine);
            this.setShortcutSet((ShortcutSet)new CustomShortcutSet(NEW_LINE_KEYSTROKE));
            this.getTemplatePresentation().setHoveredIcon(AllIcons.Actions.SearchNewLineHover);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                NewLineAction.$$$reportNull$$$0(0);
            }
            new DefaultEditorKit.InsertBreakAction().actionPerformed(new ActionEvent(SearchTextArea.this.myTextArea, 0, "action"));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/SearchTextArea$NewLineAction", "actionPerformed"));
        }
    }

    private class ClearAction
    extends DumbAwareAction {
        ClearAction() {
            super(AllIcons.Actions.Close);
            this.getTemplatePresentation().setHoveredIcon(AllIcons.Actions.CloseHovered);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ClearAction.$$$reportNull$$$0(0);
            }
            SearchTextArea.this.myTextArea.putClientProperty(SearchTextArea.JUST_CLEARED_KEY, !SearchTextArea.this.myTextArea.getText().isEmpty());
            SearchTextArea.this.myTextArea.setText("");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/SearchTextArea$ClearAction", "actionPerformed"));
        }
    }

    private class ShowHistoryAction
    extends DumbAwareAction {
        private final PopupState myPopupState;

        ShowHistoryAction() {
            super(FindBundle.message(SearchTextArea.this.mySearchMode ? "find.search.history" : "find.replace.history", new Object[0]), FindBundle.message(SearchTextArea.this.mySearchMode ? "find.search.history" : "find.replace.history", new Object[0]), AllIcons.Actions.SearchWithHistory);
            this.myPopupState = new PopupState();
            this.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"ShowSearchHistory"), SearchTextArea.this.myTextArea);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowHistoryAction.$$$reportNull$$$0(0);
            }
            if (this.myPopupState.isRecentlyHidden()) {
                return;
            }
            FeatureUsageTracker.getInstance().triggerFeatureUsed("find.recent.search");
            FindInProjectSettings findInProjectSettings = FindInProjectSettings.getInstance((Project)e.getProject());
            Object[] recent = SearchTextArea.this.mySearchMode ? findInProjectSettings.getRecentFindStrings() : findInProjectSettings.getRecentReplaceStrings();
            JBList historyList = new JBList((Object[])((String[])ArrayUtil.reverseArray((Object[])recent)));
            Utils.showCompletionPopup(SearchTextArea.this, (JList)historyList, null, SearchTextArea.this.myTextArea, null, (JBPopupListener)this.myPopupState);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/SearchTextArea$ShowHistoryAction", "actionPerformed"));
        }
    }
}

