/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.diagnostic.LogMessage;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginUtilImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.Log4jBasedLogger;
import com.intellij.util.ExceptionUtil;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.log4j.DefaultThrowableRenderer;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.ThrowableRenderer;
import org.apache.log4j.spi.ThrowableRendererSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IdeaLogger
extends Log4jBasedLogger {
    public static String ourLastActionId = "";
    public static Exception ourErrorsOccurred;
    private static final Supplier<String> ourApplicationInfoProvider;
    private static final ThrowableRenderer ourThrowableRenderer;

    @NotNull
    public static ThrowableRenderer getThrowableRenderer() {
        ThrowableRenderer throwableRenderer = ourThrowableRenderer;
        if (throwableRenderer == null) {
            IdeaLogger.$$$reportNull$$$0(0);
        }
        return throwableRenderer;
    }

    IdeaLogger(@NotNull Logger logger) {
        if (logger == null) {
            IdeaLogger.$$$reportNull$$$0(1);
        }
        super(logger);
        LoggerRepository repository = this.myLogger.getLoggerRepository();
        if (repository instanceof ThrowableRendererSupport) {
            ((ThrowableRendererSupport)repository).setThrowableRenderer(ourThrowableRenderer);
        }
    }

    public void error(Object message) {
        if (message instanceof IdeaLoggingEvent) {
            this.myLogger.error(message);
        } else {
            super.error(message);
        }
    }

    public void error(String message, @Nullable Throwable t, Attachment ... attachments) {
        if (attachments == null) {
            IdeaLogger.$$$reportNull$$$0(2);
        }
        this.myLogger.error((Object)LogMessage.createEvent(t != null ? t : new Throwable(), message, attachments));
    }

    public void warn(String message, @Nullable Throwable t) {
        super.warn(message, IdeaLogger.checkException((Throwable)t));
    }

    public void error(String message, @Nullable Throwable t, String ... details) {
        String detailString;
        if (details == null) {
            IdeaLogger.$$$reportNull$$$0(3);
        }
        if (t instanceof ControlFlowException) {
            this.myLogger.error((Object)message, IdeaLogger.checkException((Throwable)t));
            ExceptionUtil.rethrow((Throwable)t);
        }
        if (!(detailString = String.join((CharSequence)"\n", details)).isEmpty()) {
            detailString = "\nDetails: " + detailString;
        }
        if (ourErrorsOccurred == null) {
            String mess = "Logger errors occurred. See IDEA logs for details. " + (message == null || message.isEmpty() ? "" : "Error message is '" + message + "'");
            ourErrorsOccurred = new Exception(mess + detailString, t);
        }
        this.myLogger.error((Object)(message + detailString), t);
        this.logErrorHeader(t);
    }

    private void logErrorHeader(@Nullable Throwable t) {
        ApplicationImpl application;
        IdeaPluginDescriptor plugin;
        this.myLogger.error((Object)ourApplicationInfoProvider.get());
        Properties properties = System.getProperties();
        this.myLogger.error((Object)("JDK: " + properties.getProperty("java.version", "unknown") + "; VM: " + properties.getProperty("java.vm.name", "unknown") + "; Vendor: " + properties.getProperty("java.vendor", "unknown")));
        this.myLogger.error((Object)("OS: " + properties.getProperty("os.name", "unknown")));
        if (t != null && PluginManagerCore.arePluginsInitialized() && (plugin = PluginManagerCore.getPlugin(PluginUtilImpl.doFindPluginId(t))) != null && (!plugin.isBundled() || plugin.allowBundledUpdate())) {
            this.myLogger.error((Object)("Plugin to blame: " + plugin.getName() + " version: " + plugin.getVersion()));
        }
        if ((application = (ApplicationImpl)ApplicationManager.getApplication()) != null && application.getComponentCreated() && !application.isDisposed()) {
            String currentCommandName;
            CommandProcessor commandProcessor;
            String lastPreformedActionId = ourLastActionId;
            if (lastPreformedActionId != null) {
                this.myLogger.error((Object)("Last Action: " + lastPreformedActionId));
            }
            if ((commandProcessor = (CommandProcessor)application.getServiceIfCreated(CommandProcessor.class)) != null && (currentCommandName = commandProcessor.getCurrentCommandName()) != null) {
                this.myLogger.error((Object)("Current Command: " + currentCommandName));
            }
        }
    }

    static {
        ourApplicationInfoProvider = () -> {
            ApplicationInfoEx info = ApplicationInfoImpl.getShadowInstance();
            return info.getFullApplicationName() + "  Build #" + info.getBuild().asString();
        };
        ourThrowableRenderer = t -> {
            int maxExtraSize;
            int maxStackSize;
            String[] lines = DefaultThrowableRenderer.render((Throwable)t);
            if (lines.length > (maxStackSize = 1024) + (maxExtraSize = 256)) {
                String[] res2 = new String[maxStackSize + maxExtraSize + 1];
                System.arraycopy(lines, 0, res2, 0, maxStackSize);
                res2[maxStackSize] = "\t...";
                System.arraycopy(lines, lines.length - maxExtraSize, res2, maxStackSize + 1, maxExtraSize);
                return res2;
            }
            return lines;
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/idea/IdeaLogger";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attachments";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrowableRenderer";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/idea/IdeaLogger";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

