/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.Topic;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BackgroundTaskUtil {
    private static final Logger LOG = Logger.getInstance(BackgroundTaskUtil.class);

    @NotNull
    public static ProgressIndicator executeAndTryWait(@NotNull Function<? super ProgressIndicator, ? extends Runnable> backgroundTask, @Nullable Runnable onSlowAction) {
        if (backgroundTask == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(0);
        }
        return BackgroundTaskUtil.executeAndTryWait(backgroundTask, onSlowAction, 300L, false);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static ProgressIndicator executeAndTryWait(@NotNull Function<? super ProgressIndicator, ? extends Runnable> backgroundTask, @Nullable Runnable onSlowAction, long waitMillis, boolean bl) {
        void forceEDT;
        if (backgroundTask == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(1);
        }
        ModalityState modality = ModalityState.current();
        if (forceEDT != false) {
            EmptyProgressIndicator indicator2 = new EmptyProgressIndicator(modality);
            try {
                Runnable callback3 = (Runnable)ProgressManager.getInstance().runProcess(() -> BackgroundTaskUtil.lambda$executeAndTryWait$0(backgroundTask, (ProgressIndicator)indicator2), (ProgressIndicator)indicator2);
                BackgroundTaskUtil.finish(callback3, (ProgressIndicator)indicator2);
            }
            catch (ProcessCanceledException callback3) {
            }
            catch (Throwable t) {
                LOG.error(t);
            }
            EmptyProgressIndicator emptyProgressIndicator = indicator2;
            if (emptyProgressIndicator == null) {
                BackgroundTaskUtil.$$$reportNull$$$0(2);
            }
            return emptyProgressIndicator;
        }
        Pair<? extends Runnable, ProgressIndicator> pair = BackgroundTaskUtil.computeInBackgroundAndTryWait(backgroundTask, (callback2, indicator) -> ApplicationManager.getApplication().invokeLater(() -> BackgroundTaskUtil.finish(callback2, indicator), modality), modality, waitMillis);
        Runnable callback4 = (Runnable)pair.first;
        ProgressIndicator indicator3 = (ProgressIndicator)pair.second;
        if (callback4 != null) {
            BackgroundTaskUtil.finish(callback4, indicator3);
        } else if (onSlowAction != null) {
            onSlowAction.run();
        }
        ProgressIndicator progressIndicator2 = indicator3;
        if (progressIndicator2 == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(3);
        }
        return progressIndicator2;
    }

    private static void finish(@NotNull Runnable result2, @NotNull ProgressIndicator indicator) {
        if (result2 == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(4);
        }
        if (indicator == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(5);
        }
        if (!indicator.isCanceled()) {
            result2.run();
        }
    }

    @Nullable
    public static <T> T tryComputeFast(@NotNull Function<? super ProgressIndicator, ? extends T> backgroundTask, long waitMillis) {
        if (backgroundTask == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(6);
        }
        Pair<? extends T, ProgressIndicator> pair = BackgroundTaskUtil.computeInBackgroundAndTryWait(backgroundTask, (result2, indicator) -> {}, ModalityState.defaultModalityState(), waitMillis);
        Object result3 = pair.first;
        ProgressIndicator indicator2 = (ProgressIndicator)pair.second;
        indicator2.cancel();
        return (T)result3;
    }

    @Nullable
    public static <T> T computeInBackgroundAndTryWait(@NotNull Computable<? extends T> computable, @NotNull Consumer<? super T> asyncCallback, long waitMillis) {
        if (computable == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(7);
        }
        if (asyncCallback == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(8);
        }
        Pair<T, ProgressIndicator> pair = BackgroundTaskUtil.computeInBackgroundAndTryWait(indicator -> computable.compute(), (result2, indicator) -> asyncCallback.consume(result2), ModalityState.defaultModalityState(), waitMillis);
        return (T)pair.first;
    }

    @NotNull
    private static <T> Pair<T, ProgressIndicator> computeInBackgroundAndTryWait(@NotNull Function<? super ProgressIndicator, ? extends T> task2, @NotNull PairConsumer<? super T, ? super ProgressIndicator> asyncCallback, @NotNull ModalityState modality, long waitMillis) {
        if (task2 == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(9);
        }
        if (asyncCallback == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(10);
        }
        if (modality == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(11);
        }
        EmptyProgressIndicator indicator = new EmptyProgressIndicator(modality);
        indicator.start();
        Helper helper = new Helper();
        ApplicationManager.getApplication().executeOnPooledThread(() -> BackgroundTaskUtil.lambda$computeInBackgroundAndTryWait$7(task2, (ProgressIndicator)indicator, helper, asyncCallback));
        Object result2 = null;
        if (helper.await(waitMillis)) {
            result2 = helper.getResult();
        }
        Pair pair = Pair.create(result2, (Object)indicator);
        if (pair == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(12);
        }
        return pair;
    }

    @NotNull
    public static ProgressIndicator executeOnPooledThread(@NotNull Disposable parent, @NotNull Runnable runnable2) {
        if (parent == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(13);
        }
        if (runnable2 == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(14);
        }
        EmptyProgressIndicator indicator = new EmptyProgressIndicator();
        indicator.start();
        CompletableFuture<Void> future2 = CompletableFuture.runAsync(() -> BackgroundTaskUtil.lambda$executeOnPooledThread$8(runnable2, (ProgressIndicator)indicator), AppExecutorUtil.getAppExecutorService());
        Disposable disposable2 = () -> BackgroundTaskUtil.lambda$executeOnPooledThread$9((ProgressIndicator)indicator, future2, runnable2);
        if (!BackgroundTaskUtil.registerIfParentNotDisposed(parent, disposable2)) {
            indicator.cancel();
            EmptyProgressIndicator emptyProgressIndicator = indicator;
            if (emptyProgressIndicator == null) {
                BackgroundTaskUtil.$$$reportNull$$$0(15);
            }
            return emptyProgressIndicator;
        }
        future2.whenComplete((o, e) -> Disposer.dispose((Disposable)disposable2));
        EmptyProgressIndicator emptyProgressIndicator = indicator;
        if (emptyProgressIndicator == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(16);
        }
        return emptyProgressIndicator;
    }

    public static <T> T runUnderDisposeAwareIndicator(@NotNull Disposable parent, @NotNull Supplier<T> task2) {
        if (parent == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(17);
        }
        if (task2 == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(18);
        }
        Ref ref = new Ref();
        BackgroundTaskUtil.runUnderDisposeAwareIndicator(parent, () -> ref.set(task2.get()));
        return (T)ref.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runUnderDisposeAwareIndicator(@NotNull Disposable parent, @NotNull Runnable task2) {
        ProgressIndicator threadProgress;
        Object indicator;
        Disposable disposable2;
        if (parent == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(19);
        }
        if (task2 == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(20);
        }
        if (!BackgroundTaskUtil.registerIfParentNotDisposed(parent, disposable2 = () -> BackgroundTaskUtil.lambda$runUnderDisposeAwareIndicator$12((ProgressIndicator)(indicator = (threadProgress = ProgressManager.getInstance().getProgressIndicator()) == null ? new EmptyProgressIndicator(ModalityState.defaultModalityState()) : new SensitiveProgressWrapper(threadProgress))))) {
            indicator.cancel();
            throw new ProcessCanceledException();
        }
        try {
            ProgressManager.getInstance().runProcess(task2, (ProgressIndicator)indicator);
        }
        finally {
            Disposer.dispose((Disposable)disposable2);
        }
    }

    private static boolean registerIfParentNotDisposed(@NotNull Disposable parent, @NotNull Disposable disposable2) {
        if (parent == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(21);
        }
        if (disposable2 == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(22);
        }
        if (parent instanceof ComponentManager && ((ComponentManager)parent).isDisposed()) {
            return false;
        }
        return Disposer.tryRegister((Disposable)parent, (Disposable)disposable2);
    }

    @NotNull
    public static <L> L syncPublisher(@NotNull Project project, @NotNull Topic<L> topic) throws ProcessCanceledException {
        if (project == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(23);
        }
        if (topic == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(24);
        }
        Object object = ReadAction.compute(() -> {
            if (project.isDisposed()) {
                throw new ProcessCanceledException();
            }
            return project.getMessageBus().syncPublisher(topic);
        });
        if (object == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(25);
        }
        return (L)object;
    }

    @NotNull
    public static <L> L syncPublisher(@NotNull Topic<L> topic) throws ProcessCanceledException {
        if (topic == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(26);
        }
        Object object = ReadAction.compute(() -> {
            if (ApplicationManager.getApplication().isDisposed()) {
                throw new ProcessCanceledException();
            }
            return ApplicationManager.getApplication().getMessageBus().syncPublisher(topic);
        });
        if (object == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(27);
        }
        return (L)object;
    }

    private static /* synthetic */ void lambda$runUnderDisposeAwareIndicator$12(ProgressIndicator indicator) {
        if (indicator.isRunning()) {
            indicator.cancel();
        }
    }

    private static /* synthetic */ void lambda$executeOnPooledThread$9(ProgressIndicator indicator, CompletableFuture future2, Runnable runnable2) {
        if (indicator.isRunning()) {
            indicator.cancel();
        }
        try {
            future2.get(1L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            if (!(e.getCause() instanceof ProcessCanceledException)) {
                LOG.error((Throwable)e);
            }
        }
        catch (InterruptedException | TimeoutException e) {
            LOG.debug("Couldn't await background process on disposal: " + runnable2);
        }
    }

    private static /* synthetic */ void lambda$executeOnPooledThread$8(Runnable runnable2, ProgressIndicator indicator) {
        ProgressManager.getInstance().runProcess(runnable2, indicator);
    }

    private static /* synthetic */ void lambda$computeInBackgroundAndTryWait$7(Function task2, ProgressIndicator indicator, Helper helper, PairConsumer asyncCallback) {
        ProgressManager.getInstance().runProcess(() -> {
            Object result2 = task2.fun((Object)indicator);
            if (!helper.setResult(result2)) {
                asyncCallback.consume(result2, (Object)indicator);
            }
        }, indicator);
    }

    private static /* synthetic */ Runnable lambda$executeAndTryWait$0(Function backgroundTask, ProgressIndicator indicator) {
        return (Runnable)backgroundTask.fun((Object)indicator);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 12: 
            case 15: 
            case 16: 
            case 25: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 12: 
            case 15: 
            case 16: 
            case 25: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backgroundTask";
                break;
            }
            case 2: 
            case 3: 
            case 12: 
            case 15: 
            case 16: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/progress/util/BackgroundTaskUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "asyncCallback";
                break;
            }
            case 9: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modality";
                break;
            }
            case 13: 
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topic";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/progress/util/BackgroundTaskUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "executeAndTryWait";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "computeInBackgroundAndTryWait";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "executeOnPooledThread";
                break;
            }
            case 25: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "syncPublisher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "executeAndTryWait";
                break;
            }
            case 2: 
            case 3: 
            case 12: 
            case 15: 
            case 16: 
            case 25: 
            case 27: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "finish";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "tryComputeFast";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "computeInBackgroundAndTryWait";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "executeOnPooledThread";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "runUnderDisposeAwareIndicator";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "registerIfParentNotDisposed";
                break;
            }
            case 23: 
            case 24: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "syncPublisher";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 12: 
            case 15: 
            case 16: 
            case 25: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Helper<T> {
        private static final Object INITIAL_STATE = ObjectUtils.sentinel((String)"INITIAL_STATE");
        private static final Object SLOW_OPERATION_STATE = ObjectUtils.sentinel((String)"SLOW_OPERATION_STATE");
        private final Semaphore mySemaphore = new Semaphore(0);
        private final AtomicReference<Object> myResultRef = new AtomicReference<Object>(INITIAL_STATE);

        private Helper() {
        }

        public boolean setResult(T result2) {
            boolean isFast = this.myResultRef.compareAndSet(INITIAL_STATE, result2);
            this.mySemaphore.release();
            return isFast;
        }

        public boolean await(long waitMillis) {
            try {
                this.mySemaphore.tryAcquire(waitMillis, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return !this.myResultRef.compareAndSet(INITIAL_STATE, SLOW_OPERATION_STATE);
        }

        public T getResult() {
            Object result2 = this.myResultRef.get();
            assert (result2 != INITIAL_STATE && result2 != SLOW_OPERATION_STATE);
            return (T)result2;
        }
    }
}

