/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal;

import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.terminal.IdeTerminalCopyPasteHandler;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.TerminalEscapeKeyListener;
import com.intellij.terminal.TerminalSettingsListener;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.UIUtil;
import com.jediterm.terminal.TerminalCopyPasteHandler;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.model.StyleState;
import com.jediterm.terminal.model.TerminalTextBuffer;
import com.jediterm.terminal.ui.TerminalPanel;
import com.jediterm.terminal.ui.settings.SettingsProvider;
import java.awt.AWTEvent;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import javax.swing.KeyStroke;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBTerminalPanel
extends TerminalPanel
implements FocusListener,
TerminalSettingsListener,
Disposable {
    private static final Logger LOG = Logger.getInstance(JBTerminalPanel.class);
    @NonNls
    private static final String[] ACTIONS_TO_SKIP = new String[]{"ActivateTerminalToolWindow", "ActivateProjectToolWindow", "ActivateFavoritesToolWindow", "ActivateFindToolWindow", "ActivateRunToolWindow", "ActivateDebugToolWindow", "ActivateProblemsViewToolWindow", "ActivateTODOToolWindow", "ActivateStructureToolWindow", "ActivateHierarchyToolWindow", "ActivateServicesToolWindow", "ActivateCommitToolWindow", "ActivateVersionControlToolWindow", "HideActiveWindow", "HideAllWindows", "NextWindow", "PreviousWindow", "NextProjectWindow", "PreviousProjectWindow", "ShowBookmarks", "GotoBookmark0", "GotoBookmark1", "GotoBookmark2", "GotoBookmark3", "GotoBookmark4", "GotoBookmark5", "GotoBookmark6", "GotoBookmark7", "GotoBookmark8", "GotoBookmark9", "GotoAction", "GotoFile", "GotoClass", "GotoSymbol", "Vcs.Push", "ShowSettings", "RecentFiles", "Switcher", "ResizeToolWindowLeft", "ResizeToolWindowRight", "ResizeToolWindowUp", "ResizeToolWindowDown", "MaximizeToolWindow"};
    private static final int MIN_FONT_SIZE = 8;
    private final TerminalEventDispatcher myEventDispatcher;
    private final JBTerminalSystemSettingsProviderBase mySettingsProvider;
    private final TerminalEscapeKeyListener myEscapeKeyListener;
    private final List<Consumer<KeyEvent>> myPreKeyEventConsumers;
    private List<AnAction> myActionsToSkip;

    public JBTerminalPanel(@NotNull JBTerminalSystemSettingsProviderBase settingsProvider, @NotNull TerminalTextBuffer backBuffer, @NotNull StyleState styleState) {
        if (settingsProvider == null) {
            JBTerminalPanel.$$$reportNull$$$0(0);
        }
        if (backBuffer == null) {
            JBTerminalPanel.$$$reportNull$$$0(1);
        }
        if (styleState == null) {
            JBTerminalPanel.$$$reportNull$$$0(2);
        }
        super((SettingsProvider)settingsProvider, backBuffer, styleState);
        this.myEventDispatcher = new TerminalEventDispatcher();
        this.myPreKeyEventConsumers = new CopyOnWriteArrayList<Consumer<KeyEvent>>();
        this.mySettingsProvider = settingsProvider;
        this.addFocusListener(this);
        this.mySettingsProvider.addListener(this);
        this.myEscapeKeyListener = new TerminalEscapeKeyListener(this);
    }

    private boolean skipKeyEvent(@NotNull KeyEvent e) {
        if (e == null) {
            JBTerminalPanel.$$$reportNull$$$0(3);
        }
        return JBTerminalPanel.skipAction(e, this.myActionsToSkip);
    }

    private static boolean skipAction(@NotNull KeyEvent e, @Nullable List<? extends AnAction> actionsToSkip) {
        if (e == null) {
            JBTerminalPanel.$$$reportNull$$$0(4);
        }
        if (actionsToSkip != null) {
            KeyboardShortcut eventShortcut = new KeyboardShortcut(KeyStroke.getKeyStrokeForEvent(e), null);
            for (AnAction anAction : actionsToSkip) {
                for (Shortcut sc : anAction.getShortcutSet().getShortcuts()) {
                    if (!sc.isKeyboard() || !sc.startsWith((Shortcut)eventShortcut)) continue;
                    return Registry.is((String)"terminal.Ctrl-E.opens.RecentFiles.popup", (boolean)false) || !"RecentFiles".equals(ActionManager.getInstance().getId(anAction)) || e.getModifiersEx() != 128 || e.getKeyCode() != 69;
                }
            }
        }
        return false;
    }

    public void handleKeyEvent(@NotNull KeyEvent e) {
        if (e == null) {
            JBTerminalPanel.$$$reportNull$$$0(5);
        }
        if (SystemInfo.isMac && SystemInfo.isJavaVersionAtLeast((int)11, (int)0, (int)0) && e.getKeyChar() == '\n' && e.getKeyCode() == 67 && e.getModifiersEx() == 128) {
            LOG.debug("Fixing Ctrl+C");
            e.setKeyChar('\u0003');
        }
        this.myEscapeKeyListener.handleKeyEvent(e);
        for (Consumer<KeyEvent> preKeyEventConsumer : this.myPreKeyEventConsumers) {
            preKeyEventConsumer.accept(e);
        }
        if (!e.isConsumed()) {
            super.handleKeyEvent(e);
        }
    }

    public void addPreKeyEventHandler(@NotNull Consumer<KeyEvent> preKeyEventHandler) {
        if (preKeyEventHandler == null) {
            JBTerminalPanel.$$$reportNull$$$0(6);
        }
        this.myPreKeyEventConsumers.add(preKeyEventHandler);
    }

    protected void setupAntialiasing(Graphics graphics) {
        UIUtil.setupComposite((Graphics2D)((Graphics2D)graphics));
        UISettings.setupAntialiasing((Graphics)graphics);
    }

    @NotNull
    protected TerminalCopyPasteHandler createCopyPasteHandler() {
        return new IdeTerminalCopyPasteHandler();
    }

    protected void drawImage(Graphics2D gfx, BufferedImage image, int x, int y, ImageObserver observer) {
        UIUtil.drawImage((Graphics)gfx, (Image)image, (int)x, (int)y, (ImageObserver)observer);
    }

    protected void drawImage(Graphics2D g, BufferedImage image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2) {
        JBTerminalPanel.drawImage(g, image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null);
    }

    public static void drawImage(Graphics g, Image image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        if (image instanceof JBHiDPIScaledImage) {
            Graphics2D newG = (Graphics2D)g.create(0, 0, image.getWidth(observer), image.getHeight(observer));
            newG.scale(0.5, 0.5);
            Image img = ((JBHiDPIScaledImage)image).getDelegate();
            if (img == null) {
                img = image;
            }
            newG.drawImage(img, 2 * dx1, 2 * dy1, 2 * dx2, 2 * dy2, sx1 * 2, sy1 * 2, sx2 * 2, sy2 * 2, observer);
            newG.scale(1.0, 1.0);
            newG.dispose();
        } else {
            g.drawImage(image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
        }
    }

    protected boolean isRetina() {
        return UIUtil.isRetina();
    }

    protected BufferedImage createBufferedImage(int width, int height) {
        return ImageUtil.createImage((int)width, (int)height, (int)2);
    }

    @Override
    public void focusGained(FocusEvent event) {
        if (this.mySettingsProvider.overrideIdeShortcuts()) {
            this.myActionsToSkip = JBTerminalPanel.setupActionsToSkip();
            this.myEventDispatcher.register();
        } else {
            this.myActionsToSkip = null;
            this.myEventDispatcher.unregister();
        }
        if (GeneralSettings.getInstance().isSaveOnFrameDeactivation()) {
            ApplicationManager.getApplication().invokeLater(() -> FileDocumentManager.getInstance().saveAllDocuments(), ModalityState.NON_MODAL);
        }
    }

    @NotNull
    private static List<AnAction> setupActionsToSkip() {
        ArrayList<AnAction> res2 = new ArrayList<AnAction>();
        ActionManager actionManager = ActionManager.getInstance();
        for (String actionId : ACTIONS_TO_SKIP) {
            AnAction action2 = actionManager.getAction(actionId);
            if (action2 == null) continue;
            res2.add(action2);
        }
        ArrayList<AnAction> arrayList = res2;
        if (arrayList == null) {
            JBTerminalPanel.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Override
    public void focusLost(FocusEvent event) {
        this.myActionsToSkip = null;
        this.myEventDispatcher.unregister();
        SaveAndSyncHandler.getInstance().scheduleRefresh();
    }

    protected Font getFontToDisplay(char c, TextStyle style) {
        FontInfo fontInfo = this.fontForChar(c, style.hasOption(TextStyle.Option.BOLD) ? 1 : 0);
        return fontInfo.getFont();
    }

    public FontInfo fontForChar(char c, @JdkConstants.FontStyle int style) {
        return ComplementaryFontsRegistry.getFontAbleToDisplay(c, style, this.mySettingsProvider.getColorsScheme().getConsoleFontPreferences(), null);
    }

    @Override
    public void fontChanged() {
        this.reinitFontAndResize();
    }

    public void dispose() {
        super.dispose();
        this.mySettingsProvider.removeListener(this);
    }

    protected void processMouseWheelEvent(MouseWheelEvent e) {
        if (EditorSettingsExternalizable.getInstance().isWheelFontChangeEnabled() && EditorUtil.isChangeFontSize(e)) {
            int newFontSize = (int)this.mySettingsProvider.getTerminalFontSize() - e.getWheelRotation();
            if (newFontSize >= 8) {
                this.mySettingsProvider.getColorsScheme().setConsoleFontSize(newFontSize);
                this.mySettingsProvider.fireFontChanged();
            }
            return;
        }
        super.processMouseWheelEvent(e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backBuffer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleState";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preKeyEventHandler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/terminal/JBTerminalPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/terminal/JBTerminalPanel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "setupActionsToSkip";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "skipKeyEvent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "skipAction";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleKeyEvent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addPreKeyEventHandler";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class TerminalEventDispatcher
    implements IdeEventQueue.EventDispatcher {
        private boolean myRegistered = false;

        private TerminalEventDispatcher() {
        }

        @Override
        public boolean dispatch(@NotNull AWTEvent e) {
            if (e == null) {
                TerminalEventDispatcher.$$$reportNull$$$0(0);
            }
            return e instanceof KeyEvent && this.dispatchKeyEvent((KeyEvent)e);
        }

        private boolean dispatchKeyEvent(@NotNull KeyEvent e) {
            if (e == null) {
                TerminalEventDispatcher.$$$reportNull$$$0(1);
            }
            if (!JBTerminalPanel.this.skipKeyEvent(e)) {
                if (!JBTerminalPanel.this.isFocusOwner()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Prevented attempt to process " + KeyStroke.getKeyStrokeForEvent(e) + " by not focused " + this.getDebugTerminalPanelName() + ", unregistering");
                    }
                    this.unregister();
                    return false;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Consuming " + KeyStroke.getKeyStrokeForEvent(e) + ", registered:" + this.myRegistered);
                }
                IdeEventQueue.getInstance().flushDelayedKeyEvents();
                if (SystemInfo.isJavaVersionAtLeast((int)8, (int)0, (int)212)) {
                    JBTerminalPanel.this.processKeyEvent(e);
                }
                JBTerminalPanel.this.dispatchEvent(e);
                return true;
            }
            return false;
        }

        void register() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Register terminal event dispatcher for " + this.getDebugTerminalPanelName());
            }
            if (this.myRegistered) {
                LOG.info("Already registered terminal event dispatcher");
            } else if (Disposer.isDisposed((Disposable)JBTerminalPanel.this)) {
                LOG.info("Already disposed " + JBTerminalPanel.this);
            } else {
                IdeEventQueue.getInstance().addDispatcher(this, JBTerminalPanel.this);
                this.myRegistered = true;
            }
        }

        void unregister() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unregister terminal event dispatcher for " + this.getDebugTerminalPanelName());
            }
            if (this.myRegistered) {
                IdeEventQueue.getInstance().removeDispatcher(this);
            }
            this.myRegistered = false;
        }

        @NotNull
        private String getDebugTerminalPanelName() {
            String string = JBTerminalPanel.class.getSimpleName() + "@" + System.identityHashCode(JBTerminalPanel.this);
            if (string == null) {
                TerminalEventDispatcher.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/terminal/JBTerminalPanel$TerminalEventDispatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/terminal/JBTerminalPanel$TerminalEventDispatcher";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDebugTerminalPanelName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "dispatch";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "dispatchKeyEvent";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

