/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToggleButtonUI;

public class OnOffButton
extends JToggleButton {
    private String myOnText = "ON";
    private String myOffText = "OFF";

    public OnOffButton() {
        this.setBorder(null);
        this.setOpaque(false);
    }

    public String getOnText() {
        return this.myOnText;
    }

    public void setOnText(String onText) {
        this.myOnText = onText;
    }

    public String getOffText() {
        return this.myOffText;
    }

    public void setOffText(String offText) {
        this.myOffText = offText;
    }

    @Override
    public String getUIClassID() {
        return "OnOffButtonUI";
    }

    @Override
    public void updateUI() {
        Object uiClassName = UIManager.get(this.getUIClassID());
        this.setUI(uiClassName == null ? DefaultOnOffButtonUI.createUI(this) : UIManager.getUI(this));
    }

    private static class DefaultOnOffButtonUI
    extends BasicToggleButtonUI {
        private static final Color BORDER_COLOR = JBColor.namedColor((String)"ToggleButton.borderColor", (Color)new JBColor((Color)Gray._192, (Color)Gray._80));
        private static final Color BUTTON_COLOR = JBColor.namedColor((String)"ToggleButton.buttonColor", (Color)new JBColor((Color)Gray._200, (Color)Gray._100));
        private static final Color ON_BACKGROUND = JBColor.namedColor((String)"ToggleButton.onBackground", (Color)new JBColor(new Color(74, 146, 73), new Color(77, 105, 76)));
        private static final Color ON_FOREGROUND = JBColor.namedColor((String)"ToggleButton.onForeground", (Color)new JBColor(() -> UIUtil.getListForeground((boolean)true, (boolean)true)));
        private static final Color OFF_BACKGROUND = JBColor.namedColor((String)"ToggleButton.offBackground", (Color)new JBColor(() -> UIUtil.getPanelBackground()));
        private static final Color OFF_FOREGROUND = JBColor.namedColor((String)"ToggleButton.offForeground", (Color)new JBColor(() -> UIUtil.getLabelDisabledForeground()));

        private DefaultOnOffButtonUI() {
        }

        public static ComponentUI createUI(JComponent c) {
            c.setAlignmentY(0.5f);
            return new DefaultOnOffButtonUI();
        }

        @Override
        public Dimension getPreferredSize(JComponent c) {
            int vGap = JBUIScale.scale((int)3);
            OnOffButton button = (OnOffButton)c;
            String text = button.getOffText().length() > button.getOnText().length() ? button.getOffText() : button.getOnText();
            text = text.toUpperCase(Locale.getDefault());
            FontMetrics fm = c.getFontMetrics(c.getFont());
            int w = fm.stringWidth(text);
            int h = fm.getHeight();
            w = (int)((double)w + 1.25 * (double)(h += 2 * vGap));
            return new Dimension(w, h);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics g, JComponent c) {
            if (!(c instanceof OnOffButton)) {
                return;
            }
            int toggleArc = JBUIScale.scale((int)3);
            int buttonArc = JBUIScale.scale((int)5);
            int vGap = JBUIScale.scale((int)3);
            int hGap = JBUIScale.scale((int)3);
            OnOffButton button = (OnOffButton)c;
            Dimension size = button.getSize();
            int w = size.width - 2 * vGap;
            int h = size.height - 2 * hGap;
            if (h % 2 == 1) {
                --h;
            }
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int xOff = (button.getWidth() - w) / 2;
                int yOff = (button.getHeight() - h) / 2;
                g2.translate(xOff, yOff);
                boolean selected = button.isSelected();
                g2.setColor(selected ? ON_BACKGROUND : OFF_BACKGROUND);
                g2.fillRoundRect(0, 0, w, h, buttonArc, buttonArc);
                int knobWidth = w - SwingUtilities.computeStringWidth(g2.getFontMetrics(), button.getOffText()) - JBUIScale.scale((int)2);
                knobWidth = Math.min(knobWidth, h);
                int textAscent = g2.getFontMetrics().getAscent();
                Rectangle viewRect = new Rectangle();
                Rectangle textRect = new Rectangle();
                Rectangle iconRect = new Rectangle();
                g2.setColor(BUTTON_COLOR);
                if (selected) {
                    g2.fillRoundRect(w - knobWidth, 0, knobWidth, h, toggleArc, toggleArc);
                    viewRect.setBounds(0, 0, w - knobWidth, h);
                    SwingUtilities.layoutCompoundLabel(g2.getFontMetrics(), button.getOnText(), null, 0, 0, 0, 0, viewRect, iconRect, textRect, 0);
                    g2.setColor(ON_FOREGROUND);
                    g2.drawString(button.getOnText(), textRect.x, textRect.y + textAscent);
                } else {
                    g2.fillRoundRect(0, 0, knobWidth, h, toggleArc, toggleArc);
                    viewRect.setBounds(knobWidth, 0, w - knobWidth, h);
                    SwingUtilities.layoutCompoundLabel(g2.getFontMetrics(), button.getOffText(), null, 0, 0, 0, 0, viewRect, iconRect, textRect, 0);
                    g2.setColor(OFF_FOREGROUND);
                    g2.drawString(button.getOffText(), textRect.x, textRect.y + textAscent);
                }
                g2.setColor(BORDER_COLOR);
                g2.drawRoundRect(0, 0, w, h, buttonArc, buttonArc);
            }
            finally {
                g2.dispose();
            }
        }

        @Override
        public Dimension getMinimumSize(JComponent c) {
            return this.getPreferredSize(c);
        }

        @Override
        public Dimension getMaximumSize(JComponent c) {
            return this.getPreferredSize(c);
        }
    }
}

