/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.actions;

import com.intellij.internal.statistic.actions.FusStatesRecorder;
import com.intellij.internal.statistic.eventLog.EventLogNotificationService;
import com.intellij.internal.statistic.eventLog.LogEvent;
import com.intellij.internal.statistic.service.fus.collectors.FUStateUsagesLogger;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0003\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\u001e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/internal/statistic/actions/FusStatesRecorder;", "", "()V", "isRecordingInProgress", "Ljava/util/concurrent/atomic/AtomicBoolean;", "lock", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "state", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lcom/intellij/internal/statistic/eventLog/LogEvent;", "statesLogger", "Lcom/intellij/internal/statistic/service/fus/collectors/FUStateUsagesLogger;", "getCurrentState", "", "isComparisonAvailable", "", "recordEvent", "", "logEvent", "recordStateAndWait", "project", "Lcom/intellij/openapi/project/Project;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.platform.statistics.devkit"})
public final class FusStatesRecorder {
    private static final Logger log;
    private static final FUStateUsagesLogger statesLogger;
    private static final ConcurrentLinkedQueue<LogEvent> state;
    private static AtomicBoolean isRecordingInProgress;
    private static final Object lock;
    public static final FusStatesRecorder INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final List<LogEvent> recordStateAndWait(@NotNull Project project, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        Object object = lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            state.clear();
            isRecordingInProgress.getAndSet(true);
            Function1 subscriber2 = recordStateAndWait.1.subscriber.1.INSTANCE;
            String recorderId = "FUS";
            EventLogNotificationService.INSTANCE.subscribe(subscriber2, recorderId);
            try {
                CompletableFuture completableFuture = statesLogger.logApplicationStates();
                Intrinsics.checkExpressionValueIsNotNull((Object)completableFuture, (String)"statesLogger.logApplicationStates()");
                CompletableFuture logApplicationStatesFuture = completableFuture;
                CompletableFuture completableFuture2 = statesLogger.logProjectStates(project, indicator);
                Intrinsics.checkExpressionValueIsNotNull((Object)completableFuture2, (String)"statesLogger.logProjectStates(project, indicator)");
                CompletableFuture logProjectStatesFuture = completableFuture2;
                ((CompletableFuture)CompletableFuture.allOf(logApplicationStatesFuture, logProjectStatesFuture).thenCompose((Function)recordStateAndWait.1.1.INSTANCE)).get(10L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                List<LogEvent> list;
                try {
                    log.warn("Failed recording state collectors to log", (Throwable)e);
                    list = null;
                }
                catch (Throwable throwable) {
                    EventLogNotificationService.INSTANCE.unsubscribe(subscriber2, recorderId);
                    isRecordingInProgress.getAndSet(false);
                    throw throwable;
                }
                EventLogNotificationService.INSTANCE.unsubscribe(subscriber2, recorderId);
                isRecordingInProgress.getAndSet(false);
                return list;
            }
            EventLogNotificationService.INSTANCE.unsubscribe(subscriber2, recorderId);
            isRecordingInProgress.getAndSet(false);
            return CollectionsKt.toList((Iterable)state);
        }
    }

    private final void recordEvent(LogEvent logEvent) {
        if (logEvent.getEvent().getState()) {
            state.add(logEvent);
        }
    }

    @NotNull
    public final List<LogEvent> getCurrentState() {
        return CollectionsKt.toList((Iterable)state);
    }

    public final boolean isRecordingInProgress() {
        return isRecordingInProgress.get();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isComparisonAvailable() {
        if (isRecordingInProgress.get()) return false;
        Collection collection = state;
        boolean bl = false;
        if (collection.isEmpty()) return false;
        return true;
    }

    private FusStatesRecorder() {
    }

    static {
        FusStatesRecorder fusStatesRecorder;
        INSTANCE = fusStatesRecorder = new FusStatesRecorder();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FusStatesRecorder.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        log = logger;
        statesLogger = new FUStateUsagesLogger();
        state = new ConcurrentLinkedQueue();
        isRecordingInProgress = new AtomicBoolean(false);
        lock = new Object();
    }

    public static final /* synthetic */ void access$recordEvent(FusStatesRecorder $this, LogEvent logEvent) {
        $this.recordEvent(logEvent);
    }
}

