/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.newProject.steps;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ExtensionsKt;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.TextAccessor;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.Result;
import com.jetbrains.python.newProject.steps.PyRemotePathField;
import com.jetbrains.python.newProject.steps.PythonSdkChooserCombo;
import com.jetbrains.python.remote.PyProjectSynchronizer;
import com.jetbrains.python.remote.PyProjectSynchronizerProvider;
import com.jetbrains.python.remote.PythonSshInterpreterManager;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.add.PyAddSdkPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 )2\u00020\u0001:\u0001)B;\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020 H\u0002J\b\u0010$\u001a\u00020 H\u0002J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u0007H\u0016J\n\u0010'\u001a\u0004\u0018\u00010&H\u0002J\n\u0010(\u001a\u0004\u0018\u00010&H\u0002R\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\n@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/jetbrains/python/newProject/steps/PyAddExistingSdkPanel;", "Lcom/jetbrains/python/sdk/add/PyAddSdkPanel;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "existingSdks", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "newProjectPath", "", "preferredSdk", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/module/Module;Ljava/util/List;Ljava/lang/String;Lcom/intellij/openapi/projectRoots/Sdk;)V", "defaultMappings", "Lcom/intellij/util/PathMappingSettings$PathMapping;", "value", "getNewProjectPath", "()Ljava/lang/String;", "setNewProjectPath", "(Ljava/lang/String;)V", "panelName", "getPanelName", "remotePath", "getRemotePath", "remotePathField", "Lcom/jetbrains/python/newProject/steps/PyRemotePathField;", "sdk", "getSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "sdkChooserCombo", "Lcom/jetbrains/python/newProject/steps/PythonSdkChooserCombo;", "addChangeListener", "", "listener", "Ljava/lang/Runnable;", "update", "updateRemotePathIfNeeded", "validateAll", "Lcom/intellij/openapi/ui/ValidationInfo;", "validateRemotePathField", "validateSdkChooserField", "Companion", "intellij.python.community.impl"})
public final class PyAddExistingSdkPanel
extends PyAddSdkPanel {
    private List<? extends PathMappingSettings.PathMapping> defaultMappings;
    @Nullable
    private String newProjectPath;
    private final PythonSdkChooserCombo sdkChooserCombo;
    private final PyRemotePathField remotePathField;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String getPanelName() {
        String string = PyBundle.message("python.add.sdk.panel.name.existing.interpreter", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PyBundle.message(\"python\u2026me.existing.interpreter\")");
        return string;
    }

    @Override
    @Nullable
    public Sdk getSdk() {
        JComboBox jComboBox = this.sdkChooserCombo.getComboBox();
        Intrinsics.checkExpressionValueIsNotNull((Object)jComboBox, (String)"sdkChooserCombo.comboBox");
        Object object = jComboBox.getSelectedItem();
        if (!(object instanceof Sdk)) {
            object = null;
        }
        return (Sdk)object;
    }

    @Nullable
    public final String getRemotePath() {
        String string;
        JPanel jPanel = this.remotePathField.getMainPanel();
        Intrinsics.checkExpressionValueIsNotNull((Object)jPanel, (String)"remotePathField.mainPanel");
        if (jPanel.isVisible()) {
            TextAccessor textAccessor = this.remotePathField.getTextField();
            Intrinsics.checkExpressionValueIsNotNull((Object)textAccessor, (String)"remotePathField.textField");
            string = textAccessor.getText();
        } else {
            string = null;
        }
        return string;
    }

    @Override
    @Nullable
    public String getNewProjectPath() {
        return this.newProjectPath;
    }

    @Override
    public void setNewProjectPath(@Nullable String value) {
        this.newProjectPath = value;
        this.sdkChooserCombo.setNewProjectPath(value);
        this.updateRemotePathIfNeeded();
    }

    @Override
    @NotNull
    public List<ValidationInfo> validateAll() {
        return CollectionsKt.filterNotNull((Iterable)CollectionsKt.listOf((Object[])new ValidationInfo[]{this.validateSdkChooserField(), this.validateRemotePathField()}));
    }

    @Override
    public void addChangeListener(@NotNull Runnable listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        this.sdkChooserCombo.addChangedListener(new ActionListener(listener2){
            final /* synthetic */ Runnable $listener;

            public final void actionPerformed(ActionEvent it) {
                this.$listener.run();
            }
            {
                this.$listener = runnable;
            }
        });
        this.remotePathField.addTextChangeListener(new Runnable(listener2){
            final /* synthetic */ Runnable $listener;

            public final void run() {
                this.$listener.run();
            }
            {
                this.$listener = runnable;
            }
        });
    }

    private final ValidationInfo validateSdkChooserField() {
        String string;
        Sdk selectedSdk = this.getSdk();
        if (selectedSdk == null) {
            string = PyBundle.message("python.sdk.no.interpreter.selection", new Object[0]);
        } else if (PythonSdkUtil.isInvalid(selectedSdk)) {
            string = PyBundle.message("python.sdk.choose.valid.interpreter", new Object[0]);
        } else {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"when {\n      selectedSdk\u2026else -> return null\n    }");
        String message = string;
        return new ValidationInfo(message, (JComponent)((Object)this.sdkChooserCombo));
    }

    private final ValidationInfo validateRemotePathField() {
        String path = this.getRemotePath();
        return path != null && StringsKt.isBlank((CharSequence)path) ? new ValidationInfo(PyBundle.message("python.new.project.remote.path.not.provided", new Object[0])) : null;
    }

    private final void update() {
        Sdk sdk = this.getSdk();
        PyProjectSynchronizer synchronizer = sdk != null ? PyAddExistingSdkPanel.Companion.getProjectSynchronizer(sdk) : null;
        JPanel jPanel = this.remotePathField.getMainPanel();
        Intrinsics.checkExpressionValueIsNotNull((Object)jPanel, (String)"remotePathField.mainPanel");
        jPanel.setVisible(synchronizer != null);
        if (synchronizer != null) {
            boolean bl;
            boolean bl2;
            String defaultRemotePath = synchronizer.getDefaultRemotePath();
            Result<List<PathMappingSettings.PathMapping>, String> result = synchronizer.getAutoMappings();
            if (result != null) {
                Result<List<PathMappingSettings.PathMapping>, String> result2 = result;
                bl2 = false;
                boolean bl3 = false;
                Result<List<PathMappingSettings.PathMapping>, String> it = result2;
                boolean bl4 = false;
                Result<List<PathMappingSettings.PathMapping>, String> result3 = it;
                if (result3 instanceof Result.Success) {
                    this.defaultMappings = (List)((Result.Success)it).getResult();
                } else if (result3 instanceof Result.Failure) {
                    TextAccessor textAccessor = this.remotePathField.getTextField();
                    Intrinsics.checkExpressionValueIsNotNull((Object)textAccessor, (String)"remotePathField.textField");
                    textAccessor.setText((String)((Result.Failure)it).getError());
                    this.remotePathField.setReadOnly(true);
                    return;
                }
            }
            boolean bl5 = defaultRemotePath == null || this.defaultMappings == null;
            bl2 = false;
            if (_Assertions.ENABLED && !bl5) {
                boolean $i$a$-assert-PyAddExistingSdkPanel$update$42 = false;
                String $i$a$-assert-PyAddExistingSdkPanel$update$42 = "Can't have both: default mappings and default value";
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-PyAddExistingSdkPanel$update$42));
            }
            String string = defaultRemotePath;
            if (string != null) {
                CharSequence charSequence = string;
                bl2 = false;
                bl = charSequence.length() == 0;
            } else {
                bl = false;
            }
            boolean bl6 = !bl;
            bl2 = false;
            if (_Assertions.ENABLED && !bl6) {
                boolean bl7 = false;
                String string2 = "Mappings are empty";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            TextAccessor textAccessor = this.remotePathField.getTextField();
            Intrinsics.checkExpressionValueIsNotNull((Object)textAccessor, (String)"remotePathField.textField");
            TextAccessor textField = textAccessor;
            if (defaultRemotePath != null && StringUtil.isEmpty((String)textField.getText())) {
                textField.setText(defaultRemotePath);
            }
        }
        this.remotePathField.setReadOnly(this.defaultMappings != null);
        this.updateRemotePathIfNeeded();
    }

    private final void updateRemotePathIfNeeded() {
        Object object;
        Object var12_12;
        TextAccessor textAccessor;
        String path;
        block4: {
            Object v3;
            String string = this.getNewProjectPath();
            if (string == null) {
                return;
            }
            path = string;
            List<? extends PathMappingSettings.PathMapping> list = this.defaultMappings;
            if (list == null) {
                return;
            }
            List<? extends PathMappingSettings.PathMapping> mappings = list;
            TextAccessor textAccessor2 = this.remotePathField.getTextField();
            Intrinsics.checkExpressionValueIsNotNull((Object)textAccessor2, (String)"remotePathField.textField");
            Iterable iterable = mappings;
            textAccessor = textAccessor2;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                PathMappingSettings.PathMapping it = (PathMappingSettings.PathMapping)t;
                boolean bl3 = false;
                if (!it.canReplaceLocal(path)) continue;
                v3 = t;
                break block4;
            }
            v3 = var12_12 = null;
        }
        if ((object = (PathMappingSettings.PathMapping)var12_12) == null || (object = object.mapToRemote(path)) == null) {
            object = "?";
        }
        textAccessor.setText((String)object);
    }

    /*
     * WARNING - void declaration
     */
    public PyAddExistingSdkPanel(@Nullable Project project, @Nullable Module module, @NotNull List<? extends Sdk> existingSdks, @Nullable String newProjectPath, final @Nullable Sdk preferredSdk) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        this.newProjectPath = newProjectPath;
        PyRemotePathField pyRemotePathField = new PyRemotePathField();
        PyAddExistingSdkPanel pyAddExistingSdkPanel = this;
        boolean bl = false;
        boolean bl2 = false;
        Object $this$apply = pyRemotePathField;
        boolean bl3 = false;
        ((PyRemotePathField)$this$apply).addActionListener(new ActionListener((PyRemotePathField)$this$apply, this){
            final /* synthetic */ PyRemotePathField $this_apply;
            final /* synthetic */ PyAddExistingSdkPanel this$0;
            {
                this.$this_apply = pyRemotePathField;
                this.this$0 = pyAddExistingSdkPanel;
            }

            public final void actionPerformed(ActionEvent it) {
                Sdk sdk = this.this$0.getSdk();
                if (sdk == null) {
                    return;
                }
                Sdk currentSdk = sdk;
                if (!PythonSdkUtil.isRemote(currentSdk)) {
                    return;
                }
                TextAccessor textAccessor = this.$this_apply.getTextField();
                Intrinsics.checkExpressionValueIsNotNull((Object)textAccessor, (String)"textField");
                Container container = this.this$0.getParent();
                Intrinsics.checkExpressionValueIsNotNull((Object)container, (String)"parent");
                String string = com.jetbrains.python.newProject.steps.PyAddExistingSdkPanel$Companion.access$chooseRemotePath(PyAddExistingSdkPanel.Companion, currentSdk, container);
                if (string == null) {
                    return;
                }
                textAccessor.setText(string);
            }
        });
        Object object = pyRemotePathField;
        pyAddExistingSdkPanel.remotePathField = object;
        this.setLayout(new BorderLayout());
        Object $this$filter$iv = existingSdks;
        boolean $i$f$filter = false;
        $this$apply = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Sdk it = (Sdk)element$iv$iv;
            boolean bl4 = false;
            if (!(PySdkExtKt.getAssociatedModulePath(it) == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List sdksForNewProject = (List)destination$iv$iv;
        $this$filter$iv = new PythonSdkChooserCombo(project, module, sdksForNewProject, newProjectPath, (Condition<? super Sdk>)((Condition)new Condition<Sdk>(){

            public final boolean value(Sdk it) {
                return it != null && Intrinsics.areEqual((Object)it, (Object)preferredSdk);
            }
        }));
        pyAddExistingSdkPanel = this;
        bl2 = false;
        boolean bl5 = false;
        Object $this$apply2 = $this$filter$iv;
        boolean bl6 = false;
        if (SystemInfo.isMac && !UIUtil.isUnderDarcula()) {
            $this$apply2.putClientProperty((Object)"JButton.buttonType", null);
        }
        ((PythonSdkChooserCombo)((Object)$this$apply2)).addChangedListener(new ActionListener(this){
            final /* synthetic */ PyAddExistingSdkPanel this$0;
            {
                this.this$0 = pyAddExistingSdkPanel;
            }

            public final void actionPerformed(ActionEvent it) {
                PyAddExistingSdkPanel.access$update(this.this$0);
            }
        });
        object = $this$filter$iv;
        pyAddExistingSdkPanel.sdkChooserCombo = object;
        FormBuilder formBuilder = FormBuilder.createFormBuilder().addLabeledComponent(PyBundle.message("interpreter", new Object[0]), (JComponent)((Object)this.sdkChooserCombo)).addComponent((JComponent)this.remotePathField.getMainPanel());
        Intrinsics.checkExpressionValueIsNotNull((Object)formBuilder, (String)"FormBuilder.createFormBu\u2026emotePathField.mainPanel)");
        JPanel formPanel = formBuilder.getPanel();
        this.add((Component)formPanel, "North");
        this.update();
    }

    public static final /* synthetic */ void access$update(PyAddExistingSdkPanel $this) {
        $this.update();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/jetbrains/python/newProject/steps/PyAddExistingSdkPanel$Companion;", "", "()V", "projectSynchronizer", "Lcom/jetbrains/python/remote/PyProjectSynchronizer;", "Lcom/intellij/openapi/projectRoots/Sdk;", "getProjectSynchronizer", "(Lcom/intellij/openapi/projectRoots/Sdk;)Lcom/jetbrains/python/remote/PyProjectSynchronizer;", "chooseRemotePath", "", "owner", "Ljava/awt/Component;", "intellij.python.community.impl"})
    public static final class Companion {
        private final PyProjectSynchronizer getProjectSynchronizer(@NotNull Sdk $this$projectSynchronizer) {
            return PyProjectSynchronizerProvider.Companion.getSynchronizer($this$projectSynchronizer);
        }

        /*
         * WARNING - void declaration
         */
        private final String chooseRemotePath(@NotNull Sdk $this$chooseRemotePath, Component owner) {
            void supplier;
            JPanel panel2;
            Pair<Supplier<String>, JPanel> pair;
            PythonSshInterpreterManager pythonSshInterpreterManager = PythonSshInterpreterManager.Factory.getInstance();
            if (pythonSshInterpreterManager == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)pythonSshInterpreterManager, (String)"PythonSshInterpreterMana\u2026Instance() ?: return null");
            PythonSshInterpreterManager remoteManager = pythonSshInterpreterManager;
            try {
                Pair<Supplier<String>, JPanel> pair2 = remoteManager.createServerBrowserForm($this$chooseRemotePath);
                if (pair2 == null) {
                    return null;
                }
                pair = pair2;
            }
            catch (Exception e) {
                Exception exception = e;
                if (exception instanceof ExecutionException || exception instanceof InterruptedException) {
                    Logger.getInstance(PyAddExistingSdkPanel.class).warn("Failed to create server browse button", (Throwable)e);
                    JBPopupFactory.getInstance().createMessage(PyBundle.message("remote.interpreter.remote.server.permissions", new Object[0])).show(owner);
                    return null;
                }
                throw (Throwable)e;
            }
            Pair<Supplier<String>, JPanel> pair3 = pair;
            Supplier supplier2 = (Supplier)ExtensionsKt.component1(pair3);
            JPanel jPanel = panel2 = (JPanel)ExtensionsKt.component2(pair3);
            Intrinsics.checkExpressionValueIsNotNull((Object)jPanel, (String)"panel");
            jPanel.setVisible(true);
            DialogWrapper wrapper2 = new DialogWrapper(panel2, true){
                final /* synthetic */ JPanel $panel;

                protected JPanel createCenterPanel() {
                    return this.$panel;
                }
                {
                    this.$panel = $captured_local_variable$0;
                    super($super_call_param$1);
                    this.init();
                }
            };
            return wrapper2.showAndGet() ? (String)supplier.get() : null;
        }

        private Companion() {
        }

        public static final /* synthetic */ String access$chooseRemotePath(Companion $this, Sdk $this$access_u24chooseRemotePath, Component owner) {
            return $this.chooseRemotePath($this$access_u24chooseRemotePath, owner);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

