/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;

public enum HiddenApiRestriction {
    WHITELIST(0, "whitelist", false),
    GREYLIST(1, "greylist", false),
    BLACKLIST(2, "blacklist", false),
    GREYLIST_MAX_O(3, "greylist-max-o", false),
    GREYLIST_MAX_P(4, "greylist-max-p", false),
    GREYLIST_MAX_Q(5, "greylist-max-q", false),
    CORE_PLATFORM_API(8, "core-platform-api", true);

    private static final HiddenApiRestriction[] hiddenApiFlags;
    private static final HiddenApiRestriction[] domainSpecificApiFlags;
    private static final Map<String, HiddenApiRestriction> hiddenApiRestrictionsByName;
    private static final int HIDDENAPI_FLAG_MASK = 7;
    private final int value;
    private final String name;
    private final boolean isDomainSpecificApiFlag;

    private HiddenApiRestriction(int value, String name, boolean isDomainSpecificApiFlag) {
        this.value = value;
        this.name = name;
        this.isDomainSpecificApiFlag = isDomainSpecificApiFlag;
    }

    public String toString() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isSet(int value) {
        if (this.isDomainSpecificApiFlag) {
            return (value & 0xFFFFFFF8) == this.value;
        }
        return (value & 7) == this.value;
    }

    public boolean isDomainSpecificApiFlag() {
        return this.isDomainSpecificApiFlag;
    }

    public static Set<HiddenApiRestriction> getAllFlags(int value) {
        HiddenApiRestriction normalRestriction = hiddenApiFlags[value & 7];
        int domainSpecificPart = value & 0xFFFFFFF8;
        if (domainSpecificPart == 0) {
            return ImmutableSet.of(normalRestriction);
        }
        return ImmutableSet.of(normalRestriction, domainSpecificApiFlags[(domainSpecificPart >> 3) - 1]);
    }

    public static String formatHiddenRestrictions(int value) {
        StringJoiner joiner = new StringJoiner("|");
        for (HiddenApiRestriction hiddenApiRestriction : HiddenApiRestriction.getAllFlags(value)) {
            joiner.add(hiddenApiRestriction.toString());
        }
        return joiner.toString();
    }

    public static int combineFlags(Iterable<HiddenApiRestriction> flags) {
        boolean gotHiddenApiFlag = false;
        boolean gotDomainSpecificApiFlag = false;
        int value = 0;
        for (HiddenApiRestriction flag : flags) {
            if (flag.isDomainSpecificApiFlag) {
                if (gotDomainSpecificApiFlag) {
                    throw new IllegalArgumentException("Cannot combine multiple flags for domain-specific api restrictions");
                }
                gotDomainSpecificApiFlag = true;
                value += flag.value;
                continue;
            }
            if (gotHiddenApiFlag) {
                throw new IllegalArgumentException("Cannot combine multiple flags for hidden api restrictions");
            }
            gotHiddenApiFlag = true;
            value += flag.value;
        }
        return value;
    }

    public static HiddenApiRestriction forName(String name) {
        return hiddenApiRestrictionsByName.get(name);
    }

    static {
        hiddenApiFlags = new HiddenApiRestriction[]{WHITELIST, GREYLIST, BLACKLIST, GREYLIST_MAX_O, GREYLIST_MAX_P, GREYLIST_MAX_Q};
        domainSpecificApiFlags = new HiddenApiRestriction[]{CORE_PLATFORM_API};
        hiddenApiRestrictionsByName = new HashMap<String, HiddenApiRestriction>();
        for (HiddenApiRestriction hiddenApiRestriction : HiddenApiRestriction.values()) {
            hiddenApiRestrictionsByName.put(hiddenApiRestriction.toString(), hiddenApiRestriction);
        }
    }
}

