/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_bn extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_NR = "\u09a8\u09be\u0989\u09b0\u09c1";
        final String metaValue_TK = "\u099f\u09cb\u0995\u09c7\u09b2\u09be\u0989";
        final String metaValue_TV = "\u099f\u09c1\u09ad\u09be\u09b2\u09c1";
        final String metaValue_bn = "\u09ac\u09be\u0982\u09b2\u09be";
        final String metaValue_bo = "\u09a4\u09bf\u09ac\u09cd\u09ac\u09a4\u09bf";
        final String metaValue_el = "\u0997\u09cd\u09b0\u09bf\u0995";
        final String metaValue_gu = "\u0997\u09c1\u099c\u09b0\u09be\u099f\u09bf";
        final String metaValue_he = "\u09b9\u09bf\u09ac\u09cd\u09b0\u09c1";
        final String metaValue_jv = "\u099c\u09be\u09ad\u09be\u09a8\u09bf\u099c";
        final String metaValue_ka = "\u099c\u09b0\u09cd\u099c\u09bf\u09af\u09bc\u09be\u09a8";
        final String metaValue_ko = "\u0995\u09cb\u09b0\u09bf\u09af\u09bc\u09be\u09a8";
        final String metaValue_lo = "\u09b2\u09be\u0993";
        final String metaValue_ml = "\u09ae\u09be\u09b2\u09be\u09af\u09bc\u09be\u09b2\u09be\u09ae";
        final String metaValue_or = "\u0993\u09a1\u09bc\u09bf\u09af\u09bc\u09be";
        final String metaValue_ta = "\u09a4\u09be\u09ae\u09bf\u09b2";
        final String metaValue_th = "\u09a5\u09be\u0987";
        final String metaValue_ccp = "\u099a\u09be\u0995\u09ae\u09be";
        final String metaValue_peo = "\u09aa\u09cd\u09b0\u09be\u099a\u09c0\u09a8 \u09ab\u09be\u09b0\u09cd\u09b8\u09bf";
        final String metaValue_syr = "\u09b8\u09bf\u09b0\u09bf\u09af\u09bc\u09be\u0995";
        final String metaValue_uga = "\u0989\u0997\u09be\u09b0\u09bf\u099f\u09bf\u0995";
        final String metaValue_vai = "\u09ad\u09be\u0987";
        final Object[][] data = new Object[][] {
            { "ksh", "\u0995\u09b2\u09cb\u09a8\u09bf\u09af\u09bc\u09be\u09a8" },
            { "Ogam", "\u0993\u0998\u09be\u09ae" },
            { "mwl", "\u09ae\u09bf\u09b0\u09be\u09a8\u09cd\u09a1\u09bf\u099c" },
            { "Zsym", "\u09aa\u09cd\u09b0\u09a4\u09c0\u0995\u0997\u09c1\u09b2\u09bf" },
            { "cch", "\u0986\u09a4\u09cd\u09b8\u09be\u09ae" },
            { "mwr", "\u09ae\u09be\u09b0\u09cb\u09af\u09bc\u09be\u09b0\u09bf" },
            { "type.nu.lanatham", "\u099f\u09be\u0987 \u09a5\u09be\u09ae \u09a5\u09be\u09ae \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "Tagb", "\u099f\u09be\u0997\u09cb\u0993\u09af\u09bc\u09be\u09a8\u09be" },
            { "Zsye", "\u0987\u09ae\u09cb\u099c\u09bf" },
            { "ccp", metaValue_ccp },
            { "egy", "\u09aa\u09cd\u09b0\u09be\u099a\u09c0\u09a8 \u09ae\u09bf\u09b6\u09b0\u09c0\u09af\u09bc" },
            { "raj", "\u09b0\u09be\u099c\u09b8\u09cd\u09a5\u09be\u09a8\u09c0" },
            { "Phag", "\u09ab\u09be\u0997\u09cd\u09b8-\u09aa\u09be" },
            { "tem", "\u099f\u09be\u0987\u09ae\u09cd\u09a8\u09c7" },
            { "type.nu.sind", "\u0995\u09c1\u09a6\u09af\u09bc\u09be\u09a6\u09bf \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "teo", "\u09a4\u09c7\u09b8\u09cb" },
            { "rap", "\u09b0\u09be\u09aa\u09be\u09a8\u09c1\u0987" },
            { "ter", "\u09a4\u09c7\u09b0\u09c7\u09a8\u09cb" },
            { "AC", "\u0985\u09cd\u09af\u09be\u09b8\u09b8\u09c7\u09a8\u09b6\u09a8 \u0986\u0987\u09b2\u09cd\u09af\u09be\u09a8\u09cd\u09a1" },
            { "rar", "\u09b0\u09be\u09b0\u09cb\u099f\u09cb\u0982\u0997\u09be\u09a8" },
            { "tet", "\u09a4\u09c7\u09a4\u09c1\u09ae" },
            { "type.nu.sinh", "\u09b8\u09bf\u0982\u09b9\u09b2\u09c0 \u09b2\u09bf\u09a5 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "AD", "\u0986\u09a8\u09cd\u09a1\u09cb\u09b0\u09be" },
            { "AE", "\u09b8\u0982\u09af\u09c1\u0995\u09cd\u09a4 \u0986\u09b0\u09ac \u0986\u09ae\u09bf\u09b0\u09be\u09a4" },
            { "nl_BE", "\u09ab\u09cd\u09b2\u09c7\u09ae\u09bf\u09b6" },
            { "AF", "\u0986\u09ab\u0997\u09be\u09a8\u09bf\u09b8\u09cd\u09a4\u09be\u09a8" },
            { "AG", "\u0985\u09cd\u09af\u09be\u09a8\u09cd\u099f\u09bf\u0997\u09c1\u09af\u09bc\u09be \u0993 \u09ac\u09be\u09b0\u09ac\u09c1\u09a1\u09be" },
            { "type.nu.mroo", "\u09ae\u09cd\u09b0\u09cb \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.ca.ethiopic", "\u0987\u09a5\u09bf\u0993\u09aa\u09bf\u0995 \u0995\u09cd\u09af\u09be\u09b2\u09c7\u09a8\u09cd\u09a1\u09be\u09b0" },
            { "AI", "\u098f\u09cd\u09af\u09be\u0999\u09cd\u0997\u09c1\u0987\u09b2\u09be" },
            { "key.tz", "\u09b8\u09ae\u09af\u09bc \u099c\u09cb\u09a8" },
            { "AL", "\u0986\u09b2\u09ac\u09c7\u09a8\u09bf\u09af\u09bc\u09be" },
            { "AM", "\u0986\u09b0\u09cd\u09ae\u09c7\u09a8\u09bf\u09af\u09bc\u09be" },
            { "Teng", "\u09a4\u09c7\u0999\u09cd\u0997\u09cb\u09af\u09bc\u09be\u09b0" },
            { "AO", "\u0985\u09cd\u09af\u09be\u0999\u09cd\u0997\u09cb\u09b2\u09be" },
            { "AQ", "\u0985\u09cd\u09af\u09be\u09a8\u09cd\u099f\u09be\u09b0\u09cd\u0995\u099f\u09bf\u0995\u09be" },
            { "AR", "\u0986\u09b0\u09cd\u099c\u09c7\u09a8\u09cd\u099f\u09bf\u09a8\u09be" },
            { "Prti", "\u09aa\u09be\u09b0\u09cd\u09a5\u09bf\u09af\u09bc\u09a8" },
            { "AS", "\u0986\u09ae\u09c7\u09b0\u09bf\u0995\u09be\u09a8 \u09b8\u09be\u09ae\u09cb\u09af\u09bc\u09be" },
            { "AT", "\u0985\u09b8\u09cd\u099f\u09cd\u09b0\u09bf\u09af\u09bc\u09be" },
            { "AU", "\u0985\u09b8\u09cd\u099f\u09cd\u09b0\u09c7\u09b2\u09bf\u09af\u09bc\u09be" },
            { "AW", "\u0986\u09b0\u09c1\u09ac\u09be" },
            { "en_US", "\u0986\u09ae\u09c7\u09b0\u09bf\u0995\u09be\u09b0 \u0987\u0982\u09b0\u09c7\u099c\u09bf" },
            { "AX", "\u0986\u09b2\u09be\u09a8\u09cd\u09a1 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "AZ", "\u0986\u099c\u09be\u09b0\u09ac\u09be\u0987\u099c\u09be\u09a8" },
            { "BA", "\u09ac\u09b8\u09a8\u09bf\u09af\u09bc\u09be \u0993 \u09b9\u09be\u09b0\u09cd\u099c\u09c7\u0997\u09cb\u09ad\u09bf\u09a8\u09be" },
            { "BB", "\u09ac\u09be\u09b0\u09ac\u09be\u09a6\u09cb\u09b8" },
            { "ceb", "\u099a\u09c7\u09ac\u09c1\u09af\u09bc\u09be\u09a8\u09cb" },
            { "BD", "\u09ac\u09be\u0982\u09b2\u09be\u09a6\u09c7\u09b6" },
            { "kum", "\u0995\u09c1\u09ae\u09bf\u0995" },
            { "BE", "\u09ac\u09c7\u09b2\u099c\u09bf\u09af\u09bc\u09be\u09ae" },
            { "gmh", "\u09ae\u09a7\u09cd\u09af-\u0989\u099a\u09cd\u099a \u099c\u09be\u09b0\u09cd\u09ae\u09be\u09a8\u09bf" },
            { "BF", "\u09ac\u09c1\u09b0\u0995\u09bf\u09a8\u09be \u09ab\u09be\u09b8\u09cb" },
            { "BG", "\u09ac\u09c1\u09b2\u0997\u09c7\u09b0\u09bf\u09af\u09bc\u09be" },
            { "BH", "\u09ac\u09be\u09b9\u09b0\u09be\u0987\u09a8" },
            { "BI", "\u09ac\u09c1\u09b0\u09c1\u09a8\u09cd\u09a1\u09bf" },
            { "BJ", "\u09ac\u09c7\u09a8\u09bf\u09a8" },
            { "BL", "\u09b8\u09c7\u09a8\u09cd\u099f \u09ac\u09be\u09b0\u09a5\u09c7\u09b2\u09bf\u09ae\u09bf" },
            { "BM", "\u09ac\u09be\u09b0\u09ae\u09c1\u09a1\u09be" },
            { "kut", "\u0995\u09c1\u099f\u09c7\u09a8\u09be\u0987" },
            { "myv", "\u098f\u09b0\u099c\u09bf\u09af\u09bc\u09be" },
            { "BN", "\u09ac\u09cd\u09b0\u09c1\u09a8\u09c7\u0987" },
            { "BO", "\u09ac\u09b2\u09bf\u09ad\u09bf\u09af\u09bc\u09be" },
            { "BQ", "\u0995\u09cd\u09af\u09be\u09b0\u09bf\u09ac\u09bf\u09af\u09bc\u09be\u09a8 \u09a8\u09c7\u09a6\u09be\u09b0\u09b2\u09cd\u09af\u09be\u09a8\u09cd\u09a1\u09b8" },
            { "BR", "\u09ac\u09cd\u09b0\u09be\u099c\u09bf\u09b2" },
            { "BS", "\u09ac\u09be\u09b9\u09be\u09ae\u09be \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "xog", "\u09b8\u09cb\u0997\u09be" },
            { "BT", "\u09ad\u09c1\u099f\u09be\u09a8" },
            { "BV", "\u09ac\u09cb\u09ad\u09c7\u099f \u09a6\u09cd\u09ac\u09c0\u09aa" },
            { "BW", "\u09ac\u09a4\u09b8\u09cb\u09af\u09bc\u09be\u09a8\u09be" },
            { "BY", "\u09ac\u09c7\u09b2\u09be\u09b0\u09c1\u09b6" },
            { "BZ", "\u09ac\u09c7\u09b2\u09bf\u099c" },
            { "Visp", "\u09a6\u09c3\u09b6\u09cd\u09af\u09ae\u09be\u09a8 \u09ad\u09be\u09b7\u09be" },
            { "type.ca.persian", "\u09ab\u09be\u09b0\u09b8\u09bf \u0995\u09cd\u09af\u09be\u09b2\u09c7\u09a8\u09cd\u09a1\u09be\u09b0" },
            { "type.nu.hebr", "\u09b9\u09bf\u09ac\u09cd\u09b0\u09c1 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "CA", "\u0995\u09be\u09a8\u09be\u09a1\u09be" },
            { "CC", "\u0995\u09cb\u0995\u09cb\u09b8 (\u0995\u09bf\u09b2\u09bf\u0982) \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "mzn", "\u09ae\u09be\u099c\u09be\u09a8\u09a6\u09c7\u09b0\u09be\u09a8\u09bf" },
            { "CD", "\u0995\u0999\u09cd\u0997\u09cb-\u0995\u09bf\u09a8\u09b6\u09be\u09b8\u09be" },
            { "CF", "\u09ae\u09a7\u09cd\u09af \u0986\u09ab\u09cd\u09b0\u09bf\u0995\u09be\u09b0 \u09aa\u09cd\u09b0\u099c\u09be\u09a4\u09a8\u09cd\u09a4\u09cd\u09b0" },
            { "CG", "\u0995\u0999\u09cd\u0997\u09cb - \u09ac\u09cd\u09b0\u09be\u099c\u09be\u09ad\u09bf\u09b2" },
            { "CH", "\u09b8\u09c1\u0987\u099c\u09be\u09b0\u09b2\u09cd\u09af\u09be\u09a8\u09cd\u09a1" },
            { "CI", "\u0995\u09cb\u09a4 \u09a6\u09bf\u09ad\u09cb\u09af\u09bc\u09be\u09b0" },
            { "CK", "\u0995\u09c1\u0995 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "CL", "\u099a\u09bf\u09b2\u09bf" },
            { "Kthi", "\u0995\u09be\u0987\u09a5\u09bf" },
            { "CM", "\u0995\u09cd\u09af\u09be\u09ae\u09c7\u09b0\u09c1\u09a8" },
            { "CN", "\u099a\u09c0\u09a8" },
            { "CO", "\u0995\u09b2\u09ae\u09cd\u09ac\u09bf\u09af\u09bc\u09be" },
            { "CP", "\u0995\u09cd\u09b2\u09bf\u09aa\u09be\u09b0\u099f\u09a8 \u0986\u0987\u09b2\u09cd\u09af\u09be\u09a8\u09cd\u09a1" },
            { "CR", "\u0995\u09cb\u09b8\u09cd\u099f\u09be\u09b0\u09bf\u0995\u09be" },
            { "CU", "\u0995\u09bf\u0989\u09ac\u09be" },
            { "CV", "\u0995\u09c7\u09aa\u09ad\u09be\u09b0\u09cd\u09a6\u09c7" },
            { "CW", "\u0995\u09c1\u09b0\u09be\u09b8\u09be\u0993" },
            { "CX", "\u0995\u09cd\u09b0\u09bf\u09b8\u09ae\u09be\u09b8 \u09a6\u09cd\u09ac\u09c0\u09aa" },
            { "CY", "\u09b8\u09be\u0987\u09aa\u09cd\u09b0\u09be\u09b8" },
            { "type.nu.bali", "\u09ac\u09be\u09b2\u09bf\u09a8\u09c0\u09af\u09bc \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "CZ", "\u099a\u09c7\u099a\u09bf\u09af\u09bc\u09be" },
            { "eka", "\u0987\u0995\u09be\u099c\u09c1\u0995" },
            { "DE", "\u099c\u09be\u09b0\u09cd\u09ae\u09be\u09a8\u09bf" },
            { "goh", "\u09aa\u09cd\u09b0\u09be\u099a\u09c0\u09a8 \u0989\u099a\u09cd\u099a \u099c\u09be\u09b0\u09cd\u09ae\u09be\u09a8\u09bf" },
            { "ace", "\u0985\u09cd\u09af\u09be\u099a\u09be\u0987\u09a8\u09bf\u099c" },
            { "cgg", "\u099a\u09bf\u0997\u09be" },
            { "DG", "\u09a6\u09bf\u09af\u09bc\u09c7\u0997\u09cb \u0997\u09be\u09b0\u09cd\u09b8\u09bf\u09af\u09bc\u09be" },
            { "type.nu.deva", "\u09a6\u09c7\u09ac\u09a8\u09be\u0997\u09b0\u09bf \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "DJ", "\u099c\u09bf\u09ac\u09c1\u09a4\u09bf" },
            { "DK", "\u09a1\u09c7\u09a8\u09ae\u09be\u09b0\u09cd\u0995" },
            { "ach", "\u0986\u0995\u09cb\u09b2\u09bf" },
            { "gon", "\u0997\u09cb\u09a8\u09cd\u09a1\u09bf" },
            { "Brai", "\u09ac\u09cd\u09b0\u09c7\u0987\u09b2" },
            { "Brah", "\u09ac\u09cd\u09b0\u09be\u09b9\u09cd\u09ae\u09c0" },
            { "DM", "\u09a1\u09cb\u09ae\u09bf\u09a8\u09bf\u0995\u09be" },
            { "type.nu.armnlow", "\u0986\u09b0\u09cd\u09ae\u09c7\u09a8\u09c0\u09af\u09bc \u099b\u09cb\u099f\u09b9\u09be\u09a4\u09c7\u09b0 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "DO", "\u09a1\u09cb\u09ae\u09c7\u09a8\u09bf\u0995\u09be\u09a8 \u09aa\u09cd\u09b0\u099c\u09be\u09a4\u09a8\u09cd\u09a4\u09cd\u09b0" },
            { "gor", "\u0997\u09cb\u09b0\u09cb\u09a8\u09cd\u09a4\u09be\u09b2\u09cb" },
            { "got", "\u0997\u09a5\u09bf\u0995" },
            { "Mtei", "\u09ae\u09c7\u0987\u099f\u09c7\u0987 \u09ae\u09be\u09af\u09bc\u09c7\u0995" },
            { "zun", "\u099c\u09c1\u09a8\u09bf" },
            { "tig", "\u099f\u09be\u0987\u0997\u09cd\u09b0\u09c7" },
            { "DZ", "\u0986\u09b2\u099c\u09c7\u09b0\u09bf\u09af\u09bc\u09be" },
            { "pag", "\u09aa\u09be\u0999\u09cd\u0997\u09be\u09b8\u09bf\u09a8\u09be\u09a8" },
            { "type.d0.hwidth", "\u0985\u09b0\u09cd\u09a7\u09aa\u09cd\u09b0\u09b8\u09cd\u09a5 \u09aa\u09b0\u09cd\u09af\u09a8\u09cd\u09a4" },
            { "pal", "\u09aa\u09be\u09b9\u09cd\u09b2\u09be\u09ad\u09bf" },
            { "EA", "\u0995\u09c1\u0989\u099f\u09be \u098f\u09ac\u0982 \u09ae\u09c7\u09b2\u09bf\u09b2\u09be" },
            { "chb", "\u099a\u09bf\u09ac\u099a\u09be" },
            { "pam", "\u09aa\u09be\u09ae\u09cd\u09aa\u09be\u0999\u09cd\u0997\u09be" },
            { "EC", "\u0987\u0995\u09c1\u09af\u09bc\u09c7\u09a1\u09b0" },
            { "pap", "\u09aa\u09be\u09aa\u09bf\u09af\u09bc\u09be\u09ae\u09c7\u09a8\u09cd\u099f\u09cb" },
            { "ada", "\u0985\u09a6\u09be\u0997\u09cd\u09ae\u09c7" },
            { "EE", "\u098f\u09b8\u09cd\u09a4\u09cb\u09a8\u09bf\u09af\u09bc\u09be" },
            { "tiv", "\u099f\u09bf\u09ad" },
            { "EG", "\u09ae\u09bf\u09b6\u09b0" },
            { "EH", "\u09aa\u09b6\u09cd\u099a\u09bf\u09ae \u09b8\u09be\u09b9\u09be\u09b0\u09be" },
            { "chg", "\u099a\u09be\u0997\u09be\u09a4\u09be\u0987" },
            { "pau", "\u09aa\u09be\u09b2\u09be\u09af\u09bc\u09c1\u09af\u09bc\u09be\u09a8" },
            { "chk", "\u099a\u09c1\u0995\u09bf" },
            { "chn", "\u099a\u09bf\u09a8\u09c1\u0995 \u099c\u09be\u09b0\u09cd\u0997\u09a8" },
            { "chm", "\u09ae\u09be\u09b0\u09bf" },
            { "chp", "\u099a\u09bf\u09aa\u09c7\u0993\u09af\u09bc\u09be\u09a8" },
            { "cho", "\u099a\u0995\u099f\u09cb\u0993" },
            { "type.nu.mathbold", "\u0997\u09be\u09a3\u09bf\u09a4\u09bf\u0995 \u09ac\u09cb\u09b2\u09cd\u09a1 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "chr", "\u099a\u09c7\u09b0\u09cb\u0995\u09c0" },
            { "ER", "\u0987\u09b0\u09bf\u09a4\u09cd\u09b0\u09bf\u09af\u09bc\u09be" },
            { "ES", "\u09b8\u09cd\u09aa\u09c7\u09a8" },
            { "ET", "\u0987\u09a5\u09bf\u0993\u09aa\u09bf\u09af\u09bc\u09be" },
            { "EU", "\u0987\u0989\u09b0\u09cb\u09aa\u09c0\u09af\u09bc \u0987\u0989\u09a8\u09bf\u09af\u09bc\u09a8" },
            { "elx", "\u098f\u09b2\u09be\u09ae\u09be\u0987\u099f" },
            { "type.ca.gregorian", "\u0997\u09cd\u09b0\u09bf\u0997\u09cb\u09b0\u09bf\u09af\u09bc\u09be\u09a8 \u0995\u09cd\u09af\u09be\u09b2\u09c7\u09a8\u09cd\u09a1\u09be\u09b0" },
            { "EZ", "\u0987\u0989\u09b0\u09cb\u099c\u09cb\u09a8" },
            { "chy", "\u09b6\u09be\u0987\u09af\u09bc\u09c7\u09a8" },
            { "type.nu.gujr", "\u0997\u09c1\u099c\u09b0\u09be\u09a4\u09bf \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "Inds", "\u09b8\u09bf\u09a8\u09cd\u09a7\u09c1" },
            { "ady", "\u0986\u09a6\u09c7\u0997\u09c7" },
            { "FI", "\u09ab\u09bf\u09a8\u09b2\u09cd\u09af\u09be\u09a8\u09cd\u09a1" },
            { "FJ", "\u09ab\u09bf\u099c\u09bf" },
            { "FK", "\u09ab\u0995\u09b2\u09cd\u09af\u09be\u09a8\u09cd\u09a1 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "FM", "\u09ae\u09be\u0987\u0995\u09cd\u09b0\u09cb\u09a8\u09c7\u09b6\u09bf\u09af\u09bc\u09be" },
            { "key.va", "\u09b8\u09cd\u09a5\u09be\u09a8\u09c0\u09af\u09bc \u09ad\u09bf\u09a8\u09cd\u09a8\u09a4\u09be" },
            { "FO", "\u09ab\u09cd\u09af\u09be\u09b0\u0993 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "Taml", metaValue_ta },
            { "FR", "\u09ab\u09cd\u09b0\u09be\u09a8\u09cd\u09b8" },
            { "tkl", metaValue_TK },
            { "grb", "\u0997\u09cd\u09b0\u09c7\u09ac\u09cb" },
            { "root", "\u09ae\u09c2\u09b2" },
            { "type.ca.indian", "\u09ad\u09be\u09b0\u09a4\u09c0\u09af\u09bc \u099c\u09be\u09a4\u09c0\u09af\u09bc \u09ac\u09b0\u09cd\u09b7\u09aa\u099e\u09cd\u099c\u09c0" },
            { "grc", "\u09aa\u09cd\u09b0\u09be\u099a\u09c0\u09a8 \u0997\u09cd\u09b0\u09c0\u0995" },
            { "GA", "\u0997\u09cd\u09af\u09be\u09ac\u09a8" },
            { "vot", "\u09ad\u09cb\u099f\u09bf\u0995" },
            { "GB", "\u09af\u09c1\u0995\u09cd\u09a4\u09b0\u09be\u099c\u09cd\u09af" },
            { "pcm", "\u09a8\u09be\u0987\u099c\u09c7\u09b0\u09bf\u09af\u09bc \u09aa\u09bf\u099c\u09bf\u09a8" },
            { "GD", "\u0997\u09cd\u09b0\u09c7\u09a8\u09be\u09a1\u09be" },
            { "GE", "\u099c\u09b0\u09cd\u099c\u09bf\u09af\u09bc\u09be" },
            { "GF", "\u09ab\u09b0\u09be\u09b8\u09c0 \u0997\u09be\u09af\u09bc\u09be\u09a8\u09be" },
            { "GG", "\u0997\u09c1\u09af\u09bc\u09be\u09b0\u09cd\u09a8\u09b8\u09bf" },
            { "GH", "\u0998\u09be\u09a8\u09be" },
            { "Tale", "\u09a4\u09be\u0987\u09b2\u09c7" },
            { "GI", "\u099c\u09bf\u09ac\u09cd\u09b0\u09be\u09b2\u09cd\u099f\u09be\u09b0" },
            { "afh", "\u0986\u09ab\u09cd\u09b0\u09bf\u09b9\u09bf\u09b2\u09bf" },
            { "GL", "\u0997\u09cd\u09b0\u09c0\u09a8\u09b2\u09cd\u09af\u09be\u09a8\u09cd\u09a1" },
            { "enm", "\u09ae\u09a7\u09cd\u09af \u0987\u0982\u09b0\u09c7\u099c\u09bf" },
            { "GM", "\u0997\u09be\u09ae\u09cd\u09ac\u09bf\u09af\u09bc\u09be" },
            { "GN", "\u0997\u09bf\u09a8\u09bf" },
            { "GP", "\u0997\u09c1\u09af\u09bc\u09be\u09a6\u09c7\u09b2\u09cc\u09aa" },
            { "GQ", "\u09a8\u09bf\u09b0\u0995\u09cd\u09b7\u09c0\u09af\u09bc \u0997\u09bf\u09a8\u09bf" },
            { "GR", "\u0997\u09cd\u09b0\u09c0\u09b8" },
            { "GS", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u099c\u09b0\u09cd\u099c\u09bf\u09af\u09bc\u09be \u0993 \u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u09b8\u09cd\u09af\u09be\u09a8\u09cd\u09a1\u0989\u0987\u099a \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "GT", "\u0997\u09c1\u09af\u09bc\u09be\u09a4\u09c7\u09ae\u09be\u09b2\u09be" },
            { "GU", "\u0997\u09c1\u09af\u09bc\u09be\u09ae" },
            { "type.nu.mathmono", "\u0997\u09be\u09a3\u09bf\u09a4\u09bf\u0995 \u09ae\u09cb\u09a8\u09cb\u09b8\u09cd\u09aa\u09c7\u09b8 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "GW", "\u0997\u09bf\u09a8\u09bf-\u09ac\u09bf\u09b8\u09be\u0989" },
            { "tli", "\u09a4\u09cd\u09b2\u09bf\u0999\u09cd\u0997\u09bf\u099f" },
            { "tlh", "\u0995\u09cd\u09b2\u09bf\u0999\u09cd\u0997\u09a8" },
            { "Talu", "\u09a8\u09a4\u09c1\u09a8 \u09a4\u09be\u0987 \u09b2\u09c1" },
            { "GY", "\u0997\u09bf\u09af\u09bc\u09be\u09a8\u09be" },
            { "ckb", "\u09ae\u09a7\u09cd\u09af \u0995\u09c1\u09b0\u09cd\u09a6\u09bf\u09b6" },
            { "zxx", "\u09ad\u09be\u09b7\u09be\u09ad\u09bf\u09a4\u09cd\u09a4\u09bf\u0995 \u09ac\u09bf\u09b7\u09af\u09bc\u09ac\u09b8\u09cd\u09a4\u09c1 \u09a8\u09c7\u0987" },
            { "de_AT", "\u0985\u09b8\u09cd\u099f\u09cd\u09b0\u09bf\u09af\u09bc\u09be\u09a8 \u099c\u09be\u09b0\u09cd\u09ae\u09be\u09a8" },
            { "Vaii", metaValue_vai },
            { "HK", "\u09b9\u0982\u0995\u0982 \u098f\u09b8\u098f\u0986\u09b0 \u099a\u09c0\u09a8\u09be" },
            { "HM", "\u09b9\u09be\u09b0\u09cd\u09a1 \u098f\u09ac\u0982 \u09ae\u09cd\u09af\u09be\u0995\u09a1\u09cb\u09a8\u09be\u09b2\u09cd\u09a1 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "HN", "\u09b9\u09a8\u09cd\u09a1\u09c1\u09b0\u09be\u09b8" },
            { "HR", "\u0995\u09cd\u09b0\u09cb\u09af\u09bc\u09c7\u09b6\u09bf\u09af\u09bc\u09be" },
            { "agq", "\u098f\u0998\u09c7\u09ae" },
            { "gsw", "\u09b8\u09c1\u0987\u09b8 \u099c\u09be\u09b0\u09cd\u09ae\u09be\u09a8" },
            { "type.ca.islamic-umalqura", "\u0987\u09b8\u09b2\u09be\u09ae\u09bf\u0995 \u09ac\u09b0\u09cd\u09b7\u09aa\u099e\u09cd\u099c\u09c0 (\u0989\u09ae\u09cd\u09ae\u09be \u0986\u09b2-\u0995\u09c1\u09b0\u0986)" },
            { "HT", "\u09b9\u09be\u0987\u09a4\u09bf" },
            { "HU", "\u09b9\u09be\u0999\u09cd\u0997\u09c7\u09b0\u09bf" },
            { "tmh", "\u09a4\u09be\u09ae\u09be\u09b6\u09c7\u0995" },
            { "IC", "\u0995\u09cd\u09af\u09be\u09a8\u09be\u09b0\u09bf \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "peo", metaValue_peo },
            { "ID", "\u0987\u09a8\u09cd\u09a6\u09cb\u09a8\u09c7\u09b6\u09bf\u09af\u09bc\u09be" },
            { "type.nu.kali", "\u0995\u09be\u09af\u09bc\u09be\u09b9 \u09b2\u09bf \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "IE", "\u0986\u09af\u09bc\u09be\u09b0\u09b2\u09cd\u09af\u09be\u09a8\u09cd\u09a1" },
            { "nap", "\u09a8\u09c7\u09af\u09bc\u09be\u09aa\u09cb\u09b2\u09bf\u099f\u09be\u09a8" },
            { "naq", "\u09a8\u09be\u09ae\u09be" },
            { "type.nu.sora", "\u09b8\u09cb\u09b0\u09be \u09b8\u09ae\u09cd\u09aa\u09c7\u0982 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "zza", "\u099c\u09be\u099c\u09be" },
            { "IL", "\u0987\u099c\u09b0\u09be\u09af\u09bc\u09c7\u09b2" },
            { "IM", "\u0986\u0987\u09b2 \u0985\u09ab \u09ae\u09cd\u09af\u09be\u09a8" },
            { "IN", "\u09ad\u09be\u09b0\u09a4" },
            { "type.co.eor", "\u0987\u0989\u09b0\u09cb\u09aa\u09c0\u09af\u09bc \u0995\u09cd\u09b0\u09ae \u09ac\u09bf\u09a8\u09cd\u09af\u09be\u09b8\u09c7\u09b0 \u09a8\u09bf\u09af\u09bc\u09ae\u09be\u09ac\u09b2\u09c0" },
            { "IO", "\u09ac\u09cd\u09b0\u09bf\u099f\u09bf\u09b6 \u09ad\u09be\u09b0\u09a4 \u09ae\u09b9\u09be\u09b8\u09be\u0997\u09b0\u09c0\u09af\u09bc \u0985\u099e\u09cd\u099a\u09b2" },
            { "IQ", "\u0987\u09b0\u09be\u0995" },
            { "IR", "\u0987\u09b0\u09be\u09a8" },
            { "IS", "\u0986\u0987\u09b8\u09b2\u09cd\u09af\u09be\u09a8\u09cd\u09a1" },
            { "IT", "\u0987\u09a4\u09be\u09b2\u09bf" },
            { "Zmth", "\u0997\u09be\u09a3\u09bf\u09a4\u09bf\u0995 \u099a\u09bf\u09b9\u09cd\u09a8" },
            { "type.nu.thai", "\u09a5\u09be\u0987 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.beng", "\u09ac\u09be\u0982\u09b2\u09be \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.cyrl", "\u09b8\u09bf\u09b0\u09bf\u09b2\u09bf\u0995 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "JE", "\u099c\u09be\u09b0\u09cd\u09b8\u09bf" },
            { "type.ca.islamic", "\u0987\u09b8\u09b2\u09be\u09ae\u09bf\u0995 \u0995\u09cd\u09af\u09be\u09b2\u09c7\u09a8\u09cd\u09a1\u09be\u09b0" },
            { "Beng", metaValue_bn },
            { "JM", "\u099c\u09be\u09ae\u09be\u0987\u0995\u09be" },
            { "JO", "\u099c\u09b0\u09cd\u09a1\u09a8" },
            { "JP", "\u099c\u09be\u09aa\u09be\u09a8" },
            { "ain", "\u0986\u0987\u09a8\u09c1" },
            { "guz", "\u0997\u09c1\u09b8\u09c0" },
            { "tog", "\u09a8\u09be\u09af\u09bc\u09be\u09b8\u09be \u099f\u09cb\u0999\u09cd\u0997\u09be" },
            { "type.nu.knda", "\u0995\u09a8\u09cd\u09a8\u09a1\u09bc \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "Kali", "\u0995\u09be\u09af\u09bc\u09be\u09b9 \u09b2\u09bf" },
            { "de_CH", "\u09b8\u09c1\u0987\u09b8 \u09b9\u09be\u0987 \u099c\u09be\u09b0\u09cd\u09ae\u09be\u09a8" },
            { "type.co.phonetic", "\u09a7\u09cd\u09ac\u09a8\u09bf \u09a8\u09bf\u09b0\u09cd\u09a6\u09c7\u09b6\u0995 \u09ac\u09be\u099b\u09be\u0987 \u0995\u09cd\u09b0\u09ae" },
            { "type.ca.buddhist", "\u09ac\u09cc\u09a6\u09cd\u09a7 \u0995\u09cd\u09af\u09be\u09b2\u09c7\u09a8\u09cd\u09a1\u09be\u09b0" },
            { "KE", "\u0995\u09c7\u09a8\u09bf\u09af\u09bc\u09be" },
            { "419", "\u09b2\u09cd\u09af\u09be\u099f\u09bf\u09a8 \u0986\u09ae\u09c7\u09b0\u09bf\u0995\u09be" },
            { "KG", "\u0995\u09bf\u09b0\u0997\u09bf\u099c\u09bf\u09b8\u09cd\u09a4\u09be\u09a8" },
            { "KH", "\u0995\u09ae\u09cd\u09ac\u09cb\u09a1\u09bf\u09af\u09bc\u09be" },
            { "KI", "\u0995\u09bf\u09b0\u09bf\u09ac\u09be\u09a4\u09bf" },
            { "KM", "\u0995\u09ae\u09cb\u09b0\u09cb\u09b8" },
            { "KN", "\u09b8\u09c7\u09a8\u09cd\u099f \u0995\u09bf\u099f\u09b8 \u0993 \u09a8\u09c7\u09ad\u09bf\u09b8" },
            { "Knda", "\u0995\u09be\u09a8\u09be\u09a1\u09bc\u09be" },
            { "Zinh", "\u0995\u09be\u0987" },
            { "fr_CA", "\u0995\u09be\u09a8\u09be\u09a1\u09c0\u09af\u09bc \u09ab\u09b0\u09be\u09b8\u09bf" },
            { "KP", "\u0989\u09a4\u09cd\u09a4\u09b0 \u0995\u09cb\u09b0\u09bf\u09af\u09bc\u09be" },
            { "KR", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u0995\u09cb\u09b0\u09bf\u09af\u09bc\u09be" },
            { "Plrd", "\u09aa\u09cb\u09b2\u09be\u09b0\u09cd\u09a1 \u09a7\u09cd\u09ac\u09a8\u09bf\u0995" },
            { "fr_CH", "\u09b8\u09c1\u0987\u09b8 \u09ab\u09b0\u09be\u09b8\u09bf" },
            { "KW", "\u0995\u09c1\u09af\u09bc\u09c7\u09a4" },
            { "tpi", "\u099f\u09cb\u0995 \u09aa\u09bf\u09b8\u09bf\u09a8" },
            { "KY", "\u0995\u09c7\u09ae\u09cd\u09af\u09be\u09a8 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "KZ", "\u0995\u09be\u099c\u09be\u0996\u09b8\u09cd\u09a4\u09be\u09a8" },
            { "Cyrl", "\u09b8\u09bf\u09b0\u09bf\u09b2\u09bf\u0995" },
            { "LA", "\u09b2\u09be\u0993\u09b8" },
            { "LB", "\u09b2\u09c7\u09ac\u09be\u09a8\u09a8" },
            { "LC", "\u09b8\u09c7\u09a8\u09cd\u099f \u09b2\u09c1\u09b8\u09bf\u09af\u09bc\u09be" },
            { "phn", "\u09ab\u09cb\u09a8\u09bf\u09b6\u09c0\u09af\u09bc\u09be\u09a8" },
            { "Cyrs", "\u09aa\u09cd\u09b0\u09be\u099a\u09c0\u09a8 \u099a\u09be\u09b0\u09cd\u099a \u09b8\u09cd\u09b2\u09be\u09ad\u09cb\u09a8\u09bf\u0995 \u09b8\u09bf\u09b0\u09bf\u09b2\u09bf\u0995" },
            { "gwi", "\u0997\u0993\u0987\u099a\u09cd\u2019\u0987\u09a8" },
            { "nds", "\u09a8\u09bf\u09ae\u09cd\u09a8 \u099c\u09be\u09b0\u09cd\u09ae\u09be\u09a8\u09bf" },
            { "LI", "\u09b2\u09bf\u099a\u09c7\u09a8\u09b8\u09cd\u099f\u09c7\u0987\u09a8" },
            { "LK", "\u09b6\u09cd\u09b0\u09c0\u09b2\u0999\u09cd\u0995\u09be" },
            { "akk", "\u0986\u0995\u09cd\u0995\u09be\u09a6\u09bf\u09af\u09bc\u09be\u09a8" },
            { "cop", "\u0995\u09aa\u099f\u09bf\u0995" },
            { "LR", "\u09b2\u09be\u0987\u09ac\u09c7\u09b0\u09bf\u09af\u09bc\u09be" },
            { "LS", "\u09b2\u09c7\u09b8\u09cb\u09a5\u09cb" },
            { "Phlv", "\u09aa\u09c1\u09b8\u09cd\u09a4\u0995 \u09aa\u09be\u09b9\u09b2\u09ad\u09bf" },
            { "LT", "\u09b2\u09bf\u09a5\u09c1\u09af\u09bc\u09be\u09a8\u09bf\u09af\u09bc\u09be" },
            { "LU", "\u09b2\u09be\u0995\u09cd\u09b8\u09c7\u09ae\u09ac\u09be\u09b0\u09cd\u0997" },
            { "LV", "\u09b2\u09be\u09a4\u09cd\u09ad\u09bf\u09af\u09bc\u09be" },
            { "Kana", "\u0995\u09be\u099f\u09be\u0995\u09be\u09a8\u09be" },
            { "LY", "\u09b2\u09bf\u09ac\u09bf\u09af\u09bc\u09be" },
            { "lad", "\u09b2\u09be\u09a1\u09bf\u09a8\u09cb" },
            { "vun", "\u09ad\u09c1\u099e\u09cd\u099c\u09cb" },
            { "lah", "\u09b2\u09be\u09a8\u09cd\u09a1\u09be" },
            { "lag", "\u09b2\u09be\u0999\u09cd\u0997\u09bf" },
            { "Thaa", "\u09a5\u09be\u09a8\u09be" },
            { "MA", "\u09ae\u09cb\u09b0\u0995\u09cd\u0995\u09cb" },
            { "MC", "\u09ae\u09cb\u09a8\u09be\u0995\u09cb" },
            { "MD", "\u09ae\u09b2\u09a1\u09cb\u09ad\u09be" },
            { "ME", "\u09ae\u09a8\u09cd\u099f\u09bf\u09a8\u09bf\u0997\u09cd\u09b0\u09cb" },
            { "MF", "\u09b8\u09c7\u09a8\u09cd\u099f \u09ae\u09be\u09b0\u09cd\u099f\u09bf\u09a8" },
            { "lam", "\u09b2\u09be\u09ae\u09cd\u09ac\u09be" },
            { "MG", "\u09ae\u09be\u09a6\u09be\u0997\u09be\u09b8\u09cd\u0995\u09be\u09b0" },
            { "Thai", metaValue_th },
            { "MH", "\u09ae\u09be\u09b0\u09cd\u09b6\u09be\u09b2 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "ale", "\u0986\u09b2\u09c7\u0989\u09a4" },
            { "type.nu.vaii", "\u09ad\u09be\u0987 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "MK", "\u0989\u09a4\u09cd\u09a4\u09b0 \u09ae\u09cd\u09af\u09be\u09b8\u09c7\u09a1\u09cb\u09a8\u09bf\u09af\u09bc\u09be" },
            { "type.nu.mathdbl", "\u0997\u09be\u09a3\u09bf\u09a4\u09bf\u0995 \u09a1\u09be\u09ac\u09b2-\u09b8\u09cd\u099f\u09cd\u09b0\u09be\u0995 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "ML", "\u09ae\u09be\u09b2\u09bf" },
            { "MM", "\u09ae\u09be\u09af\u09bc\u09be\u09a8\u09ae\u09be\u09b0 (\u09ac\u09be\u09b0\u09cd\u09ae\u09be)" },
            { "MN", "\u09ae\u0999\u09cd\u0997\u09cb\u09b2\u09bf\u09af\u09bc\u09be" },
            { "new", "\u09a8\u09c7\u0993\u09af\u09bc\u09be\u09b0\u09bf" },
            { "MO", "\u09ae\u09cd\u09af\u09be\u0995\u09be\u0993 \u098f\u09b8\u098f\u0986\u09b0 \u099a\u09c0\u09a8\u09be" },
            { "MP", "\u0989\u09a4\u09cd\u09a4\u09b0\u09be\u099e\u09cd\u099a\u09b2\u09c0\u09af\u09bc \u09ae\u09be\u09b0\u09bf\u09af\u09bc\u09be\u09a8\u09be \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "MQ", "\u09ae\u09be\u09b0\u09cd\u099f\u09bf\u09a8\u09bf\u0995" },
            { "MR", "\u09ae\u09b0\u09bf\u09a4\u09be\u09a8\u09bf\u09af\u09bc\u09be" },
            { "MS", "\u09ae\u09a8\u09cd\u099f\u09b8\u09c7\u09b0\u09be\u099f" },
            { "MT", "\u09ae\u09be\u09b2\u09cd\u099f\u09be" },
            { "type.m0.ungegn", "\u0987\u0989\u098f\u09a8 \u099c\u09bf\u0987\u099c\u09bf\u098f\u09a8 \u09ac\u09b0\u09cd\u09a3\u09be\u09a8\u09cd\u09a4\u09b0\u09a3" },
            { "MU", "\u09ae\u09b0\u09bf\u09b6\u09be\u09b8" },
            { "alt", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a8 \u0986\u09b2\u09a4\u09be\u0987" },
            { "MV", "\u09ae\u09be\u09b2\u09a6\u09cd\u09ac\u09c0\u09aa" },
            { "MW", "\u09ae\u09be\u09b2\u09be\u0989\u0987" },
            { "MX", "\u09ae\u09c7\u0995\u09cd\u09b8\u09bf\u0995\u09cb" },
            { "type.ca.japanese", "\u099c\u09be\u09aa\u09be\u09a8\u09bf \u0995\u09cd\u09af\u09be\u09b2\u09c7\u09a8\u09cd\u09a1\u09be\u09b0" },
            { "MY", "\u09ae\u09be\u09b2\u09af\u09bc\u09c7\u09b6\u09bf\u09af\u09bc\u09be" },
            { "MZ", "\u09ae\u09cb\u099c\u09be\u09ae\u09cd\u09ac\u09bf\u0995" },
            { "Phli", "\u0996\u09a6\u09bf\u09a4 \u09aa\u09be\u09b9\u09b2\u09ad\u09bf" },
            { "NA", "\u09a8\u09be\u09ae\u09bf\u09ac\u09bf\u09af\u09bc\u09be" },
            { "202", "\u0989\u09aa \u09b8\u09be\u09b9\u09be\u09b0\u09be\u09a8 \u0986\u09ab\u09cd\u09b0\u09bf\u0995\u09be" },
            { "type.ca.hebrew", "\u09b9\u09bf\u09ac\u09cd\u09b0\u09c1 \u0995\u09cd\u09af\u09be\u09b2\u09c7\u09a8\u09cd\u09a1\u09be\u09b0" },
            { "type.co.dictionary", "\u0985\u09ad\u09bf\u09a7\u09be\u09a8 \u09ac\u09be\u099b\u09be\u0987 \u09ac\u09bf\u09a8\u09cd\u09af\u09be\u09b8" },
            { "NC", "\u09a8\u09bf\u0989 \u0995\u09cd\u09af\u09be\u09b2\u09c7\u09a1\u09cb\u09a8\u09bf\u09af\u09bc\u09be" },
            { "NE", "\u09a8\u09be\u0987\u099c\u09be\u09b0" },
            { "NF", "\u09a8\u09b0\u09ab\u09cb\u0995 \u09a6\u09cd\u09ac\u09c0\u09aa" },
            { "NG", "\u09a8\u09be\u0987\u099c\u09c7\u09b0\u09bf\u09af\u09bc\u09be" },
            { "trv", "\u09a4\u09be\u09b0\u09cb\u0995\u09cb" },
            { "Phlp", "\u09b8\u09b2\u09cd\u099f\u09be\u09b0 \u09aa\u09be\u09b9\u09b2\u09ad\u09bf" },
            { "NI", "\u09a8\u09bf\u0995\u09be\u09b0\u09be\u0997\u09c1\u09af\u09bc\u09be" },
            { "Hmng", "\u09ab\u09be\u09b9\u09be\u0993 \u09ae\u0999" },
            { "NL", "\u09a8\u09c7\u09a6\u09be\u09b0\u09b2\u09cd\u09af\u09be\u09a8\u09cd\u09a1\u09b8" },
            { "NO", "\u09a8\u09b0\u0993\u09af\u09bc\u09c7" },
            { "NP", "\u09a8\u09c7\u09aa\u09be\u09b2" },
            { "NR", metaValue_NR },
            { "NU", "\u09a8\u09bf\u0989\u09af\u09bc\u09c7" },
            { "Phnx", "\u09ab\u09bf\u09a8\u09bf\u09b6\u09bf\u09af\u09bc" },
            { "rof", "\u09b0\u09ae\u09cd\u09ac\u09cb" },
            { "tsi", "\u09b8\u09bf\u09ae\u09b6\u09bf\u09af\u09bc\u09be\u09a8" },
            { "NZ", "\u09a8\u09bf\u0989\u099c\u09bf\u09b2\u09cd\u09af\u09be\u09a8\u09cd\u09a1" },
            { "rom", "\u09b0\u09cb\u09ae\u09be\u09a8\u09bf" },
            { "Mero", "\u09ae\u09c7\u09b0\u09cb\u0987\u099f\u09bf\u0995" },
            { "crh", "\u0995\u09cd\u09b0\u09bf\u09ae\u09bf\u09af\u09bc\u09be\u09a8 \u09a4\u09c1\u09b0\u09cd\u0995\u09bf" },
            { "ang", "\u09aa\u09cd\u09b0\u09be\u099a\u09c0\u09a8 \u0987\u0982\u09b0\u09c7\u099c\u09c0" },
            { "OM", "\u0993\u09ae\u09be\u09a8" },
            { "anp", "\u0986\u0999\u09cd\u0997\u09bf\u0995\u09be" },
            { "crs", "\u09b8\u09c7\u09b8\u09c7\u09b2\u0993\u09af\u09bc\u09be \u0995\u09cd\u09b0\u09c7\u0993\u09b2 \u09ab\u09cd\u09b0\u09c7\u099e\u09cd\u099a" },
            { "Xpeo", metaValue_peo },
            { "type.nu.hmng", "\u09aa\u09be\u09b9\u09af\u09bc\u09be \u09ae\u0982 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "PA", "\u09aa\u09be\u09a8\u09be\u09ae\u09be" },
            { "type.ca.islamic-civil", "\u0987\u09b8\u09b2\u09be\u09ae\u09bf\u0995-\u09b8\u09bf\u09ad\u09bf\u09b2 \u09ac\u09b0\u09cd\u09b7\u09aa\u099e\u09cd\u099c\u09c0" },
            { "csb", "\u0995\u09be\u09b6\u09c1\u09ac\u09bf\u09af\u09bc\u09be\u09a8" },
            { "en_GB", "\u09ac\u09cd\u09b0\u09bf\u099f\u09bf\u09b6 \u0987\u0982\u09b0\u09c7\u099c\u09bf" },
            { "PE", "\u09aa\u09c7\u09b0\u09c1" },
            { "PF", "\u09ab\u09b0\u09be\u09b8\u09c0 \u09aa\u09b2\u09bf\u09a8\u09c7\u09b6\u09bf\u09af\u09bc\u09be" },
            { "PG", "\u09aa\u09be\u09aa\u09c1\u09af\u09bc\u09be \u09a8\u09bf\u0989 \u0997\u09bf\u09a8\u09bf" },
            { "PH", "\u09ab\u09bf\u09b2\u09bf\u09aa\u09be\u0987\u09a8" },
            { "PK", "\u09aa\u09be\u0995\u09bf\u09b8\u09cd\u09a4\u09be\u09a8" },
            { "PL", "\u09aa\u09cb\u09b2\u09cd\u09af\u09be\u09a8\u09cd\u09a1" },
            { "ewo", "\u0987\u0993\u09a8\u09cd\u09a1\u09cb" },
            { "PM", "\u09b8\u09c7\u09a8\u09cd\u099f \u09aa\u09bf\u09af\u09bc\u09c7\u09b0 \u0993 \u09ae\u09bf\u0995\u09c1\u09af\u09bc\u09c7\u09b2\u09a8" },
            { "PN", "\u09aa\u09bf\u099f\u0995\u09c7\u09af\u09bc\u09be\u09b0\u09cd\u09a8 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "PR", "\u09aa\u09c1\u09af\u09bc\u09c7\u09b0\u09cd\u09a4\u09cb \u09b0\u09bf\u0995\u09cb" },
            { "PS", "\u09aa\u09cd\u09af\u09be\u09b2\u09c7\u09b8\u09cd\u099f\u09be\u0987\u09a8\u09c7\u09b0 \u0985\u099e\u09cd\u099a\u09b2\u09b8\u09ae\u09c2\u09b9" },
            { "Bali", "\u09ac\u09be\u09b2\u09c0\u09af\u09bc" },
            { "PT", "\u09aa\u09b0\u09cd\u09a4\u09c1\u0997\u09be\u09b2" },
            { "PW", "\u09aa\u09be\u09b2\u09be\u0989" },
            { "nia", "\u09a8\u09bf\u09af\u09bc\u09be\u09b8" },
            { "type.nu.greklow", "\u0997\u09cd\u09b0\u09c0\u0995 \u099b\u09cb\u099f \u09b9\u09be\u09a4\u09c7\u09b0 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "PY", "\u09aa\u09cd\u09af\u09be\u09b0\u09be\u0997\u09c1\u09af\u09bc\u09c7" },
            { "tum", "\u09a4\u09c1\u09ae\u09cd\u09ac\u09c1\u0995\u09be" },
            { "Hebr", metaValue_he },
            { "QA", "\u0995\u09be\u09a4\u09be\u09b0" },
            { "niu", "\u09a8\u09bf\u0989\u09af\u09bc\u09be\u09a8" },
            { "QO", "\u0986\u0989\u099f\u09b2\u09be\u0987\u09a8\u09bf\u0982 \u0993\u09b8\u09be\u09a8\u09bf\u09af\u09bc\u09be" },
            { "lez", "\u09b2\u09c7\u099c\u0998\u09bf\u09af\u09bc\u09be\u09a8" },
            { "type.nu.ahom", "\u0985\u09b9\u09ae \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.takr", "\u09a4\u09be\u0995\u09cd\u09b0\u09bf \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "tvl", metaValue_TV },
            { "Tavt", "\u09a4\u09be\u0987 \u09ad\u09bf\u09af\u09bc\u09c7\u09ce" },
            { "001", "\u09aa\u09c3\u09a5\u09bf\u09ac\u09c0" },
            { "002", "\u0986\u09ab\u09cd\u09b0\u09bf\u0995\u09be" },
            { "003", "\u0989\u09a4\u09cd\u09a4\u09b0 \u0986\u09ae\u09c7\u09b0\u09bf\u0995\u09be" },
            { "RE", "\u09b0\u09bf\u0987\u0989\u09a8\u09bf\u09af\u09bc\u09a8" },
            { "005", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u0986\u09ae\u09c7\u09b0\u09bf\u0995\u09be" },
            { "jbo", "\u09b2\u09cb\u099c\u09ac\u09be\u09a8" },
            { "Rjng", "\u09b0\u09c7\u099c\u09cd\u09af\u09be\u0999\u09cd\u0997" },
            { "009", "\u0993\u09b6\u09bf\u09af\u09bc\u09be\u09a8\u09bf\u09af\u09bc\u09be" },
            { "RO", "\u09b0\u09cb\u09ae\u09be\u09a8\u09bf\u09af\u09bc\u09be" },
            { "RS", "\u09b8\u09be\u09b0\u09cd\u09ac\u09bf\u09af\u09bc\u09be" },
            { "RU", "\u09b0\u09be\u09b6\u09bf\u09af\u09bc\u09be" },
            { "RW", "\u09b0\u09c1\u09af\u09bc\u09be\u09a8\u09cd\u09a1\u09be" },
            { "type.nu.talu", "\u09a8\u09a4\u09c1\u09a8 \u09a4\u09be\u0987 \u09b2\u09bf\u0989 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "Ugar", metaValue_uga },
            { "Mani", "\u09ae\u09cd\u09af\u09be\u09a8\u09bf\u099a\u09be\u0987\u09a8" },
            { "Khar", "\u0996\u09b0\u09cb\u09b7\u09cd\u09a0\u09c0" },
            { "SA", "\u09b8\u09cc\u09a6\u09bf \u0986\u09b0\u09ac" },
            { "pon", "\u09aa\u09cb\u09b9\u09cd\u09a8\u09aa\u09c7\u0987\u09af\u09bc\u09be\u09a8" },
            { "Mand", "\u09ae\u09cd\u09af\u09be\u09a8\u09cd\u09a1\u09be\u09af\u09bc\u09c0\u09a8" },
            { "SB", "\u09b8\u09b2\u09cb\u09ae\u09a8 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "twq", "\u09a4\u09be\u09b8\u09be\u0993\u09af\u09bc\u09be\u0995" },
            { "011", "\u09aa\u09b6\u09cd\u099a\u09bf\u09ae \u0986\u09ab\u09cd\u09b0\u09bf\u0995\u09be" },
            { "SC", "\u09b8\u09bf\u09b8\u09bf\u09b2\u09bf" },
            { "SD", "\u09b8\u09c1\u09a6\u09be\u09a8" },
            { "013", "\u09ae\u09a7\u09cd\u09af \u0986\u09ae\u09c7\u09b0\u09bf\u0995\u09be" },
            { "SE", "\u09b8\u09c1\u0987\u09a1\u09c7\u09a8" },
            { "014", "\u09aa\u09c2\u09b0\u09cd\u09ac \u0986\u09ab\u09cd\u09b0\u09bf\u0995\u09be" },
            { "arc", "\u0986\u09b0\u09be\u09ae\u09be\u0987\u0995" },
            { "015", "\u0989\u09a4\u09cd\u09a4\u09b0 \u0986\u09ab\u09cd\u09b0\u09bf\u0995\u09be" },
            { "SG", "\u09b8\u09bf\u0999\u09cd\u0997\u09be\u09aa\u09c1\u09b0" },
            { "SH", "\u09b8\u09c7\u09a8\u09cd\u099f \u09b9\u09c7\u09b2\u09c7\u09a8\u09be" },
            { "type.lb.strict", "\u099f\u09be\u0987\u099f \u09b2\u09be\u0987\u09a8 \u09ac\u09bf\u09ad\u09be\u099c\u0995 \u09b6\u09c8\u09b2\u09c0" },
            { "017", "\u09ae\u09a7\u09cd\u09af \u0986\u09ab\u09cd\u09b0\u09bf\u0995\u09be" },
            { "SI", "\u09b8\u09cd\u09b2\u09cb\u09ad\u09be\u09a8\u09bf\u09af\u09bc\u09be" },
            { "type.nu.mymrtlng", "\u09ae\u09be\u09af\u09bc\u09be\u09a8\u09ae\u09be\u09b0 \u09a5\u09be\u0987 \u09b2\u09c7\u09af\u09bc\u09bf\u0982 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "018", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a8 \u0986\u09ab\u09cd\u09b0\u09bf\u0995\u09be" },
            { "SJ", "\u09b8\u09cd\u09ac\u09be\u09b2\u09ac\u09be\u09b0\u09cd\u09a1 \u0993 \u099c\u09be\u09a8 \u09ae\u09c7\u09af\u09bc\u09c7\u09a8" },
            { "019", "\u0986\u09ae\u09c7\u09b0\u09bf\u0995\u09be\u09b8" },
            { "SK", "\u09b8\u09cd\u09b2\u09cb\u09ad\u09be\u0995\u09bf\u09af\u09bc\u09be" },
            { "SL", "\u09b8\u09bf\u09af\u09bc\u09c7\u09b0\u09be \u09b2\u09bf\u0993\u09a8" },
            { "SM", "\u09b8\u09be\u09a8 \u09ae\u09be\u09b0\u09bf\u09a8\u09cb" },
            { "SN", "\u09b8\u09c7\u09a8\u09c7\u0997\u09be\u09b2" },
            { "SO", "\u09b8\u09cb\u09ae\u09be\u09b2\u09bf\u09af\u09bc\u09be" },
            { "arn", "\u09ae\u09be\u09aa\u09c1\u099a\u09bf" },
            { "arp", "\u0986\u09b0\u09be\u09aa\u09be\u09b9\u09cb" },
            { "type.nu.taml", "\u0990\u09a4\u09bf\u09b9\u09cd\u09af\u09ac\u09be\u09b9\u09c0 \u09a4\u09be\u09ae\u09bf\u09b2 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "SR", "\u09b8\u09c1\u09b0\u09bf\u09a8\u09be\u09ae" },
            { "SS", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u09b8\u09c1\u09a6\u09be\u09a8" },
            { "ST", "\u09b8\u09be\u0993\u099f\u09cb\u09ae\u09be \u0993 \u09aa\u09cd\u09b0\u09bf\u09a8\u09cd\u09b8\u09bf\u09aa\u09bf" },
            { "SV", "\u098f\u09b2 \u09b8\u09be\u09b2\u09ad\u09c7\u09a6\u09b0" },
            { "SX", "\u09b8\u09bf\u09a8\u09cd\u099f \u09ae\u09be\u09b0\u09cd\u099f\u09c7\u09a8" },
            { "SY", "\u09b8\u09bf\u09b0\u09bf\u09af\u09bc\u09be" },
            { "yao", "\u0987\u09af\u09bc\u09be\u0993" },
            { "SZ", "\u0987\u09b8\u0993\u09af\u09bc\u09be\u09a4\u09bf\u09a8\u09bf" },
            { "arw", "\u0986\u09b0\u09be\u0993\u09af\u09bc\u09be\u0995" },
            { "yap", "\u0987\u09af\u09bc\u09be\u09aa\u09c7\u09b8\u09c7" },
            { "TA", "\u099f\u09cd\u09b0\u09bf\u09b8\u09cd\u099f\u09be\u09a8 \u09a1\u09be \u0995\u09c1\u09a8\u09b9\u09be" },
            { "asa", "\u0986\u09b8\u09c1" },
            { "type.ms.ussystem", "\u09ae\u09be\u09b0\u09cd\u0995\u09bf\u09a8 \u09af\u09c1\u0995\u09cd\u09a4\u09b0\u09be\u09b7\u09cd\u099f\u09cd\u09b0\u09c7\u09b0 \u09aa\u09b0\u09bf\u09ae\u09be\u09aa \u09b8\u09bf\u09b8\u09cd\u099f\u09c7\u09ae" },
            { "021", "\u0989\u09a4\u09cd\u09a4\u09b0\u09be\u099e\u09cd\u099a\u09b2\u09c0\u09af\u09bc \u0986\u09ae\u09c7\u09b0\u09bf\u0995\u09be" },
            { "TC", "\u09a4\u09c1\u09b0\u09cd\u0995\u09b8 \u0993 \u0995\u09be\u0987\u0995\u09cb\u09b8 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "yav", "\u0987\u09af\u09bc\u09be\u0999\u09cd\u0997\u09ac\u09c7\u09a8" },
            { "TD", "\u099a\u09be\u09a6" },
            { "TF", "\u09ab\u09b0\u09be\u09b8\u09c0 \u09a6\u0995\u09cd\u09b7\u09bf\u09a3\u09be\u099e\u09cd\u099a\u09b2" },
            { "TG", "\u099f\u09cb\u0997\u09cb" },
            { "TH", "\u09a5\u09be\u0987\u09b2\u09cd\u09af\u09be\u09a8\u09cd\u09a1" },
            { "TJ", "\u09a4\u09be\u099c\u09bf\u0995\u09bf\u09b8\u09cd\u09a4\u09be\u09a8" },
            { "TK", metaValue_TK },
            { "029", "\u0995\u09cd\u09af\u09be\u09b0\u09be\u09ac\u09bf\u09af\u09bc\u09be\u09a8" },
            { "TL", "\u09a4\u09bf\u09ae\u09c1\u09b0-\u09b2\u09c7\u09b8\u09cd\u09a4\u09c7" },
            { "ybb", "\u0987\u09af\u09bc\u09c7\u09ae\u09cd\u09ac\u09be" },
            { "type.co.searchjl", "\u09b9\u09be\u0999\u09cd\u0997\u09c1\u09b2 \u09aa\u09cd\u09b0\u09be\u09a5\u09ae\u09bf\u0995 \u09ac\u09cd\u09af\u099e\u09cd\u099c\u09a8\u09ac\u09b0\u09cd\u09a3 \u09a6\u09cd\u09ac\u09be\u09b0\u09be \u0985\u09a8\u09c1\u09b8\u09a8\u09cd\u09a7\u09be\u09a8 \u0995\u09b0\u09c1\u09a8" },
            { "TM", "\u09a4\u09c1\u09b0\u09cd\u0995\u09ae\u09c7\u09a8\u09bf\u09b8\u09cd\u09a4\u09be\u09a8" },
            { "TN", "\u09a4\u09bf\u0989\u09a8\u09bf\u09b8\u09bf\u09af\u09bc\u09be" },
            { "TO", "\u099f\u09cb\u0999\u09cd\u0997\u09be" },
            { "TR", "\u09a4\u09c1\u09b0\u09b8\u09cd\u0995" },
            { "TT", "\u09a4\u09cd\u09b0\u09bf\u09a8\u09bf\u09a8\u09be\u09a6 \u0993 \u099f\u09cb\u09ac\u09cd\u09af\u09be\u0997\u09cb" },
            { "TV", metaValue_TV },
            { "TW", "\u09a4\u09be\u0987\u0993\u09af\u09bc\u09be\u09a8" },
            { "ast", "\u0986\u09b8\u09cd\u09a4\u09c1\u09b0\u09bf\u09af\u09bc" },
            { "Orkh", "\u0985\u09b0\u09cd\u0996\u09cb\u09a8" },
            { "TZ", "\u09a4\u09be\u099e\u09cd\u099c\u09be\u09a8\u09bf\u09af\u09bc\u09be" },
            { "nmg", "\u0995\u09cb\u09af\u09bc\u09be\u09b8\u09bf\u0993" },
            { "Zzzz", "\u0985\u099c\u09be\u09a8\u09be \u09b2\u09bf\u09aa\u09bf" },
            { "UA", "\u0987\u0989\u0995\u09cd\u09b0\u09c7\u09a8" },
            { "rup", "\u0986\u09b0\u09ae\u09c7\u09a8\u09bf\u09af\u09bc\u09be\u09a8" },
            { "030", "\u09aa\u09c2\u09b0\u09cd\u09ac \u098f\u09b6\u09bf\u09af\u09bc\u09be" },
            { "tyv", "\u099f\u09c1\u09ad\u09bf\u09a8\u09bf\u09af\u09bc\u09be\u09a8" },
            { "sw_CD", "\u0995\u0999\u09cd\u0997\u09cb \u09b8\u09cb\u09af\u09bc\u09be\u09b9\u09bf\u09b2\u09bf" },
            { "034", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u098f\u09b6\u09bf\u09af\u09bc\u09be" },
            { "hai", "\u09b9\u09be\u0987\u09a1\u09be" },
            { "035", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u09aa\u09c2\u09b0\u09cd\u09ac \u098f\u09b6\u09bf\u09af\u09bc\u09be" },
            { "UG", "\u0989\u0997\u09be\u09a8\u09cd\u09a1\u09be" },
            { "type.co.pinyin", "\u09aa\u09bf\u09a8\u09bf\u09a8 \u09b8\u099c\u09cd\u099c\u09be\u0995\u09cd\u09b0\u09ae" },
            { "039", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u0987\u0989\u09b0\u09cb\u09aa" },
            { "Sinh", "\u09b8\u09bf\u0982\u09b9\u09b2\u09bf" },
            { "UM", "\u09af\u09c1\u0995\u09cd\u09a4\u09b0\u09be\u09b7\u09cd\u099f\u09cd\u09b0\u09c7\u09b0 \u09aa\u09be\u09b0\u09cd\u09b6\u09cd\u09ac\u09ac\u09b0\u09cd\u09a4\u09c0 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "UN", "\u099c\u09be\u09a4\u09bf\u09b8\u0982\u0998" },
            { "US", "\u09ae\u09be\u09b0\u09cd\u0995\u09bf\u09a8 \u09af\u09c1\u0995\u09cd\u09a4\u09b0\u09be\u09b7\u09cd\u099f\u09cd\u09b0" },
            { "haw", "\u09b9\u09be\u0993\u09af\u09bc\u09be\u0987\u09af\u09bc\u09be\u09a8" },
            { "type.co.gb2312han", "\u09b8\u09be\u09a7\u09be\u09b0\u09a3 \u099a\u09c0\u09a8\u09be \u09b8\u099c\u09cd\u099c\u09be\u0995\u09cd\u09b0\u09ae - \u099c\u09bf\u09ac\u09bf\u09e8\u09e9\u09e7\u09e8" },
            { "UY", "\u0989\u09b0\u09c1\u0997\u09c1\u09af\u09bc\u09c7" },
            { "prg", "\u09aa\u09cd\u09b0\u09c1\u09b6\u09bf\u09af\u09bc\u09be\u09a8" },
            { "UZ", "\u0989\u099c\u09ac\u09c7\u0995\u09bf\u09b8\u09cd\u09a4\u09be\u09a8" },
            { "tzm", "\u09b8\u09c7\u09a8\u09cd\u099f\u09cd\u09b0\u09be\u09b2 \u0986\u099f\u09b2\u09be\u09b8 \u09a4\u09be\u09ae\u09be\u099c\u09bf\u0997\u09be\u09a4" },
            { "type.co.stroke", "\u0986\u09ac\u09b0\u09cd\u09a4\u09bf\u09a4 \u09b8\u099c\u09cd\u099c\u09be\u0995\u09cd\u09b0\u09ae" },
            { "nnh", "\u09a8\u09bf\u0999\u09cd\u0997\u09c7\u09ae\u09cd\u09ac\u09c1\u09a8" },
            { "VA", "\u09ad\u09cd\u09af\u09be\u099f\u09bf\u0995\u09be\u09a8 \u09b8\u09bf\u099f\u09bf" },
            { "pro", "\u09aa\u09cd\u09b0\u09be\u099a\u09c0\u09a8 \u09aa\u09cd\u09b0\u09cb\u09ad\u09c7\u09a8\u09b8\u09be\u09b2" },
            { "VC", "\u09b8\u09c7\u09a8\u09cd\u099f \u09ad\u09bf\u09a8\u09b8\u09c7\u09a8\u09cd\u099f \u0993 \u0997\u09cd\u09b0\u09c7\u09a8\u09be\u09a1\u09bf\u09a8\u09b8" },
            { "VE", "\u09ad\u09c7\u09a8\u09c7\u099c\u09c1\u09af\u09bc\u09c7\u09b2\u09be" },
            { "VG", "\u09ac\u09cd\u09b0\u09bf\u099f\u09bf\u09b6 \u09ad\u09be\u09b0\u09cd\u099c\u09bf\u09a8 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "VI", "\u09ae\u09be\u09b0\u09cd\u0995\u09bf\u09a8 \u09af\u09c1\u0995\u09cd\u09a4\u09b0\u09be\u09b7\u09cd\u099f\u09cd\u09b0\u09c7\u09b0 \u09ad\u09be\u09b0\u09cd\u099c\u09bf\u09a8 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "VN", "\u09ad\u09bf\u09af\u09bc\u09c7\u09a4\u09a8\u09be\u09ae" },
            { "VU", "\u09ad\u09be\u09a8\u09c1\u09af\u09bc\u09be\u099f\u09c1" },
            { "nog", "\u09a8\u09cb\u0997\u09be\u0987" },
            { "rwk", "\u09b0\u09be\u0993\u09af\u09bc\u09be" },
            { "non", "\u09aa\u09cd\u09b0\u09be\u099a\u09c0\u09a8 \u09a8\u09b0\u09cd\u09b8" },
            { "053", "\u0985\u09b8\u09cd\u099f\u09cd\u09b0\u09be\u09b2\u09c7\u09b6\u09bf\u09af\u09bc\u09be" },
            { "054", "\u09ae\u09cd\u09af\u09be\u09b2\u09c7\u09a8\u09c7\u09b6\u09bf\u09af\u09bc\u09be" },
            { "WF", "\u0993\u09af\u09bc\u09be\u09b2\u09bf\u09b8 \u0993 \u09ab\u09c1\u099f\u09c1\u09a8\u09be" },
            { "type.co.traditional", "\u09aa\u09cd\u09b0\u09a5\u09be\u0997\u09a4 \u09ac\u09be\u099b\u09be\u0987 \u09ac\u09bf\u09a8\u09cd\u09af\u09be\u09b8" },
            { "057", "\u09ae\u09be\u0987\u0995\u09cd\u09b0\u09cb\u09a8\u09c7\u09b6\u09bf\u09af\u09bc\u09be \u0985\u099e\u09cd\u099a\u09b2" },
            { "jgo", "\u0997\u09cb\u09ae\u09cd\u09ac\u09be" },
            { "lkt", "\u09b2\u09be\u0995\u09cb\u099f\u09be" },
            { "type.nu.finance", "\u0985\u09b0\u09cd\u09a5\u09a8\u09c8\u09a4\u09bf\u0995 \u09b8\u0982\u0996\u09cd\u09af\u09be\u09b8\u09c2\u099a\u0995" },
            { "type.co.compat", "\u0986\u0997\u09c7\u09b0 \u09ac\u09be\u099b\u09be\u0987\u09af\u09bc\u09c7\u09b0 \u0995\u09cd\u09b0\u09ae, \u09b8\u09be\u09ae\u099e\u09cd\u099c\u09b8\u09cd\u09af\u09c7\u09b0 \u099c\u09a8\u09cd\u09af" },
            { "wae", "\u0993\u09af\u09bc\u09be\u09b2\u09b8\u09c7\u09b0" },
            { "WS", "\u09b8\u09be\u09ae\u09cb\u09af\u09bc\u09be" },
            { "type.nu.mtei", "\u09ae\u09bf\u099f\u09bf\u0987 \u09ae\u09be\u09af\u09bc\u09c7\u0995 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "wal", "\u0993\u09af\u09bc\u09be\u09b2\u09be\u09ae\u09cb" },
            { "was", "\u0993\u09af\u09bc\u09be\u09b6\u09cb" },
            { "XA", "\u09b8\u09bf\u0989\u09a1\u09cb-\u0985\u09cd\u09af\u09be\u0995\u09b8\u09c7\u09a8\u09cd\u099f" },
            { "war", "\u0993\u09af\u09bc\u09be\u09b0\u09c7" },
            { "XB", "\u09b8\u09bf\u0989\u09a1\u09cb-\u09ac\u09bf\u09a1\u09bf" },
            { "awa", "\u0986\u0993\u09af\u09bc\u09be\u09a7\u09bf" },
            { "061", "\u09aa\u09b2\u09bf\u09a8\u09c7\u09b6\u09bf\u09af\u09bc\u09be" },
            { "XK", "\u0995\u09b8\u09cb\u09ad\u09cb" },
            { "type.nu.brah", "\u09ac\u09cd\u09b0\u09be\u09b9\u09cd\u09ae\u09c0 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "\u0985\u09b2\u09bf\u0996\u09bf\u09a4" },
            { "Olck", "\u0993\u09b2 \u099a\u09bf\u0995\u09bf" },
            { "wbp", "\u0993\u09af\u09bc\u09be\u09b0\u09cd\u09b2\u09aa\u09bf\u09b0\u09bf" },
            { "Batk", "\u09ac\u09be\u099f\u09be\u0995" },
            { "Blis", "\u09ac\u09cd\u09b2\u09bf\u09b8\u09aa\u09cd\u09b0\u09a4\u09c0\u0995" },
            { "YE", "\u0987\u09af\u09bc\u09c7\u09ae\u09c7\u09a8" },
            { "nqo", "\u098f\u09a8\u2019\u0995\u09cb" },
            { "type.co.standard", "\u0986\u09a6\u09b0\u09cd\u09b6 \u09ac\u09be\u099b\u09be\u0987 \u09ac\u09bf\u09a8\u09cd\u09af\u09be\u09b8" },
            { "fan", "\u09ab\u09cd\u09af\u09be\u0999\u09cd\u0997" },
            { "fat", "\u09ab\u09be\u09a8\u09cd\u09a4\u09bf" },
            { "Sgnw", "\u099a\u09bf\u09b9\u09cd\u09a8 \u09b2\u09bf\u0996\u09a8" },
            { "YT", "\u09ae\u09be\u09af\u09bc\u09cb\u09a4\u09cd\u09a4\u09c7" },
            { "type.nu.cham", "\u099a\u09be\u09ae \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "ZA", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u0986\u09ab\u09cd\u09b0\u09bf\u0995\u09be" },
            { "type.nu.sund", "\u09b8\u09c1\u09a6\u09be\u09a8\u09c0\u09af\u09bc \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.lb.loose", "\u0986\u09b2\u0997\u09be \u09b2\u09be\u0987\u09a8 \u09ac\u09bf\u09ad\u09be\u099c\u0995 \u09b6\u09c8\u09b2\u09c0" },
            { "Deva", "\u09a6\u09c7\u09ac\u09a8\u09be\u0997\u09b0\u09bf" },
            { "type.nu.geor", "\u099c\u09b0\u09cd\u099c\u09bf\u09af\u09bc\u09be\u09a8 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.co.zhuyin", "\u099d\u09c1\u0987\u09a8 \u09b8\u099c\u09cd\u099c\u09be\u0995\u09cd\u09b0\u09ae" },
            { "Hira", "\u09b9\u09bf\u09b0\u09be\u0997\u09be\u09a8\u09be" },
            { "ZM", "\u099c\u09be\u09ae\u09cd\u09ac\u09bf\u09af\u09bc\u09be" },
            { "ZW", "\u099c\u09bf\u09ae\u09cd\u09ac\u09be\u09ac\u09cb\u09af\u09bc\u09c7" },
            { "ZZ", "\u0985\u099c\u09be\u09a8\u09be \u0985\u099e\u09cd\u099a\u09b2" },
            { "Runr", "\u09b0\u09c1\u09a8\u09bf\u0995" },
            { "type.ms.metric", "\u09ae\u09c7\u099f\u09cd\u09b0\u09bf\u0995 \u09b8\u09bf\u09b8\u09cd\u099f\u09c7\u09ae" },
            { "type.ca.iso8601", "ISO-861 \u0995\u09cd\u09af\u09be\u09b2\u09c7\u09a8\u09cd\u09a1\u09be\u09b0" },
            { "lol", "\u09ae\u09cb\u0999\u09cd\u0997\u09cb" },
            { "nso", "\u0989\u09a4\u09cd\u09a4\u09b0\u09be\u099e\u09cd\u099a\u09b2\u09c0\u09af\u09bc \u09b8\u09cb\u09a5\u09cb" },
            { "type.nu.telu", "\u09a4\u09c7\u09b2\u09c1\u0997\u09c1 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "lou", "\u09b2\u09c1\u0987\u09b8\u09bf\u09af\u09bc\u09be\u09a8\u09be \u0995\u09cd\u09b0\u09c7\u0993\u09b2" },
            { "loz", "\u09b2\u09cb\u099c\u09bf" },
            { "jmc", "\u09ae\u09be\u0995\u09be\u09ae\u09c7" },
            { "type.nu.hansfin", "\u09b8\u09b0\u09b2\u09bf\u0995\u09c3\u09a4 \u099a\u09c8\u09a8\u09bf\u0995 \u0986\u09b0\u09cd\u09a5\u09bf\u0995 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "hil", "\u09b9\u09bf\u09b2\u09bf\u0997\u09cd\u09af\u09be\u09af\u09bc\u09a8\u09cb\u09a8" },
            { "type.nu.arabext", "\u09aa\u09cd\u09b0\u09b8\u09be\u09b0\u09bf\u09a4 \u0986\u09b0\u09ac\u09bf -\u09ad\u09be\u09b0\u09a4\u09c0\u09af\u09bc \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "nus", "\u09a8\u09c1\u09af\u09bc\u09be\u09b0" },
            { "dak", "\u09a1\u09be\u0995\u09cb\u099f\u09be" },
            { "type.nu.fullwide", "\u09aa\u09c2\u09b0\u09cd\u09a3 \u099a\u0993\u09a1\u09bc\u09be \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "hit", "\u09b9\u09bf\u099f\u09cd\u099f\u09bf\u099f" },
            { "dar", "\u09a6\u09be\u09b0\u09cd\u0997\u0993\u09af\u09bc\u09be" },
            { "dav", "\u09a4\u09be\u0987\u09a4\u09be" },
            { "Maya", "\u09ae\u09be\u09af\u09bc\u09be\u09a8 \u09b9\u09be\u09af\u09bc\u09be\u09b0\u09cb\u0997\u09cd\u09b2\u09bf\u09aa" },
            { "lrc", "\u0989\u09a4\u09cd\u09a4\u09b0 \u09b2\u09c1\u09b0\u09bf" },
            { "type.co.emoji", "\u0987\u09ae\u09cb\u099c\u09bf \u09ac\u09be\u099b\u09be\u0987 \u0995\u09cd\u09b0\u09ae" },
            { "Copt", "\u0995\u09cb\u09aa\u09cd\u099f\u09bf\u0995" },
            { "nwc", "\u09aa\u09cd\u09b0\u09be\u099a\u09c0\u09a8 \u09a8\u09c7\u0993\u09af\u09bc\u09be\u09b0\u09c0" },
            { "udm", "\u0989\u09a1\u09ae\u09c1\u09b0\u09cd\u099f" },
            { "Khmr", "\u0996\u09c7\u09ae\u09c7\u09b0" },
            { "type.ca.islamic-rgsa", "\u0987\u09b8\u09b2\u09be\u09ae\u09bf\u0995 \u09ac\u09b0\u09cd\u09b7\u09aa\u099e\u09cd\u099c\u09c0 (\u09b8\u09cc\u09a6\u09bf \u0986\u09b0\u09ac, \u09a6\u09c3\u09b6\u09cd\u09af\u09ae\u09be\u09a8)" },
            { "Limb", "\u09b2\u09bf\u09ae\u09cd\u09ac\u09c1" },
            { "sad", "\u09b8\u09cd\u09af\u09be\u09a8\u09cd\u09a1\u09be\u0993\u09af\u09bc\u09c7" },
            { "type.nu.roman", "\u09b0\u09cb\u09ae\u09be\u09a8 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "sah", "\u09b6\u09be\u0996\u09be" },
            { "type.nu.shrd", "\u09b8\u09be\u09b0\u09a6\u09be \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "sam", "\u09b8\u09be\u09ae\u09be\u09b0\u09bf\u099f\u09be\u09a8 \u0986\u09b0\u09be\u09ae\u09bf\u0995" },
            { "saq", "\u09b8\u09be\u09ae\u09ac\u09c1\u09b0\u09c1" },
            { "sas", "\u09b8\u09be\u09b8\u09be\u0995" },
            { "sat", "\u09b8\u09be\u0981\u0993\u09a4\u09be\u09b2\u09bf" },
            { "Tfng", "\u09a4\u09bf\u09ab\u09bf\u09a8\u09be\u0997" },
            { "jpr", "\u099c\u09c1\u09a6\u09c7\u0993 \u09ab\u09be\u09b0\u09cd\u09b8\u09bf" },
            { "type.d0.npinyin", "\u09b8\u09be\u0982\u0996\u09bf\u0995" },
            { "type.nu.native", "\u09b8\u09cd\u09a5\u09be\u09a8\u09c0\u09af\u09bc \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "sba", "\u09a8\u09cd\u09af\u09be\u0997\u09be\u09ae\u09cd\u09ac\u09c7" },
            { "Guru", "\u0997\u09c1\u09b0\u09c1\u09ae\u09c1\u0996\u09bf" },
            { "lua", "\u09b2\u09c1\u09ac\u09be-\u09b2\u09c1\u09b2\u09c1\u09af\u09bc\u09be" },
            { "type.nu.tirh", "\u09a4\u09bf\u09b0\u09b9\u09c1\u09a4\u09be \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.d0.fwidth", "\u09aa\u09c2\u09b0\u09cd\u09a3\u09aa\u09cd\u09b0\u09b8\u09cd\u09a5 \u09aa\u09b0\u09cd\u09af\u09a8\u09cd\u09a4" },
            { "sbp", "\u09b8\u09be\u0999\u09cd\u0997\u09c1" },
            { "lui", "\u09b2\u09c1\u0987\u09b8\u09c7\u09a8\u09cb" },
            { "nyn", "\u09a8\u09cd\u09af\u09be\u09af\u09bc\u09be\u0999\u09cd\u0995\u09cb\u09b2\u09c7" },
            { "nym", "\u09a8\u09cd\u09af\u09be\u09af\u09bc\u09be\u09ae\u0993\u09af\u09bc\u09c7\u099c\u09bf" },
            { "lun", "\u09b2\u09c1\u09a8\u09cd\u09a1\u09be" },
            { "nyo", "\u09a8\u09cd\u09af\u09cb\u09b0\u09cb" },
            { "luo", "\u09b2\u09c1\u09af\u09bc\u09cb" },
            { "fil", "\u09ab\u09bf\u09b2\u09bf\u09aa\u09bf\u09a8\u09cb" },
            { "hmn", "\u09b9\u09cd\u200c\u09ae\u09cb\u0999" },
            { "del", "\u09a1\u09c7\u09b2\u09be\u0993\u09af\u09bc\u09c7\u09b0" },
            { "lus", "\u09ae\u09bf\u099c\u09cb" },
            { "bal", "\u09ac\u09c7\u09b2\u09c1\u099a\u09c0" },
            { "den", "\u09b8\u09cd\u09b2\u09cd\u09af\u09be\u09ad" },
            { "uga", metaValue_uga },
            { "ban", "\u09ac\u09be\u09b2\u09bf\u09a8\u09c0\u09af\u09bc" },
            { "type.nu.wara", "\u0993\u09af\u09bc\u09be\u09b0\u09c7\u0982 \u09b8\u09bf\u099f\u09bf \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "luy", "\u09b2\u09c1\u0987\u09af\u09bc\u09be" },
            { "bas", "\u09ac\u09be\u09b8\u09be" },
            { "jrb", "\u099c\u09c1\u09a6\u09c7\u0993 \u0986\u09b0\u09ac\u09bf" },
            { "es_ES", "\u0987\u0989\u09b0\u09cb\u09aa\u09c0\u09af\u09bc \u09b8\u09cd\u09aa\u09cd\u09af\u09be\u09a8\u09bf\u09b6" },
            { "nzi", "\u098f\u09a8\u099c\u09bf\u09ae\u09be" },
            { "sco", "\u09b8\u09cd\u0995\u099f\u09b8" },
            { "scn", "\u09b8\u09bf\u09b8\u09bf\u09b2\u09bf\u09af\u09bc\u09be\u09a8" },
            { "aa", "\u0986\u09ab\u09be\u09b0" },
            { "ab", "\u0986\u09ac\u0996\u09be\u099c\u09bf\u09af\u09bc\u09be\u09a8" },
            { "ae", "\u0986\u09ac\u09c7\u09b8\u09cd\u09a4\u09c0\u09af\u09bc" },
            { "af", "\u0986\u09ab\u09cd\u09b0\u09bf\u0995\u09be\u09a8" },
            { "ak", "\u0986\u0995\u09be\u09a8" },
            { "type.nu.cakm", "\u099a\u09be\u0995\u09ae\u09be \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "am", "\u0986\u09ae\u09b9\u09be\u09b0\u09bf\u0995" },
            { "an", "\u0986\u09b0\u09cd\u0997\u09cb\u09a8\u09bf\u099c" },
            { "Arab", "\u0986\u09b0\u09ac\u09bf" },
            { "Jpan", "\u099c\u09be\u09aa\u09be\u09a8\u09c0" },
            { "ar", "\u0986\u09b0\u09ac\u09c0" },
            { "Hrkt", "\u099c\u09be\u09aa\u09be\u09a8\u09bf \u0985\u0995\u09cd\u09b7\u09b0\u09ae\u09be\u09b2\u09be" },
            { "as", "\u0985\u09b8\u09ae\u09c0\u09af\u09bc\u09be" },
            { "Lina", "\u09b2\u09bf\u09a8\u09bf\u09af\u09bc\u09be\u09b0 \u098f" },
            { "av", "\u0986\u09ad\u09c7\u09b0\u09bf\u0995" },
            { "Linb", "\u09b2\u09bf\u09a8\u09bf\u09af\u09bc\u09be\u09b0 \u09ac\u09bf" },
            { "sdh", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u0995\u09c1\u09b0\u09cd\u09a6\u09bf\u09b6" },
            { "ay", "\u0986\u09af\u09bc\u09ae\u09be\u09b0\u09be" },
            { "az", "\u0986\u099c\u09be\u09b0\u09ac\u09be\u0987\u099c\u09be\u09a8\u09c0" },
            { "ba", "\u09ac\u09be\u09b6\u0995\u09bf\u09b0" },
            { "type.co.unihan", "\u09b0\u09be\u09a1\u09bf\u0995\u09c7\u09b2 \u09b8\u09cd\u099f\u09cd\u09b0\u09cb\u0995 \u09ac\u09be\u099b\u09be\u0987 \u09ac\u09bf\u09a8\u09cd\u09af\u09be\u09b8" },
            { "be", "\u09ac\u09c7\u09b2\u09be\u09b0\u09c1\u09b6\u09bf\u09af\u09bc" },
            { "bg", "\u09ac\u09c1\u09b2\u0997\u09c7\u09b0\u09bf\u09af\u09bc" },
            { "bi", "\u09ac\u09bf\u09b8\u09b2\u09be\u09ae\u09be" },
            { "type.nu.java", "\u099c\u09be\u09ad\u09be\u09a8\u09bf\u099c \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "bm", "\u09ac\u09be\u09ae\u09ac\u09be\u09b0\u09be" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "\u09a6\u09cb\u0997\u09cd\u09b0\u09c0\u09ac" },
            { "br", "\u09ac\u09cd\u09b0\u09c7\u099f\u09a8" },
            { "bs", "\u09ac\u09b8\u09a8\u09c0\u09af\u09bc\u09be\u09a8" },
            { "Mymr", "\u09ae\u09be\u09af\u09bc\u09be\u09a8\u09ae\u09be\u09b0" },
            { "type.nu.laoo", "\u09b2\u09be\u0993 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "seh", "\u09b8\u09c7\u09a8\u09be" },
            { "Nkoo", "\u098f\u09a8\u0995\u09cb" },
            { "sel", "\u09b8\u09c7\u09b2\u09cd\u0995\u09c1\u09aa" },
            { "ca", "\u0995\u09be\u09a4\u09be\u09b2\u09be\u09a8" },
            { "ses", "\u0995\u09cb\u09af\u09bc\u09b0\u09be\u09ac\u09c7\u09a8\u09cb \u09b8\u09c7\u09a8\u09cd\u09a8\u09c0" },
            { "ce", "\u099a\u09c7\u099a\u09c7\u09a8" },
            { "ch", "\u099a\u09be\u09ae\u09cb\u09b0\u09cb" },
            { "co", "\u0995\u09b0\u09cd\u09b8\u09bf\u0995\u09be\u09a8" },
            { "Orya", metaValue_or },
            { "cr", "\u0995\u09cd\u09b0\u09bf" },
            { "cs", "\u099a\u09c7\u0995" },
            { "cu", "\u099a\u09be\u09b0\u09cd\u099a \u09b8\u09cd\u09b2\u09be\u09ad\u09bf\u0995" },
            { "cv", "\u099a\u09c1\u09ac\u09be\u09b8" },
            { "cy", "\u0993\u09af\u09bc\u09c7\u09b2\u09b6" },
            { "type.nu.ethi", "\u0987\u09a5\u09bf\u09af\u09bc\u09cb\u09aa\u09bf\u0995 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "Yiii", "\u0989\u0987" },
            { "da", "\u09a1\u09c7\u09a8\u09bf\u09b6" },
            { "pt_PT", "\u0987\u0989\u09b0\u09cb\u09aa\u09c7\u09b0 \u09aa\u09b0\u09cd\u09a4\u09c1\u0997\u09c0\u099c" },
            { "de", "\u099c\u09be\u09b0\u09cd\u09ae\u09be\u09a8" },
            { "type.cf.standard", "\u09ae\u09be\u09a8\u0995 \u09ae\u09c1\u09a6\u09cd\u09b0\u09be \u09ac\u09bf\u09a8\u09cd\u09af\u09be\u09b8" },
            { "bej", "\u09ac\u09c7\u099c\u09be" },
            { "din", "\u09a1\u09bf\u0982\u0995\u09be" },
            { "Bugi", "\u09ac\u09c1\u0997\u09bf" },
            { "bem", "\u09ac\u09c7\u09ae\u09cd\u09ac\u09be" },
            { "sga", "\u09aa\u09cd\u09b0\u09be\u099a\u09c0\u09a8 \u0986\u0987\u09b0\u09bf\u09b6" },
            { "type.nu.mong", "\u09ae\u0999\u09cd\u0997\u09cb\u09b2\u09c0\u09af\u09bc \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "dv", "\u09a6\u09bf\u09ac\u09c7\u09b9\u09bf" },
            { "es_419", "\u09b2\u09cd\u09af\u09be\u099f\u09bf\u09a8 \u0986\u09ae\u09c7\u09b0\u09bf\u0995\u09be\u09a8 \u09b8\u09cd\u09aa\u09cd\u09af\u09be\u09a8\u09bf\u09b6" },
            { "dz", "\u099c\u09cb\u0999\u09cd\u0997\u09be" },
            { "bez", "\u09ac\u09c7\u09a8\u09be" },
            { "type.ca.chinese", "\u099a\u09c0\u09a8\u09be \u0995\u09cd\u09af\u09be\u09b2\u09c7\u09a8\u09cd\u09a1\u09be\u09b0" },
            { "dje", "\u099c\u09be\u09b0\u09cd\u09ae\u09be" },
            { "type.nu.grek", "\u0997\u09cd\u09b0\u09bf\u0995 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "ee", "\u0987\u0989\u09af\u09bc\u09bf" },
            { "type.lb.normal", "\u09b8\u09be\u09a7\u09be\u09b0\u09a3 \u09b2\u09be\u0987\u09a8 \u09ac\u09bf\u09ad\u09be\u099c\u0995 \u09b6\u09c8\u09b2\u09c0" },
            { "ro_MD", "\u09ae\u09b2\u09a6\u09be\u09ad\u09bf\u09af\u09bc" },
            { "el", metaValue_el },
            { "en", "\u0987\u0982\u09b0\u09c7\u099c\u09bf" },
            { "eo", "\u098f\u09b8\u09cd\u09aa\u09c7\u09b0\u09be\u09a8\u09cd\u09a4\u09cb" },
            { "type.co.big5han", "\u09aa\u09cd\u09b0\u09a5\u09be\u0997\u09a4 \u099a\u09c0\u09a8\u09be \u09b8\u099c\u09cd\u099c\u09be\u0995\u09cd\u09b0\u09ae - \u09ac\u09bf\u0997\u09eb" },
            { "es", "\u09b8\u09cd\u09aa\u09cd\u09af\u09be\u09a8\u09bf\u09b6" },
            { "et", "\u098f\u09b8\u09cd\u09a4\u09cb\u09a8\u09c0\u09af\u09bc" },
            { "Hanb", "\u09b9\u09cd\u09af\u09be\u09a8\u09ac\u09bf" },
            { "eu", "\u09ac\u09be\u09b8\u09cd\u0995" },
            { "Buhd", "\u09ac\u09c1\u09b9\u09bf\u09a1" },
            { "Hang", "\u09b9\u09be\u0999\u09cd\u0997\u09c1\u09b2" },
            { "Samr", "\u09b8\u09ae\u09c7\u09b0\u09bf\u099f\u09a8" },
            { "shi", "\u09a4\u09be\u099a\u09c7\u09b2\u09b9\u09bf\u09a4" },
            { "hsb", "\u0989\u099a\u09cd\u099a \u09b8\u09cb\u09b0\u09cd\u09ac\u09bf\u09af\u09bc\u09be\u09a8" },
            { "Hani", "\u09b9\u09cd\u09af\u09be\u09a8" },
            { "shn", "\u09b6\u09be\u09a8" },
            { "Hano", "\u09b9\u09cd\u09af\u09be\u09a8\u09c1\u09a8\u09c1" },
            { "fa", "\u09ab\u09be\u09b0\u09cd\u09b8\u09bf" },
            { "Hans", "\u09b8\u09b0\u09b2\u09c0\u0995\u09c3\u09a4" },
            { "type.nu.latn", "\u0993\u09af\u09bc\u09c7\u09b8\u09cd\u099f\u09be\u09b0\u09cd\u09a8 \u09a1\u09bf\u099c\u09bf\u099f" },
            { "Hant", "\u0990\u09a4\u09bf\u09b9\u09cd\u09af\u09ac\u09be\u09b9\u09c0" },
            { "ff", "\u09ab\u09c1\u09b2\u09be\u09b9\u09cd" },
            { "hsn", "Xiang \u099a\u09c0\u09a8\u09be" },
            { "fi", "\u09ab\u09bf\u09a8\u09bf\u09b6" },
            { "fj", "\u09ab\u09bf\u099c\u09bf\u0986\u09a8" },
            { "fon", "\u09ab\u09a8" },
            { "bgn", "\u09aa\u09b6\u09cd\u099a\u09bf\u09ae \u09ac\u09be\u09b2\u09cb\u099a\u09bf" },
            { "yue", "\u0995\u09cd\u09af\u09be\u09a8\u09cd\u099f\u09cb\u09a8\u09bf\u099c" },
            { "fo", "\u09ab\u09be\u09b0\u09cb\u09b8" },
            { "type.m0.bgn", "\u0987\u0989\u098f\u09b8 \u09ac\u09bf\u099c\u09bf\u098f\u09a8 \u09ac\u09b0\u09cd\u09a3\u09be\u09a8\u09cd\u09a4\u09b0\u09a3" },
            { "umb", "\u0989\u09ae\u09cd\u09ac\u09c1\u09a8\u09cd\u09a6\u09c1" },
            { "fr", "\u09ab\u09b0\u09be\u09b8\u09bf" },
            { "sid", "\u09b8\u09bf\u09a1\u09be\u09ae\u09cb" },
            { "fy", "\u09aa\u09b6\u09cd\u099a\u09bf\u09ae \u09ab\u09cd\u09b0\u09bf\u09b8\u09bf\u09af\u09bc\u09be\u09a8" },
            { "ga", "\u0986\u0987\u09b0\u09bf\u09b6" },
            { "gd", "\u09b8\u09cd\u0995\u099f\u09b8-\u0997\u09cd\u09af\u09c7\u09b2\u09bf\u0995" },
            { "gl", "\u0997\u09cd\u09af\u09be\u09b2\u09bf\u09b6\u09bf\u09af\u09bc" },
            { "gn", "\u0997\u09c1\u09af\u09bc\u09be\u09b0\u09be\u09a8\u09bf" },
            { "bho", "\u09ad\u09cb\u099c\u09aa\u09c1\u09b0\u09bf" },
            { "und", "\u0985\u099c\u09be\u09a8\u09be \u09ad\u09be\u09b7\u09be" },
            { "type.ca.ethiopic-amete-alem", "\u0987\u09a5\u09bf\u0993\u09aa\u09bf\u0993 \u0986\u09ae\u09c7\u09a4\u09c7 \u0986\u09b2\u09c7\u09ae \u0995\u09cd\u09af\u09be\u09b2\u09c7\u09a8\u09cd\u09a1\u09be\u09b0" },
            { "gu", metaValue_gu },
            { "type.ca.islamic-tbla", "\u0987\u09b8\u09b2\u09be\u09ae\u09bf\u0995 \u09ac\u09b0\u09cd\u09b7\u09aa\u099e\u09cd\u099c\u09c0 (\u099b\u0995\u09ac\u09a6\u09cd\u09a7, \u099c\u09cd\u09af\u09cb\u09a4\u09bf\u09b0\u09cd\u09ac\u09bf\u09a6\u09cd\u09af\u09c0\u09af\u09bc \u09af\u09c1\u0997)" },
            { "gv", "\u09ae\u09cd\u09af\u09be\u0999\u09cd\u0995\u09b8" },
            { "type.nu.osma", "\u0993\u09b8\u09ae\u09be\u09a8\u09bf\u09af\u09bc \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "ha", "\u09b9\u09be\u0989\u09b8\u09be" },
            { "he", metaValue_he },
            { "hi", "\u09b9\u09bf\u09a8\u09cd\u09a6\u09bf" },
            { "hup", "\u09b9\u09c1\u09aa\u09be" },
            { "bik", "\u09ac\u09bf\u0995\u09cb\u09b2" },
            { "bin", "\u09ac\u09bf\u09a8\u09bf" },
            { "ho", "\u09b9\u09bf\u09b0\u09bf \u09ae\u09cb\u09a4\u09c1" },
            { "hr", "\u0995\u09cd\u09b0\u09cb\u09af\u09bc\u09c7\u09b6\u09c0\u09af\u09bc" },
            { "ht", "\u09b9\u09be\u0987\u09a4\u09bf\u09af\u09bc\u09be\u09a8 \u0995\u09cd\u09b0\u09c7\u0993\u09b2" },
            { "hu", "\u09b9\u09be\u0999\u09cd\u0997\u09c7\u09b0\u09c0\u09af\u09bc" },
            { "hy", "\u0986\u09b0\u09cd\u09ae\u09c7\u09a8\u09bf\u09af\u09bc" },
            { "hz", "\u09b9\u09c7\u09b0\u09c7\u09b0\u09cb" },
            { "frc", "\u0995\u09be\u099c\u09c1\u09a8 \u09ab\u09b0\u09be\u09b8\u09bf" },
            { "ia", "\u0987\u09a8\u09cd\u099f\u09be\u09b0\u09b2\u09bf\u0999\u09cd\u0997\u09c1\u09af\u09bc\u09be" },
            { "Jamo", "\u099c\u09cd\u09af\u09be\u09ae\u09cb" },
            { "id", "\u0987\u09a8\u09cd\u09a6\u09cb\u09a8\u09c7\u09b6\u09c0\u09af\u09bc" },
            { "type.nu.tibt", "\u09a4\u09bf\u09ac\u09cd\u09ac\u09a4\u09bf \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "ie", "\u0987\u09a8\u09cd\u099f\u09be\u09b0\u09b2\u09bf\u0999\u09cd\u0997" },
            { "ig", "\u0987\u0997\u09cd\u200c\u09ac\u09cb" },
            { "ii", "\u09b8\u09bf\u099a\u09c1\u09af\u09bc\u09be\u09a8 \u09af\u09bc\u09bf" },
            { "frm", "\u09ae\u09a7\u09cd\u09af \u09ab\u09b0\u09be\u09b8\u09bf" },
            { "ik", "\u0987\u09a8\u09c1\u09aa\u09bf\u09af\u09bc\u09be\u0995" },
            { "fro", "\u09aa\u09cd\u09b0\u09be\u099a\u09c0\u09a8 \u09ab\u09b0\u09be\u09b8\u09bf" },
            { "io", "\u0987\u09a1\u09cb" },
            { "frs", "\u09aa\u09c2\u09b0\u09cd\u09ac \u09ab\u09cd\u09b0\u09bf\u09b8\u09bf\u09af\u09bc" },
            { "frr", "\u0989\u09a4\u09cd\u09a4\u09b0\u09be\u099e\u09cd\u099a\u09b2\u09c0\u09af\u09bc \u09ab\u09cd\u09b0\u09bf\u09b8\u09bf\u09af\u09bc\u09be\u09a8" },
            { "is", "\u0986\u0987\u09b8\u09b2\u09cd\u09af\u09be\u09a8\u09cd\u09a1\u09c0\u09af\u09bc" },
            { "it", "\u0987\u09a4\u09be\u09b2\u09bf\u09af\u09bc" },
            { "iu", "\u0987\u09a8\u09c1\u0995\u09cd\u099f\u09bf\u099f\u09c1\u099f" },
            { "Mlym", metaValue_ml },
            { "ja", "\u099c\u09be\u09aa\u09be\u09a8\u09bf" },
            { "Sara", "\u09b8\u09be\u09b0\u09be\u09a4\u09bf" },
            { "doi", "\u09a1\u09cb\u0997\u09b0\u09bf" },
            { "type.nu.lepc", "\u09b2\u09c7\u09aa\u099a\u09be \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "sma", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3\u09be\u099e\u09cd\u099a\u09b2\u09c0\u09af\u09bc \u09b8\u09be\u09ae\u09bf" },
            { "jv", metaValue_jv },
            { "Shaw", "\u09b8\u09be\u09ad\u09bf\u09af\u09bc\u09be\u09a8" },
            { "mad", "\u09ae\u09be\u09a6\u09c1\u09b0\u09c7\u09b8\u09c7" },
            { "smj", "\u09b2\u09c1\u09b2\u09c7 \u09b8\u09be\u09ae\u09bf" },
            { "mag", "\u09ae\u09be\u0997\u09be\u09b9\u09bf" },
            { "mai", "\u09ae\u09c8\u09a5\u09bf\u09b2\u09bf" },
            { "smn", "\u0987\u09a8\u09be\u09b0\u09bf \u09b8\u09be\u09ae\u09bf" },
            { "ka", metaValue_ka },
            { "bla", "\u09b8\u09bf\u0995\u09b8\u09bf\u0995\u09be" },
            { "mak", "\u09ae\u09cd\u09af\u09be\u0995\u09be\u09b8\u09be\u09b0" },
            { "wuu", "Wu \u099a\u09c0\u09a8\u09be" },
            { "sms", "\u09b8\u09cd\u0995\u09cb\u09b2\u09cd\u099f \u09b8\u09be\u09ae\u09bf" },
            { "man", "\u09ae\u09cd\u09af\u09be\u09a8\u09cd\u09a1\u09bf\u0999\u09cd\u0997\u09cb" },
            { "kg", "\u0995\u0999\u09cd\u0997\u09cb" },
            { "Goth", "\u0997\u09cb\u09a5\u09bf\u0995" },
            { "ki", "\u0995\u09bf\u0995\u09c1\u09af\u09bc\u09c1" },
            { "mas", "\u09ae\u09be\u09b8\u09be\u0987" },
            { "kj", "\u0995\u09cb\u09af\u09bc\u09be\u09a8\u09bf\u09af\u09bc\u09be\u09ae\u09be" },
            { "kk", "\u0995\u09be\u099c\u09be\u0996" },
            { "kl", "\u0995\u09cd\u09af\u09be\u09b2\u09be\u09b2\u09cd\u09b2\u09bf\u09b8\u09c1\u099f" },
            { "km", "\u0996\u09ae\u09c7\u09b0" },
            { "kn", "\u0995\u09a8\u09cd\u09a8\u09a1\u09bc" },
            { "ko", metaValue_ko },
            { "kr", "\u0995\u09be\u09a8\u09c1\u09b0\u09bf" },
            { "ks", "\u0995\u09be\u09b6\u09cd\u09ae\u09c0\u09b0\u09bf" },
            { "Cirt", "\u0995\u09bf\u09b0\u09cd\u099f" },
            { "Lepc", "\u09b2\u09c7\u09aa\u09cd\u099a\u09be" },
            { "Avst", "\u0986\u09ad\u09c7\u09b8\u09a4\u09be\u09a8" },
            { "ku", "\u0995\u09c1\u09b0\u09cd\u09a6\u09bf\u09b6" },
            { "kv", "\u0995\u09cb\u09ae\u09bf" },
            { "kw", "\u0995\u09b0\u09cd\u09a3\u09bf\u09b6" },
            { "ky", "\u0995\u09bf\u09b0\u09cd\u0997\u09bf\u099c" },
            { "snk", "\u09b8\u09cb\u09a8\u09bf\u0999\u09cd\u0995\u09c7" },
            { "la", "\u09b2\u09be\u09a4\u09bf\u09a8" },
            { "lb", "\u09b2\u09c1\u0995\u09cd\u09b8\u09c7\u09ae\u09ac\u09be\u09b0\u09cd\u0997\u09c0\u09af\u09bc" },
            { "type.nu.mlym", "\u09ae\u09be\u09b2\u09af\u09bc\u09be\u09b2\u09ae \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "lg", "\u0997\u09be\u09a8\u09cd\u09a1\u09be" },
            { "Roro", "\u09b0\u09cb\u0999\u09cd\u0997\u09cb\u09b0\u09cb\u0999\u09cd\u0997\u09cb" },
            { "li", "\u09b2\u09bf\u09ae\u09cd\u09ac\u09c1\u09b0\u09cd\u0997\u09bf\u09b6" },
            { "Tibt", metaValue_bo },
            { "ln", "\u09b2\u09bf\u0999\u09cd\u0997\u09be\u09b2\u09be" },
            { "fur", "\u09ab\u09cd\u09b0\u09bf\u0989\u09b2\u09bf\u09af\u09bc\u09be\u09a8" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "\u0987\u09ae\u09cd\u09aa\u09c7\u09b0\u09bf\u09af\u09bc\u09be\u09b2 \u09aa\u09b0\u09bf\u09ae\u09be\u09aa \u09b8\u09bf\u09b8\u09cd\u099f\u09c7\u09ae" },
            { "type.nu.lana", "\u099f\u09be\u0987 \u09a5\u09be\u09ae \u09b9\u09cb\u09b0\u09be \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "lt", "\u09b2\u09bf\u09a5\u09c1\u09af\u09bc\u09c7\u09a8\u09c0\u09af\u09bc" },
            { "lu", "\u09b2\u09c1\u09ac\u09be-\u0995\u09be\u099f\u09be\u0999\u09cd\u0997\u09be" },
            { "lv", "\u09b2\u09be\u09a4\u09cd\u200c\u09ad\u09c0\u09af\u09bc" },
            { "sog", "\u09b8\u09cb\u0997\u09a1\u09bf\u09af\u09bc\u09be\u09a8" },
            { "mg", "\u09ae\u09be\u09b2\u09be\u0997\u09be\u09b8\u09bf" },
            { "mh", "\u09ae\u09be\u09b0\u09cd\u09b6\u09be\u09b2\u09bf\u099c" },
            { "type.co.ducet", "\u09a1\u09bf\u09ab\u09b2\u09cd\u099f \u0987\u0989\u09a8\u09bf\u0995\u09cb\u09a1 \u09ac\u09be\u099b\u09be\u0987 \u09ac\u09bf\u09a8\u09cd\u09af\u09be\u09b8" },
            { "mi", "\u09ae\u09be\u0993\u09b0\u09bf" },
            { "mk", "\u09ae\u09cd\u09af\u09be\u09b8\u09bf\u09a1\u09cb\u09a8\u09c0\u09af\u09bc" },
            { "ml", metaValue_ml },
            { "mn", "\u09ae\u0999\u09cd\u0997\u09cb\u09b2\u09bf\u09af\u09bc" },
            { "mr", "\u09ae\u09be\u09b0\u09be\u09a0\u09bf" },
            { "ms", "\u09ae\u09be\u09b2\u09af\u09bc" },
            { "mt", "\u09ae\u09b2\u09cd\u099f\u09bf\u09af\u09bc" },
            { "my", "\u09ac\u09b0\u09cd\u09ae\u09bf" },
            { "Saur", "\u09b8\u09cc\u09b0\u09be\u09b7\u09cd\u099f\u09cd\u09b0" },
            { "Armn", "\u0986\u09b0\u09cd\u09ae\u09c7\u09a8\u09c0\u09af\u09bc" },
            { "mdf", "\u09ae\u09cb\u0995\u09b6\u09be" },
            { "dsb", "\u09a8\u09bf\u09ae\u09cd\u09a8\u09a4\u09b0 \u09b8\u09cb\u09b0\u09cd\u09ac\u09bf\u09af\u09bc\u09be\u09a8" },
            { "Armi", "\u0986\u09b0\u09ae\u09bf" },
            { "na", metaValue_NR },
            { "type.co.search", "\u09b8\u09be\u09a7\u09be\u09b0\u09a3-\u0989\u09a6\u09cd\u09a6\u09c7\u09b6\u09cd\u09af\u09c7 \u0985\u09a8\u09c1\u09b8\u09a8\u09cd\u09a7\u09be\u09a8" },
            { "nb", "\u09a8\u09b0\u0993\u09af\u09bc\u09c7\u099c\u09bf\u09af\u09bc\u09be\u09a8 \u09ac\u09cb\u0995\u09ae\u09be\u09b2" },
            { "nd", "\u0989\u09a4\u09cd\u09a4\u09b0 \u098f\u09a8\u09cd\u09a6\u09c7\u09ac\u09bf\u09b2\u09bf" },
            { "ne", "\u09a8\u09c7\u09aa\u09be\u09b2\u09c0" },
            { "ng", "\u098f\u09a8\u09cd\u09a6\u09cb\u0999\u09cd\u0997\u09be" },
            { "mdr", "\u09ae\u09cd\u09af\u09be\u09a3\u09cd\u09a1\u09be\u09b0" },
            { "nl", "\u0993\u09b2\u09a8\u09cd\u09a6\u09be\u099c" },
            { "nn", "\u09a8\u09b0\u0993\u09af\u09bc\u09c7\u099c\u09c0\u09af\u09bc\u09be\u09a8 \u09a8\u09bf\u09a8\u09b0\u09cd\u09b8\u09cd\u0995" },
            { "no", "\u09a8\u09b0\u0993\u09af\u09bc\u09c7\u099c\u09c0\u09af\u09bc" },
            { "nr", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u098f\u09a8\u09a1\u09c7\u09ac\u09c7\u09b2\u09c7" },
            { "type.nu.modi", "\u09ae\u09cb\u09a6\u09bf \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "nv", "\u09a8\u09be\u09ad\u09be\u099c\u09cb" },
            { "kaa", "\u0995\u09be\u09b0\u09be-\u0995\u09be\u09b2\u09cd\u09aa\u09be\u0995" },
            { "ny", "\u09a8\u09be\u09af\u09bc\u09be\u099e\u09cd\u099c\u09be" },
            { "kac", "\u0995\u09be\u099a\u09bf\u09a8" },
            { "kab", "\u0995\u09be\u09ac\u09be\u0987\u09b2\u09c7" },
            { "oc", "\u0985\u0995\u09cd\u09b8\u09bf\u099f\u09be\u09a8" },
            { "kaj", "\u0985\u099c\u09cd\u099c\u09c1" },
            { "kam", "\u0995\u09be\u09ae\u09cd\u09ac\u09be" },
            { "men", "\u09ae\u09c7\u09a8\u09cd\u09a1\u09c7" },
            { "oj", "\u0993\u099c\u09bf\u09ac\u0993\u09af\u09bc\u09be" },
            { "mer", "\u09ae\u09c7\u09b0\u09c1" },
            { "type.nu.armn", "\u0986\u09b0\u09cd\u09ae\u09c7\u09a8\u09c0\u09af\u09bc \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "om", "\u0985\u09b0\u09cb\u09ae\u09cb" },
            { "kaw", "\u0995\u09be\u0989\u0987" },
            { "or", metaValue_or },
            { "os", "\u0993\u09b8\u09c7\u099f\u09bf\u0995" },
            { "kbd", "\u0995\u09be\u09ac\u09be\u09b0\u09cd\u09a1\u09bf\u09af\u09bc\u09be\u09a8" },
            { "mfe", "\u09ae\u09b0\u09bf\u09b8\u09bf\u09af\u09bc\u09be\u09a8" },
            { "srn", "\u09b8\u09cd\u09b0\u09be\u09a8\u09be\u09a8 \u099f\u09cb\u0999\u09cd\u0997\u09cb" },
            { "pa", "\u09aa\u09be\u099e\u09cd\u099c\u09be\u09ac\u09c0" },
            { "dua", "\u09a6\u09c1\u09af\u09bc\u09be\u09b2\u09be" },
            { "srr", "\u09b8\u09c7\u09b0\u09c7\u09b0" },
            { "pi", "\u09aa\u09be\u09b2\u09bf" },
            { "pl", "\u09aa\u09cb\u09b2\u09bf\u09b6" },
            { "dum", "\u09ae\u09a7\u09cd\u09af \u09a1\u09be\u099a" },
            { "type.nu.saur", "\u09b8\u09cc\u09b0\u09be\u09b7\u09cd\u099f\u09cd\u09b0\u09c7\u09b0 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.ca.dangi", "\u09a6\u09be\u0999\u09cd\u0997\u09c0 \u0995\u09cd\u09af\u09be\u09b2\u09c7\u09a8\u09cd\u09a1\u09be\u09b0" },
            { "ps", "\u09aa\u09c1\u09b6\u09a4\u09c1" },
            { "pt", "\u09aa\u09b0\u09cd\u09a4\u09c1\u0997\u09c0\u099c" },
            { "mga", "\u09ae\u09a7\u09cd\u09af \u0986\u0987\u09b0\u09bf\u09b6" },
            { "key.co", "\u09ac\u09be\u099b\u09be\u0987 \u09ac\u09bf\u09a8\u09cd\u09af\u09be\u09b8" },
            { "pt_BR", "\u09ac\u09cd\u09b0\u09be\u099c\u09bf\u09b2\u09c7\u09b0 \u09aa\u09b0\u09cd\u09a4\u09c1\u0997\u09c0\u099c" },
            { "kcg", "\u099f\u09be\u0987\u09af\u09bc\u09be\u09aa" },
            { "mgh", "\u09ae\u09be\u0996\u09c1\u09af\u09bc\u09be-\u09ae\u09c7\u09a4\u09cd\u09a4\u09cb" },
            { "key.cf", "\u09ae\u09c1\u09a6\u09cd\u09b0\u09cd\u09af\u09be \u09ab\u09b0\u09ae\u09cd\u09af\u09be\u099f" },
            { "type.nu.nkoo", "\u098f\u09a8\u2019\u0995\u09cb \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "bra", "\u09ac\u09cd\u09b0\u09be\u099c" },
            { "key.ca", "\u0995\u09cd\u09af\u09be\u09b2\u09c7\u09a8\u09cd\u09a1\u09be\u09b0" },
            { "Laoo", metaValue_lo },
            { "mgo", "\u09ae\u09c7\u099f\u09be" },
            { "type.hc.h23", "\u09e8\u09ea \u0998\u09a3\u09cd\u099f\u09be\u09b0 \u09b9\u09bf\u09b8\u09be\u09ac\u09c7 (\u09e6\u2013\u09e8\u09e9)" },
            { "type.hc.h24", "\u09e8\u09ea \u0998\u09a3\u09cd\u099f\u09be\u09b0 \u09b9\u09bf\u09b8\u09be\u09ac\u09c7 (\u09e7\u2013\u09e8\u09ea)" },
            { "ssy", "\u09b8\u09be\u09b9\u09cb" },
            { "type.nu.mymr", "\u09ae\u09be\u09af\u09bc\u09be\u09a8\u09ae\u09be\u09b0 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "qu", "\u0995\u09c7\u099a\u09c1\u09af\u09bc\u09be" },
            { "zap", "\u099c\u09be\u09aa\u09cb\u099f\u09c7\u0995" },
            { "brx", "\u09ac\u09cb\u09a1\u09bc\u09cb" },
            { "Lana", "\u09b2\u09be\u09a8\u09cd\u09a8\u09be" },
            { "kde", "\u09ae\u09be\u0995\u09cb\u09a8\u09cd\u09a6\u09c7" },
            { "Ethi", "\u0987\u09a5\u09bf\u0993\u09aa\u09bf\u09af\u09bc" },
            { "type.hc.h12", "\u09e7\u09e8 \u0998\u09a3\u09cd\u099f\u09be\u09b0 \u09b9\u09bf\u09b8\u09be\u09ac\u09c7 (\u09e7\u2013\u09e7\u09e8)" },
            { "type.hc.h11", "\u09e7\u09e8 \u0998\u09a3\u09cd\u099f\u09be\u09b0 \u09b9\u09bf\u09b8\u09be\u09ac\u09c7 (\u09e6\u2013\u09e7\u09e7)" },
            { "rm", "\u09b0\u09cb\u09ae\u09be\u09a8\u09cd\u09b8" },
            { "rn", "\u09b0\u09c1\u09a8\u09cd\u09a6\u09bf" },
            { "key.cu", "\u09ae\u09c1\u09a6\u09cd\u09b0\u09be" },
            { "ro", "\u09b0\u09cb\u09ae\u09be\u09a8\u09c0\u09af\u09bc" },
            { "type.nu.orya", "\u0993\u09a1\u09bc\u09bf\u09af\u09bc\u09be \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.hanidec", "\u099a\u09c8\u09a8\u09bf\u0995 \u09a6\u09b6\u09ae\u09bf\u0995 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "ru", "\u09b0\u09c1\u09b6" },
            { "rw", "\u0995\u09bf\u09a8\u09af\u09bc\u09be\u09b0\u09cb\u09af\u09bc\u09be\u09a8\u09cd\u09a1\u09be" },
            { "zbl", "\u099a\u09bf\u09a4\u09cd\u09b0 \u09ad\u09be\u09b7\u09be" },
            { "kea", "\u0995\u09be\u09ac\u09c1\u09ad\u09be\u09b0\u09a6\u09bf\u09af\u09bc\u09be\u09a8\u09c1" },
            { "mic", "\u09ae\u09bf\u0995\u09ae\u09cd\u09af\u09be\u0995" },
            { "suk", "\u09b8\u09c1\u0995\u09c1\u09ae\u09be" },
            { "en_AU", "\u0985\u09b8\u09cd\u099f\u09cd\u09b0\u09c7\u09b2\u09c0\u09af\u09bc \u0987\u0982\u09b0\u09c7\u099c\u09bf" },
            { "sa", "\u09b8\u0982\u09b8\u09cd\u0995\u09c3\u09a4" },
            { "sc", "\u09b8\u09be\u09b0\u09cd\u09a1\u09bf\u09a8\u09bf\u09af\u09bc\u09be\u09a8" },
            { "sus", "\u09b8\u09c1\u09b8\u09c1" },
            { "sd", "\u09b8\u09bf\u09a8\u09cd\u09a7\u09bf" },
            { "se", "\u0989\u09a4\u09cd\u09a4\u09b0\u09be\u099e\u09cd\u099a\u09b2\u09c0\u09af\u09bc \u09b8\u09be\u09ae\u09bf" },
            { "min", "\u09ae\u09bf\u09a8\u09be\u0982\u0995\u09be\u09ac\u09be\u0989" },
            { "sg", "\u09b8\u09be\u0999\u09cd\u0997\u09cb" },
            { "sh", "\u09b8\u09be\u09b0\u09cd\u09ac\u09cb-\u0995\u09cd\u09b0\u09cb\u09af\u09bc\u09c7\u09b6\u09bf\u09af\u09bc" },
            { "si", "\u09b8\u09bf\u0982\u09b9\u09b2\u09c0" },
            { "sux", "\u09b8\u09c1\u09ae\u09c7\u09b0\u09c0\u09af\u09bc" },
            { "sk", "\u09b8\u09cd\u09b2\u09cb\u09ad\u09be\u0995" },
            { "sl", "\u09b8\u09cd\u09b2\u09cb\u09ad\u09c7\u09a8\u09c0\u09af\u09bc" },
            { "sm", "\u09b8\u09be\u09ae\u09cb\u09af\u09bc\u09be\u09a8" },
            { "sn", "\u09b6\u09cb\u09a8\u09be" },
            { "so", "\u09b8\u09cb\u09ae\u09be\u09b2\u09bf" },
            { "type.nu.arab", "\u0986\u09b0\u09ac\u09bf-\u09ad\u09be\u09b0\u09a4\u09c0\u09af\u09bc \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "sq", "\u0986\u09b2\u09ac\u09c7\u09a8\u09c0\u09af\u09bc" },
            { "sr", "\u09b8\u09be\u09b0\u09cd\u09ac\u09c0\u09af\u09bc" },
            { "ss", "\u09b8\u09cb\u09af\u09bc\u09be\u09a4\u09bf" },
            { "type.cf.account", "\u09b9\u09bf\u09b8\u09be\u09ac\u09c7\u09b0 \u09ae\u09c1\u09a6\u09cd\u09b0\u09be \u09ac\u09bf\u09a8\u09cd\u09af\u09be\u09b8" },
            { "Java", metaValue_jv },
            { "st", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a8 \u09b8\u09cb\u09a5\u09cb" },
            { "su", "\u09b8\u09c1\u09a6\u09be\u09a8\u09c0" },
            { "sv", "\u09b8\u09c1\u0987\u09a1\u09bf\u09b6" },
            { "sw", "\u09b8\u09cb\u09af\u09bc\u09be\u09b9\u09bf\u09b2\u09bf" },
            { "type.nu.hantfin", "\u0990\u09a4\u09bf\u09b9\u09cd\u09af\u09ac\u09be\u09b9\u09c0 \u099a\u09c8\u09a8\u09bf\u0995 \u0986\u09b0\u09cd\u09a5\u09bf\u0995 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "ibb", "\u0987\u09ac\u09bf\u09ac\u09bf\u0993" },
            { "iba", "\u0987\u09ac\u09be\u09a8" },
            { "ta", metaValue_ta },
            { "142", "\u098f\u09b6\u09bf\u09af\u09bc\u09be" },
            { "bua", "\u09ac\u09c1\u09b0\u09bf\u09af\u09bc\u09be\u09a4" },
            { "143", "\u09ae\u09a7\u09cd\u09af \u098f\u09b6\u09bf\u09af\u09bc\u09be" },
            { "te", "\u09a4\u09c7\u09b2\u09c1\u0997\u09c1" },
            { "145", "\u09aa\u09b6\u09cd\u099a\u09bf\u09ae \u098f\u09b6\u09bf\u09af\u09bc\u09be" },
            { "tg", "\u09a4\u09be\u099c\u09bf\u0995" },
            { "th", metaValue_th },
            { "ti", "\u09a4\u09bf\u0997\u09b0\u09bf\u09a8\u09bf\u09af\u09bc\u09be" },
            { "bug", "\u09ac\u09c1\u0997\u09bf\u09a8\u09bf" },
            { "kfo", "\u0995\u09cb\u09b0\u09cb" },
            { "en_CA", "\u0995\u09be\u09a8\u09be\u09a1\u09c0\u09af\u09bc \u0987\u0982\u09b0\u09c7\u099c\u09bf" },
            { "tk", "\u09a4\u09c1\u09b0\u09cd\u0995\u09ae\u09c7\u09a8\u09c0" },
            { "tl", "\u09a4\u09be\u0997\u09be\u09b2\u0997" },
            { "tn", "\u09b8\u09cb\u09af\u09bc\u09be\u09a8\u09be" },
            { "to", "\u099f\u09cb\u0999\u09cd\u0997\u09be\u09a8" },
            { "dyo", "\u099c\u09cb\u09b2\u09be-\u09ab\u09a8\u09c0" },
            { "type.nu.jpan", "\u099c\u09be\u09aa\u09be\u09a8\u09bf \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "tr", "\u09a4\u09c1\u09b0\u09cd\u0995\u09c0" },
            { "Cakm", metaValue_ccp },
            { "ts", "\u09b8\u0999\u09cd\u0997\u09be" },
            { "swb", "\u0995\u09ae\u09cb\u09b0\u09bf\u09af\u09bc\u09be\u09a8" },
            { "tt", "\u09a4\u09be\u09a4\u09be\u09b0" },
            { "dyu", "\u09a1\u09bf\u0989\u09b2\u09be" },
            { "tw", "\u099f\u09cb\u09af\u09bc\u09be\u0987" },
            { "ty", "\u09a4\u09be\u09b9\u09bf\u09a4\u09bf\u09af\u09bc\u09be\u09a8" },
            { "150", "\u0987\u0989\u09b0\u09cb\u09aa" },
            { "151", "\u09aa\u09c2\u09b0\u09cd\u09ac \u0987\u0989\u09b0\u09cb\u09aa" },
            { "type.nu.mathsanb", "\u0997\u09be\u09a3\u09bf\u09a4\u09bf\u0995 \u09b8\u09cd\u09af\u09be\u09a8\u09cd\u09b8-\u09b6\u09c7\u09b0\u09bf\u09ab \u09ac\u09cb\u09b2\u09cd\u09a1 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "154", "\u0989\u09a4\u09cd\u09a4\u09b0 \u0987\u0989\u09b0\u09cb\u09aa" },
            { "dzg", "\u09a6\u09be\u099c\u09be\u0997\u09be" },
            { "155", "\u09aa\u09b6\u09cd\u099a\u09bf\u09ae \u0987\u0989\u09b0\u09cb\u09aa" },
            { "ug", "\u0989\u0987\u0998\u09c1\u09b0" },
            { "Kore", metaValue_ko },
            { "Ital", "\u09aa\u09cd\u09b0\u09be\u099a\u09c0\u09a8 \u0987\u09a4\u09be\u09b2\u09bf" },
            { "Zyyy", "\u09b8\u09be\u09a7\u09be\u09b0\u09a8" },
            { "uk", "\u0987\u0989\u0995\u09cd\u09b0\u09c7\u09a8\u09c0\u09af\u09bc" },
            { "type.ca.coptic", "\u0995\u09aa\u099f\u09bf\u0995 \u0995\u09cd\u09af\u09be\u09b2\u09c7\u09a8\u09cd\u09a1\u09be\u09b0" },
            { "ur", "\u0989\u09b0\u09cd\u09a6\u09c1" },
            { "xal", "\u0995\u09be\u09b2\u09cd\u09ae\u0987\u0995" },
            { "zen", "\u099c\u09c7\u09a8\u09be\u0997\u09be" },
            { "uz", "\u0989\u099c\u09ac\u09c7\u0995\u09c0\u09af\u09bc" },
            { "kha", "\u0996\u09be\u09b6\u09bf" },
            { "nds_NL", "\u09b2\u09cb \u09b8\u09cd\u09af\u09be\u0995\u09cd\u09b8\u09a8" },
            { "Sylo", "\u09b8\u09bf\u09b2\u09c7\u099f\u09bf \u09a8\u09be\u0997\u09b0\u09bf" },
            { "ve", "\u09ad\u09c7\u09a8\u09cd\u09a1\u09be" },
            { "type.ca.roc", "\u09ae\u09bf\u0999\u09cd\u0997\u09c1\u0993 \u0995\u09cd\u09af\u09be\u09b2\u09c7\u09a8\u09cd\u09a1\u09be\u09b0" },
            { "vi", "\u09ad\u09bf\u09af\u09bc\u09c7\u09a4\u09a8\u09be\u09ae\u09c0" },
            { "kho", "\u0996\u09cb\u099f\u09be\u09a8\u09bf\u099c" },
            { "khq", "\u0995\u09cb\u09af\u09bc\u09b0\u09be \u099a\u09c0\u09a8\u09bf" },
            { "key.hc", "\u09b8\u09ae\u09af\u09bc\u09c7\u09b0 \u09b9\u09bf\u09b8\u09be\u09ac (\u09e7\u09e8 \u09ac\u09be \u09e8\u09ea)" },
            { "vo", "\u09ad\u09cb\u09b2\u09be\u09aa\u09c1\u0995" },
            { "syc", "\u09aa\u09cd\u09b0\u09be\u099a\u09c0\u09a8 \u09b8\u09bf\u09b0\u09bf\u0993" },
            { "type.nu.mathsans", "\u0997\u09be\u09a3\u09bf\u09a4\u09bf\u0995 \u09b8\u09cd\u09af\u09be\u09a8\u09cd\u09b8-\u09b6\u09c7\u09b0\u09bf\u09ab \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "Osma", "\u0993\u09b8\u09ae\u09be\u09a8\u09bf\u09af\u09bc" },
            { "quc", "\u0995\u09bf\u2018\u099a\u09c7" },
            { "type.nu.gonm", "\u09ae\u09be\u09b8\u09be\u09b0\u09be\u09ae \u0997\u09a8\u09cd\u09a1\u09bf \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "gaa", "\u0997\u09be" },
            { "wa", "\u0993\u09af\u09bc\u09be\u09b2\u09c1\u09a8" },
            { "gag", "\u0997\u09be\u0997\u09be\u0989\u099c" },
            { "syr", metaValue_syr },
            { "Grek", metaValue_el },
            { "gan", "gan" },
            { "Lydi", "\u09b2\u09be\u0987\u09a1\u09bf\u09af\u09bc\u09be\u09a8" },
            { "Xsux", "\u09b8\u09c1\u09ae\u09c7\u09b0-\u0986\u0995\u09cd\u0995\u09be\u09a6\u09c0\u09af\u09bc \u0995\u09c0\u09b2\u0995\u09b0\u09c2\u09aa" },
            { "wo", "\u0989\u0993\u09b2\u09cb\u09ab" },
            { "zgh", "\u0986\u09a6\u09b0\u09cd\u09b6 \u09ae\u09b0\u0995\u09cd\u0995\u09cb\u09a8 \u09a4\u09be\u09ae\u09be\u099c\u09bf\u0997\u09be\u09a4" },
            { "ar_001", "\u0986\u09a7\u09c1\u09a8\u09bf\u0995 \u0986\u09a6\u09b0\u09cd\u09b6 \u0986\u09b0\u09ac\u09c0" },
            { "Cans", "\u09b8\u0982\u09af\u09c1\u0995\u09cd\u09a4 \u0995\u09be\u09a8\u09be\u09a1\u09bf\u09af\u09bc\u09be\u09a8 \u0985\u09cd\u09af\u09be\u09ac\u09cd\u09b0\u09cb\u099c\u09bf\u09a8\u09bf\u09af\u09bc\u09be\u09a8 \u09b8\u09bf\u09b2\u09c7\u09ac\u09bf\u0995\u09cd\u09b8" },
            { "gay", "\u0997\u09be\u09af\u09bc\u09cb" },
            { "Mong", "\u09ae\u09cb\u0999\u09cd\u0997\u09cb\u09b2\u09c0\u09af\u09bc" },
            { "mnc", "\u09ae\u09be\u099e\u09cd\u099a\u09c1" },
            { "Latf", "\u09ab\u09cd\u09b0\u09be\u0995\u09cd\u099f\u09c1\u09b0 \u09b2\u09cd\u09af\u09be\u099f\u09bf\u09a8" },
            { "gba", "\u09ac\u09be\u09af\u09bc\u09be" },
            { "mni", "\u09ae\u09a3\u09bf\u09aa\u09c1\u09b0\u09c0" },
            { "Latn", "\u09b2\u09cd\u09af\u09be\u099f\u09bf\u09a8" },
            { "Latg", "\u0997\u09cd\u09af\u09be\u09b2\u09bf\u0995 \u09b2\u09cd\u09af\u09be\u099f\u09bf\u09a8" },
            { "type.nu.hans", "\u09b8\u09b0\u09b2\u09bf\u0995\u09c3\u09a4 \u099a\u09c8\u09a8\u09bf\u0995 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.hant", "\u0990\u09a4\u09bf\u09b9\u09cd\u09af\u09be\u09ac\u09be\u09b9\u09c0 \u099a\u09c8\u09a8\u09bf\u0995 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "xh", "\u099c\u09cb\u09b8\u09be" },
            { "type.nu.romanlow", "\u09b0\u09cb\u09ae\u09be\u09a8 \u099b\u09cb\u099f\u09b9\u09be\u09a4\u09c7\u09b0 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "byn", "\u09ac\u09cd\u09b2\u09bf\u09a8" },
            { "Lyci", "\u09b2\u09be\u0987\u09b8\u09bf\u09af\u09bc\u09be\u09a8" },
            { "osa", "\u0993\u09b8\u09c7\u099c" },
            { "Moon", "\u09ae\u09c1\u09a8" },
            { "moh", "\u09ae\u09cb\u09b9\u09be\u0993\u0995" },
            { "kkj", "\u0995\u09be\u0995\u09cb" },
            { "Syrc", metaValue_syr },
            { "yi", "\u0987\u09af\u09bc\u09c7\u09a6\u09cd\u09a6\u09bf\u09b6" },
            { "mos", "\u09ae\u09b8\u09bf" },
            { "Dsrt", "\u09a6\u09c7\u09b8\u09c7\u09b0\u09be\u09a4" },
            { "yo", "\u0987\u0993\u09b0\u09c1\u09ac\u09be" },
            { "type.nu.traditional", "\u0990\u09a4\u09bf\u09b9\u09cd\u09af\u0997\u09a4 \u09b8\u0982\u0996\u09cd\u09af\u09be\u09b8\u09c2\u099a\u0995" },
            { "es_MX", "\u09ae\u09cd\u09af\u09be\u0995\u09cd\u09b8\u09bf\u0995\u09be\u09a8 \u09b8\u09cd\u09aa\u09cd\u09af\u09be\u09a8\u09bf\u09b6" },
            { "Syrj", "\u09aa\u09b6\u09cd\u099a\u09bf\u09ae\u09be\u099e\u09cd\u099a\u09b2\u09c0\u09af\u09bc \u09b8\u09bf\u09b0\u09bf\u09af\u09bc\u09be\u0995" },
            { "ota", "\u0985\u099f\u09cb\u09ae\u09be\u09a8 \u09a4\u09c1\u09b0\u09cd\u0995\u09bf" },
            { "Syre", "\u098f\u09b8\u09cd\u099f\u09cd\u09b0\u09c7\u0999\u09cd\u0997\u09c7\u09b2\u09cb \u09b8\u09bf\u09b0\u09bf\u09af\u09bc\u09be\u0995" },
            { "vai", metaValue_vai },
            { "za", "\u099d\u09c1\u09cd\u09af\u09bc\u09be\u0999" },
            { "Cari", "\u0995\u09cd\u09af\u09be\u09b0\u09bf\u09af\u09bc\u09be\u09a8" },
            { "kln", "\u0995\u09be\u09b2\u09c7\u09a8\u099c\u09bf\u09a8" },
            { "zh", "\u099a\u09c0\u09a8\u09be" },
            { "Bopo", "\u09ac\u09cb\u09aa\u09cb\u09ae\u09cb\u09ab\u09cb" },
            { "Perm", "\u09aa\u09cd\u09b0\u09be\u099a\u09c0\u09a8 \u09aa\u09be\u09b0\u09cd\u09ae\u09bf\u0995" },
            { "key.lb", "\u09b2\u09be\u0987\u09a8 \u09ac\u09bf\u09ad\u09be\u099c\u0995 \u09b6\u09c8\u09b2\u09c0" },
            { "zu", "\u099c\u09c1\u09b2\u09c1" },
            { "type.co.phonebook", "\u09ab\u09cb\u09a8\u09ac\u09c1\u0995 \u09b8\u099c\u09cd\u099c\u09be\u0995\u09cd\u09b0\u09ae" },
            { "Geor", metaValue_ka },
            { "kmb", "\u0995\u09bf\u09ae\u09cd\u09ac\u09c1\u09a8\u09cd\u09a6\u09c1" },
            { "type.nu.jpanfin", "\u099c\u09be\u09aa\u09be\u09a8\u09bf \u0986\u09b0\u09cd\u09a5\u09bf\u0995 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "Cham", "\u099a\u09cd\u09af\u09be\u09ae" },
            { "gez", "\u0997\u09c0\u099c" },
            { "Syrn", "\u09aa\u09c2\u09b0\u09cd\u09ac\u09be\u099e\u09cd\u099a\u09b2\u09c0\u09af\u09bc \u09b8\u09bf\u09b0\u09bf\u09af\u09bc\u09be\u0995" },
            { "type.nu.mymrshan", "\u09ae\u09be\u09af\u09bc\u09be\u09a8\u09ae\u09be\u09b0 \u09b6\u09be\u09a8 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.olck", "\u0993\u09b2 \u099a\u09bf\u0995\u09bf \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.co.reformed", "\u09b0\u09bf\u09ab\u09b0\u09cd\u09ae\u09a1 \u09ac\u09be\u099b\u09be\u0987 \u09ac\u09bf\u09a8\u09cd\u09af\u09be\u09b8" },
            { "Tglg", "\u099f\u09be\u0997\u09be\u09b2\u0997" },
            { "Egyd", "\u09ae\u09bf\u09b6\u09b0\u09c0\u09af\u09bc \u09a1\u09c7\u09ae\u09cb\u099f\u09bf\u0995" },
            { "Egyh", "\u09ae\u09bf\u09b6\u09b0\u09c0\u09af\u09bc \u09b9\u09be\u09af\u09bc\u09b0\u09c7\u099f\u09bf\u0995" },
            { "ebu", "\u098f\u09ae\u09cd\u09ac\u09c1" },
            { "Egyp", "\u09ae\u09bf\u09b6\u09b0\u09c0\u09af\u09bc \u09b9\u09be\u09af\u09bc\u09be\u09b0\u09cb\u0997\u09cd\u09b2\u09bf\u09aa" },
            { "Geok", "\u099c\u09b0\u09cd\u099c\u09bf\u09af\u09bc \u0996\u09c1\u09ce\u09b8\u09c1\u09b0\u09bf" },
            { "zh_Hans", "\u09b8\u09b0\u09b2\u09c0\u0995\u09c3\u09a4 \u099a\u09c0\u09a8\u09be" },
            { "koi", "\u0995\u09ae\u09bf-\u09aa\u09be\u09b0\u09ae\u09bf\u0986\u0995" },
            { "Hung", "\u09aa\u09c1\u09b0\u09cb\u09a8\u09cb \u09b9\u09be\u0999\u09cd\u0997\u09c7\u09b0\u09c0\u09af\u09bc" },
            { "kok", "\u0995\u09cb\u0999\u09cd\u0995\u09be\u09a8\u09bf" },
            { "kos", "\u0995\u09cb\u09b8\u09cd\u09b0\u09be\u0987\u09a8" },
            { "type.nu.limb", "\u09b2\u09bf\u09ae\u09cd\u09ac\u09c1 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "zh_Hant", "\u0990\u09a4\u09bf\u09b9\u09cd\u09af\u09ac\u09be\u09b9\u09bf \u099a\u09c0\u09a8\u09be" },
            { "Sund", "\u09b8\u09be\u09a8\u09cd\u09a6\u09be\u09a8\u09bf\u099c" },
            { "kpe", "\u0995\u09cd\u200c\u09aa\u09c7\u09b2\u09cd\u09b2\u09c7" },
            { "type.nu.khmr", "\u0996\u09c7\u09ae\u09c7\u09b0 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "ilo", "\u0987\u09b2\u09cb\u0995\u09cb" },
            { "Cprt", "\u09b8\u09be\u0987\u09aa\u09cd\u09b0\u09cb\u09af\u09bc\u09c7\u099f" },
            { "mua", "\u09ae\u09c1\u09a6\u09be\u0999\u09cd\u0997" },
            { "type.nu.guru", "\u0997\u09c1\u09b0\u09c1\u09ae\u09c1\u0996\u09bf \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "mul", "\u098f\u0995\u09be\u09a7\u09bf\u0995 \u09ad\u09be\u09b7\u09be" },
            { "cad", "\u0995\u09cd\u09af\u09be\u09a1\u09cb" },
            { "key.ms", "\u09aa\u09b0\u09bf\u09ae\u09be\u09aa \u09b8\u09bf\u09b8\u09cd\u099f\u09c7\u09ae" },
            { "mus", "\u0995\u09cd\u09b0\u09bf\u0995" },
            { "Glag", "\u0997\u09cd\u09b2\u09be\u0997\u09cb\u09b2\u09bf\u099f\u09bf\u0995" },
            { "gil", "\u0997\u09bf\u09b2\u09ac\u09be\u09b0\u09cd\u099f\u09bf\u099c" },
            { "Cher", "\u099a\u09c7\u09b0\u09cb\u0995\u09bf" },
            { "car", "\u0995\u09cd\u09af\u09be\u09b0\u09bf\u09ac" },
            { "type.nu.tamldec", "\u09a4\u09be\u09ae\u09bf\u09b2 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "krc", "\u0995\u09be\u09b0\u099a\u09c7-\u09ac\u09be\u09b2\u09cd\u0995\u09be\u09b0" },
            { "inh", "\u0987\u0999\u09cd\u0997\u09c1\u09b6" },
            { "fa_AF", "\u09a6\u09be\u09b0\u09bf" },
            { "krl", "\u0995\u09be\u09b0\u09c7\u09b2\u09bf\u09af\u09bc\u09be\u09a8" },
            { "efi", "\u098f\u09ab\u09bf\u0995" },
            { "key.nu", "\u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "kru", "\u0995\u09c1\u09b0\u09c1\u0996" },
            { "ksb", "\u09b6\u09be\u09ae\u09cd\u09ac\u09be\u09b2\u09be" },
            { "Telu", "\u09a4\u09c7\u09b2\u09c7\u0997\u09c1" },
            { "ksf", "\u09ac\u09be\u09ab\u09bf\u09af\u09bc\u09be" },
        };
        return data;
    }
}
