/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_bs extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Grini\u010dko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Acre = new String[] {
               "Acre standardno vreme",
               "",
               "Acre letnje ra\u010dunanje vremena",
               "",
               "Acre vreme",
               "",
            };
        final String[] Apia = new String[] {
               "Apijsko standardno vrijeme",
               "",
               "Apijsko ljetno vrijeme",
               "",
               "Apijsko vrijeme",
               "",
            };
        final String[] Cook = new String[] {
               "Standardno vrijeme na Kukovim ostrvima",
               "",
               "Poluljetno vrijeme na Kukovim ostrvima",
               "",
               "Vrijeme na Kukovim ostrvima",
               "",
            };
        final String[] Cuba = new String[] {
               "Kubansko standardno vrijeme",
               "",
               "Kubansko ljetno vrijeme",
               "",
               "Kubansko vrijeme",
               "",
            };
        final String[] Fiji = new String[] {
               "Standardno vrijeme na Fid\u017eiju",
               "",
               "Fid\u017eijsko ljetno vrijeme",
               "",
               "Vrijeme na Fid\u017eiju",
               "",
            };
        final String[] Gulf = new String[] {
               "Zalivsko standardno vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Hovdsko standardno vrijeme",
               "",
               "Hovdsko ljetno vrijeme",
               "",
               "Hovdsko vrijeme",
               "",
            };
        final String[] Iran = new String[] {
               "Iransko standardno vrijeme",
               "",
               "Iransko ljetno vrijeme",
               "",
               "Iransko vrijeme",
               "",
            };
        final String[] Niue = new String[] {
               "Vrijeme na Ostrvu Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Omsko standardno vrijeme",
               "",
               "Omsko ljetno vrijeme",
               "",
               "Omsko vrijeme",
               "",
            };
        final String[] Peru = new String[] {
               "Peruansko standardno vrijeme",
               "",
               "Peruansko ljetno vrijeme",
               "",
               "Peruansko vrijeme",
               "",
            };
        final String[] Truk = new String[] {
               "\u010cu\u010dko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Vrijeme na Ostrvu Vejk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "\u010cileansko standardno vrijeme",
               "",
               "\u010cileansko ljetno vrijeme",
               "",
               "\u010cileansko vrijeme",
               "",
            };
        final String[] China = new String[] {
               "Kinesko standardno vrijeme",
               "",
               "Kinesko ljetno vrijeme",
               "",
               "Kinesko vrijeme",
               "",
            };
        final String[] Cocos = new String[] {
               "Vrijeme na Ostrvima Kokos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Vrijeme stanice Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Indijsko standardno vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "Japansko standardno vrijeme",
               "",
               "Japansko ljetno vrijeme",
               "",
               "Japansko vrijeme",
               "",
            };
        final String[] Korea = new String[] {
               "Korejsko standardno vrijeme",
               "",
               "Korejsko ljetno vrijeme",
               "",
               "Korejsko vrijeme",
               "",
            };
        final String[] Nauru = new String[] {
               "Vrijeme na Ostrvu Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Nepalsko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Vrijeme na Ostrvu Palau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samoansko standardno vrijeme",
               "",
               "Samoansko ljetno vrijeme",
               "",
               "Samoansko vrijeme",
               "",
            };
        final String[] Syowa = new String[] {
               "Vrijeme stanice Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tongansko standardno vrijeme",
               "",
               "Tongansko ljetno vrijeme",
               "",
               "Tongansko vrijeme",
               "",
            };
        final String[] Alaska = new String[] {
               "Aljaskansko standardno vrijeme",
               "",
               "Aljaskansko ljetno vrijeme",
               "",
               "Aljaskansko vrijeme",
               "",
            };
        final String[] Amazon = new String[] {
               "Amazonsko standardno vrijeme",
               "",
               "Amazonsko ljetno vrijeme",
               "",
               "Amazonsko vrijeme",
               "",
            };
        final String[] Anadyr = new String[] {
               "Anadir standardno vreme",
               "",
               "Anadir letnje ra\u010dunanje vremena",
               "",
               "Anadir vreme",
               "",
            };
        final String[] Azores = new String[] {
               "Azorsko standardno vrijeme",
               "",
               "Azorsko ljetno vrijeme",
               "",
               "Azorsko vrijeme",
               "",
            };
        final String[] Bhutan = new String[] {
               "Butansko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Brunejsko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Uskr\u0161njeostrvsko standardno vrijeme",
               "",
               "Uskr\u0161njeostrvsko ljetno vrijeme",
               "",
               "Uskr\u0161njeostrvsko vrijeme",
               "",
            };
        final String[] Guyana = new String[] {
               "Gvajansko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Izraelsko standardno vrijeme",
               "",
               "Izraelsko ljetno vrijeme",
               "",
               "Izraelsko vrijeme",
               "",
            };
        final String[] Kosrae = new String[] {
               "Vrijeme na Ostrvu Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Vrijeme stanice Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Moskovsko standardno vrijeme",
               "",
               "Moskovsko ljetno vrijeme",
               "",
               "Moskovsko vrijeme",
               "",
            };
        final String[] Ponape = new String[] {
               "Vrijeme na Ostrvu Ponape",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Samara standardno vreme",
               "",
               "Samara letnje ra\u010dunanje vremena",
               "",
               "Samara vreme",
               "",
            };
        final String[] Tahiti = new String[] {
               "Tahi\u0107ansko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Tajpejsko standardno vrijeme",
               "",
               "Tajpejsko ljetno vrijeme",
               "",
               "Tajpejsko vrijeme",
               "",
            };
        final String[] Tuvalu = new String[] {
               "Tuvaluansko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Vrijeme stanice Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Vrijeme na Ostrvima Valis i Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Arabijsko standardno vrijeme",
               "",
               "Arabijsko ljetno vrijeme",
               "",
               "Arabijsko vrijeme",
               "",
            };
        final String[] Armenia = new String[] {
               "Armensko standardno vrijeme",
               "",
               "Armensko ljetno vrijeme",
               "",
               "Armensko vrijeme",
               "",
            };
        final String[] Bolivia = new String[] {
               "Bolivijsko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "\u010catamsko standardno vrijeme",
               "",
               "\u010catamsko ljetno vrijeme",
               "",
               "\u010catamsko vrijeme",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Koordinirano svjetsko vrijeme",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ekvadorsko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambijersko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Gruzijsko standardno vrijeme",
               "",
               "Gruzijsko ljetno vrijeme",
               "",
               "Gruzijsko vrijeme",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkutsko standardno vrijeme",
               "",
               "Irkutsko ljetno vrijeme",
               "",
               "Irkutsko vrijeme",
               "",
            };
        final String[] Magadan = new String[] {
               "Magadansko standardno vrijeme",
               "",
               "Magadansko ljetno vrijeme",
               "",
               "Magadansko vrijeme",
               "",
            };
        final String[] Myanmar = new String[] {
               "Mijanmarsko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Norfol\u0161ko standardno vrijeme",
               "",
               "Norfol\u0161ko ljetno vrijeme",
               "",
               "Norfol\u0161ko vrijeme",
               "",
            };
        final String[] Noronha = new String[] {
               "Standardno vrijeme na ostrvu Fernando di Noronja",
               "",
               "Ljetno vrijeme na ostrvu Fernando di Noronja",
               "",
               "Vrijeme na ostrvu Fernando di Noronja",
               "",
            };
        final String[] Reunion = new String[] {
               "Reunionsko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Vrijeme stanice Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Vrijeme na Solomonskim ostrvima",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Vrijeme na Ostrvu Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Urugvajsko standardno vrijeme",
               "",
               "Urugvajsko ljetno vrijeme",
               "",
               "Urugvajsko vrijeme",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatuansko standardno vrijeme",
               "",
               "Vanuatuansko ljetno vrijeme",
               "",
               "Vanuatuansko vrijeme",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Jakutsko standardno vrijeme",
               "",
               "Jakutsko ljetno vrijeme",
               "",
               "Jakutsko vrijeme",
               "",
            };
        final String[] Atlantic = new String[] {
               "Sjevernoameri\u010dko atlantsko standardno vrijeme",
               "",
               "Sjevernoameri\u010dko atlantsko ljetno vrijeme",
               "",
               "Sjevernoameri\u010dko atlantsko vrijeme",
               "",
            };
        final String[] Brasilia = new String[] {
               "Brazilijsko standardno vrijeme",
               "",
               "Brazilijsko ljetno vrijeme",
               "",
               "Brazilijsko vrijeme",
               "",
            };
        final String[] Chamorro = new String[] {
               "\u010camorsko standardno vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Colombia = new String[] {
               "Kolumbijsko standardno vrijeme",
               "",
               "Kolumbijsko ljetno vrijeme",
               "",
               "Kolumbijsko vrijeme",
               "",
            };
        final String[] Falkland = new String[] {
               "Folklandsko standardno vrijeme",
               "",
               "Folklandsko ljetno vrijeme",
               "",
               "Folklandsko vrijeme",
               "",
            };
        final String[] Malaysia = new String[] {
               "Malezijsko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Maldivsko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ulanbatorsko standardno vrijeme",
               "",
               "Ulanbatorsko ljetno vrijeme",
               "",
               "Ulanbatorsko vrijeme",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pakistansko standardno vrijeme",
               "",
               "Pakistansko ljetno vrijeme",
               "",
               "Pakistansko vrijeme",
               "",
            };
        final String[] Paraguay = new String[] {
               "Paragvajsko standardno vrijeme",
               "",
               "Paragvajsko ljetno vrijeme",
               "",
               "Paragvajsko vrijeme",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Vrijeme na Ostrvima Pitkern",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Sahalinsko standardno vrijeme",
               "",
               "Sahalinsko ljetno vrijeme",
               "",
               "Sahalinsko vrijeme",
               "",
            };
        final String[] Suriname = new String[] {
               "Surinamsko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Argentinsko standardno vrijeme",
               "",
               "Argentinsko ljetno vrijeme",
               "",
               "Argentinsko vrijeme",
               "",
            };
        final String[] Christmas = new String[] {
               "Vrijeme na Bo\u017ei\u0107nom Ostrvu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galapagosko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hongkon\u0161ko standardno vrijeme",
               "",
               "Hongkon\u0161ko ljetno vrijeme",
               "",
               "Hongkon\u0161ko vrijeme",
               "",
            };
        final String[] Indochina = new String[] {
               "Indokinesko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Petropavlovsk-Kam\u010datski standardno vreme",
               "",
               "Petropavlovsk-Kam\u010datski letnje ra\u010dunanje vremena",
               "",
               "Petropavlovsk-Kam\u010datski vreme",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Kirgistansko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Standardno vrijeme na Ostrvu Lord Hau",
               "",
               "Ljetno vrijeme na Ostrvu Lord Hau",
               "",
               "Vrijeme na Ostrvu Lord Hau",
               "",
            };
        final String[] Macquarie = new String[] {
               "Vrijeme na Ostrvu Makvori",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Marquesas = new String[] {
               "Vrijeme na Ostrvima Markiz",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Mauricijsko standardno vrijeme",
               "",
               "Mauricijsko ljetno vrijeme",
               "",
               "Mauricijsko vrijeme",
               "",
            };
        final String[] Singapore = new String[] {
               "Singapursko standardno vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Venecuelansko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Volgogradsko standardno vrijeme",
               "",
               "Volgogradsko ljetno vrijeme",
               "",
               "Volgogradsko vrijeme",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Azerbejd\u017eansko standardno vrijeme",
               "",
               "Azerbejd\u017eansko ljetno vrijeme",
               "",
               "Azerbejd\u017eansko vrijeme",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Banglade\u0161ko standardno vrijeme",
               "",
               "Banglade\u0161ko ljetno vrijeme",
               "",
               "Banglade\u0161ko vrijeme",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Zelenortsko standardno vrijeme",
               "",
               "Zelenortsko ljetno vrijeme",
               "",
               "Zelenortsko vrijeme",
               "",
            };
        final String[] East_Timor = new String[] {
               "Isto\u010dnotimorsko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Sej\u0161elsko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Tad\u017eikistansko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Uzbekistansko standardno vrijeme",
               "",
               "Uzbekistansko ljetno vrijeme",
               "",
               "Uzbekistansko vrijeme",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afganistansko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarsko standardno vrijeme",
               "",
               "Krasnojarsko ljetno vrijeme",
               "",
               "Krasnojarsko vrijeme",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Novozelandsko standardno vrijeme",
               "",
               "Novozelandsko ljetno vrijeme",
               "",
               "Novozelandsko vrijeme",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirsko standardno vrijeme",
               "",
               "Novosibirsko ljetno vrijeme",
               "",
               "Novosibirsko vrijeme",
               "",
            };
        final String[] Philippines = new String[] {
               "Filipinsko standardno vrijeme",
               "",
               "Filipinsko ljetno vrijeme",
               "",
               "Filipinsko vrijeme",
               "",
            };
        final String[] Vladivostok = new String[] {
               "Vladivosto\u010dko standardno vrijeme",
               "",
               "Vladivosto\u010dko ljetno vrijeme",
               "",
               "Vladivosto\u010dko vrijeme",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Vrijeme na Indijskom okeanu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Vrijeme na Ostrvima Lajn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Njufaundlendsko standardno vrijeme",
               "",
               "Njufaundlendsko ljetno vrijeme",
               "",
               "Njufaundlendsko vrijeme",
               "",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmenistansko standardno vrijeme",
               "",
               "Turkmenistansko ljetno vrijeme",
               "",
               "Turkmenistansko vrijeme",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Francuskogvajansko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Novokaledonijsko standardno vrijeme",
               "",
               "Novokaledonijsko ljetno vrijeme",
               "",
               "Novokaledonijsko vrijeme",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Ju\u017enod\u017eord\u017eijsko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinbur\u0161ko standardno vrijeme",
               "",
               "Jekaterinbur\u0161ko ljetno vrijeme",
               "",
               "Jekaterinbur\u0161ko vrijeme",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Centralnoafri\u010dko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "Isto\u010dnoafri\u010dko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Western = new String[] {
               "Zapadnoafri\u010dko standardno vrijeme",
               "",
               "Zapadnoafri\u010dko ljetno vrijeme",
               "",
               "Zapadnoafri\u010dko vrijeme",
               "",
            };
        final String[] DumontDUrville = new String[] {
               "Vrijeme stanice Dumont-d\u2019Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Centralnoevropsko standardno vrijeme",
               "",
               "Centralnoevropsko ljetno vrijeme",
               "",
               "Centralnoevropsko vrijeme",
               "",
            };
        final String[] Europe_Eastern = new String[] {
               "Isto\u010dnoevropsko standardno vrijeme",
               "",
               "Isto\u010dnoevropsko ljetno vrijeme",
               "",
               "Isto\u010dnoevropsko vrijeme",
               "",
            };
        final String[] Europe_Western = new String[] {
               "Zapadnoevropsko standardno vrijeme",
               "",
               "Zapadnoevropsko ljetno vrijeme",
               "",
               "Zapadnoevropsko vrijeme",
               "",
            };
        final String[] Mexico_Pacific = new String[] {
               "Meksi\u010dko pacifi\u010dko standardno vrijeme",
               "",
               "Meksi\u010dko pacifi\u010dko ljetno vrijeme",
               "",
               "Meksi\u010dko pacifi\u010dko vrijeme",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "Ju\u017enoafri\u010dko standardno vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Central = new String[] {
               "Sjevernoameri\u010dko centralno standardno vrijeme",
               "",
               "Sjevernoameri\u010dko centralno ljetno vrijeme",
               "",
               "Sjevernoameri\u010dko centralno vrijeme",
               "",
            };
        final String[] America_Eastern = new String[] {
               "Sjevernoameri\u010dko isto\u010dno standardno vrijeme",
               "",
               "Sjevernoameri\u010dko isto\u010dno ljetno vrijeme",
               "",
               "Sjevernoameri\u010dko isto\u010dno vrijeme",
               "",
            };
        final String[] America_Pacific = new String[] {
               "Sjevernoameri\u010dko pacifi\u010dko standardno vrijeme",
               "",
               "Sjevernoameri\u010dko pacifi\u010dko ljetno vrijeme",
               "",
               "Sjevernoameri\u010dko pacifi\u010dko vrijeme",
               "",
            };
        final String[] French_Southern = new String[] {
               "Vrijeme na Francuskoj Ju\u017enoj Teritoriji i Antarktiku",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Vrijeme na Gilbertovim ostrvima",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Havajsko-aleu\u0107ansko standardno vrijeme",
               "",
               "Havajsko-aleu\u0107ansko ljetno vrijeme",
               "",
               "Havajsko-aleu\u0107ansko vrijeme",
               "",
            };
        final String[] Phoenix_Islands = new String[] {
               "Vrijeme na Ostrvima Finiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Standardno vrijeme na Ostrvima Sveti Petar i Mikelon",
               "",
               "Ljetno vrijeme na Ostrvima Sveti Petar i Mikelon",
               "",
               "Vrijeme na Ostrvima Sveti Petar i Mikelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Sjevernoameri\u010dko planinsko standardno vrijeme",
               "",
               "Sjevernoameri\u010dko planinsko ljetno vrijeme",
               "",
               "Sjevernoameri\u010dko planinsko vrijeme",
               "",
            };
        final String[] Marshall_Islands = new String[] {
               "Vrijeme na Mar\u0161alovim ostrvima",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "Sjeverozapadno meksi\u010dko standardno vrijeme",
               "",
               "Sjeverozapadno meksi\u010dko ljetno vrijeme",
               "",
               "Sjeverozapadno meksi\u010dko vrijeme",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Vrijeme na Papui Novoj Gvineji",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Centralnoaustralijsko standardno vrijeme",
               "",
               "Centralnoaustralijsko ljetno vrijeme",
               "",
               "Centralnoaustralijsko vrijeme",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "Isto\u010dnoaustralijsko standardno vrijeme",
               "",
               "Isto\u010dnoaustralijsko ljetno vrijeme",
               "",
               "Isto\u010dnoaustralijsko vrijeme",
               "",
            };
        final String[] Australia_Western = new String[] {
               "Zapadnoaustralijsko standardno vrijeme",
               "",
               "Zapadnoaustralijsko ljetno vrijeme",
               "",
               "Zapadnoaustralijsko vrijeme",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "Isto\u010dnogrenlandsko standardno vrijeme",
               "",
               "Isto\u010dnogrenlandsko ljetno vrijeme",
               "",
               "Isto\u010dnogrenlandsko vrijeme",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "Zapadnogrenlandsko standardno vrijeme",
               "",
               "Zapadnogrenlandsko ljetno vrijeme",
               "",
               "Zapadnogrenlandsko vrijeme",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "Centralnoindonezijsko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Isto\u010dnoindonezijsko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Western = new String[] {
               "Zapadnoindonezijsko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Isto\u010dnokazahstansko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Zapadnokazahstansko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Australijsko centralnozapadno standardno vrijeme",
               "",
               "Australijsko centralnozapadno ljetno vrijeme",
               "",
               "Australijsko centralno zapadno vrijeme",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "JST", Japan },
            { "MIT", Apia },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "SST", Solomon },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UTC", ETC_UTC },
            { "MST7MDT", America_Mountain },
            { "PST8PDT", America_Pacific },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Asia/Amman", Europe_Eastern },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Africa/Juba", Africa_Eastern },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Truk },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kuching", Malaysia },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Damascus", Europe_Eastern },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan_Eastern },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Ust-Nera", Vladivostok },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Grini\u010dko vrijeme",
                    "",
                    "Irsko standardno vrijeme",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Jersey", GMT },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Grini\u010dko vrijeme",
                    "",
                    "Britansko ljetno vrijeme",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", America_Pacific },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "Asia/Chongqing", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Grini\u010dko vrijeme",
                    "",
                    "Britansko ljetno vrijeme",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Pacific/Easter", Easter },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Ponape },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Pacific/Wallis", Wallis },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Godthab", Greenland_Western },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Mountain },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/Perth", Australia_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey", GMT },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", Maldives },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", America_Pacific },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Europe/Isle_of_Man", GMT },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Antarctica/Macquarie", Macquarie },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "Aden" },
            { "timezone.excity.Asia/Baku", "Baku" },
            { "timezone.excity.Asia/Dili", "Dili" },
            { "timezone.excity.Asia/Gaza", "Gaza" },
            { "timezone.excity.Asia/Hovd", "Hovd" },
            { "timezone.excity.Asia/Omsk", "Omsk" },
            { "timezone.excity.Asia/Oral", "Oral" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Aman" },
            { "timezone.excity.Asia/Aqtau", "Aktau" },
            { "timezone.excity.Asia/Chita", "Chita" },
            { "timezone.excity.Asia/Dhaka", "Daka" },
            { "timezone.excity.Asia/Dubai", "Dubai" },
            { "timezone.excity.Asia/Kabul", "Kabul" },
            { "timezone.excity.Asia/Macau", "Makau" },
            { "timezone.excity.Asia/Qatar", "Katar" },
            { "timezone.excity.Asia/Seoul", "Seul" },
            { "timezone.excity.Asia/Tokyo", "Tokio" },
            { "timezone.excity.Asia/Tomsk", "Tomsk" },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "Juba" },
            { "timezone.excity.Africa/Lome", "Lome" },
            { "timezone.excity.Asia/Almaty", "Almati" },
            { "timezone.excity.Asia/Anadyr", "Anadir" },
            { "timezone.excity.Asia/Aqtobe", "Akutobe" },
            { "timezone.excity.Asia/Atyrau", "Atiraj" },
            { "timezone.excity.Asia/Beirut", "Bejrut" },
            { "timezone.excity.Asia/Brunei", "Bruneji" },
            { "timezone.excity.Asia/Hebron", "Hebron" },
            { "timezone.excity.Asia/Kuwait", "Kuvajt" },
            { "timezone.excity.Asia/Manila", "Manila" },
            { "timezone.excity.Asia/Muscat", "Muskat" },
            { "timezone.excity.Asia/Riyadh", "Rijad" },
            { "timezone.excity.Asia/Saigon", "Ho \u0160i Min" },
            { "timezone.excity.Asia/Taipei", "Tajpej" },
            { "timezone.excity.Asia/Tehran", "Teheran" },
            { "timezone.excity.Asia/Urumqi", "Urum\u010di" },
            { "timezone.excity.Etc/Unknown", "Nepoznati grad" },
            { "timezone.excity.Europe/Kiev", "Kijev" },
            { "timezone.excity.Europe/Oslo", "Oslo" },
            { "timezone.excity.Europe/Riga", "Riga" },
            { "timezone.excity.Europe/Rome", "Rim" },
            { "timezone.excity.Indian/Mahe", "Mahe" },
            { "timezone.excity.Africa/Accra", "Accra" },
            { "timezone.excity.Africa/Cairo", "Kairo" },
            { "timezone.excity.Africa/Ceuta", "Ceuta" },
            { "timezone.excity.Africa/Dakar", "Dakar" },
            { "timezone.excity.Africa/Lagos", "Lagos" },
            { "timezone.excity.Africa/Tunis", "Tunis" },
            { "timezone.excity.America/Adak", "Adak" },
            { "timezone.excity.America/Lima", "Lima" },
            { "timezone.excity.America/Nome", "Nome" },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "timezone.excity.Asia/Bahrain", "Bahrein" },
            { "timezone.excity.Asia/Bangkok", "Bangkok" },
            { "timezone.excity.Asia/Barnaul", "Barnaul" },
            { "timezone.excity.Asia/Bishkek", "Bi\u0161kek" },
            { "timezone.excity.Asia/Colombo", "Kolombo" },
            { "timezone.excity.Asia/Irkutsk", "Irkutsk" },
            { "timezone.excity.Asia/Jakarta", "D\u017eakarta" },
            { "timezone.excity.Asia/Karachi", "Kara\u010di" },
            { "timezone.excity.Asia/Kuching", "Ku\u010ding" },
            { "timezone.excity.Asia/Magadan", "Magadan" },
            { "timezone.excity.Asia/Nicosia", "Nikozija" },
            { "timezone.excity.Asia/Rangoon", "Rangun" },
            { "timezone.excity.Asia/Tbilisi", "Tbilisi" },
            { "timezone.excity.Asia/Thimphu", "Thimphu" },
            { "timezone.excity.Asia/Yakutsk", "Jakutsk" },
            { "timezone.excity.Asia/Yerevan", "Jerevan" },
            { "timezone.excity.Europe/Kirov", "Kirov" },
            { "timezone.excity.Europe/Malta", "Malta" },
            { "timezone.excity.Europe/Minsk", "Minsk" },
            { "timezone.excity.Europe/Paris", "Pariz" },
            { "timezone.excity.Europe/Sofia", "Sofija" },
            { "timezone.excity.Europe/Vaduz", "Vaduz" },
            { "timezone.excity.Indian/Cocos", "Kokosova ostrva" },
            { "timezone.excity.Pacific/Apia", "Apia" },
            { "timezone.excity.Pacific/Fiji", "Fid\u017ei" },
            { "timezone.excity.Pacific/Guam", "Guam" },
            { "timezone.excity.Pacific/Niue", "Niue" },
            { "timezone.excity.Pacific/Wake", "Wake" },
            { "timezone.excity.Africa/Bamako", "Bamako" },
            { "timezone.excity.Africa/Bangui", "Bangui" },
            { "timezone.excity.Africa/Banjul", "Banjul" },
            { "timezone.excity.Africa/Bissau", "Bissau" },
            { "timezone.excity.Africa/Douala", "Douala" },
            { "timezone.excity.Africa/Harare", "Harare" },
            { "timezone.excity.Africa/Kigali", "Kigali" },
            { "timezone.excity.Africa/Luanda", "Luanda" },
            { "timezone.excity.Africa/Lusaka", "Lusaka" },
            { "timezone.excity.Africa/Malabo", "Malabo" },
            { "timezone.excity.Africa/Maputo", "Maputo" },
            { "timezone.excity.Africa/Maseru", "Maseru" },
            { "timezone.excity.Africa/Niamey", "Niamey" },
            { "timezone.excity.America/Aruba", "Aruba" },
            { "timezone.excity.America/Bahia", "Bahia" },
            { "timezone.excity.America/Belem", "Belem" },
            { "timezone.excity.America/Boise", "Boise" },
            { "timezone.excity.America/Jujuy", "Jujuy" },
            { "timezone.excity.America/Sitka", "Sitka" },
            { "timezone.excity.America/Thule", "Thule" },
            { "timezone.excity.Asia/Ashgabat", "A\u0161habad" },
            { "timezone.excity.Asia/Damascus", "Damask" },
            { "timezone.excity.Asia/Dushanbe", "Du\u0161anbe" },
            { "timezone.excity.Asia/Jayapura", "D\u017eajapura" },
            { "timezone.excity.Asia/Katmandu", "Katmandu" },
            { "timezone.excity.Asia/Khandyga", "Handiga" },
            { "timezone.excity.Asia/Makassar", "Makasar" },
            { "timezone.excity.Asia/Qostanay", "Kostanaj" },
            { "timezone.excity.Asia/Sakhalin", "Sahalin" },
            { "timezone.excity.Asia/Shanghai", "\u0160angaj" },
            { "timezone.excity.Asia/Tashkent", "Ta\u0161kent" },
            { "timezone.excity.Asia/Ust-Nera", "Ust-Nera" },
            { "timezone.excity.Europe/Athens", "Atina" },
            { "timezone.excity.Europe/Berlin", "Berlin" },
            { "timezone.excity.Europe/Dublin", "Dablin" },
            { "timezone.excity.Europe/Jersey", "Jersey" },
            { "timezone.excity.Europe/Lisbon", "Lisabon" },
            { "timezone.excity.Europe/London", "London" },
            { "timezone.excity.Europe/Madrid", "Madrid" },
            { "timezone.excity.Europe/Monaco", "Monako" },
            { "timezone.excity.Europe/Moscow", "Moskva" },
            { "timezone.excity.Europe/Prague", "Prag" },
            { "timezone.excity.Europe/Samara", "Samara" },
            { "timezone.excity.Europe/Skopje", "Skoplje" },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Vienna", "Be\u010d" },
            { "timezone.excity.Europe/Warsaw", "Var\u0161ava" },
            { "timezone.excity.Europe/Zagreb", "Zagreb" },
            { "timezone.excity.Europe/Zurich", "Cirih" },
            { "timezone.excity.Indian/Chagos", "Chagos" },
            { "timezone.excity.Indian/Comoro", "Comoro" },
            { "timezone.excity.Pacific/Efate", "Efate" },
            { "timezone.excity.Pacific/Nauru", "Nauru" },
            { "timezone.excity.Pacific/Palau", "Palau" },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Abidjan" },
            { "timezone.excity.Africa/Algiers", "Algiers" },
            { "timezone.excity.Africa/Conakry", "Conakry" },
            { "timezone.excity.Africa/Kampala", "Kampala" },
            { "timezone.excity.Africa/Mbabane", "Mbabane" },
            { "timezone.excity.Africa/Nairobi", "Nairobi" },
            { "timezone.excity.Africa/Tripoli", "Tripoli" },
            { "timezone.excity.America/Belize", "Belize" },
            { "timezone.excity.America/Bogota", "Bogota" },
            { "timezone.excity.America/Cancun", "Cancun" },
            { "timezone.excity.America/Cayman", "Kajman" },
            { "timezone.excity.America/Cuiaba", "Cuiaba" },
            { "timezone.excity.America/Dawson", "Dawson" },
            { "timezone.excity.America/Denver", "Denver" },
            { "timezone.excity.America/Guyana", "Guyana" },
            { "timezone.excity.America/Havana", "Havana" },
            { "timezone.excity.America/Inuvik", "Inuvik" },
            { "timezone.excity.America/Juneau", "Juneau" },
            { "timezone.excity.America/La_Paz", "La Paz" },
            { "timezone.excity.America/Maceio", "Maceio" },
            { "timezone.excity.America/Manaus", "Manaus" },
            { "timezone.excity.America/Merida", "Merida" },
            { "timezone.excity.America/Nassau", "Nassau" },
            { "timezone.excity.America/Panama", "Panama" },
            { "timezone.excity.America/Recife", "Recife" },
            { "timezone.excity.America/Regina", "Regina" },
            { "timezone.excity.Asia/Famagusta", "Famagusta" },
            { "timezone.excity.Asia/Hong_Kong", "Hong Kong" },
            { "timezone.excity.Asia/Jerusalem", "Jeruzalem" },
            { "timezone.excity.Asia/Kamchatka", "Kam\u010datka" },
            { "timezone.excity.Asia/Pontianak", "Pontianak" },
            { "timezone.excity.Asia/Pyongyang", "Pjongjang" },
            { "timezone.excity.Asia/Qyzylorda", "Kizilorda" },
            { "timezone.excity.Asia/Samarkand", "Samarkand" },
            { "timezone.excity.Asia/Singapore", "Singapur" },
            { "timezone.excity.Asia/Vientiane", "Vijentijan" },
            { "timezone.excity.Europe/Andorra", "Andora" },
            { "timezone.excity.Europe/Saratov", "Saratov" },
            { "timezone.excity.Europe/Tallinn", "Talin" },
            { "timezone.excity.Europe/Vatican", "Vatikan" },
            { "timezone.excity.Europe/Vilnius", "Vilnius" },
            { "timezone.excity.Indian/Mayotte", "Mayotte" },
            { "timezone.excity.Indian/Reunion", "Reunion" },
            { "timezone.excity.Pacific/Easter", "Easter" },
            { "timezone.excity.Pacific/Kosrae", "Kosrae" },
            { "timezone.excity.Pacific/Majuro", "Majuro" },
            { "timezone.excity.Pacific/Midway", "Midway" },
            { "timezone.excity.Pacific/Noumea", "Noumea" },
            { "timezone.excity.Pacific/Saipan", "Saipan" },
            { "timezone.excity.Pacific/Tahiti", "Tahiti" },
            { "timezone.excity.Pacific/Tarawa", "Tarawa" },
            { "timezone.excity.Pacific/Wallis", "Valis" },
            { "timezone.excity.Africa/Blantyre", "Blantyre" },
            { "timezone.excity.Africa/Djibouti", "D\u017eibuti" },
            { "timezone.excity.Africa/El_Aaiun", "El Aaiun" },
            { "timezone.excity.Africa/Freetown", "Freetown" },
            { "timezone.excity.Africa/Gaborone", "Gaborone" },
            { "timezone.excity.Africa/Khartoum", "Kartum" },
            { "timezone.excity.Africa/Kinshasa", "Kinshasa" },
            { "timezone.excity.Africa/Monrovia", "Monrovia" },
            { "timezone.excity.Africa/Ndjamena", "Ndjamena" },
            { "timezone.excity.Africa/Sao_Tome", "Sao Tome" },
            { "timezone.excity.Africa/Windhoek", "Windhoek" },
            { "timezone.excity.America/Antigua", "Antigva" },
            { "timezone.excity.America/Caracas", "Caracas" },
            { "timezone.excity.America/Cayenne", "Cayenne" },
            { "timezone.excity.America/Chicago", "Chicago" },
            { "timezone.excity.America/Cordoba", "Cordoba" },
            { "timezone.excity.America/Creston", "Creston" },
            { "timezone.excity.America/Curacao", "Kurasao" },
            { "timezone.excity.America/Detroit", "Detroit" },
            { "timezone.excity.America/Grenada", "Grenada" },
            { "timezone.excity.America/Halifax", "Halifax" },
            { "timezone.excity.America/Iqaluit", "Iqaluit" },
            { "timezone.excity.America/Jamaica", "Jamajka" },
            { "timezone.excity.America/Managua", "Managua" },
            { "timezone.excity.America/Marigot", "Marigot" },
            { "timezone.excity.America/Mendoza", "Mendoza" },
            { "timezone.excity.America/Moncton", "Moncton" },
            { "timezone.excity.America/Nipigon", "Nipigon" },
            { "timezone.excity.America/Noronha", "Noronha" },
            { "timezone.excity.America/Ojinaga", "Ojinaga" },
            { "timezone.excity.America/Phoenix", "Phoenix" },
            { "timezone.excity.America/Tijuana", "Tijuana" },
            { "timezone.excity.America/Toronto", "Toronto" },
            { "timezone.excity.America/Tortola", "Tortola" },
            { "timezone.excity.America/Yakutat", "Yakutat" },
            { "timezone.excity.Asia/Choibalsan", "\u010cojbalsan" },
            { "timezone.excity.Asia/Phnom_Penh", "Pnom Pen" },
            { "timezone.excity.Atlantic/Azores", "Azori" },
            { "timezone.excity.Atlantic/Canary", "Kanari" },
            { "timezone.excity.Australia/Eucla", "Eucla" },
            { "timezone.excity.Australia/Perth", "Pert" },
            { "timezone.excity.Europe/Belgrade", "Beograd" },
            { "timezone.excity.Europe/Brussels", "Brisel" },
            { "timezone.excity.Europe/Budapest", "Budimpe\u0161ta" },
            { "timezone.excity.Europe/Busingen", "Busingen" },
            { "timezone.excity.Europe/Chisinau", "Ki\u0161injev" },
            { "timezone.excity.Europe/Guernsey", "Gernzi" },
            { "timezone.excity.Europe/Helsinki", "Helsinki" },
            { "timezone.excity.Europe/Istanbul", "Istanbul" },
            { "timezone.excity.Europe/Sarajevo", "Sarajevo" },
            { "timezone.excity.Europe/Uzhgorod", "U\u017egorod" },
            { "timezone.excity.Indian/Maldives", "Maldivi" },
            { "timezone.excity.Pacific/Chatham", "Chatham" },
            { "timezone.excity.Pacific/Fakaofo", "Fakaofo" },
            { "timezone.excity.Pacific/Gambier", "Gambier" },
            { "timezone.excity.Pacific/Norfolk", "Norfolk" },
            { "timezone.excity.Africa/Bujumbura", "Bujumbura" },
            { "timezone.excity.Africa/Mogadishu", "Mogadi\u0161" },
            { "timezone.excity.America/Anguilla", "Angvila" },
            { "timezone.excity.America/Asuncion", "Asuncion" },
            { "timezone.excity.America/Barbados", "Barbados" },
            { "timezone.excity.America/Dominica", "Dominika" },
            { "timezone.excity.America/Edmonton", "Edmonton" },
            { "timezone.excity.America/Eirunepe", "Eirunepe" },
            { "timezone.excity.America/Mazatlan", "Mazatlan" },
            { "timezone.excity.America/Miquelon", "Miquelon" },
            { "timezone.excity.America/New_York", "New York" },
            { "timezone.excity.America/Resolute", "Resolute" },
            { "timezone.excity.America/Santarem", "Santarem" },
            { "timezone.excity.America/Santiago", "Santiago" },
            { "timezone.excity.America/Winnipeg", "Winnipeg" },
            { "timezone.excity.Antarctica/Casey", "Casey" },
            { "timezone.excity.Antarctica/Davis", "Davis" },
            { "timezone.excity.Antarctica/Syowa", "Syowa" },
            { "timezone.excity.Antarctica/Troll", "Troll" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnojarsk" },
            { "timezone.excity.Asia/Novosibirsk", "Novosibirsk" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulan Bator" },
            { "timezone.excity.Asia/Vladivostok", "Vladivostok" },
            { "timezone.excity.Atlantic/Bermuda", "Bermuda" },
            { "timezone.excity.Atlantic/Madeira", "Madeira" },
            { "timezone.excity.Atlantic/Stanley", "Stanley" },
            { "timezone.excity.Australia/Currie", "Currie" },
            { "timezone.excity.Australia/Darwin", "Darwin" },
            { "timezone.excity.Australia/Hobart", "Hobart" },
            { "timezone.excity.Australia/Sydney", "Sidnej" },
            { "timezone.excity.Europe/Amsterdam", "Amsterdam" },
            { "timezone.excity.Europe/Astrakhan", "Astrahan" },
            { "timezone.excity.Europe/Bucharest", "Bukure\u0161t" },
            { "timezone.excity.Europe/Gibraltar", "Gibraltar" },
            { "timezone.excity.Europe/Ljubljana", "Ljubljana" },
            { "timezone.excity.Europe/Mariehamn", "Mariehamn" },
            { "timezone.excity.Europe/Podgorica", "Podgorica" },
            { "timezone.excity.Europe/Stockholm", "\u0160tokholm" },
            { "timezone.excity.Europe/Ulyanovsk", "Ulyanovsk" },
            { "timezone.excity.Europe/Volgograd", "Volgograd" },
            { "timezone.excity.Indian/Christmas", "Bo\u017ei\u0107no ostrvo" },
            { "timezone.excity.Indian/Kerguelen", "Kerguelen" },
            { "timezone.excity.Indian/Mauritius", "Mauricijus" },
            { "timezone.excity.Pacific/Auckland", "Auckland" },
            { "timezone.excity.Pacific/Funafuti", "Funafuti" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.Pacific/Johnston", "Johnston" },
            { "timezone.excity.Pacific/Pitcairn", "Pitkern" },
            { "timezone.excity.Africa/Casablanca", "Kazablanka" },
            { "timezone.excity.Africa/Libreville", "Libreville" },
            { "timezone.excity.Africa/Lubumbashi", "Lubumbashi" },
            { "timezone.excity.Africa/Nouakchott", "Nouakchott" },
            { "timezone.excity.Africa/Porto-Novo", "Porto-Novo" },
            { "timezone.excity.America/Anchorage", "Anchorage" },
            { "timezone.excity.America/Araguaina", "Araguaina" },
            { "timezone.excity.America/Boa_Vista", "Boa Vista" },
            { "timezone.excity.America/Catamarca", "Catamarca" },
            { "timezone.excity.America/Chihuahua", "Chihuahua" },
            { "timezone.excity.America/Fortaleza", "Fortaleza" },
            { "timezone.excity.America/Glace_Bay", "Glace Bay" },
            { "timezone.excity.America/Goose_Bay", "Goose Bay" },
            { "timezone.excity.America/Guatemala", "Gvatemala" },
            { "timezone.excity.America/Guayaquil", "Guayaquil" },
            { "timezone.excity.America/Matamoros", "Matamoros" },
            { "timezone.excity.America/Menominee", "Menominee" },
            { "timezone.excity.America/Monterrey", "Monterrey" },
            { "timezone.excity.America/Sao_Paulo", "Sao Paulo" },
            { "timezone.excity.America/Vancouver", "Vancouver" },
            { "timezone.excity.Antarctica/Mawson", "Mawson" },
            { "timezone.excity.Antarctica/Palmer", "Palmer" },
            { "timezone.excity.Antarctica/Vostok", "Vostok" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kuala Lumpur" },
            { "timezone.excity.Asia/Novokuznetsk", "Novokuznjeck" },
            { "timezone.excity.Europe/Bratislava", "Bratislava" },
            { "timezone.excity.Europe/Copenhagen", "Kopenhagen" },
            { "timezone.excity.Europe/Luxembourg", "Luksemburg" },
            { "timezone.excity.Europe/San_Marino", "San Marino" },
            { "timezone.excity.Europe/Simferopol", "Simferopolj" },
            { "timezone.excity.Europe/Zaporozhye", "Zaporo\u017eje" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Pacific/Galapagos", "Galapagos" },
            { "timezone.excity.Pacific/Kwajalein", "Kwajalein" },
            { "timezone.excity.Pacific/Marquesas", "Marquesas" },
            { "timezone.excity.Pacific/Pago_Pago", "Pago Pago" },
            { "timezone.excity.Pacific/Rarotonga", "Rarotonga" },
            { "timezone.excity.Pacific/Tongatapu", "Tongatapu" },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Ababa" },
            { "timezone.excity.Africa/Brazzaville", "Brazzaville" },
            { "timezone.excity.Africa/Ouagadougou", "Ouagadougou" },
            { "timezone.excity.America/Costa_Rica", "Kostarika" },
            { "timezone.excity.America/Grand_Turk", "Grand Turk" },
            { "timezone.excity.America/Guadeloupe", "Gvadalupe" },
            { "timezone.excity.America/Hermosillo", "Hermosillo" },
            { "timezone.excity.America/Kralendijk", "Kralendijk" },
            { "timezone.excity.America/Louisville", "Louisville" },
            { "timezone.excity.America/Martinique", "Martinique" },
            { "timezone.excity.America/Metlakatla", "Metlakatla" },
            { "timezone.excity.America/Montevideo", "Montevideo" },
            { "timezone.excity.America/Montserrat", "Montserrat" },
            { "timezone.excity.America/Paramaribo", "Paramaribo" },
            { "timezone.excity.America/Rio_Branco", "Rio Branco" },
            { "timezone.excity.America/Whitehorse", "Whitehorse" },
            { "timezone.excity.Antarctica/McMurdo", "McMurdo" },
            { "timezone.excity.Antarctica/Rothera", "Rothera" },
            { "timezone.excity.Asia/Srednekolymsk", "Srednekolymsk" },
            { "timezone.excity.Asia/Yekaterinburg", "Jekaterinburg" },
            { "timezone.excity.Atlantic/Reykjavik", "Rejkjavik" },
            { "timezone.excity.Atlantic/St_Helena", "Sveta Helena" },
            { "timezone.excity.Australia/Adelaide", "Adelaide" },
            { "timezone.excity.Australia/Brisbane", "Brisbane" },
            { "timezone.excity.Australia/Lindeman", "Lindeman" },
            { "timezone.excity.Europe/Isle_of_Man", "Ostrvo Man" },
            { "timezone.excity.Europe/Kaliningrad", "Kalinjingrad" },
            { "timezone.excity.Pacific/Kiritimati", "Kiritimati" },
            { "timezone.excity.Africa/Johannesburg", "Johannesburg" },
            { "timezone.excity.America/El_Salvador", "Salvador" },
            { "timezone.excity.America/Fort_Nelson", "Fort Nelson" },
            { "timezone.excity.America/Los_Angeles", "Los Angeles" },
            { "timezone.excity.America/Mexico_City", "Mexico City" },
            { "timezone.excity.America/Pangnirtung", "Pangnirtung" },
            { "timezone.excity.America/Porto_Velho", "Porto Velho" },
            { "timezone.excity.America/Puerto_Rico", "Portoriko" },
            { "timezone.excity.America/Rainy_River", "Rainy River" },
            { "timezone.excity.America/Tegucigalpa", "Tegucigalpa" },
            { "timezone.excity.America/Thunder_Bay", "Thunder Bay" },
            { "timezone.excity.America/Yellowknife", "Yellowknife" },
            { "timezone.excity.Arctic/Longyearbyen", "Longyearbyen" },
            { "timezone.excity.Atlantic/Cape_Verde", "Kape Verde" },
            { "timezone.excity.Australia/Lord_Howe", "Lord Hau" },
            { "timezone.excity.Australia/Melbourne", "Melburn" },
            { "timezone.excity.Indian/Antananarivo", "Antananarivo" },
            { "timezone.excity.Pacific/Guadalcanal", "Guadalcanal" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Dar es Salaam" },
            { "timezone.excity.America/Blanc-Sablon", "Blanc-Sablon" },
            { "timezone.excity.America/Buenos_Aires", "Buenos Aires" },
            { "timezone.excity.America/Campo_Grande", "Campo Grande" },
            { "timezone.excity.America/Danmarkshavn", "Danmarkshavn" },
            { "timezone.excity.America/Dawson_Creek", "Dawson Creek" },
            { "timezone.excity.America/Indianapolis", "Indianapolis" },
            { "timezone.excity.America/Punta_Arenas", "Punta Arenas" },
            { "timezone.excity.America/Rankin_Inlet", "Rankin Inlet" },
            { "timezone.excity.America/Santa_Isabel", "Santa Isabel" },
            { "timezone.excity.Antarctica/Macquarie", "Macquarie" },
            { "timezone.excity.Pacific/Bougainville", "Bougainville" },
            { "timezone.excity.Pacific/Port_Moresby", "Port Moresby" },
            { "timezone.excity.America/Cambridge_Bay", "Cambridge Bay" },
            { "timezone.excity.America/Port_of_Spain", "Port of Spain" },
            { "timezone.excity.America/Santo_Domingo", "Santo Domingo" },
            { "timezone.excity.America/Swift_Current", "Swift Current" },
            { "timezone.excity.Australia/Broken_Hill", "Broken Hill" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia Banderas" },
            { "timezone.excity.America/Port-au-Prince", "Port-au-Prince" },
            { "timezone.excity.Atlantic/South_Georgia", "South Georgia" },
            { "timezone.excity.America/Argentina/Salta", "Salta" },
            { "timezone.excity.America/Argentina/Tucuman", "Tucuman" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ushuaia" },
            { "timezone.excity.America/Argentina/La_Rioja", "La Rioja" },
            { "timezone.excity.America/Argentina/San_Juan", "San Juan" },
            { "timezone.excity.America/Argentina/San_Luis", "San Luis" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Sjeverna Dakota" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Sjeverna Dakota" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Rio Gallegos" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Sjeverna Dakota" },
        };
        return data;
    }
}
