/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.DefaultFocusComponent;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

public class QuickNotepad
extends JPanel
implements EBComponent,
QuickNotepadActions,
DefaultFocusComponent {
    private static final long serialVersionUID = 6412255692894321789L;
    private String filename;
    private String defaultFilename;
    private View view;
    private boolean floating;
    private QuickNotepadTextArea textArea;
    private QuickNotepadToolPanel toolPanel;

    public QuickNotepad(View view, String position) {
        super(new BorderLayout());
        this.view = view;
        this.floating = position.equals("floating");
        if (jEdit.getSettingsDirectory() != null) {
            this.filename = jEdit.getProperty((String)"options.quicknotepad.filepath");
            if (this.filename == null || this.filename.length() == 0) {
                this.filename = new String(jEdit.getSettingsDirectory() + File.separator + "qn.txt");
                jEdit.setProperty((String)"options.quicknotepad.filepath", (String)this.filename);
            }
            this.defaultFilename = this.filename;
        }
        this.toolPanel = new QuickNotepadToolPanel(this);
        this.add("North", this.toolPanel);
        if (this.floating) {
            this.setPreferredSize(new Dimension(500, 250));
        }
        this.textArea = new QuickNotepadTextArea();
        this.textArea.setFont(QuickNotepadOptionPane.makeFont());
        JScrollPane pane = new JScrollPane(this.textArea);
        this.add("Center", pane);
        this.readFile();
    }

    public void focusOnDefaultComponent() {
        this.textArea.requestFocus();
    }

    public String getFilename() {
        return this.filename;
    }

    public void handleMessage(EBMessage message) {
        if (message instanceof PropertiesChanged) {
            this.propertiesChanged();
        }
    }

    private void propertiesChanged() {
        Font newFont;
        String propertyFilename = jEdit.getProperty((String)"options.quicknotepad.filepath");
        if (!StandardUtilities.objectsEqual((Object)this.defaultFilename, (Object)propertyFilename)) {
            this.saveFile();
            this.toolPanel.propertiesChanged();
            this.filename = this.defaultFilename = propertyFilename;
            this.readFile();
        }
        if (!(newFont = QuickNotepadOptionPane.makeFont()).equals(this.textArea.getFont())) {
            this.textArea.setFont(newFont);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        EditBus.addToBus((EBComponent)this);
    }

    @Override
    public void removeNotify() {
        this.saveFile();
        super.removeNotify();
        EditBus.removeFromBus((EBComponent)this);
    }

    @Override
    public void saveFile() {
        if (this.filename == null || this.filename.length() == 0) {
            return;
        }
        try {
            FileWriter out = new FileWriter(this.filename);
            out.write(this.textArea.getText());
            out.close();
        }
        catch (IOException ioe) {
            Log.log((int)9, QuickNotepad.class, (Object)("Could not write notepad text to " + this.filename));
        }
    }

    @Override
    public void chooseFile() {
        String[] paths = GUIUtilities.showVFSFileDialog((View)this.view, null, (int)0, (boolean)false);
        if (paths != null && !paths[0].equals(this.filename)) {
            this.saveFile();
            this.filename = paths[0];
            this.toolPanel.propertiesChanged();
            this.readFile();
        }
    }

    @Override
    public void copyToBuffer() {
        jEdit.newFile((View)this.view);
        this.view.getEditPane().getTextArea().setText(this.textArea.getText());
    }

    private void readFile() {
        if (this.filename == null || this.filename.length() == 0) {
            return;
        }
        BufferedReader bf = null;
        try {
            String str;
            bf = new BufferedReader(new FileReader(this.filename));
            StringBuffer sb = new StringBuffer(2048);
            while ((str = bf.readLine()) != null) {
                sb.append(str).append('\n');
            }
            bf.close();
            this.textArea.setText(sb.toString());
        }
        catch (FileNotFoundException fnf) {
            Log.log((int)9, QuickNotepad.class, (Object)("notepad file " + this.filename + " does not exist"));
        }
        catch (IOException ioe) {
            Log.log((int)9, QuickNotepad.class, (Object)("could not read notepad file " + this.filename));
        }
    }
}

