// Generated by gmmproc 2.64.2 -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_PADTEMPLATE_H
#define _GSTREAMERMM_PADTEMPLATE_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008-2016 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gst.h>
#include <gstreamermm/object.h>
#include <gstreamermm/pad.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GstPadTemplate = struct _GstPadTemplate;
using GstPadTemplateClass = struct _GstPadTemplateClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gst
{ class  PadTemplate_Class; } // namespace Gst
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gst
{

/** @addtogroup gstreamermmEnums gstreamermm Enums and Flags */

/** 
 *  @var PadTemplateFlags PAD_TEMPLATE_FLAG_LAST
 * First flag that can be used by subclasses.
 * 
 *  @enum PadTemplateFlags
 * 
 * Flags for the padtemplate
 *
 * @ingroup gstreamermmEnums
 * @par Bitwise operators:
 * <tt>%PadTemplateFlags operator|(PadTemplateFlags, PadTemplateFlags)</tt><br>
 * <tt>%PadTemplateFlags operator&(PadTemplateFlags, PadTemplateFlags)</tt><br>
 * <tt>%PadTemplateFlags operator^(PadTemplateFlags, PadTemplateFlags)</tt><br>
 * <tt>%PadTemplateFlags operator~(PadTemplateFlags)</tt><br>
 * <tt>%PadTemplateFlags& operator|=(PadTemplateFlags&, PadTemplateFlags)</tt><br>
 * <tt>%PadTemplateFlags& operator&=(PadTemplateFlags&, PadTemplateFlags)</tt><br>
 * <tt>%PadTemplateFlags& operator^=(PadTemplateFlags&, PadTemplateFlags)</tt><br>
 */
enum PadTemplateFlags
{
  PAD_TEMPLATE_FLAG_LAST = 0x100
};

/** @ingroup gstreamermmEnums */
inline PadTemplateFlags operator|(PadTemplateFlags lhs, PadTemplateFlags rhs)
  { return static_cast<PadTemplateFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline PadTemplateFlags operator&(PadTemplateFlags lhs, PadTemplateFlags rhs)
  { return static_cast<PadTemplateFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline PadTemplateFlags operator^(PadTemplateFlags lhs, PadTemplateFlags rhs)
  { return static_cast<PadTemplateFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline PadTemplateFlags operator~(PadTemplateFlags flags)
  { return static_cast<PadTemplateFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gstreamermmEnums */
inline PadTemplateFlags& operator|=(PadTemplateFlags& lhs, PadTemplateFlags rhs)
  { return (lhs = static_cast<PadTemplateFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline PadTemplateFlags& operator&=(PadTemplateFlags& lhs, PadTemplateFlags rhs)
  { return (lhs = static_cast<PadTemplateFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline PadTemplateFlags& operator^=(PadTemplateFlags& lhs, PadTemplateFlags rhs)
  { return (lhs = static_cast<PadTemplateFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::PadTemplateFlags> : public Glib::Value_Flags<Gst::PadTemplateFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{

/** 
 *  @var PadPresence PAD_ALWAYS
 * The pad is always available.
 * 
 *  @var PadPresence PAD_SOMETIMES
 * The pad will become available depending on the media stream.
 * 
 *  @var PadPresence PAD_REQUEST
 * The pad is only available on request with
 * Gst::Element::request_pad().
 * 
 *  @enum PadPresence
 * 
 * Indicates when this pad will become available.
 *
 * @ingroup gstreamermmEnums
 */
enum PadPresence
{
  PAD_ALWAYS,
  PAD_SOMETIMES,
  PAD_REQUEST
};

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::PadPresence> : public Glib::Value_Enum<Gst::PadPresence>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{


class Caps;
class Pad;

/** A class that describes the media type of a pad.
 * Padtemplates describe the possible media types a pad or an elementfactory
 * can handle. This allows for both inspection of handled types before loading
 * the element plugin as well as identifying pads on elements that are not yet
 * created (request or sometimes pads).
 *
 * Gst::Pad and PadTemplates have Gst::Caps attached to it to describe the
 * media type they are capable of dealing with. get_caps() is used to get the
 * caps of a padtemplate. It's not possible to modify the caps of a padtemplate
 * after creation.
 *
 * PadTemplates have a Gst::PadPresence property which identifies the lifetime
 * of the pad and that can be retrieved with get_presence(). Also the direction
 * of the pad can be retrieved from the GstPadTemplate with get_direction().
 *
 * The get_name_template() method is important for Gst::PAD_REQUEST pads
 * because it has to be used as the name in the
 * Gst::Element::get_request_pad() call to instantiate a pad from this
 * template.
 *
 * Padtemplates can be created with create().

 * A padtemplate can be used to create a pad (see Gst::Pad::create() methods).
 *
 * Last reviewed on 2016-06-06 (1.8.0)
 */

class PadTemplate : public Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = PadTemplate;
  using CppClassType = PadTemplate_Class;
  using BaseObjectType = GstPadTemplate;
  using BaseClassType = GstPadTemplateClass;

  // noncopyable
  PadTemplate(const PadTemplate&) = delete;
  PadTemplate& operator=(const PadTemplate&) = delete;

private:  friend class PadTemplate_Class;
  static CppClassType padtemplate_class_;

protected:
  explicit PadTemplate(const Glib::ConstructParams& construct_params);
  explicit PadTemplate(GstPadTemplate* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  PadTemplate(PadTemplate&& src) noexcept;
  PadTemplate& operator=(PadTemplate&& src) noexcept;

  ~PadTemplate() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstPadTemplate*       gobj()       { return reinterpret_cast<GstPadTemplate*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstPadTemplate* gobj() const { return reinterpret_cast<GstPadTemplate*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstPadTemplate* gobj_copy();

private:


protected:
    explicit PadTemplate(const Glib::ustring& name_template, PadDirection direction, PadPresence presence, const Glib::RefPtr<Gst::Caps>& caps);


public:
  /** Creates a new pad template with a name according to the given template
   * and with the given arguments. This functions takes ownership of the
   * provided caps, so be sure to not use them afterwards.
   *
   * @param name_template The name template.
   * @param direction The Gst::PadDirection of the template.
   * @param presence The Gst::PadPresence of the pad.
   * @param caps A Gst::Caps set for the template. The caps are taken ownership
   * of.
   * @return A new Gst::PadTemplate.
   */
  
  static Glib::RefPtr<PadTemplate> create(const Glib::ustring& name_template, PadDirection direction, PadPresence presence, const Glib::RefPtr<Gst::Caps>& caps);


  /** Gets the capabilities of the pad template.
   * 
   * @return The Gst::Caps of the pad template.
   * Unref after usage.
   */
  Glib::RefPtr<Gst::Caps> get_caps();
  
  /** Gets the capabilities of the pad template.
   * 
   * @return The Gst::Caps of the pad template.
   * Unref after usage.
   */
  Glib::RefPtr<const Gst::Caps> get_caps() const;

  /** Get the nametemplate of the padtemplate.
   */
  Glib::ustring get_name_template() const;

  /** Get the Gst::PadDirection of the padtemplate.
   */
  PadDirection get_direction() const;

  /** Get the Gst::PadPresence of the padtemplate.
   */
  PadPresence get_presence() const;

  /** The capabilities of the pad described by the pad template.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gst::Caps> > property_caps() const;


  /** The direction of the pad described by the pad template.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Gst::PadDirection > property_direction() const;


  /** The name template of the pad template.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_name_template() const;


  /** When the pad described by the pad template will become available.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Gst::PadPresence > property_presence() const;


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%pad_created(const Glib::RefPtr<Gst::Pad>& pad)</tt>
   *
   * Flags: Run Last
   *
   * This signal is fired when an element creates a pad from this template.
   * 
   * @param pad The pad that was created.
   */

  Glib::SignalProxy< void,const Glib::RefPtr<Gst::Pad>& > signal_pad_created();


  //gst_pad_template_pad_created emits the "pad-created" signal.  It seems
  //internal to C API (it is not found in API docs) so ignore it.
  

public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_pad_created().
  virtual void on_pad_created(const Glib::RefPtr<Gst::Pad>& pad);


};


class StaticPadTemplate
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = StaticPadTemplate;
  using BaseObjectType = GstStaticPadTemplate;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  StaticPadTemplate(const StaticPadTemplate& other) noexcept;
  StaticPadTemplate& operator=(const StaticPadTemplate& other) noexcept;

  StaticPadTemplate(StaticPadTemplate&& other) noexcept;
  StaticPadTemplate& operator=(StaticPadTemplate&& other) noexcept;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type() G_GNUC_CONST;

  StaticPadTemplate();

  explicit StaticPadTemplate(const GstStaticPadTemplate* gobject); // always takes a copy

  ///Provides access to the underlying C instance.
  GstStaticPadTemplate*       gobj()       { return &gobject_; }

  ///Provides access to the underlying C instance.
  const GstStaticPadTemplate* gobj() const { return &gobject_; }

protected:
  GstStaticPadTemplate gobject_;

private:
  
 
public:

  
  /** Gets the capabilities of the static pad template.
   * 
   * @return The Gst::Caps of the static pad template.
   * Unref after usage. Since the core holds an additional
   * ref to the returned caps, use gst_caps_make_writable()
   * on the returned caps to modify it.
   */
  Glib::RefPtr<Gst::Caps> get_caps();
  
  /** Gets the capabilities of the static pad template.
   * 
   * @return The Gst::Caps of the static pad template.
   * Unref after usage. Since the core holds an additional
   * ref to the returned caps, use gst_caps_make_writable()
   * on the returned caps to modify it.
   */
  Glib::RefPtr<const Gst::Caps> get_caps() const;

  
  /** Converts a Gst::StaticPadTemplate into a Gst::PadTemplate.
   * 
   * @return A new Gst::PadTemplate.
   */
  Glib::RefPtr<Gst::PadTemplate> get();

  /** Get the nametemplate of the padtemplate.
   */
  Glib::ustring get_name_template() const;

  /** Get the Gst::PadDirection of the padtemplate.
   */
  PadDirection get_direction() const;

  /** Get the Gst::PadPresence of the padtemplate.
   */
  PadPresence get_presence() const;
  

};

#ifndef DOXYGEN_SHOULD_SKIP_THIS
struct StaticPadTemplateTraits
{
  typedef const Gst::StaticPadTemplate   CppType;
  typedef const GstStaticPadTemplate *   CType;
  typedef GstStaticPadTemplate *         CTypeNonConst;

  static CType   to_c_type      (CppType& obj) { return obj.gobj();  }
  static CType   to_c_type      (CType   ptr)  { return ptr;      }
  static CppType to_cpp_type    (CType   ptr)
  {
     return CppType(const_cast<CTypeNonConst>(ptr));
  }

  static void release_c_type (CType)
  {
  }
};
#endif //DOXYGEN_SHOULD_SKIP_THIS

} //namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::PadTemplate
   */
  
  Glib::RefPtr<Gst::PadTemplate> wrap(GstPadTemplate* object, bool take_copy = false);
}


namespace Glib
{

/** @relates Gst::StaticPadTemplate
 * @param object The C instance
 * @result A C++ instance that wraps this C instance.
 */

Gst::StaticPadTemplate& wrap(GstStaticPadTemplate* object);

/** @relates Gst::StaticPadTemplate
 * @param object The C instance
 * @result A C++ instance that wraps this C instance.
 */

const Gst::StaticPadTemplate& wrap(const GstStaticPadTemplate* object);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class  Value<Gst::StaticPadTemplate> : public Glib::Value_Boxed<Gst::StaticPadTemplate>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


#endif /* _GSTREAMERMM_PADTEMPLATE_H */

