/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.codegen;

import jadx.api.plugins.input.data.IFieldData;
import jadx.api.plugins.input.data.annotations.EncodedValue;
import jadx.api.plugins.input.data.annotations.IAnnotation;
import jadx.core.codegen.ClassGen;
import jadx.core.codegen.CodeWriter;
import jadx.core.codegen.InsnGen;
import jadx.core.codegen.TypeGen;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.IAttributeNode;
import jadx.core.dex.attributes.annotations.AnnotationsList;
import jadx.core.dex.attributes.annotations.MethodParameters;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.StringUtils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class AnnotationGen {
    private final ClassNode cls;
    private final ClassGen classGen;

    public AnnotationGen(ClassNode cls, ClassGen classGen) {
        this.cls = cls;
        this.classGen = classGen;
    }

    public void addForClass(CodeWriter code) {
        this.add(this.cls, code);
    }

    public void addForMethod(CodeWriter code, MethodNode mth) {
        this.add(mth, code);
    }

    public void addForField(CodeWriter code, FieldNode field) {
        this.add(field, code);
    }

    public void addForParameter(CodeWriter code, MethodParameters paramsAnnotations, int n) {
        List<AnnotationsList> paramList = paramsAnnotations.getParamList();
        if (n >= paramList.size()) {
            return;
        }
        AnnotationsList aList = paramList.get(n);
        if (aList == null || aList.isEmpty()) {
            return;
        }
        for (IAnnotation a : aList.getAll()) {
            this.formatAnnotation(code, a);
            code.add(' ');
        }
    }

    private void add(IAttributeNode node, CodeWriter code) {
        AnnotationsList aList = node.get(AType.ANNOTATION_LIST);
        if (aList == null || aList.isEmpty()) {
            return;
        }
        for (IAnnotation a : aList.getAll()) {
            String aCls = a.getAnnotationClass();
            if (aCls.startsWith("Ldalvik/annotation/")) continue;
            code.startLine();
            this.formatAnnotation(code, a);
        }
    }

    private void formatAnnotation(CodeWriter code, IAnnotation a) {
        code.add('@');
        ClassNode annCls = this.cls.root().resolveClass(a.getAnnotationClass());
        if (annCls != null) {
            this.classGen.useClass(code, annCls);
        } else {
            this.classGen.useClass(code, a.getAnnotationClass());
        }
        Map vl = a.getValues();
        if (!vl.isEmpty()) {
            code.add('(');
            Iterator it = vl.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                String paramName = this.getParamName(annCls, (String)e.getKey());
                if (!paramName.equals("value") || vl.size() != 1) {
                    code.add(paramName);
                    code.add(" = ");
                }
                this.encodeValue(this.cls.root(), code, (EncodedValue)e.getValue());
                if (!it.hasNext()) continue;
                code.add(", ");
            }
            code.add(')');
        }
    }

    private String getParamName(@Nullable ClassNode annCls, String paramName) {
        MethodNode mth;
        if (annCls != null && (mth = annCls.searchMethodByShortName(paramName)) != null) {
            return mth.getAlias();
        }
        return paramName;
    }

    public void addThrows(MethodNode mth, CodeWriter code) {
        List<ArgType> throwList = mth.getThrows();
        if (!throwList.isEmpty()) {
            code.add(" throws ");
            Iterator<ArgType> it = throwList.iterator();
            while (it.hasNext()) {
                ArgType ex = it.next();
                this.classGen.useType(code, ex);
                if (!it.hasNext()) continue;
                code.add(", ");
            }
        }
    }

    public EncodedValue getAnnotationDefaultValue(String name) {
        EncodedValue defValue;
        IAnnotation an = this.cls.getAnnotation("Ldalvik/annotation/AnnotationDefault;");
        if (an != null && (defValue = an.getDefaultValue()) != null) {
            IAnnotation defAnnotation = (IAnnotation)defValue.getValue();
            return (EncodedValue)defAnnotation.getValues().get(name);
        }
        return null;
    }

    public void encodeValue(RootNode root, CodeWriter code, EncodedValue encodedValue) {
        if (encodedValue == null) {
            code.add("null");
            return;
        }
        Object value = encodedValue.getValue();
        switch (encodedValue.getType()) {
            case ENCODED_NULL: {
                code.add("null");
                break;
            }
            case ENCODED_BOOLEAN: {
                code.add(Boolean.TRUE.equals(value) ? "true" : "false");
                break;
            }
            case ENCODED_BYTE: {
                code.add(TypeGen.formatByte(((Byte)value).byteValue(), false));
                break;
            }
            case ENCODED_SHORT: {
                code.add(TypeGen.formatShort(((Short)value).shortValue(), false));
                break;
            }
            case ENCODED_CHAR: {
                code.add(this.getStringUtils().unescapeChar(((Character)value).charValue()));
                break;
            }
            case ENCODED_INT: {
                code.add(TypeGen.formatInteger(((Integer)value).intValue(), false));
                break;
            }
            case ENCODED_LONG: {
                code.add(TypeGen.formatLong((Long)value, false));
                break;
            }
            case ENCODED_FLOAT: {
                code.add(TypeGen.formatFloat(((Float)value).floatValue()));
                break;
            }
            case ENCODED_DOUBLE: {
                code.add(TypeGen.formatDouble((Double)value));
                break;
            }
            case ENCODED_STRING: {
                code.add(this.getStringUtils().unescapeString((String)value));
                break;
            }
            case ENCODED_TYPE: {
                this.classGen.useType(code, ArgType.parse((String)value));
                code.add(".class");
                break;
            }
            case ENCODED_ENUM: 
            case ENCODED_FIELD: {
                if (value instanceof IFieldData) {
                    FieldInfo field = FieldInfo.fromData(root, (IFieldData)value);
                    InsnGen.makeStaticFieldAccess(code, field, this.classGen);
                    break;
                }
                if (value instanceof FieldInfo) {
                    InsnGen.makeStaticFieldAccess(code, (FieldInfo)value, this.classGen);
                    break;
                }
                throw new JadxRuntimeException("Unexpected field type class: " + value.getClass());
            }
            case ENCODED_METHOD: {
                break;
            }
            case ENCODED_ARRAY: {
                code.add('{');
                Iterator it = ((Iterable)value).iterator();
                while (it.hasNext()) {
                    EncodedValue v = (EncodedValue)it.next();
                    this.encodeValue(this.cls.root(), code, v);
                    if (!it.hasNext()) continue;
                    code.add(", ");
                }
                code.add('}');
                break;
            }
            case ENCODED_ANNOTATION: {
                this.formatAnnotation(code, (IAnnotation)value);
                break;
            }
            default: {
                throw new JadxRuntimeException("Can't decode value: " + encodedValue.getType() + " (" + encodedValue + ')');
            }
        }
    }

    private StringUtils getStringUtils() {
        return this.cls.root().getStringUtils();
    }
}

