/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class RolloverToggleButton
extends JToggleButton {
    private Border originalBorder;
    private Border rolloverBorder;
    private static final AlphaComposite c = AlphaComposite.getInstance(3, 0.5f);
    private boolean revalidateBlocked;

    public RolloverToggleButton() {
        this.setBorderPainted(true);
        Color color = UIManager.getColor("Button.darkShadow");
        Color color2 = UIManager.getColor("Button.foreground");
        this.originalBorder = BorderFactory.createLineBorder(color, 1);
        this.rolloverBorder = BorderFactory.createLineBorder(color2, 1);
        this.setBorder(this.originalBorder);
        this.setContentAreaFilled(false);
        this.addMouseListener(new MouseOverHandler());
    }

    public RolloverToggleButton(Icon icon) {
        this();
        this.setIcon(icon);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setBorder(this.originalBorder);
        this.setRequestFocusEnabled(false);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.setBorderPainted(true);
        this.repaint();
    }

    @Override
    public void setBorderPainted(boolean bl) {
        try {
            this.revalidateBlocked = true;
            super.setBorderPainted(bl);
            this.setContentAreaFilled(false);
        }
        finally {
            this.revalidateBlocked = false;
        }
    }

    @Override
    public void revalidate() {
        if (!this.revalidateBlocked) {
            super.revalidate();
        }
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.isEnabled()) {
            super.paint(graphics);
        } else {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setComposite(c);
            super.paint(graphics2D);
        }
    }

    class MouseOverHandler
    extends MouseAdapter {
        MouseOverHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            RolloverToggleButton.this.setBorder(RolloverToggleButton.this.rolloverBorder);
            RolloverToggleButton.this.setContentAreaFilled(false);
            RolloverToggleButton.this.setBorderPainted(true);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            RolloverToggleButton.this.setBorder(RolloverToggleButton.this.originalBorder);
            RolloverToggleButton.this.setContentAreaFilled(false);
            RolloverToggleButton.this.setBorderPainted(true);
        }
    }
}

