/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.menu;

import java.util.StringTokenizer;
import javax.swing.JMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.gjt.sp.jedit.ActionContext;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.menu.DynamicMenuProvider;
import org.gjt.sp.jedit.msg.DynamicMenuChanged;
import org.gjt.sp.jedit.msg.PropertiesChanged;

public class EnhancedMenu
extends JMenu
implements MenuListener {
    protected int initialComponentCount;
    protected ActionContext context;
    protected String providerCode;
    protected DynamicMenuProvider provider;
    protected EditBusStub ebStub;

    public EnhancedMenu(String string) {
        this(string, jEdit.getProperty(string.concat(".label")), jEdit.getActionContext());
    }

    public EnhancedMenu(String string, String string2) {
        this(string, string2, jEdit.getActionContext());
    }

    public EnhancedMenu(String string, String string2, ActionContext actionContext) {
        String string3;
        char c;
        int n;
        this.context = actionContext;
        if (string2 == null) {
            string2 = string;
        }
        if ((n = string2.indexOf(36)) != -1 && string2.length() - n > 1) {
            c = Character.toLowerCase(string2.charAt(n + 1));
            string2 = string2.substring(0, n).concat(string2.substring(++n));
        } else {
            c = '\u0000';
        }
        this.setText(string2);
        if (!OperatingSystem.isMacOS()) {
            this.setMnemonic(c);
        }
        if ((string3 = jEdit.getProperty(string)) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string3);
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if (string4.equals("-")) {
                    this.addSeparator();
                    continue;
                }
                this.add(GUIUtilities.loadMenuItem(actionContext, string4, true));
            }
        }
        this.initialComponentCount = this.getMenuComponentCount();
        this.providerCode = jEdit.getProperty(string + ".code");
        this.ebStub = new EditBusStub(string);
        this.ebStub.menuOutOfDate = true;
        this.addMenuListener(this);
        if (this.providerCode != null) {
            EditBus.addToBus(this.ebStub);
        }
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
        this.init();
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void init() {
        if (this.providerCode == null) {
            return;
        }
        if (this.provider == null) {
            Object object = BeanShell.eval(null, BeanShell.getNameSpace(), this.providerCode);
            this.provider = (DynamicMenuProvider)object;
        }
        if (this.provider == null) {
            this.providerCode = null;
            return;
        }
        if (this.ebStub.menuOutOfDate || this.provider.updateEveryTime()) {
            this.ebStub.menuOutOfDate = false;
            while (this.getMenuComponentCount() != this.initialComponentCount) {
                this.remove(this.getMenuComponentCount() - 1);
            }
            if (this.provider != null) {
                this.provider.update(this);
            }
        }
    }

    protected void finalize() {
        if (this.ebStub != null) {
            EditBus.removeFromBus(this.ebStub);
        }
    }

    public static class EditBusStub {
        String name;
        boolean menuOutOfDate;

        EditBusStub(String string) {
            this.name = string;
            this.menuOutOfDate = true;
        }

        @EditBus.EBHandler
        public void handleDynamicMenuChanged(DynamicMenuChanged dynamicMenuChanged) {
            if (this.name.equals(dynamicMenuChanged.getMenuName())) {
                this.menuOutOfDate = true;
            }
        }

        @EditBus.EBHandler
        public void handlePropertiesChanged(PropertiesChanged propertiesChanged) {
            this.menuOutOfDate = true;
        }
    }
}

