/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.libraries;

import cc.arduino.contributions.VersionComparator;
import cc.arduino.contributions.libraries.ContributedLibrary;
import cc.arduino.contributions.libraries.ContributedLibraryDependency;
import cc.arduino.contributions.libraries.ContributedLibraryReleases;
import cc.arduino.contributions.libraries.UnavailableContributedLibrary;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class LibrariesIndex {
    private ArrayList<ContributedLibrary> list = new ArrayList();

    public List<ContributedLibrary> getLibraries() {
        return this.list;
    }

    public List<ContributedLibrary> find(String name) {
        return this.getLibraries().stream().filter(l -> name.equals(l.getName())).collect(Collectors.toList());
    }

    public ContributedLibrary find(String name, String version) {
        if (name == null || version == null) {
            return null;
        }
        for (ContributedLibrary lib : this.find(name)) {
            if (!version.equals(lib.getParsedVersion())) continue;
            return lib;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (ContributedLibrary library : this.getLibraries()) {
            sb.append(library.toString());
        }
        return sb.toString();
    }

    public List<String> getCategories() {
        LinkedList<String> categories = new LinkedList<String>();
        for (ContributedLibrary lib : this.getLibraries()) {
            if (lib.getCategory() == null || categories.contains(lib.getCategory())) continue;
            categories.add(lib.getCategory());
        }
        Collections.sort(categories);
        return categories;
    }

    public List<String> getTypes() {
        HashSet<String> typesAccumulator = new HashSet<String>();
        for (ContributedLibrary lib : this.getLibraries()) {
            if (lib.getTypes() == null) continue;
            typesAccumulator.addAll(lib.getTypes());
        }
        LinkedList<String> types = new LinkedList<String>(typesAccumulator);
        Collections.sort(types);
        return types;
    }

    public Optional<ContributedLibrary> getInstalled(String name) {
        ContributedLibraryReleases rel = new ContributedLibraryReleases(this.find(name));
        return rel.getInstalled();
    }

    public List<ContributedLibrary> resolveDependeciesOf(ContributedLibrary library) {
        ArrayList<ContributedLibrary> solution = new ArrayList<ContributedLibrary>();
        solution.add(library);
        if (this.resolveDependeciesOf(solution, library)) {
            return solution;
        }
        return null;
    }

    public boolean resolveDependeciesOf(List<ContributedLibrary> solution, ContributedLibrary library) {
        List<ContributedLibraryDependency> requirements = library.getDependencies();
        if (requirements == null) {
            return true;
        }
        for (ContributedLibraryDependency dep : requirements) {
            boolean alreadyInSolution = solution.stream().anyMatch(l -> l.getName().equals(dep.getName()));
            if (alreadyInSolution) continue;
            List<ContributedLibrary> possibleDeps = this.findMatchingDependencies(dep);
            if (possibleDeps.isEmpty()) {
                solution.add(new UnavailableContributedLibrary(dep));
                continue;
            }
            Optional<ContributedLibrary> installed = possibleDeps.stream().filter(l -> l.getInstalledLibrary().isPresent()).findAny();
            ContributedLibrary selected = installed.isPresent() ? installed.get() : (ContributedLibrary)possibleDeps.stream().reduce(VersionComparator::max).get();
            solution.add(selected);
            if (this.resolveDependeciesOf(solution, selected)) continue;
            return false;
        }
        return true;
    }

    private List<ContributedLibrary> findMatchingDependencies(ContributedLibraryDependency dep) {
        List<ContributedLibrary> available = this.find(dep.getName());
        if (dep.getVersion() == null || dep.getVersion().isEmpty()) {
            return available;
        }
        return available;
    }
}

