/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.SettingsXML;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.DynamicMenuChanged;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.XMLUtilities;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class BufferHistory {
    private static LinkedList<Entry> history = new LinkedList();
    private static final ReentrantReadWriteLock historyLock = new ReentrantReadWriteLock();
    private static SettingsXML recentXML;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Entry getEntry(String string) {
        historyLock.readLock().lock();
        try {
            for (Entry entry : history) {
                if (!MiscUtilities.pathsEqual(entry.path, string)) continue;
                Entry entry2 = entry;
                return entry2;
            }
        }
        finally {
            historyLock.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setEntry(String string, int n, Selection[] selectionArray, String string2, String string3) {
        Entry entry = new Entry(string, n, BufferHistory.selectionToString(selectionArray), string2, string3);
        historyLock.writeLock().lock();
        try {
            BufferHistory.removeEntry(string);
            BufferHistory.addEntry(entry);
        }
        finally {
            historyLock.writeLock().unlock();
        }
        BufferHistory.notifyChange();
    }

    public static void clear() {
        historyLock.writeLock().lock();
        try {
            history.clear();
        }
        finally {
            historyLock.writeLock().unlock();
        }
        BufferHistory.notifyChange();
    }

    public static List<Entry> getHistory() {
        historyLock.readLock().lock();
        try {
            List list = (List)history.clone();
            return list;
        }
        finally {
            historyLock.readLock().unlock();
        }
    }

    public static void load() {
        if (recentXML == null) {
            return;
        }
        if (!recentXML.fileExists()) {
            return;
        }
        Log.log(3, BufferHistory.class, "Loading " + recentXML);
        RecentHandler recentHandler = new RecentHandler();
        try {
            recentXML.load(recentHandler);
        }
        catch (IOException iOException) {
            Log.log(9, BufferHistory.class, iOException);
        }
        BufferHistory.trimToLimit(recentHandler.result);
        history = recentHandler.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save() {
        if (recentXML == null) {
            return;
        }
        if (recentXML.hasChangedOnDisk()) {
            Log.log(7, BufferHistory.class, recentXML + " changed on disk; will not save recent files");
            return;
        }
        Log.log(3, BufferHistory.class, "Saving " + recentXML);
        String string = System.getProperty("line.separator");
        SettingsXML.Saver saver = null;
        try {
            saver = recentXML.openSaver();
            saver.writeXMLDeclaration();
            saver.write("<!DOCTYPE RECENT SYSTEM \"recent.dtd\">");
            saver.write(string);
            saver.write("<RECENT>");
            saver.write(string);
            List<Entry> list = BufferHistory.getHistory();
            for (Entry entry : list) {
                saver.write("<ENTRY>");
                saver.write(string);
                saver.write("<PATH>");
                saver.write(XMLUtilities.charsToEntities(entry.path, false));
                saver.write("</PATH>");
                saver.write(string);
                saver.write("<CARET>");
                saver.write(String.valueOf(entry.caret));
                saver.write("</CARET>");
                saver.write(string);
                if (entry.selection != null && entry.selection.length() > 0) {
                    saver.write("<SELECTION>");
                    saver.write(entry.selection);
                    saver.write("</SELECTION>");
                    saver.write(string);
                }
                if (entry.encoding != null) {
                    saver.write("<ENCODING>");
                    saver.write(entry.encoding);
                    saver.write("</ENCODING>");
                    saver.write(string);
                }
                if (entry.mode != null) {
                    saver.write("<MODE>");
                    saver.write(entry.mode);
                    saver.write("</MODE>");
                    saver.write(string);
                }
                saver.write("</ENTRY>");
                saver.write(string);
            }
            saver.write("</RECENT>");
            saver.write(string);
            saver.finish();
        }
        catch (Exception exception) {
            Log.log(9, BufferHistory.class, exception);
        }
        finally {
            IOUtilities.closeQuietly(saver);
        }
    }

    private static void addEntry(Entry entry) {
        historyLock.writeLock().lock();
        try {
            history.addFirst(entry);
            BufferHistory.trimToLimit(history);
        }
        finally {
            historyLock.writeLock().unlock();
        }
    }

    private static void removeEntry(String string) {
        historyLock.writeLock().lock();
        try {
            Iterator iterator = history.iterator();
            while (iterator.hasNext()) {
                Entry entry = (Entry)iterator.next();
                if (!MiscUtilities.pathsEqual(string, entry.path)) continue;
                iterator.remove();
                return;
            }
        }
        finally {
            historyLock.writeLock().unlock();
        }
    }

    private static String selectionToString(Selection[] selectionArray) {
        if (selectionArray == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < selectionArray.length; ++i) {
            Selection selection;
            if (i != 0) {
                stringBuilder.append(' ');
            }
            if ((selection = selectionArray[i]) instanceof Selection.Range) {
                stringBuilder.append("range ");
            } else {
                stringBuilder.append("rect ");
            }
            stringBuilder.append(selection.getStart());
            stringBuilder.append(' ');
            stringBuilder.append(selection.getEnd());
        }
        return stringBuilder.toString();
    }

    private static Selection[] stringToSelection(String string) {
        Selection[] selectionArray;
        if (string == null) {
            return null;
        }
        ArrayList<Selection.Range> arrayList = new ArrayList<Selection.Range>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            selectionArray = stringTokenizer.nextToken();
            int n = Integer.parseInt(stringTokenizer.nextToken());
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            if (n2 < n) continue;
            Selection selection = "range".equals(selectionArray) ? new Selection.Range(n, n2) : new Selection.Rect(n, n2);
            arrayList.add((Selection.Range)selection);
        }
        selectionArray = new Selection[arrayList.size()];
        selectionArray = arrayList.toArray(selectionArray);
        return selectionArray;
    }

    private static void trimToLimit(Deque<Entry> deque) {
        int n = jEdit.getIntegerProperty("recentFiles", 40);
        while (deque.size() > n) {
            deque.removeLast();
        }
    }

    private static void notifyChange() {
        EditBus.send(new DynamicMenuChanged("recent-files"));
    }

    static {
        String string = jEdit.getSettingsDirectory();
        if (string != null) {
            recentXML = new SettingsXML(string, "recent");
        }
    }

    private static class RecentHandler
    extends DefaultHandler {
        public LinkedList<Entry> result = new LinkedList();
        private String path;
        private int caret;
        private String selection;
        private String encoding;
        private String mode;
        private final StringBuilder charData = new StringBuilder();

        private RecentHandler() {
        }

        @Override
        public InputSource resolveEntity(String string, String string2) {
            return XMLUtilities.findEntity(string2, "recent.dtd", this.getClass());
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            if ("ENTRY".equals(string3)) {
                this.result.addLast(new Entry(this.path, this.caret, this.selection, this.encoding, this.mode));
                this.path = null;
                this.caret = 0;
                this.selection = null;
                this.encoding = null;
                this.mode = null;
            } else if ("PATH".equals(string3)) {
                this.path = this.charData.toString();
            } else if ("CARET".equals(string3)) {
                try {
                    String string4 = this.charData.toString().trim();
                    if (string4.length() != this.charData.length()) {
                        Log.log(7, this, "The caret position in recent.xml was wrong: '" + this.charData + "', fixing it");
                    }
                    this.caret = Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    Log.log(9, this, "Unable to parse caret position " + this.charData);
                }
            } else if ("SELECTION".equals(string3)) {
                this.selection = this.charData.toString();
            } else if ("ENCODING".equals(string3)) {
                this.encoding = this.charData.toString();
            } else if ("MODE".equals(string3)) {
                this.mode = this.charData.toString();
            }
            this.charData.setLength(0);
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            this.charData.append(cArray, n, n2);
        }
    }

    public static class Entry {
        public String path;
        public int caret;
        public String selection;
        public String encoding;
        public String mode;

        public Selection[] getSelection() {
            return BufferHistory.stringToSelection(this.selection);
        }

        public Entry(String string, int n, String string2, String string3, String string4) {
            this.path = string;
            this.caret = n;
            this.selection = string2;
            this.encoding = string3;
            this.mode = string4;
        }

        public String toString() {
            return this.path + ": " + this.caret;
        }
    }
}

