/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.SystemTray;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.stream.IntStream;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.gui.ColorWellButton;
import org.gjt.sp.jedit.gui.FontSelector;
import org.gjt.sp.jedit.gui.NumericTextField;
import org.gjt.sp.jedit.gui.ScreenRectangleSelectionButton;
import org.gjt.sp.jedit.gui.tray.JTrayIconManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.options.IconTheme;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;

public class AppearanceOptionPane
extends AbstractOptionPane
implements ItemListener {
    public static final String[] builtInIconThemes = new String[]{"tango", "old"};
    private UIManager.LookAndFeelInfo[] lfs;
    private JComboBox<String> lookAndFeel;
    private FontSelector primaryFont;
    private FontSelector secondaryFont;
    private FontSelector helpViewerFont;
    private JTextField history;
    private JTextField menuSpillover;
    private JCheckBox showTips;
    private JCheckBox showSplash;
    private JCheckBox textColors;
    private JCheckBox decorateFrames;
    private JCheckBox decorateDialogs;
    private JComboBox<String> iconThemes;
    private JCheckBox systemTrayIcon;
    private JRadioButton systemTrayIconBackgroundDefault;
    private JRadioButton systemTrayIconBackgroundAutodetect;
    private JRadioButton systemTrayIconBackgroundFixedColor;
    private JRadioButton systemTrayIconBackgroundPickedRectangle;
    private ColorWellButton systemTrayIconBackgroundColor;
    private ScreenRectangleSelectionButton systemTrayIconBackgroundRectangle;
    private boolean lnfChanged = false;

    public AppearanceOptionPane() {
        super("appearance");
    }

    @Override
    protected void _init() {
        String string;
        this.lfs = UIManager.getInstalledLookAndFeels();
        String[] stringArray = new String[this.lfs.length];
        String string2 = UIManager.getLookAndFeel().getClass().getName();
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.lfs[i].getName();
            if (!string2.equals(this.lfs[i].getClassName())) continue;
            n = i;
        }
        this.lookAndFeel = new JComboBox<String>(stringArray);
        this.lookAndFeel.setSelectedIndex(n);
        this.lookAndFeel.addItemListener(this);
        this.addComponent(jEdit.getProperty("options.appearance.lf"), this.lookAndFeel);
        String[] stringArray2 = IconTheme.builtInNames();
        this.iconThemes = new JComboBox<String>(stringArray2);
        this.addComponent(jEdit.getProperty("options.appearance.iconTheme"), this.iconThemes);
        String string3 = IconTheme.get();
        for (int i = 0; i < stringArray2.length; ++i) {
            if (!stringArray2[i].equals(string3)) continue;
            this.iconThemes.setSelectedIndex(i);
            break;
        }
        Font font = jEdit.getFontProperty("metal.primary.font");
        this.primaryFont = new FontSelector(font);
        this.primaryFont.setEnabled(true);
        this.addComponent(jEdit.getProperty("options.appearance.primaryFont"), (Component)this.primaryFont);
        this.secondaryFont = new FontSelector(jEdit.getFontProperty("metal.secondary.font"));
        this.secondaryFont.setEnabled(true);
        this.addComponent(jEdit.getProperty("options.appearance.secondaryFont"), (Component)this.secondaryFont);
        this.helpViewerFont = new FontSelector(jEdit.getFontProperty("helpviewer.font", font));
        this.addComponent(jEdit.getProperty("options.appearance.helpViewerFont"), (Component)this.helpViewerFont);
        this.history = new NumericTextField(jEdit.getProperty("history"), true);
        this.addComponent(jEdit.getProperty("options.appearance.history"), (Component)this.history);
        this.menuSpillover = new NumericTextField(jEdit.getProperty("menu.spillover"), true);
        this.addComponent(jEdit.getProperty("options.appearance.menuSpillover"), (Component)this.menuSpillover);
        this.addSeparator("options.appearance.systrayicon.label");
        this.systemTrayIcon = new JCheckBox(jEdit.getProperty("options.appearance.systrayicon"), jEdit.getBooleanProperty("systrayicon", true));
        if (!SystemTray.isSupported()) {
            this.systemTrayIcon.setSelected(false);
            this.systemTrayIcon.setEnabled(false);
            this.addComponent(new JLabel(jEdit.getProperty("options.appearance.systrayicon.not.supported")));
        }
        this.addComponent(this.systemTrayIcon);
        if (OperatingSystem.isX11()) {
            Object object;
            string = jEdit.getProperty("systrayicon.background", "autodetect").toLowerCase();
            this.systemTrayIconBackgroundDefault = new JRadioButton(jEdit.getProperty("options.appearance.systrayicon.background.default"), string.equals("default"));
            this.systemTrayIconBackgroundDefault.setEnabled(this.systemTrayIcon.isSelected());
            this.systemTrayIconBackgroundAutodetect = new JRadioButton(jEdit.getProperty("options.appearance.systrayicon.background.autodetect"), string.equals("autodetect"));
            this.systemTrayIconBackgroundAutodetect.setEnabled(this.systemTrayIcon.isSelected());
            this.systemTrayIconBackgroundFixedColor = new JRadioButton(jEdit.getProperty("options.appearance.systrayicon.background.fixed"), string.equals("fixed"));
            this.systemTrayIconBackgroundFixedColor.setEnabled(this.systemTrayIcon.isSelected());
            this.systemTrayIconBackgroundPickedRectangle = new JRadioButton(jEdit.getProperty("options.appearance.systrayicon.background.picked"), string.equals("picked"));
            this.systemTrayIconBackgroundPickedRectangle.setEnabled(this.systemTrayIcon.isSelected());
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.systemTrayIconBackgroundDefault);
            buttonGroup.add(this.systemTrayIconBackgroundAutodetect);
            buttonGroup.add(this.systemTrayIconBackgroundFixedColor);
            buttonGroup.add(this.systemTrayIconBackgroundPickedRectangle);
            this.addComponent(this.systemTrayIconBackgroundDefault);
            this.addComponent(this.systemTrayIconBackgroundAutodetect);
            this.addComponent(this.systemTrayIconBackgroundFixedColor);
            this.systemTrayIconBackgroundColor = new ColorWellButton(jEdit.getColorProperty("systrayicon.bgColor"));
            this.systemTrayIconBackgroundColor.setEnabled(this.systemTrayIconBackgroundFixedColor.isEnabled() && this.systemTrayIconBackgroundFixedColor.isSelected());
            JLabel jLabel = this.newLabel(jEdit.getProperty("options.appearance.systrayicon.background.color.label"), this.systemTrayIconBackgroundColor);
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 12));
            jLabel.setEnabled(this.systemTrayIconBackgroundFixedColor.isEnabled() && this.systemTrayIconBackgroundFixedColor.isSelected());
            this.addComponent(jLabel, (Component)this.systemTrayIconBackgroundColor, 3);
            this.systemTrayIconBackgroundFixedColor.addItemListener(itemEvent -> {
                boolean bl = itemEvent.getStateChange() == 1;
                jLabel.setEnabled(bl);
                this.systemTrayIconBackgroundColor.setEnabled(bl);
            });
            this.addComponent(this.systemTrayIconBackgroundPickedRectangle);
            Color[][] colorArray = jEdit.getColorMatrixProperty("systrayicon.bgPixel");
            BufferedImage bufferedImage = null;
            if (colorArray != null) {
                object = Arrays.stream(colorArray).flatMap(Arrays::stream).mapToInt(Color::getRGB).toArray();
                int n2 = colorArray[0].length;
                int n3 = colorArray.length;
                bufferedImage = new BufferedImage(n2, n3, 1);
                bufferedImage.setRGB(0, 0, n2, n3, (int[])object, 0, n2);
            }
            this.systemTrayIconBackgroundRectangle = new ScreenRectangleSelectionButton(bufferedImage);
            object = this.newLabel(jEdit.getProperty("options.appearance.systrayicon.background.pixel.label"), this.systemTrayIconBackgroundRectangle);
            if (SystemTray.isSupported()) {
                this.systemTrayIconBackgroundRectangle.setRectangleDimension(SystemTray.getSystemTray().getTrayIconSize());
                this.systemTrayIconBackgroundRectangle.setEnabled(this.systemTrayIconBackgroundPickedRectangle.isEnabled() && this.systemTrayIconBackgroundPickedRectangle.isSelected());
                ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 12));
                ((JComponent)object).setEnabled(this.systemTrayIconBackgroundPickedRectangle.isEnabled() && this.systemTrayIconBackgroundPickedRectangle.isSelected());
                this.addComponent((Component)object, (Component)this.systemTrayIconBackgroundRectangle, 3);
            }
            this.systemTrayIconBackgroundPickedRectangle.addItemListener(arg_0 -> this.lambda$_init$1((JLabel)object, arg_0));
            this.systemTrayIcon.addItemListener(arg_0 -> this.lambda$_init$2(jLabel, (JLabel)object, arg_0));
        }
        this.addSeparator("options.appearance.startup.label");
        this.showSplash = new JCheckBox(jEdit.getProperty("options.appearance.showSplash"));
        string = jEdit.getSettingsDirectory();
        if (string == null) {
            this.showSplash.setSelected(true);
        } else {
            this.showSplash.setSelected(!new File(string, "nosplash").exists());
        }
        this.addComponent(this.showSplash);
        this.showTips = new JCheckBox(jEdit.getProperty("options.appearance.showTips"));
        this.showTips.setSelected(jEdit.getBooleanProperty("tip.show"));
        this.addComponent(this.showTips);
        this.addSeparator("options.appearance.experimental.label");
        this.addComponent(GUIUtilities.createMultilineLabel(jEdit.getProperty("options.appearance.experimental.caption")));
        this.textColors = new JCheckBox(jEdit.getProperty("options.appearance.textColors"));
        this.textColors.setSelected(jEdit.getBooleanProperty("textColors"));
        this.addComponent(this.textColors);
        this.decorateFrames = new JCheckBox(jEdit.getProperty("options.appearance.decorateFrames"));
        this.decorateFrames.setSelected(jEdit.getBooleanProperty("decorate.frames"));
        this.addComponent(this.decorateFrames);
        this.decorateDialogs = new JCheckBox(jEdit.getProperty("options.appearance.decorateDialogs"));
        this.decorateDialogs.setSelected(jEdit.getBooleanProperty("decorate.dialogs"));
        this.addComponent(this.decorateDialogs);
        this.lnfChanged = false;
    }

    @Override
    protected void _save() {
        String string;
        if (this.lnfChanged) {
            string = this.lfs[this.lookAndFeel.getSelectedIndex()].getClassName();
            jEdit.setProperty("lookAndFeel", string);
        }
        jEdit.setFontProperty("metal.primary.font", this.primaryFont.getFont());
        jEdit.setFontProperty("metal.secondary.font", this.secondaryFont.getFont());
        jEdit.setFontProperty("helpviewer.font", this.helpViewerFont.getFont());
        jEdit.setProperty("history", this.history.getText());
        jEdit.setProperty("menu.spillover", this.menuSpillover.getText());
        jEdit.setBooleanProperty("tip.show", this.showTips.isSelected());
        if (SystemTray.isSupported()) {
            jEdit.setBooleanProperty("systrayicon", this.systemTrayIcon.isSelected());
            if (OperatingSystem.isX11()) {
                string = jEdit.getProperty("systrayicon.background", "autodetect");
                String string2 = this.systemTrayIconBackgroundDefault.isSelected() ? "default" : (this.systemTrayIconBackgroundAutodetect.isSelected() ? "autodetect" : (this.systemTrayIconBackgroundFixedColor.isSelected() ? "fixed" : (this.systemTrayIconBackgroundPickedRectangle.isSelected() ? "picked" : "autodetect")));
                jEdit.setProperty("systrayicon.background", string2);
                Color color = jEdit.getColorProperty("systrayicon.bgColor");
                Color color2 = this.systemTrayIconBackgroundColor.getSelectedColor();
                jEdit.setColorProperty("systrayicon.bgColor", color2);
                Color[][] colorArray = jEdit.getColorMatrixProperty("systrayicon.bgPixel");
                BufferedImage bufferedImage = this.systemTrayIconBackgroundRectangle.getSelectedImage();
                Color[][] colorArray2 = null;
                if (bufferedImage != null) {
                    int n3 = bufferedImage.getWidth();
                    int n4 = bufferedImage.getHeight();
                    Color[] colorArray3 = (Color[])Arrays.stream(bufferedImage.getRGB(0, 0, n3, n4, null, 0, n3)).mapToObj(Color::new).toArray(Color[]::new);
                    colorArray2 = (Color[][])IntStream.range(0, n4).mapToObj(n2 -> Arrays.copyOfRange(colorArray3, n2 * n3, (n2 + 1) * n3)).toArray(n -> new Color[n][]);
                }
                jEdit.setColorMatrixProperty("systrayicon.bgPixel", colorArray2);
                if (!string.equals(string2) || string2.equals("fixed") && !color.equals(color2) || string2.equals("picked") && !Arrays.deepEquals((Object[])colorArray, colorArray2)) {
                    JTrayIconManager.removeTrayIcon();
                    JTrayIconManager.addTrayIcon();
                }
            }
        }
        IconTheme.set(this.iconThemes.getSelectedItem().toString());
        this.setFonts();
        this.setFileFlag("nosplash", !this.showSplash.isSelected());
        jEdit.setBooleanProperty("textColors", this.textColors.isSelected());
        jEdit.setBooleanProperty("decorate.frames", this.decorateFrames.isSelected());
        jEdit.setBooleanProperty("decorate.dialogs", this.decorateDialogs.isSelected());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setFileFlag(String string, boolean bl) {
        String string2 = jEdit.getSettingsDirectory();
        if (string2 == null) return;
        File file = new File(string2, string);
        if (!bl) {
            file.delete();
            return;
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(10);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            try {
                Log.log(9, this, iOException);
            }
            catch (Throwable throwable) {
                IOUtilities.closeQuietly(fileOutputStream);
                throw throwable;
            }
            IOUtilities.closeQuietly(fileOutputStream);
            return;
        }
        IOUtilities.closeQuietly(fileOutputStream);
        return;
    }

    private void setFonts() {
        UIManager.put("Button.font", this.primaryFont.getFont());
        UIManager.put("CheckBox.font", this.primaryFont.getFont());
        UIManager.put("CheckBoxMenuItem.font", this.primaryFont.getFont());
        UIManager.put("ColorChooser.font", this.primaryFont.getFont());
        UIManager.put("DesktopIcon.font", this.primaryFont.getFont());
        UIManager.put("Label.font", this.primaryFont.getFont());
        UIManager.put("Menu.font", this.primaryFont.getFont());
        UIManager.put("MenuBar.font", this.primaryFont.getFont());
        UIManager.put("MenuItem.font", this.primaryFont.getFont());
        UIManager.put("OptionPane.font", this.primaryFont.getFont());
        UIManager.put("Panel.font", this.primaryFont.getFont());
        UIManager.put("PopupMenu.font", this.primaryFont.getFont());
        UIManager.put("ProgressBar.font", this.primaryFont.getFont());
        UIManager.put("RadioButton.font", this.primaryFont.getFont());
        UIManager.put("RadioButtonMenuItem.font", this.primaryFont.getFont());
        UIManager.put("ScrollPane.font", this.primaryFont.getFont());
        UIManager.put("Slider.font", this.primaryFont.getFont());
        UIManager.put("TabbedPane.font", this.primaryFont.getFont());
        UIManager.put("Table.font", this.primaryFont.getFont());
        UIManager.put("TableHeader.font", this.primaryFont.getFont());
        UIManager.put("TitledBorder.font", this.primaryFont.getFont());
        UIManager.put("ToggleButton.font", this.primaryFont.getFont());
        UIManager.put("ToolBar.font", this.primaryFont.getFont());
        UIManager.put("ToolTip.font", this.primaryFont.getFont());
        UIManager.put("Tree.font", this.primaryFont.getFont());
        UIManager.put("Viewport.font", this.primaryFont.getFont());
        UIManager.put("ComboBox.font", this.secondaryFont.getFont());
        UIManager.put("EditorPane.font", this.secondaryFont.getFont());
        UIManager.put("FormattedTextField.font", this.secondaryFont.getFont());
        UIManager.put("List.font", this.secondaryFont.getFont());
        UIManager.put("PasswordField.font", this.secondaryFont.getFont());
        UIManager.put("Spinner.font", this.secondaryFont.getFont());
        UIManager.put("TextArea.font", this.secondaryFont.getFont());
        UIManager.put("TextField.font", this.secondaryFont.getFont());
        UIManager.put("TextPane.font", this.secondaryFont.getFont());
    }

    @Override
    public final void itemStateChanged(ItemEvent itemEvent) {
        this.lnfChanged = true;
    }

    private /* synthetic */ void lambda$_init$2(JLabel jLabel, JLabel jLabel2, ItemEvent itemEvent) {
        boolean bl = itemEvent.getStateChange() == 1;
        this.systemTrayIconBackgroundDefault.setEnabled(bl);
        this.systemTrayIconBackgroundAutodetect.setEnabled(bl);
        this.systemTrayIconBackgroundFixedColor.setEnabled(bl);
        this.systemTrayIconBackgroundPickedRectangle.setEnabled(bl);
        if (bl) {
            jLabel.setEnabled(this.systemTrayIconBackgroundFixedColor.isSelected());
            this.systemTrayIconBackgroundColor.setEnabled(this.systemTrayIconBackgroundFixedColor.isSelected());
            jLabel2.setEnabled(this.systemTrayIconBackgroundPickedRectangle.isSelected());
            this.systemTrayIconBackgroundRectangle.setEnabled(this.systemTrayIconBackgroundPickedRectangle.isSelected());
        } else {
            jLabel.setEnabled(false);
            this.systemTrayIconBackgroundColor.setEnabled(false);
            jLabel2.setEnabled(false);
            this.systemTrayIconBackgroundRectangle.setEnabled(false);
        }
    }

    private /* synthetic */ void lambda$_init$1(JLabel jLabel, ItemEvent itemEvent) {
        boolean bl = itemEvent.getStateChange() == 1;
        jLabel.setEnabled(bl);
        this.systemTrayIconBackgroundRectangle.setEnabled(bl);
    }
}

