# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.resample_with_data_set import ResampleWithDataSet


class PResampleWithDataSet(ResampleWithDataSet):
    """
    PResampleWithDataSet - points from another dataset.
    
    Superclass: ResampleWithDataSet
    
    PResampleWithDataSet is the parallel version of
    ResampleWithDataSet filter
    @sa
    ResampleWithDataSet PResampleToImage
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPResampleWithDataSet, obj, update, **traits)
    
    use_balanced_partition_for_points_lookup = tvtk_base.false_bool_trait(desc=\
        """
        Set/Get if the filter should use Balanced Partitioning for fast
        lookup of the input points. Balanced Partitioning partitions the
        points into similar sized bins. It takes logarithmic time to
        search for the candidate bins, but search inside border bins
        takes constant time. The default is to use Regular Partitioning
        which partitions the space of the points into regular sized bins.
        Based on their distribution, the bins may contain widely varying
        number of points. It takes constant time to search for the
        candidate bins but search within border bins can vary. For most
        cases, both techniques perform the same with Regular Partitioning
        being slightly better. Balanced Partitioning may perform better
        when the points distribution is highly skewed.
        """
    )

    def _use_balanced_partition_for_points_lookup_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseBalancedPartitionForPointsLookup,
                        self.use_balanced_partition_for_points_lookup_)

    def _get_controller(self):
        return wrap_vtk(self._vtk_obj.GetController())
    def _set_controller(self, arg):
        old_val = self._get_controller()
        self._wrap_call(self._vtk_obj.SetController,
                        deref_vtk(arg))
        self.trait_property_changed('controller', old_val, arg)
    controller = traits.Property(_get_controller, _set_controller, desc=\
        """
        By default this filter uses the global controller, but this
        method can be used to set another instead.
        """
    )

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        """
        Get the input data object. This method is not recommended for
        use, but lots of old style filters use it.
        """
    )

    _updateable_traits_ = \
    (('use_balanced_partition_for_points_lookup',
    'GetUseBalancedPartitionForPointsLookup'), ('compute_tolerance',
    'GetComputeTolerance'), ('mark_blank_points_and_cells',
    'GetMarkBlankPointsAndCells'), ('pass_cell_arrays',
    'GetPassCellArrays'), ('pass_field_arrays', 'GetPassFieldArrays'),
    ('pass_point_arrays', 'GetPassPointArrays'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('categorical_data',
    'GetCategoricalData'), ('tolerance', 'GetTolerance'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'compute_tolerance', 'debug',
    'global_warning_display', 'mark_blank_points_and_cells',
    'pass_cell_arrays', 'pass_field_arrays', 'pass_point_arrays',
    'release_data_flag', 'use_balanced_partition_for_points_lookup',
    'categorical_data', 'progress_text', 'tolerance'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PResampleWithDataSet, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PResampleWithDataSet properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['compute_tolerance', 'mark_blank_points_and_cells',
            'pass_cell_arrays', 'pass_field_arrays', 'pass_point_arrays',
            'use_balanced_partition_for_points_lookup'], [], ['categorical_data',
            'tolerance']),
            title='Edit PResampleWithDataSet properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PResampleWithDataSet properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

