/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsbase.util.images;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;

public class ImageUtilities {
    private ImageUtilities() {
    }

    public static RenderedImage createRenderedImage(Image image, ImageObserver observer, Color bkg) {
        if (bkg == null && image instanceof RenderedImage) {
            return (RenderedImage)((Object)image);
        }
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(observer), image.getHeight(observer), bkg == null ? 2 : 1);
        Graphics g = bufferedImage.getGraphics();
        if (bkg == null) {
            g.drawImage(image, 0, 0, observer);
        } else {
            g.drawImage(image, 0, 0, bkg, observer);
        }
        return bufferedImage;
    }

    public static BufferedImage createBufferedImage(RenderedImage image, ImageObserver observer, Color bkg) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        throw new IllegalArgumentException("not supperted " + image.getClass());
    }

    public static BufferedImage createBufferedImage(Image image, ImageObserver observer, Color bkg) {
        if (bkg == null && image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        return (BufferedImage)ImageUtilities.createRenderedImage(image, observer, bkg);
    }

    public static RenderedImage createRenderedImage(RenderedImage image, Color bkg) {
        if (bkg == null) {
            return image;
        }
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        Graphics2D g = (Graphics2D)bufferedImage.getGraphics();
        g.setBackground(bkg);
        g.clearRect(0, 0, image.getWidth(), image.getHeight());
        g.drawRenderedImage(image, new AffineTransform());
        return bufferedImage;
    }

    public static byte[] getBytes(Image image, Color bkg, String code, int pad, ImageObserver observer) {
        return ImageUtilities.getBytes(ImageUtilities.createRenderedImage(image, observer, bkg), bkg, code, pad);
    }

    public static byte[] getBytes(RenderedImage image, Color bkg, String code, int pad) {
        boolean preMultiply;
        if (pad < 1) {
            pad = 1;
        }
        Raster raster = image.getData();
        int width = image.getWidth();
        int height = image.getHeight();
        boolean bl = preMultiply = code.charAt(0) == '*';
        if (preMultiply) {
            code = code.substring(1);
        }
        int pixelSize = code.length();
        int size = width * height * pixelSize;
        int index = 0;
        byte[] bytes = new byte[size += width % pad * height];
        ColorModel colorModel = image.getColorModel();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int argb = colorModel.getRGB(raster.getDataElements(x, y, null));
                int a = argb >> 24 & 0xFF;
                int r = argb >> 16 & 0xFF;
                int g = argb >> 8 & 0xFF;
                int b = argb >> 0 & 0xFF;
                if (preMultiply && a < 255) {
                    if (bkg == null) {
                        bkg = Color.BLACK;
                    }
                    double alpha = (double)a / 255.0;
                    r = (int)(alpha * (double)r + (1.0 - alpha) * (double)bkg.getRed());
                    g = (int)(alpha * (double)g + (1.0 - alpha) * (double)bkg.getGreen());
                    b = (int)(alpha * (double)b + (1.0 - alpha) * (double)bkg.getBlue());
                }
                for (int i = 0; i < code.length(); ++i) {
                    switch (code.charAt(i)) {
                        case 'A': 
                        case 'a': {
                            bytes[index] = (byte)a;
                            break;
                        }
                        case 'R': 
                        case 'r': {
                            bytes[index] = (byte)r;
                            break;
                        }
                        case 'G': 
                        case 'g': {
                            bytes[index] = (byte)g;
                            break;
                        }
                        case 'B': 
                        case 'b': {
                            bytes[index] = (byte)b;
                            break;
                        }
                        default: {
                            System.err.println(ImageUtilities.class.getClass() + ": Invalid code in '" + code + "'");
                        }
                    }
                    ++index;
                }
            }
            for (int i = 0; i < width % pad; ++i) {
                bytes[index] = 0;
                ++index;
            }
        }
        return bytes;
    }
}

