/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.PerspectiveManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

class Autosave
implements ActionListener {
    private static Timer timer;

    public static void setInterval(int n) {
        if (n == 0) {
            if (timer != null) {
                timer.stop();
                timer = null;
            }
            return;
        }
        n *= 1000;
        if (timer == null) {
            timer = new Timer(n, new Autosave());
            timer.start();
        } else {
            timer.setDelay(n);
        }
    }

    public static void stop() {
        if (timer != null) {
            timer.stop();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (jEdit.getIntegerProperty("autosave", 0) == 0) {
            return;
        }
        if (jEdit.getViewCount() != 0 && PerspectiveManager.isPerspectiveDirty()) {
            PerspectiveManager.setPerspectiveDirty(false);
            PerspectiveManager.savePerspective(true);
        }
        boolean bl = jEdit.getBooleanProperty("autosaveUntitled");
        jEdit.getBufferManager().getBuffers().stream().filter(buffer -> bl || !buffer.isUntitled()).forEach(Buffer::autosave);
        Log.flushStream();
    }

    private Autosave() {
    }
}

