/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.util;

import java.awt.Color;
import java.awt.Font;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.gjt.sp.jedit.IPropertyManager;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.jedit.syntax.Token;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

public class SyntaxUtilities {
    public static IPropertyManager propertyManager;
    private static final Pattern COLOR_MATRIX_PATTERN;
    private static final Pattern COMMA_BETWEEN_BRACKETS_SEPARATOR_PATTERN;
    private static final Pattern COMMA_SEPARATOR_PATTERN;

    public static String getColorHexString(Color color) {
        String string = "#ff000000";
        String string2 = Integer.toHexString(color.getRGB());
        return string.substring(0, string.length() - string2.length()).concat(string2);
    }

    public static Color parseColor(String object, Color color) {
        if (object == null || ((String)object).isEmpty()) {
            return color;
        }
        if (((String)(object = ((String)object).trim())).charAt(0) == '#') {
            try {
                object = ((String)object).substring(1);
                if (((String)object).length() == 6) {
                    object = "ff" + (String)object;
                }
                BigInteger bigInteger = new BigInteger((String)object, 16);
                return new Color(bigInteger.intValue(), true);
            }
            catch (NumberFormatException numberFormatException) {
                return color;
            }
        }
        if ("red".equals(object)) {
            return Color.red;
        }
        if ("green".equals(object)) {
            return Color.green;
        }
        if ("blue".equals(object)) {
            return Color.blue;
        }
        if ("yellow".equals(object)) {
            return Color.yellow;
        }
        if ("orange".equals(object)) {
            return Color.orange;
        }
        if ("white".equals(object)) {
            return Color.white;
        }
        if ("lightGray".equals(object)) {
            return Color.lightGray;
        }
        if ("gray".equals(object)) {
            return Color.gray;
        }
        if ("darkGray".equals(object)) {
            return Color.darkGray;
        }
        if ("black".equals(object)) {
            return Color.black;
        }
        if ("cyan".equals(object)) {
            return Color.cyan;
        }
        if ("magenta".equals(object)) {
            return Color.magenta;
        }
        if ("pink".equals(object)) {
            return Color.pink;
        }
        return color;
    }

    public static String getColorMatrixString(Color[][] colorArray2) {
        if (colorArray2 == null) {
            return null;
        }
        return Arrays.stream(colorArray2).map(colorArray -> Arrays.stream(colorArray).map(SyntaxUtilities::getColorHexString).collect(Collectors.joining(",", "[", "]"))).collect(Collectors.joining(",", "[", "]"));
    }

    public static Color[][] parseColorMatrix(String string, Color[][] colorArray2) {
        if (string == null || !COLOR_MATRIX_PATTERN.matcher(string).matches()) {
            return colorArray2;
        }
        Color[][] colorArray3 = (Color[][])COMMA_BETWEEN_BRACKETS_SEPARATOR_PATTERN.splitAsStream((string = string.strip()).substring(1, string.length() - 1)).map(string2 -> {
            string2 = string2.strip();
            return (Color[])COMMA_SEPARATOR_PATTERN.splitAsStream(string2.substring(1, string2.length() - 1)).map(String::strip).map(string -> SyntaxUtilities.parseColor(string, null)).toArray(Color[]::new);
        }).toArray(n -> new Color[n][]);
        if (Arrays.stream(colorArray3).flatMap(Arrays::stream).anyMatch(Objects::isNull) || Arrays.stream(colorArray3).mapToInt(colorArray -> ((Color[])colorArray).length).distinct().count() != 1L) {
            return colorArray2;
        }
        return colorArray3;
    }

    public static SyntaxStyle parseStyle(String string, String string2, int n, boolean bl, Color color) throws IllegalArgumentException {
        Color color2 = color;
        Color color3 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.startsWith("color:")) {
                if (!bl) continue;
                color2 = SyntaxUtilities.parseColor(string3.substring(6), Color.black);
                continue;
            }
            if (string3.startsWith("bgColor:")) {
                if (!bl) continue;
                color3 = SyntaxUtilities.parseColor(string3.substring(8), null);
                continue;
            }
            if (string3.startsWith("style:")) {
                for (int i = 6; i < string3.length(); ++i) {
                    if (string3.charAt(i) == 'i') {
                        bl2 = true;
                        continue;
                    }
                    if (string3.charAt(i) == 'b') {
                        bl3 = true;
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid style: " + string3);
                }
                continue;
            }
            throw new IllegalArgumentException("Invalid directive: " + string3);
        }
        return new SyntaxStyle(color2, color3, new Font(string2, (bl2 ? 2 : 0) | (bl3 ? 1 : 0), n));
    }

    public static SyntaxStyle parseStyle(String string, String string2, int n, boolean bl) throws IllegalArgumentException {
        return SyntaxUtilities.parseStyle(string, string2, n, bl, Color.black);
    }

    public static SyntaxStyle[] loadStyles(String string, int n) {
        return SyntaxUtilities.loadStyles(string, n, true);
    }

    public static SyntaxStyle[] loadStyles(String string, int n, boolean bl) {
        SyntaxStyle[] syntaxStyleArray = new SyntaxStyle[19];
        for (int i = 1; i < syntaxStyleArray.length; ++i) {
            try {
                String string2 = "view.style." + Token.tokenToString((byte)i).toLowerCase(Locale.ENGLISH);
                syntaxStyleArray[i] = SyntaxUtilities.parseStyle(propertyManager.getProperty(string2), string, n, bl);
                continue;
            }
            catch (Exception exception) {
                Log.log(9, StandardUtilities.class, exception);
            }
        }
        return syntaxStyleArray;
    }

    private SyntaxUtilities() {
    }

    static {
        COLOR_MATRIX_PATTERN = Pattern.compile("(?x)\n^\n\\s*+ # optionally preceded by whitespace\n\\[\n    (?: # one or more comma-separated matrix rows\n        \\s*+ # optionally preceded by whitespace\n        (?> # one matrix row\n            \\s*+ # optionally preceded by whitespace\n            \\[\n                (?: # one or more comma-separated colors\n                    \\s*+ # optionally preceded by whitespace\n                    (?>                                       # one color\n                        \\#\\p{XDigit}{6}(?:\\p{XDigit}{2})?+ # with '#' and 6 to 8 hex digits\n                        | red                                 # or as simple word\n                        | green\n                        | blue\n                        | yellow\n                        | orange\n                        | white\n                        | lightGray\n                        | gray\n                        | darkGray\n                        | black\n                        | cyan\n                        | magenta\n                        | pink\n                    )\n                    \\s*+ # optionally followed by whitespace\n                    (?:           # optionally followed\n                        ,         # by a comma\n                        (?!\\s*]) # that is not followed by a closing bracket\n                    )?+ \n                )++\n                \\s*+\n            ]\n        )\n        \\s*+ # optionally followed by whitespace\n        (?:           # optionally followed\n            ,         # by a comma\n            (?!\\s*]) # that is not followed by a closing bracket\n        )?+\n    )++\n    \\s*+ # optionally followed by whitespace\n]\n\\s*+ # optionally followed by whitespace\n$");
        COMMA_BETWEEN_BRACKETS_SEPARATOR_PATTERN = Pattern.compile("(?<=])\\s*+,\\s*+(?=\\[)");
        COMMA_SEPARATOR_PATTERN = Pattern.compile("\\s*+,\\s*+");
    }
}

