# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.multi_process_controller import MultiProcessController


class MPIController(MultiProcessController):
    """
    MPIController - Process communication using MPI
    
    Superclass: MultiProcessController
    
    MPIController is a concrete class which implements the abstract
    multi-process control methods defined in MultiProcessController
    using MPI (Message Passing Interface) cf. Using MPI / Portable
    Parallel Programming with the Message-Passing Interface, Gropp et al,
    MIT Press. It also provide functionality specific to MPI and not
    present in MultiProcessController. Before any MPI communication
    can occur Initialize() must be called by all processes. It is
    required to be called once, controllers created after this need not
    call Initialize(). At the end of the program Finalize() must be
    called by all processes.
    
    The use of user-defined communicators are supported with the
    create_sub_controller method.  Note that a duplicate of the user
    defined communicator is used for internal communications (RMIs). 
    This communicator has the same properties as the user one except that
    it has a new context which prevents the two communicators from
    interfering with each other.
    
    @sa
    OutputPort InputPort  MultiProcessController
    MPICommunicator ProcessGroup
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkMPIController, obj, update, **traits)
    
    def _get_communicator(self):
        return wrap_vtk(self._vtk_obj.GetCommunicator())
    def _set_communicator(self, arg):
        old_val = self._get_communicator()
        self._wrap_call(self._vtk_obj.SetCommunicator,
                        deref_vtk(arg))
        self.trait_property_changed('communicator', old_val, arg)
    communicator = traits.Property(_get_communicator, _set_communicator, desc=\
        """
        Returns the communicator associated with this controller. A
        default communicator is created in constructor.
        """
    )

    use_ssend_for_rmi = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        When set to 1, trigger_rmi uses Ssend() instead of Send() calls.
        Off (0) by default.
        """
    )

    def _use_ssend_for_rmi_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseSsendForRMI,
                        self.use_ssend_for_rmi)

    def _get_processor_name(self):
        return self._vtk_obj.GetProcessorName()
    processor_name = traits.Property(_get_processor_name, desc=\
        """
        
        """
    )

    def error_string(self, *args):
        """
        V.error_string(int) -> string
        C++: static char *ErrorString(int err)
        Given an MPI error code, return a string which contains an error
        message. This string has to be freed by the user.
        """
        ret = self._wrap_call(self._vtk_obj.ErrorString, *args)
        return ret

    def initialize(self):
        """
        V.initialize()
        C++: virtual void Initialize()
        Same as Initialize(0, 0, 1). Mainly for calling from wrapped
        languages.
        """
        ret = self._vtk_obj.Initialize()
        return ret
        

    def iprobe(self, *args):
        """
        V.iprobe(int, int, [int, ...], [int, ...]) -> int
        C++: int Iprobe(int source, int tag, int *flag, int *actualSource)
        V.iprobe(int, int, [int, ...], [int, ...], [int, ...], [int, ...])
             -> int
        C++: int Iprobe(int source, int tag, int *flag, int *actualSource,
             int *type, int *size)
        V.iprobe(int, int, [int, ...], [int, ...], [int, ...], [int, ...])
             -> int
        C++: int Iprobe(int source, int tag, int *flag, int *actualSource,
             unsigned long *type, int *size)
        V.iprobe(int, int, [int, ...], [int, ...], string, [int, ...])
            -> int
        C++: int Iprobe(int source, int tag, int *flag, int *actualSource,
             const char *type, int *size)
        V.iprobe(int, int, [int, ...], [int, ...], [float, ...], [int,
            ...]) -> int
        C++: int Iprobe(int source, int tag, int *flag, int *actualSource,
             double *type, int *size)
        Nonblocking test for a message.  Inputs are: source -- the source
        rank or ANY_SOURCE; tag -- the tag value.  Outputs are: flag --
        True if a message matches; actual_source -- the rank sending the
        message (useful if ANY_SOURCE is used) if flag is True and
        actual_source isn't nullptr; size -- the length of the message in
        bytes if flag is true (only set if size isn't nullptr). The
        return value is 1 for success and 0 otherwise. Note: These
        methods delegate to the communicator
        """
        ret = self._wrap_call(self._vtk_obj.Iprobe, *args)
        return ret

    _updateable_traits_ = \
    (('broadcast_trigger_rmi', 'GetBroadcastTriggerRMI'), ('debug',
    'GetDebug'), ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('use_ssend_for_rmi', 'GetUseSsendForRMI'), ('break_flag',
    'GetBreakFlag'), ('number_of_processes', 'GetNumberOfProcesses'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['broadcast_trigger_rmi', 'debug', 'global_warning_display',
    'break_flag', 'number_of_processes', 'use_ssend_for_rmi'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(MPIController, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit MPIController properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['broadcast_trigger_rmi'], [], ['break_flag',
            'number_of_processes', 'use_ssend_for_rmi']),
            title='Edit MPIController properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit MPIController properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

