/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import gnu.inet.util.GetSystemPropertyAction;
import gnu.inet.util.LineInputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.util.Vector;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessageAware;
import javax.mail.MessageContext;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.MultipartDataSource;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.SharedInputStream;

public class MimeMultipart
extends Multipart {
    protected DataSource ds;
    protected boolean parsed;
    private boolean complete;
    private String preamble;

    public MimeMultipart() {
        this("mixed");
    }

    public MimeMultipart(String subtype) {
        String boundary = MimeUtility.getUniqueBoundaryValue();
        ContentType ct = new ContentType("multipart", subtype, null);
        ct.setParameter("boundary", boundary);
        this.contentType = ct.toString();
        this.parsed = true;
    }

    public MimeMultipart(DataSource ds) throws MessagingException {
        if (ds instanceof MessageAware) {
            MessageContext mc = ((MessageAware)ds).getMessageContext();
            this.setParent(mc.getPart());
        }
        if (ds instanceof MultipartDataSource) {
            this.setMultipartDataSource((MultipartDataSource)ds);
            this.parsed = true;
        } else {
            this.ds = ds;
            this.contentType = ds.getContentType();
            this.parsed = false;
        }
    }

    public void setSubType(String subtype) throws MessagingException {
        ContentType ct = new ContentType(this.contentType);
        ct.setSubType(subtype);
        this.contentType = ct.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCount() throws MessagingException {
        MimeMultipart mimeMultipart = this;
        synchronized (mimeMultipart) {
            this.parse();
            return super.getCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BodyPart getBodyPart(int index) throws MessagingException {
        MimeMultipart mimeMultipart = this;
        synchronized (mimeMultipart) {
            this.parse();
            return super.getBodyPart(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BodyPart getBodyPart(String CID) throws MessagingException {
        MimeMultipart mimeMultipart = this;
        synchronized (mimeMultipart) {
            this.parse();
            int count = this.getCount();
            for (int i = 0; i < count; ++i) {
                MimeBodyPart bp = (MimeBodyPart)this.getBodyPart(i);
                String contentID = bp.getContentID();
                if (contentID == null || !contentID.equals(CID)) continue;
                return bp;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateHeaders() throws MessagingException {
        if (this.parts == null) {
            return;
        }
        Vector vector = this.parts;
        synchronized (vector) {
            int len = this.parts.size();
            for (int i = 0; i < len; ++i) {
                ((MimeBodyPart)this.parts.get(i)).updateHeaders();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(OutputStream os) throws IOException, MessagingException {
        GetSystemPropertyAction a;
        String charset = "US-ASCII";
        byte[] sep = new byte[]{13, 10};
        this.parse();
        ContentType ct = new ContentType(this.contentType);
        String boundaryParam = ct.getParameter("boundary");
        if (boundaryParam == null && "false".equals(AccessController.doPrivileged(a = new GetSystemPropertyAction("mail.mime.multipart.ignoremissingboundaryparameter")))) {
            throw new MessagingException("Missing boundary parameter");
        }
        byte[] boundary = ("--" + boundaryParam).getBytes("US-ASCII");
        if (this.preamble != null) {
            os.write(this.preamble.getBytes("US-ASCII"));
        }
        Vector vector = this.parts;
        synchronized (vector) {
            int len = this.parts.size();
            for (int i = 0; i < len; ++i) {
                os.write(boundary);
                os.write(sep);
                os.flush();
                ((MimeBodyPart)this.parts.get(i)).writeTo(os);
                os.write(sep);
            }
        }
        boundary = ("--" + boundaryParam + "--").getBytes("US-ASCII");
        os.write(boundary);
        os.write(sep);
        os.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parse() throws MessagingException {
        if (this.parsed) {
            return;
        }
        MimeMultipart mimeMultipart = this;
        synchronized (mimeMultipart) {
            GetSystemPropertyAction a;
            InputStream is = null;
            SharedInputStream sis = null;
            try {
                String line;
                GetSystemPropertyAction a2;
                ContentType ct;
                String boundaryParam;
                is = this.ds.getInputStream();
                if (is instanceof SharedInputStream) {
                    sis = (SharedInputStream)((Object)is);
                }
                if (!(is instanceof ByteArrayInputStream) && !(is instanceof BufferedInputStream)) {
                    is = new BufferedInputStream(is);
                }
                if ((boundaryParam = (ct = new ContentType(this.contentType)).getParameter("boundary")) == null && "false".equals(AccessController.doPrivileged(a2 = new GetSystemPropertyAction("mail.mime.multipart.ignoremissingboundaryparameter")))) {
                    throw new MessagingException("Missing boundary parameter");
                }
                Object boundary = boundaryParam == null ? null : "--" + boundaryParam;
                LineInputStream lis = new LineInputStream(is);
                StringBuffer preambleBuf = null;
                while ((line = lis.readLine()) != null) {
                    String l = MimeMultipart.trim(line);
                    if (boundary == null && l.startsWith("--") && !l.endsWith("--")) {
                        boundary = l.substring(2).trim();
                        break;
                    }
                    if (l.equals(boundary)) break;
                    if (preambleBuf == null) {
                        preambleBuf = new StringBuffer();
                    }
                    preambleBuf.append(line);
                    preambleBuf.append('\n');
                }
                if (preambleBuf != null) {
                    this.preamble = preambleBuf.toString();
                }
                if (line == null) {
                    throw new MessagingException("No start boundary");
                }
                byte[] bbytes = ((String)boundary).getBytes();
                int blen = bbytes.length;
                long start = 0L;
                long end = 0L;
                boolean done = false;
                while (!done) {
                    InternetHeaders headers = null;
                    if (sis != null) {
                        start = sis.getPosition();
                        while ((line = MimeMultipart.trim(lis.readLine())) != null && line.length() > 0) {
                        }
                        if (line == null) {
                            throw new IOException("EOF before content body");
                        }
                    } else {
                        headers = this.createInternetHeaders(is);
                    }
                    ByteArrayOutputStream bos = null;
                    if (sis == null) {
                        bos = new ByteArrayOutputStream();
                    }
                    if (!is.markSupported()) {
                        String cn = is.getClass().getName();
                        throw new MessagingException("FIXME: mark not supported on underlying input stream: " + cn);
                    }
                    boolean eol = true;
                    int last = -1;
                    int afterLast = -1;
                    while (true) {
                        int c;
                        if (eol) {
                            int pos;
                            is.mark(blen + 1024);
                            for (pos = 0; pos < blen && is.read() == bbytes[pos]; ++pos) {
                            }
                            if (pos == blen) {
                                c = is.read();
                                if (c == 45 && is.read() == 45) {
                                    done = true;
                                    this.complete = true;
                                    break;
                                }
                                while (c == 32 || c == 9) {
                                    c = is.read();
                                }
                                if (c == 13) {
                                    is.mark(1);
                                    if (is.read() == 10) break;
                                    is.reset();
                                    break;
                                }
                                if (c == 10) break;
                            }
                            if (bos != null && last != -1) {
                                bos.write(last);
                                if (afterLast != -1) {
                                    bos.write(afterLast);
                                }
                                afterLast = -1;
                                last = -1;
                            }
                            is.reset();
                        }
                        if ((c = is.read()) < 0) {
                            done = true;
                            break;
                        }
                        if (c == 13 || c == 10) {
                            eol = true;
                            if (sis != null) {
                                end = sis.getPosition() - 1L;
                            }
                            last = c;
                            if (c != 13) continue;
                            is.mark(1);
                            c = is.read();
                            if (c == 10) {
                                afterLast = c;
                                continue;
                            }
                            is.reset();
                            continue;
                        }
                        eol = false;
                        if (bos == null) continue;
                        bos.write(c);
                    }
                    MimeBodyPart bp = sis != null ? this.createMimeBodyPart(sis.newStream(start, end)) : this.createMimeBodyPart(headers, bos.toByteArray());
                    this.addBodyPart(bp);
                }
            }
            catch (IOException e) {
                throw new MessagingException("I/O error", e);
            }
            this.parsed = true;
            if (!this.complete && "false".equals(AccessController.doPrivileged(a = new GetSystemPropertyAction("mail.mime.multipart.ignoremissingendboundary")))) {
                throw new MessagingException("Missing end boundary");
            }
        }
    }

    public boolean isComplete() throws MessagingException {
        return this.complete;
    }

    public String getPreamble() throws MessagingException {
        return this.preamble;
    }

    public void setPreamble(String preamble) throws MessagingException {
        this.preamble = preamble;
    }

    private static String trim(String line) {
        if (line == null) {
            return null;
        }
        int len = (line = line.trim()).length();
        if (len > 0 && line.charAt(len - 1) == '\r') {
            line = line.substring(0, len - 1);
        }
        return line;
    }

    protected InternetHeaders createInternetHeaders(InputStream is) throws MessagingException {
        return new InternetHeaders(is);
    }

    protected MimeBodyPart createMimeBodyPart(InternetHeaders headers, byte[] content) throws MessagingException {
        return new MimeBodyPart(headers, content);
    }

    protected MimeBodyPart createMimeBodyPart(InputStream is) throws MessagingException {
        return new MimeBodyPart(is);
    }
}

