Topkg — The transitory OCaml software packager
-------------------------------------------------------------------------------
v1.0.2

Topkg is a packager for distributing OCaml software. It provides an
API to describe the files a package installs in a given build
configuration and to specify information about the package's
distribution, creation and publication procedures.

The optional topkg-care package provides the `topkg` command line tool
which helps with various aspects of a package's life cycle: creating
and linting a distribution, releasing it on the WWW, publish its
documentation, add it to the OCaml opam repository, etc.

Topkg is distributed under the ISC license and has **no**
dependencies. This is what your packages will need as a *build*
dependency.

Topkg-care is distributed under the ISC license it depends on
[fmt][fmt], [logs][logs], [bos][bos], [cmdliner][cmdliner],
[webbrowser][webbrowser] and `opam-format`.

[fmt]: http://erratique.ch/software/fmt
[logs]: http://erratique.ch/software/logs
[bos]: http://erratique.ch/software/bos
[cmdliner]: http://erratique.ch/software/cmdliner
[webbrowser]: http://erratique.ch/software/webbrowser

Home page: http://erratique.ch/software/topkg  

## Installation

Topkg and topkg-care can be installed with `opam`:

    opam install topkg       # All you need for your packages
    opam install topkg-care  # topkg binary, takes care of your packages
    
If you don't use `opam` consult the [`topkg.opam`](topkg.opam) and
[`topkg-care.opam`](topkg-care.opam) files for build instructions.

## Documentation

A basic introduction and API reference is automatically generated by
`ocamldoc` from the interfaces. It can be consulted [online][doc].

The `topkg` command line tool is extensively documented in man pages
available through it's help system. Type:

```
topkg help release # for help about releasing your package
topkg help         # for more help
```

[doc]: http://erratique.ch/software/topkg/doc
