/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex;

import com.dickimawbooks.texparserlib.DoubleParam;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.Param;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import java.io.IOException;
import java.util.Arrays;

public class LaTeXGenericCommand
extends GenericCommand {
    private char[] latexSyntax;
    private TeXObject[] defaultArgs;
    public static final char SYNTAX_OPTIONAL = 'o';
    public static final char SYNTAX_MANDATORY = 'm';

    public LaTeXGenericCommand(String string) {
        this(true, string);
    }

    public LaTeXGenericCommand(boolean bl, String string) {
        super(bl, string, null, new TeXObjectList());
        this.latexSyntax = null;
    }

    public LaTeXGenericCommand(boolean bl, String string, TeXObjectList teXObjectList) {
        super(bl, string, null, teXObjectList);
        this.latexSyntax = null;
    }

    public LaTeXGenericCommand(boolean bl, String string, String string2, TeXObjectList teXObjectList) {
        this(bl, string, string2.toCharArray(), teXObjectList, (TeXObjectList)null);
    }

    public LaTeXGenericCommand(boolean bl, String string, char[] cArray, TeXObjectList teXObjectList) {
        this(bl, string, cArray, teXObjectList, (TeXObjectList)null);
    }

    public LaTeXGenericCommand(boolean bl, String string, String string2, TeXObjectList teXObjectList, TeXObjectList teXObjectList2) {
        this(bl, string, string2.toCharArray(), teXObjectList, teXObjectList2);
    }

    public LaTeXGenericCommand(boolean bl, String string, char[] cArray, TeXObjectList teXObjectList, TeXObjectList teXObjectList2) {
        super(bl, string, null, teXObjectList);
        this.latexSyntax = cArray;
        int n = teXObjectList2 == null ? 0 : teXObjectList2.size();
        this.defaultArgs = n == 0 ? null : new TeXObject[n];
        this.numArgs = 0;
        if (this.latexSyntax != null) {
            int n2 = 0;
            for (int i = 0; i < this.latexSyntax.length; ++i) {
                if (this.latexSyntax[i] == 'm') {
                    ++this.numArgs;
                    continue;
                }
                if (this.latexSyntax[i] == 'o') {
                    ++this.numArgs;
                    this.defaultArgs[n2] = (TeXObject)((TeXObject)teXObjectList2.get(n2)).clone();
                    ++n2;
                    continue;
                }
                throw new IllegalArgumentException("Invalid argument identifier: " + this.latexSyntax[i]);
            }
        }
    }

    public LaTeXGenericCommand(boolean bl, String string, char[] cArray, TeXObjectList teXObjectList, TeXObject[] teXObjectArray) {
        super(bl, string, null, teXObjectList);
        this.latexSyntax = cArray;
        int n = teXObjectArray == null ? 0 : teXObjectArray.length;
        this.defaultArgs = n == 0 ? null : new TeXObject[n];
        this.numArgs = 0;
        if (this.latexSyntax != null) {
            int n2 = 0;
            for (int i = 0; i < this.latexSyntax.length; ++i) {
                if (this.latexSyntax[i] == 'm') {
                    ++this.numArgs;
                    continue;
                }
                if (this.latexSyntax[i] == 'o') {
                    ++this.numArgs;
                    this.defaultArgs[n2] = (TeXObject)teXObjectArray[n2].clone();
                    ++n2;
                    continue;
                }
                throw new IllegalArgumentException("Invalid argument identifier: " + this.latexSyntax[i]);
            }
        }
    }

    @Override
    public Object clone() {
        return new LaTeXGenericCommand(this.isShort, this.getName(), this.latexSyntax, (TeXObjectList)this.getDefinition().clone());
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof LaTeXGenericCommand)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        LaTeXGenericCommand laTeXGenericCommand = (LaTeXGenericCommand)object;
        if (this.isShort != laTeXGenericCommand.isShort || !this.getDefinition().equals(laTeXGenericCommand.getDefinition())) {
            return false;
        }
        return Arrays.equals(this.latexSyntax, laTeXGenericCommand.latexSyntax) && Arrays.equals(this.defaultArgs, laTeXGenericCommand.defaultArgs);
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.getReplacement(teXParser, teXObjectList);
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        return this.getReplacement(teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.getReplacement(teXParser, teXObjectList).expandfully(teXParser, teXObjectList);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return this.getReplacement(teXParser).expandfully(teXParser);
    }

    private TeXObjectList getReplacement(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        byte by;
        TeXObject[] teXObjectArray = this.numArgs == 0 ? null : new TeXObject[this.numArgs];
        byte by2 = by = this.isShort ? TeXObjectList.POP_SHORT : (byte)0;
        if (this.numArgs > 0) {
            int n = 0;
            for (int i = 0; i < this.numArgs; ++i) {
                TeXObject teXObject = null;
                switch (this.latexSyntax[i]) {
                    case 'o': {
                        teXObject = teXObjectList.popArg(teXParser, by, 91, 93);
                        if (teXObject != null) break;
                        teXObject = this.defaultArgs[n++];
                        break;
                    }
                    case 'm': {
                        teXObject = teXObjectList.popArg(teXParser, by);
                    }
                }
                teXObjectArray[i] = teXObject;
            }
        }
        TeXObjectList teXObjectList2 = new TeXObjectList();
        this.addReplacements(teXParser, teXObjectList2, teXObjectArray, this.getDefinition());
        return teXObjectList2;
    }

    private TeXObjectList getReplacement(TeXParser teXParser) throws IOException {
        TeXObject[] teXObjectArray;
        TeXObject[] teXObjectArray2 = teXObjectArray = this.numArgs == 0 ? null : new TeXObject[this.numArgs];
        if (this.numArgs > 0) {
            byte by = this.isShort ? TeXObjectList.POP_SHORT : (byte)0;
            int n = 0;
            for (int i = 0; i < this.numArgs; ++i) {
                TeXObject teXObject = null;
                switch (this.latexSyntax[i]) {
                    case 'o': {
                        teXObject = teXParser.popNextArg(by, 91, 93);
                        if (teXObject != null) break;
                        teXObject = this.defaultArgs[n++];
                        break;
                    }
                    case 'm': {
                        teXObject = teXParser.popNextArg(by);
                    }
                }
                teXObjectArray[i] = teXObject;
            }
        }
        TeXObjectList teXObjectList = new TeXObjectList();
        this.addReplacements(teXParser, teXObjectList, teXObjectArray, this.getDefinition());
        return teXObjectList;
    }

    private void addReplacements(TeXParser teXParser, TeXObjectList teXObjectList, TeXObject[] teXObjectArray, TeXObjectList teXObjectList2) {
        for (TeXObject teXObject : teXObjectList2) {
            if (teXObject instanceof Param) {
                int n = ((Param)teXObject).getDigit() - 1;
                teXObjectList.add((TeXObject)teXObjectArray[n].clone());
                continue;
            }
            if (teXObject instanceof DoubleParam) {
                teXObjectList.add(((DoubleParam)teXObject).next());
                continue;
            }
            if (teXObject instanceof TeXObjectList) {
                TeXObjectList teXObjectList3 = ((TeXObjectList)teXObject).createList();
                teXObjectList.add(teXObjectList3);
                this.addReplacements(teXParser, teXObjectList3, teXObjectArray, (TeXObjectList)teXObject);
                continue;
            }
            teXObjectList.add((TeXObject)teXObject.clone());
        }
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.getReplacement(teXParser, teXObjectList).process(teXParser, teXObjectList);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.getReplacement(teXParser).process(teXParser);
    }

    public char[] getLaTeXSyntax() {
        return this.latexSyntax;
    }

    public String getLaTeXSyntaxString() {
        return this.latexSyntax == null ? "" : new String(this.latexSyntax);
    }

    @Override
    public String toString() {
        return String.format("%s[name=%s,syntax=%s,definition=%s]", this.getClass().getSimpleName(), this.getName(), this.getLaTeXSyntaxString(), this.getDefinition());
    }
}

