/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex;

import com.dickimawbooks.texparserlib.Declaration;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSettings;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import java.io.IOException;

public class MathDeclaration
extends Declaration {
    private int orgMode;
    private int mode = 1;
    private boolean numbered;

    public MathDeclaration() {
        this("(", 1, false);
    }

    public MathDeclaration(String string) {
        this(string, 1, false);
    }

    public MathDeclaration(String string, int n) {
        this(string, n, false);
    }

    public MathDeclaration(String string, int n, boolean bl) {
        super(string);
        this.mode = n;
        this.numbered = bl;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        return null;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return null;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return null;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return null;
    }

    @Override
    public Object clone() {
        return new MathDeclaration(this.getName(), this.mode, this.numbered);
    }

    public void doModeSwitch(TeXParser teXParser) {
        TeXSettings teXSettings = teXParser.getSettings();
        this.orgMode = teXSettings.getCurrentMode();
        teXSettings.setMode(this.mode);
    }

    public void revertModeSwitch(TeXParser teXParser) {
        TeXSettings teXSettings = teXParser.getSettings();
        teXSettings.setMode(this.orgMode);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.doModeSwitch(teXParser);
        if (this.isNumbered()) {
            ((LaTeXParserListener)teXParser.getListener()).stepcounter("equation");
        }
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.doModeSwitch(teXParser);
        if (this.isNumbered()) {
            ((LaTeXParserListener)teXParser.getListener()).stepcounter("equation");
        }
    }

    @Override
    public void end(TeXParser teXParser) throws IOException {
        this.revertModeSwitch(teXParser);
    }

    public int getMode() {
        return this.mode;
    }

    public boolean isNumbered() {
        return this.numbered;
    }

    @Override
    public boolean isModeSwitcher() {
        return true;
    }
}

