/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.ajp;

import java.net.Socket;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.Processor;
import org.apache.coyote.ajp.AbstractAjpProtocol;
import org.apache.coyote.ajp.AjpProcessor;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.JIoEndpoint;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.SocketWrapper;

public class AjpProtocol
extends AbstractAjpProtocol<Socket> {
    private static final Log log = LogFactory.getLog(AjpProtocol.class);
    private AjpConnectionHandler cHandler;

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected AbstractEndpoint.Handler getHandler() {
        return this.cHandler;
    }

    public AjpProtocol() {
        this.endpoint = new JIoEndpoint();
        this.endpoint.setAddress(JreCompat.getInstance().getLoopbackAddress());
        this.cHandler = new AjpConnectionHandler(this);
        ((JIoEndpoint)this.endpoint).setHandler(this.cHandler);
        this.setSoLinger(-1);
        this.setSoTimeout(-1);
        this.setTcpNoDelay(true);
    }

    @Override
    protected String getNamePrefix() {
        return "ajp-bio";
    }

    protected static class AjpConnectionHandler
    extends AbstractAjpProtocol.AbstractAjpConnectionHandler<Socket, AjpProcessor>
    implements JIoEndpoint.Handler {
        protected AjpProtocol proto;

        public AjpConnectionHandler(AjpProtocol ajpProtocol) {
            this.proto = ajpProtocol;
        }

        @Override
        protected AbstractProtocol<Socket> getProtocol() {
            return this.proto;
        }

        @Override
        protected Log getLog() {
            return log;
        }

        @Override
        public SSLImplementation getSslImplementation() {
            return null;
        }

        @Override
        public void release(SocketWrapper<Socket> socketWrapper, Processor<Socket> processor, boolean bl, boolean bl2) {
            processor.recycle(bl);
            this.recycledProcessors.offer(processor);
        }

        @Override
        protected AjpProcessor createProcessor() {
            AjpProcessor ajpProcessor = new AjpProcessor(this.proto.packetSize, (JIoEndpoint)this.proto.endpoint);
            ajpProcessor.setAdapter(this.proto.adapter);
            ajpProcessor.setAjpFlush(this.proto.getAjpFlush());
            ajpProcessor.setTomcatAuthentication(this.proto.tomcatAuthentication);
            ajpProcessor.setTomcatAuthorization(this.proto.getTomcatAuthorization());
            ajpProcessor.setSecret(this.proto.getSecret());
            ajpProcessor.setKeepAliveTimeout(this.proto.getKeepAliveTimeout());
            ajpProcessor.setClientCertProvider(this.proto.getClientCertProvider());
            ajpProcessor.setMaxCookieCount(this.proto.getMaxCookieCount());
            ajpProcessor.setAllowedRequestAttributesPatternPattern(this.proto.getAllowedRequestAttributesPatternPattern());
            this.register(ajpProcessor);
            return ajpProcessor;
        }
    }
}

