/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el.lang;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.el.FunctionMapper;
import org.apache.el.util.MessageFactory;
import org.apache.el.util.ReflectionUtil;

public class FunctionMapperImpl
extends FunctionMapper
implements Externalizable {
    private static final long serialVersionUID = 1L;
    protected ConcurrentMap<String, Function> functions = new ConcurrentHashMap<String, Function>();

    public Method resolveFunction(String string, String string2) {
        Function function = (Function)this.functions.get(string + ":" + string2);
        if (function == null) {
            return null;
        }
        return function.getMethod();
    }

    public void mapFunction(String string, String string2, Method method) {
        String string3 = string + ":" + string2;
        if (method == null) {
            this.functions.remove(string3);
        } else {
            Function function = new Function(string, string2, method);
            this.functions.put(string3, function);
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.functions);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.functions = (ConcurrentMap)objectInput.readObject();
    }

    public static class Function
    implements Externalizable {
        protected transient Method m;
        protected String owner;
        protected String name;
        protected String[] types;
        protected String prefix;
        protected String localName;

        public Function(String string, String string2, Method method) {
            if (string2 == null) {
                throw new NullPointerException(MessageFactory.get("error.nullLocalName"));
            }
            if (method == null) {
                throw new NullPointerException(MessageFactory.get("error.nullMethod"));
            }
            this.prefix = string;
            this.localName = string2;
            this.m = method;
        }

        public Function() {
        }

        @Override
        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeUTF(this.prefix != null ? this.prefix : "");
            objectOutput.writeUTF(this.localName);
            this.getMethod();
            objectOutput.writeUTF(this.owner != null ? this.owner : this.m.getDeclaringClass().getName());
            objectOutput.writeUTF(this.name != null ? this.name : this.m.getName());
            objectOutput.writeObject(this.types != null ? this.types : ReflectionUtil.toTypeNameArray(this.m.getParameterTypes()));
        }

        @Override
        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.prefix = objectInput.readUTF();
            if (this.prefix.isEmpty()) {
                this.prefix = null;
            }
            this.localName = objectInput.readUTF();
            this.owner = objectInput.readUTF();
            this.name = objectInput.readUTF();
            this.types = (String[])objectInput.readObject();
        }

        public Method getMethod() {
            if (this.m == null) {
                try {
                    Class<?> clazz = ReflectionUtil.forName(this.owner);
                    Class<?>[] classArray = ReflectionUtil.toTypeArray(this.types);
                    this.m = clazz.getMethod(this.name, classArray);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return this.m;
        }

        public boolean equals(Object object) {
            if (object instanceof Function) {
                return this.hashCode() == object.hashCode();
            }
            return false;
        }

        public int hashCode() {
            return (this.prefix + this.localName).hashCode();
        }
    }
}

