/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.membership;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.Properties;
import javax.management.ObjectName;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.MembershipProvider;
import org.apache.catalina.tribes.MessageListener;
import org.apache.catalina.tribes.io.ChannelData;
import org.apache.catalina.tribes.io.XByteBuffer;
import org.apache.catalina.tribes.jmx.JmxRegistry;
import org.apache.catalina.tribes.membership.McastServiceImpl;
import org.apache.catalina.tribes.membership.McastServiceMBean;
import org.apache.catalina.tribes.membership.MemberImpl;
import org.apache.catalina.tribes.membership.MembershipServiceBase;
import org.apache.catalina.tribes.util.Arrays;
import org.apache.catalina.tribes.util.StringManager;
import org.apache.catalina.tribes.util.UUIDGenerator;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class McastService
extends MembershipServiceBase
implements MessageListener,
McastServiceMBean {
    private static final Log log = LogFactory.getLog(McastService.class);
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.tribes.membership");
    protected McastServiceImpl impl;
    protected MessageListener msglistener;
    protected MemberImpl localMember;
    private int mcastSoTimeout;
    private int mcastTTL;
    protected byte[] payload;
    protected byte[] domain;
    private ObjectName oname = null;

    public McastService() {
        this.setDefaults(this.properties);
    }

    @Override
    public void setProperties(Properties properties) {
        this.hasProperty(properties, "mcastPort");
        this.hasProperty(properties, "mcastAddress");
        this.hasProperty(properties, "memberDropTime");
        this.hasProperty(properties, "mcastFrequency");
        this.hasProperty(properties, "tcpListenPort");
        this.hasProperty(properties, "tcpListenHost");
        this.setDefaults(properties);
        this.properties = properties;
    }

    @Override
    public String getLocalMemberName() {
        return this.localMember.toString();
    }

    @Override
    public Member getLocalMember(boolean bl) {
        if (bl && this.localMember != null && this.impl != null) {
            this.localMember.setMemberAliveTime(System.currentTimeMillis() - this.impl.getServiceStartTime());
        }
        return this.localMember;
    }

    @Override
    public void setLocalMemberProperties(String string, int n, int n2, int n3) {
        this.properties.setProperty("tcpListenHost", string);
        this.properties.setProperty("tcpListenPort", String.valueOf(n));
        this.properties.setProperty("udpListenPort", String.valueOf(n3));
        this.properties.setProperty("tcpSecurePort", String.valueOf(n2));
        try {
            if (this.localMember != null) {
                this.localMember.setHostname(string);
                this.localMember.setPort(n);
            } else {
                this.localMember = new MemberImpl(string, n, 0L);
                this.localMember.setUniqueId(UUIDGenerator.randomUUID(true));
                this.localMember.setPayload(this.getPayload());
                this.localMember.setDomain(this.getDomain());
                this.localMember.setLocal(true);
            }
            this.localMember.setSecurePort(n2);
            this.localMember.setUdpPort(n3);
            this.localMember.getData(true, true);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException);
        }
    }

    public void setAddress(String string) {
        this.properties.setProperty("mcastAddress", string);
    }

    @Override
    public String getAddress() {
        return this.properties.getProperty("mcastAddress");
    }

    public void setMcastBindAddress(String string) {
        this.setBind(string);
    }

    public void setBind(String string) {
        this.properties.setProperty("mcastBindAddress", string);
    }

    @Override
    public String getBind() {
        return this.properties.getProperty("mcastBindAddress");
    }

    public void setPort(int n) {
        this.properties.setProperty("mcastPort", String.valueOf(n));
    }

    public void setRecoveryCounter(int n) {
        this.properties.setProperty("recoveryCounter", String.valueOf(n));
    }

    @Override
    public int getRecoveryCounter() {
        String string = this.properties.getProperty("recoveryCounter");
        if (string != null) {
            return Integer.parseInt(string);
        }
        return -1;
    }

    public void setRecoveryEnabled(boolean bl) {
        this.properties.setProperty("recoveryEnabled", String.valueOf(bl));
    }

    @Override
    public boolean getRecoveryEnabled() {
        String string = this.properties.getProperty("recoveryEnabled");
        if (string != null) {
            return Boolean.parseBoolean(string);
        }
        return false;
    }

    public void setRecoverySleepTime(long l) {
        this.properties.setProperty("recoverySleepTime", String.valueOf(l));
    }

    @Override
    public long getRecoverySleepTime() {
        String string = this.properties.getProperty("recoverySleepTime");
        if (string != null) {
            return Long.parseLong(string);
        }
        return -1L;
    }

    public void setLocalLoopbackDisabled(boolean bl) {
        this.properties.setProperty("localLoopbackDisabled", String.valueOf(bl));
    }

    @Override
    public boolean getLocalLoopbackDisabled() {
        String string = this.properties.getProperty("localLoopbackDisabled");
        if (string != null) {
            return Boolean.parseBoolean(string);
        }
        return false;
    }

    @Override
    public int getPort() {
        String string = this.properties.getProperty("mcastPort");
        return Integer.parseInt(string);
    }

    public void setFrequency(long l) {
        this.properties.setProperty("mcastFrequency", String.valueOf(l));
    }

    @Override
    public long getFrequency() {
        String string = this.properties.getProperty("mcastFrequency");
        return Long.parseLong(string);
    }

    public void setMcastDropTime(long l) {
        this.setDropTime(l);
    }

    public void setDropTime(long l) {
        this.properties.setProperty("memberDropTime", String.valueOf(l));
    }

    @Override
    public long getDropTime() {
        String string = this.properties.getProperty("memberDropTime");
        return Long.parseLong(string);
    }

    protected void hasProperty(Properties properties, String string) {
        if (properties.getProperty(string) == null) {
            throw new IllegalArgumentException(sm.getString("mcastService.missing.property", string));
        }
    }

    @Override
    public void start(int n) throws Exception {
        this.hasProperty(this.properties, "mcastPort");
        this.hasProperty(this.properties, "mcastAddress");
        this.hasProperty(this.properties, "memberDropTime");
        this.hasProperty(this.properties, "mcastFrequency");
        this.hasProperty(this.properties, "tcpListenPort");
        this.hasProperty(this.properties, "tcpListenHost");
        this.hasProperty(this.properties, "tcpSecurePort");
        this.hasProperty(this.properties, "udpListenPort");
        if (this.impl != null) {
            this.impl.start(n);
            return;
        }
        String string = this.getProperties().getProperty("tcpListenHost");
        int n2 = Integer.parseInt(this.getProperties().getProperty("tcpListenPort"));
        int n3 = Integer.parseInt(this.getProperties().getProperty("tcpSecurePort"));
        int n4 = Integer.parseInt(this.getProperties().getProperty("udpListenPort"));
        if (this.localMember == null) {
            this.localMember = new MemberImpl(string, n2, 100L);
            this.localMember.setUniqueId(UUIDGenerator.randomUUID(true));
            this.localMember.setLocal(true);
        } else {
            this.localMember.setHostname(string);
            this.localMember.setPort(n2);
            this.localMember.setMemberAliveTime(100L);
        }
        this.localMember.setSecurePort(n3);
        this.localMember.setUdpPort(n4);
        if (this.payload != null) {
            this.localMember.setPayload(this.payload);
        }
        if (this.domain != null) {
            this.localMember.setDomain(this.domain);
        }
        this.localMember.setServiceStartTime(System.currentTimeMillis());
        InetAddress inetAddress = null;
        if (this.properties.getProperty("mcastBindAddress") != null) {
            inetAddress = InetAddress.getByName(this.properties.getProperty("mcastBindAddress"));
        }
        int n5 = -1;
        int n6 = -1;
        if (this.properties.getProperty("mcastTTL") != null) {
            try {
                n5 = Integer.parseInt(this.properties.getProperty("mcastTTL"));
            }
            catch (Exception exception) {
                log.error((Object)sm.getString("McastService.parseTTL", this.properties.getProperty("mcastTTL")), (Throwable)exception);
            }
        }
        if (this.properties.getProperty("mcastSoTimeout") != null) {
            try {
                n6 = Integer.parseInt(this.properties.getProperty("mcastSoTimeout"));
            }
            catch (Exception exception) {
                log.error((Object)sm.getString("McastService.parseSoTimeout", this.properties.getProperty("mcastSoTimeout")), (Throwable)exception);
            }
        }
        this.impl = new McastServiceImpl(this.localMember, Long.parseLong(this.properties.getProperty("mcastFrequency")), Long.parseLong(this.properties.getProperty("memberDropTime")), Integer.parseInt(this.properties.getProperty("mcastPort")), inetAddress, InetAddress.getByName(this.properties.getProperty("mcastAddress")), n5, n6, this, this, Boolean.parseBoolean(this.properties.getProperty("localLoopbackDisabled")));
        this.impl.setMembershipService(this);
        String string2 = this.properties.getProperty("recoveryEnabled");
        boolean bl = Boolean.parseBoolean(string2);
        this.impl.setRecoveryEnabled(bl);
        int n7 = Integer.parseInt(this.properties.getProperty("recoveryCounter"));
        this.impl.setRecoveryCounter(n7);
        long l = Long.parseLong(this.properties.getProperty("recoverySleepTime"));
        this.impl.setRecoverySleepTime(l);
        this.impl.setChannel(this.channel);
        this.impl.start(n);
        JmxRegistry jmxRegistry = JmxRegistry.getRegistry(this.channel);
        if (jmxRegistry != null) {
            this.oname = jmxRegistry.registerJmx(",component=Membership", this);
        }
    }

    @Override
    public void stop(int n) {
        try {
            if (this.impl != null && this.impl.stop(n)) {
                if (this.oname != null) {
                    JmxRegistry.getRegistry(this.channel).unregisterJmx(this.oname);
                    this.oname = null;
                }
                this.impl.setChannel(null);
                this.impl = null;
                this.channel = null;
            }
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("McastService.stopFail", n), (Throwable)exception);
        }
    }

    public void setMessageListener(MessageListener messageListener) {
        this.msglistener = messageListener;
    }

    public void removeMessageListener() {
        this.msglistener = null;
    }

    @Override
    public void messageReceived(ChannelMessage channelMessage) {
        if (this.msglistener != null && this.msglistener.accept(channelMessage)) {
            this.msglistener.messageReceived(channelMessage);
        }
    }

    @Override
    public boolean accept(ChannelMessage channelMessage) {
        return true;
    }

    @Override
    public void broadcast(ChannelMessage channelMessage) throws ChannelException {
        if (this.impl == null || (this.impl.startLevel & 8) != 8) {
            throw new ChannelException(sm.getString("mcastService.noStart"));
        }
        byte[] byArray = XByteBuffer.createDataPackage((ChannelData)channelMessage);
        if (byArray.length > 65535) {
            throw new ChannelException(sm.getString("mcastService.exceed.maxPacketSize", Integer.toString(byArray.length), Integer.toString(65535)));
        }
        DatagramPacket datagramPacket = new DatagramPacket(byArray, 0, byArray.length);
        try {
            this.impl.send(false, datagramPacket);
        }
        catch (Exception exception) {
            throw new ChannelException(exception);
        }
    }

    @Override
    public int getSoTimeout() {
        return this.mcastSoTimeout;
    }

    public void setSoTimeout(int n) {
        this.mcastSoTimeout = n;
        this.properties.setProperty("mcastSoTimeout", String.valueOf(n));
    }

    @Override
    public int getTtl() {
        return this.mcastTTL;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    @Override
    public byte[] getDomain() {
        return this.domain;
    }

    public void setTtl(int n) {
        this.mcastTTL = n;
        this.properties.setProperty("mcastTTL", String.valueOf(n));
    }

    @Override
    public void setPayload(byte[] byArray) {
        this.payload = byArray;
        if (this.localMember != null) {
            this.localMember.setPayload(byArray);
            try {
                if (this.impl != null) {
                    this.impl.send(false);
                }
            }
            catch (Exception exception) {
                log.error((Object)sm.getString("McastService.payload"), (Throwable)exception);
            }
        }
    }

    @Override
    public void setDomain(byte[] byArray) {
        this.domain = byArray;
        if (this.localMember != null) {
            this.localMember.setDomain(byArray);
            try {
                if (this.impl != null) {
                    this.impl.send(false);
                }
            }
            catch (Exception exception) {
                log.error((Object)sm.getString("McastService.domain"), (Throwable)exception);
            }
        }
    }

    public void setDomain(String string) {
        if (string == null) {
            return;
        }
        if (string.startsWith("{")) {
            this.setDomain(Arrays.fromString(string));
        } else {
            this.setDomain(Arrays.convert(string));
        }
    }

    @Override
    public MembershipProvider getMembershipProvider() {
        return this.impl;
    }

    protected void setDefaults(Properties properties) {
        if (properties.getProperty("mcastPort") == null) {
            properties.setProperty("mcastPort", "45564");
        }
        if (properties.getProperty("mcastAddress") == null) {
            properties.setProperty("mcastAddress", "228.0.0.4");
        }
        if (properties.getProperty("memberDropTime") == null) {
            properties.setProperty("memberDropTime", "3000");
        }
        if (properties.getProperty("mcastFrequency") == null) {
            properties.setProperty("mcastFrequency", "500");
        }
        if (properties.getProperty("recoveryCounter") == null) {
            properties.setProperty("recoveryCounter", "10");
        }
        if (properties.getProperty("recoveryEnabled") == null) {
            properties.setProperty("recoveryEnabled", "true");
        }
        if (properties.getProperty("recoverySleepTime") == null) {
            properties.setProperty("recoverySleepTime", "5000");
        }
        if (properties.getProperty("localLoopbackDisabled") == null) {
            properties.setProperty("localLoopbackDisabled", "false");
        }
    }

    public static void main(String[] stringArray) throws Exception {
        McastService mcastService = new McastService();
        Properties properties = new Properties();
        properties.setProperty("mcastPort", "5555");
        properties.setProperty("mcastAddress", "224.10.10.10");
        properties.setProperty("mcastClusterDomain", "catalina");
        properties.setProperty("bindAddress", "localhost");
        properties.setProperty("memberDropTime", "3000");
        properties.setProperty("mcastFrequency", "500");
        properties.setProperty("tcpListenPort", "4000");
        properties.setProperty("tcpListenHost", "127.0.0.1");
        properties.setProperty("tcpSecurePort", "4100");
        properties.setProperty("udpListenPort", "4200");
        mcastService.setProperties(properties);
        mcastService.start();
        Thread.sleep(3600000L);
    }
}

