/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2.managed;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.xa.XAResource;
import org.apache.tomcat.dbcp.dbcp2.DelegatingConnection;
import org.apache.tomcat.dbcp.dbcp2.managed.TransactionContext;

public class TransactionRegistry {
    private final TransactionManager transactionManager;
    private final Map<Transaction, TransactionContext> caches = new WeakHashMap<Transaction, TransactionContext>();
    private final Map<Connection, XAResource> xaResources = new WeakHashMap<Connection, XAResource>();
    private final TransactionSynchronizationRegistry transactionSynchronizationRegistry;

    public TransactionRegistry(TransactionManager transactionManager, TransactionSynchronizationRegistry transactionSynchronizationRegistry) {
        this.transactionManager = transactionManager;
        this.transactionSynchronizationRegistry = transactionSynchronizationRegistry;
    }

    public TransactionRegistry(TransactionManager transactionManager) {
        this(transactionManager, null);
    }

    public synchronized void registerConnection(Connection connection, XAResource xAResource) {
        Objects.requireNonNull(connection, "connection is null");
        Objects.requireNonNull(xAResource, "xaResource is null");
        this.xaResources.put(connection, xAResource);
    }

    public synchronized XAResource getXAResource(Connection connection) throws SQLException {
        Objects.requireNonNull(connection, "connection is null");
        Connection connection2 = this.getConnectionKey(connection);
        XAResource xAResource = this.xaResources.get(connection2);
        if (xAResource == null) {
            throw new SQLException("Connection does not have a registered XAResource " + connection);
        }
        return xAResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionContext getActiveTransactionContext() throws SQLException {
        Transaction transaction = null;
        try {
            transaction = this.transactionManager.getTransaction();
            if (transaction == null) {
                return null;
            }
        }
        catch (SystemException systemException) {
            throw new SQLException("Unable to determine current transaction ", systemException);
        }
        TransactionRegistry transactionRegistry = this;
        synchronized (transactionRegistry) {
            TransactionContext transactionContext = this.caches.get(transaction);
            if (transactionContext == null) {
                transactionContext = new TransactionContext(this, transaction, this.transactionSynchronizationRegistry);
                this.caches.put(transaction, transactionContext);
            }
            return transactionContext;
        }
    }

    public synchronized void unregisterConnection(Connection connection) {
        Connection connection2 = this.getConnectionKey(connection);
        this.xaResources.remove(connection2);
    }

    private Connection getConnectionKey(Connection connection) {
        Connection connection2 = connection instanceof DelegatingConnection ? ((DelegatingConnection)connection).getInnermostDelegateInternal() : connection;
        return connection2;
    }
}

