/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.JavacErrorDetail;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.compiler.SmapStratum;
import org.apache.jasper.compiler.SmapUtil;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.types.Path;

public class AntCompiler
extends Compiler {
    private final Log log = LogFactory.getLog(AntCompiler.class);
    protected static final Object javacLock = new Object();
    protected Project project = null;
    protected JasperAntLogger logger;

    protected Project getProject() {
        if (this.project != null) {
            return this.project;
        }
        this.project = new Project();
        this.logger = new JasperAntLogger();
        this.logger.setOutputPrintStream(System.out);
        this.logger.setErrorPrintStream(System.err);
        this.logger.setMessageOutputLevel(2);
        this.project.addBuildListener((BuildListener)this.logger);
        if (System.getProperty("catalina.home") != null) {
            this.project.setBasedir(System.getProperty("catalina.home"));
        }
        if (this.options.getCompiler() != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Compiler " + this.options.getCompiler()));
            }
            this.project.setProperty("build.compiler", this.options.getCompiler());
        }
        this.project.init();
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void generateClass(Map<String, SmapStratum> map) throws FileNotFoundException, JasperException, Exception {
        Object object;
        Object object2;
        Object object3;
        StringBuilder stringBuilder;
        String string;
        long l;
        block24: {
            Object object4;
            Object object5;
            String string2;
            l = 0L;
            if (this.log.isDebugEnabled()) {
                l = System.currentTimeMillis();
            }
            String string3 = this.ctxt.getOptions().getJavaEncoding();
            string = this.ctxt.getServletJavaFileName();
            String string4 = this.ctxt.getClassPath();
            stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append("Compile: javaFileName=" + string + "\n");
            stringBuilder2.append("    classpath=" + string4 + "\n");
            SystemLogHandler.setThread();
            this.getProject();
            Javac javac = (Javac)this.project.createTask("javac");
            Path path = new Path(this.project);
            path.setPath(System.getProperty("java.class.path"));
            stringBuilder2.append("    cp=" + System.getProperty("java.class.path") + "\n");
            StringTokenizer stringTokenizer = new StringTokenizer(string4, File.pathSeparator);
            while (stringTokenizer.hasMoreElements()) {
                string2 = stringTokenizer.nextToken();
                object5 = new File(string2);
                path.setLocation((File)object5);
                stringBuilder2.append("    cp=" + object5 + "\n");
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Using classpath: " + System.getProperty("java.class.path") + File.pathSeparator + string4));
            }
            string2 = new Path(this.project);
            string2.setLocation(this.options.getScratchDir());
            stringBuilder2.append("    work dir=" + this.options.getScratchDir() + "\n");
            object5 = System.getProperty("java.ext.dirs");
            if (object5 != null) {
                object4 = new Path(this.project);
                object4.setPath((String)object5);
                javac.setExtdirs(object4);
                stringBuilder2.append("    extension dir=" + (String)object5 + "\n");
            }
            if (this.ctxt.getOptions().getFork()) {
                object4 = System.getProperty("java.endorsed.dirs");
                if (object4 != null) {
                    object3 = javac.createCompilerArg();
                    object3.setLine("-J-Djava.endorsed.dirs=" + this.quotePathList((String)object4));
                    stringBuilder2.append("    endorsed dir=" + this.quotePathList((String)object4) + "\n");
                } else {
                    stringBuilder2.append("    no endorsed dirs specified\n");
                }
            }
            javac.setEncoding(string3);
            javac.setClasspath(path);
            javac.setDebug(this.ctxt.getOptions().getClassDebugInfo());
            javac.setSrcdir((Path)string2);
            javac.setTempdir(this.options.getScratchDir());
            javac.setFork(this.ctxt.getOptions().getFork());
            stringBuilder2.append("    srcDir=" + string2 + "\n");
            if (this.options.getCompiler() != null) {
                javac.setCompiler(this.options.getCompiler());
                stringBuilder2.append("    compiler=" + this.options.getCompiler() + "\n");
            }
            if (this.options.getCompilerTargetVM() != null) {
                javac.setTarget(this.options.getCompilerTargetVM());
                stringBuilder2.append("   compilerTargetVM=" + this.options.getCompilerTargetVM() + "\n");
            }
            if (this.options.getCompilerSourceVM() != null) {
                javac.setSource(this.options.getCompilerSourceVM());
                stringBuilder2.append("   compilerSourceVM=" + this.options.getCompilerSourceVM() + "\n");
            }
            object4 = javac.createInclude();
            object4.setName(this.ctxt.getJavaPath());
            stringBuilder2.append("    include=" + this.ctxt.getJavaPath() + "\n");
            object3 = null;
            try {
                if (this.ctxt.getOptions().getFork()) {
                    javac.execute();
                    break block24;
                }
                object2 = javacLock;
                synchronized (object2) {
                    javac.execute();
                }
            }
            catch (BuildException buildException) {
                object3 = buildException;
                this.log.error((Object)Localizer.getMessage("jsp.error.javac"), (Throwable)buildException);
                this.log.error((Object)(Localizer.getMessage("jsp.error.javac.env") + stringBuilder2.toString()));
            }
        }
        stringBuilder.append(this.logger.getReport());
        object2 = SystemLogHandler.unsetThread();
        if (object2 != null) {
            stringBuilder.append(System.lineSeparator());
            stringBuilder.append((String)object2);
        }
        if (!this.ctxt.keepGenerated() && !((File)(object = new File(string))).delete()) {
            throw new JasperException(Localizer.getMessage("jsp.warning.compiler.javafile.delete.fail", object));
        }
        if (object3 != null) {
            object = stringBuilder.toString();
            this.log.error((Object)Localizer.getMessage("jsp.error.compilation", string, object));
            JavacErrorDetail[] javacErrorDetailArray = ErrorDispatcher.parseJavacErrors((String)object, string, this.pageNodes);
            if (javacErrorDetailArray != null) {
                this.errDispatcher.javacError(javacErrorDetailArray);
            } else {
                this.errDispatcher.javacError((String)object, (Exception)object3);
            }
        }
        if (this.log.isDebugEnabled()) {
            long l2 = System.currentTimeMillis();
            this.log.debug((Object)("Compiled " + this.ctxt.getServletJavaFileName() + " " + (l2 - l) + "ms"));
        }
        this.logger = null;
        this.project = null;
        if (this.ctxt.isPrototypeMode()) {
            return;
        }
        if (!this.options.isSmapSuppressed()) {
            SmapUtil.installSmap(map);
        }
    }

    private String quotePathList(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 10);
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.indexOf(32) == -1) {
                stringBuilder.append(string2);
            } else {
                stringBuilder.append('\"');
                stringBuilder.append(string2);
                stringBuilder.append('\"');
            }
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringBuilder.append(File.pathSeparatorChar);
        }
        return stringBuilder.toString();
    }

    static {
        System.setErr(new SystemLogHandler(System.err));
    }

    protected static class SystemLogHandler
    extends PrintStream {
        protected final PrintStream wrapped;
        protected static final ThreadLocal<PrintStream> streams = new ThreadLocal();
        protected static final ThreadLocal<ByteArrayOutputStream> data = new ThreadLocal();

        public SystemLogHandler(PrintStream printStream) {
            super(printStream);
            this.wrapped = printStream;
        }

        public static void setThread() {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            data.set(byteArrayOutputStream);
            streams.set(new PrintStream(byteArrayOutputStream));
        }

        public static String unsetThread() {
            ByteArrayOutputStream byteArrayOutputStream = data.get();
            if (byteArrayOutputStream == null) {
                return null;
            }
            streams.set(null);
            data.set(null);
            return byteArrayOutputStream.toString();
        }

        protected PrintStream findStream() {
            PrintStream printStream = streams.get();
            if (printStream == null) {
                printStream = this.wrapped;
            }
            return printStream;
        }

        @Override
        public void flush() {
            this.findStream().flush();
        }

        @Override
        public void close() {
            this.findStream().close();
        }

        @Override
        public boolean checkError() {
            return this.findStream().checkError();
        }

        @Override
        protected void setError() {
        }

        @Override
        public void write(int n) {
            this.findStream().write(n);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.findStream().write(byArray);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) {
            this.findStream().write(byArray, n, n2);
        }

        @Override
        public void print(boolean bl) {
            this.findStream().print(bl);
        }

        @Override
        public void print(char c) {
            this.findStream().print(c);
        }

        @Override
        public void print(int n) {
            this.findStream().print(n);
        }

        @Override
        public void print(long l) {
            this.findStream().print(l);
        }

        @Override
        public void print(float f) {
            this.findStream().print(f);
        }

        @Override
        public void print(double d) {
            this.findStream().print(d);
        }

        @Override
        public void print(char[] cArray) {
            this.findStream().print(cArray);
        }

        @Override
        public void print(String string) {
            this.findStream().print(string);
        }

        @Override
        public void print(Object object) {
            this.findStream().print(object);
        }

        @Override
        public void println() {
            this.findStream().println();
        }

        @Override
        public void println(boolean bl) {
            this.findStream().println(bl);
        }

        @Override
        public void println(char c) {
            this.findStream().println(c);
        }

        @Override
        public void println(int n) {
            this.findStream().println(n);
        }

        @Override
        public void println(long l) {
            this.findStream().println(l);
        }

        @Override
        public void println(float f) {
            this.findStream().println(f);
        }

        @Override
        public void println(double d) {
            this.findStream().println(d);
        }

        @Override
        public void println(char[] cArray) {
            this.findStream().println(cArray);
        }

        @Override
        public void println(String string) {
            this.findStream().println(string);
        }

        @Override
        public void println(Object object) {
            this.findStream().println(object);
        }
    }

    public static class JasperAntLogger
    extends DefaultLogger {
        protected final StringBuilder reportBuf = new StringBuilder();

        protected void printMessage(String string, PrintStream printStream, int n) {
        }

        protected void log(String string) {
            this.reportBuf.append(string);
            this.reportBuf.append(System.lineSeparator());
        }

        protected String getReport() {
            String string = this.reportBuf.toString();
            this.reportBuf.setLength(0);
            return string;
        }
    }
}

